Rem
Rem $Header: wkrelod.sql 22-nov-2004.15:15:58 syang Exp $
Rem
Rem wkrelod.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      wkrelod.sql - reload script for 9.2.0 release
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    syang       11/22/04 - xbranchmerge to 'st_isearch_9.2.0.1' 
Rem    wechin      08/21/02 - wechin_bug-2525681
Rem    wechin      08/21/02 - Created
Rem

-- declare WK validation procedure to be used by registry
-- make sure procedure is defined under SYS
alter session set current_schema=SYS;
@@wkvalid.sql

alter session set current_schema = WKSYS;

PROMPT ==========  Updating sys.registry$ (running as SYS)  ==========
PROMPT

update sys.registry$ set invoker#=0 where cid='WK';
commit;
/

PROMPT ==============  Loading Ultra Search components  ==============
PROMPT

execute dbms_registry.loading('WK', 'Oracle Ultra Search', 'VALIDATE_WK', 'WKSYS');

PROMPT ... loading Ultra Search Java stored packages
declare
  lib_path varchar2(1000);
begin
  select ccd_pvalue into lib_path
    from wk$crawler_config_default 
    where ccd_pname = 'CC_DS_AGENT_PATH';
  lib_path := substr(lib_path,1,instr(lib_path,'lib')+3);
  sys.dbms_java.loadjava('-schema WKSYS -v -f -r -synonym -grant PUBLIC ' ||
    lib_path || 'ultrasearch_db.jar', '((* wksys) (* public))');
end;
/

PROMPT ... loading Ultra Search PL/SQL package headers
@@wk0pkh.sql

PROMPT ... loading Ultra Search PL/SQL package bodies
@@wk0plb.sql

REM ========================================================================
REM Registry to installed state
REM ========================================================================

declare
  ver varchar2(80);
begin
  -- ver := '9.2.0.2.0';
  dbms_registry.loaded('WK');
end;
/

alter session set current_schema = SYS;
execute SYS.VALIDATE_WK;
