Rem
Rem $Header: wkvalid.sql 23-nov-2004.16:11:23 syang Exp $
Rem
Rem wkvalid.sql
Rem
Rem Copyright (c) 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      wkvalid.sql - WK VALIDation
Rem
Rem    DESCRIPTION
Rem      Component validatation procedure to be declared in SYS as part of rdbms registry mechanism
Rem      Derived from wk_util.valid
Rem
Rem    NOTES
Rem      bug 3936668: move wk_util.valid into SYS schema
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    syang       11/23/04 - syang_backport_9.2.0.6.0_3936668
Rem    syang       10/11/04 - Created
Rem

/*---------------------------- VALIDATE_WK -----------------------------*/
/*
  NAME
   VALIDATE_WK
  DESCRIPTION
   This function validates the schema upgrade/install. It is invoked by SYS
   This function will:
   - Check if there is any invalid objects.
   - Update service registry.
  RETURN
*/
create or replace procedure VALIDATE_WK
is
  l_count number;
  l_stmt  varchar2(4000);
  l_valid boolean := true;
  l_val   varchar2(4000);
begin
  dbms_output.put_line('Invoking Ultra Search Install/Upgrade validation procedure VALIDATE_WK');

  -- recompile invalid object
  -- print out the invalid object name/type. i.e., wk_util.recompile_db_objects;
  for c in (select object_type, object_name from dba_objects
             where status='INVALID' and owner='WKSYS') loop
    if c.object_type = 'VIEW' then
      begin
        execute immediate 'alter view wksys.'||c.object_name||' compile';
      exception
        when others then
          null;
      end;
    elsif c.object_type = 'PACKAGE' then
      begin
        execute immediate 'alter package wksys.'||c.object_name||' compile';
      exception
        when others then
          null;
      end;
    elsif c.object_type = 'PACKAGE BODY' then
      begin
        execute immediate 'alter package wksys.'||c.object_name||' compile body';
      exception
        when others then
          null;
      end;
    elsif c.object_type = 'PROCEDURE' then
      begin
        execute immediate 'alter procedure wksys.'||c.object_name||' compile';
      exception
        when others then
          null;
      end;
    else
      dbms_output.put_line(c.object_type||' '||c.object_name ||' is invalid.');
    end if;
  end loop;

  -- get the number of invalid objects
  select count(*) into l_count from dba_objects 
    where status='INVALID' and owner='WKSYS';

  if (l_count > 0) then
    l_valid := false;
  end if;

  -- update the service registry.
  if l_valid then
    l_stmt := 'begin dbms_registry.valid(''WK''); end;';
  else
    l_stmt := 'begin dbms_registry.invalid(''WK''); end;';
  end if;

  execute immediate l_stmt;

  -- print out the success or failure banners
  if l_valid then
    dbms_output.put_line('Ultra Search VALIDATE_WK done with no error');
  else
    dbms_output.put_line('=======================================================');
    dbms_output.put_line('=     FAILED validation of schema: WKSYS ');
    dbms_output.put_line('=======================================================');
  end if;

exception
  when others then
    dbms_output.put_line('=======================================================');
    dbms_output.put_line('=     WKSYS schema validation failed: '||sqlerrm);
    dbms_output.put_line('=======================================================');
end;
/
