# Makefile for natively compiled PL/SQL sources.
#
#  Copyright (c) 1995, 2000 by Oracle Corporation 
#    NAME
#      pnc_makefile.mk
#    DESCRIPTION
#      This file is used to compile C files generated
#      as a result of native compilation of PL/SQL
#      programs.
#
#
#    MODIFIED   (MM/DD/YY)
#     sylin      07/16/02 - 2451985 Rename INCLUDE to NCOMPINCLUDE
#     sylin      07/16/02 - 2451978 Remove comments referring to gcc
#     mvemulap   06/21/02 - remove VCINCLUDE; depend on system INCLUDE and LIB
#     mvemulap   04/09/01 - OPTIMIZE=-xO1
#     mvemulap   04/05/01 - always make the target
#     mvemulap   03/16/01 - fix merge error
#     nmantrav   01/03/01 - Use SUNWspro6.1 cc.
#     mvemulap   01/12/01 -  remove .c file
#     kmuthukk   12/06/00 - revert back to unoptimized as default
#     kmuthukk   12/04/00 - include path must have $ORACHOME/plsql/public
#     kmuthukk   12/04/00 - set optimize to -O2
#     kmuthukk   12/04/00 - use ORACLE_HOME instead of SRCHOME
#     mvemulap   10/27/00 - no echo
#     kmuthukk   04/12/99 - compile optimized
#     mvemulap   03/13/99 - creation

I_SYM=/I
PLSQLHOME=$(ORACLE_HOME)/plsql/
ORACLELIB=$(ORACLE_HOME)/lib/

# PLSQL include
PLSQLINCLUDE=$(PLSQLHOME)include/
PLSQLINCLUDEH=$(I_SYM)$(PLSQLINCLUDE)

# PLSQL public
PLSQLPUBLIC=$(PLSQLHOME)public/
PLSQLPUBLICH=$(I_SYM)$(PLSQLPUBLIC)


#
# File extensions
#
SO_EXT=dll
OBJ_EXT=obj
SRC_EXT=c
LOG_EXT=nlg

#
# C compiler flags
#
NCOMPINCLUDE=$(PLSQLINCLUDEH) $(PLSQLPUBLICH)
PFLAGS=$(NCOMPINCLUDE)
NOLOGO=/nologo
CFLAGS=$(OPTIMIZE) $(PFLAGS) $(PIC) $(NOLOGO)

RM=rm
MV=mv

#
# Specify C Compiler
#
CC=cl

#
# Compile Rule
#
COMPO=$(CC) $*.$(SRC_EXT) /c /Fo$*.$(OBJ_EXT) $(CFLAGS)
COMPILE.c=COMPO

#
# Specify Linker and Linker flags
#
LD=link
SHARED_CFLAG=-dll
LDFLAGS=$(NOLOGO)
SO_COMMAND=$(LD) $(LDFLAGS) $(SHARED_CFLAG) $*.$(OBJ_EXT) -out:$@ $(ORACLELIB)orapls9.lib

.SILENT:

#
# To create shared libraries
#
%.$(SO_EXT): FORCE
	$($(COMPILE.c)) > $*.$(LOG_EXT) 2>&1
	-$(MV) $@ $@.1 
	-$(RM) $@.1 
	$(SO_COMMAND) > $*.$(LOG_EXT) 2>&1
	$(RM) -f $*.$(SRC_EXT) $*.$(OBJ_EXT) $*.$(LOG_EXT)

FORCE:
