Rem 
Rem $Header: dmcrt.sql 07-nov-2003.16:54:46 xbarr Exp $ template.tsc 
Rem 
Rem Copyright (c) 1987, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem NAME
Rem    DMCRT.SQL
Rem
Rem
Rem NOTES
Rem    This script sets up the Data Mining schemas and objects.
Rem    Script to be run as SYS. Following parameter values need to be supplied
Rem  
Rem    &&1 - ODM Tablspace Name
Rem    &&2 - ODM Temporary Tablespace Name
Rem
Rem   MODIFIED    (MM/DD/YY)  
Rem   xbarr        11/07/03 - fix bug#3241377 
Rem   xbarr        03/12/02 - add dbms_registry privs 
Rem   mmcracke     03/05/02 - remove connect statement.
Rem   xbarr        02/25/02 - remove accesscheck Java grant due to security implication 
Rem   xbarr        02/18/02 - added accesscheck Java grant 
Rem   mmcracke     02/15/02 - reversed SYS grant section. Needed for installer 
Rem   mmcracke     02/15/02 - incorporate dmcrtbs.sql.
Rem   mmcracke     02/11/02 - Move grants out.  Need to run under SYS.
Rem   pstengar     01/31/02 - Added select permissions.
Rem   xbarr        01/30/02 - added create index privs 
Rem   xbarr        01/14/02 - add select any tbl create any view drop any view privs 
Rem   xbarr        12/14/01 - add drop any privs
Rem   xbarr        11/20/01 - account update
Rem   xbarr        11/14/01 - update to exclude tbs drop 
Rem   xbarr        10/21/01 - update privs
Rem   xbarr        10/17/01 - update conf_table
Rem   xbarr        10/15/01 - Modified for shipit drop 
Rem   xbarr        10/03/01 - modify privs
Rem   xbarr        09/27/01 - add loadjava permission
Rem   xbarr        09/26/01 - add AQ grants
Rem   xbarr        09/24/01 - modify MTR grants 
Rem   xbarr        09/18/01 - add AQ roles
Rem   xbarr        09/13/01 - add MTR privs and dbms_java debug permissions to dmcreate
Rem   ramkrish     09/12/01 - comment out header
Rem   ramkrish     09/07/01 - Merged ramkrish_fix_admin_make
Rem   xbarr        09/07/01 - Creation
Rem

drop user ODM cascade;

create user ODM identified by ODM default tablespace &&1 temporary tablespace &&2 quota unlimited on &&1;

grant
  CREATE DATABASE LINK,
  CREATE TRIGGER,
  CREATE PROCEDURE,
  CREATE SEQUENCE,
  CREATE SESSION,
  CREATE SYNONYM,
  CREATE VIEW,
  QUERY REWRITE,
  CREATE TABLE,
  ALTER SESSION,
  CREATE TYPE,
  AQ_ADMINISTRATOR_ROLE,
  AQ_USER_ROLE,
  ALTER SYSTEM
to ODM;

drop user odm_mtr cascade;

create user odm_mtr identified by mtrpw default tablespace &&1 temporary tablespace &&2 quota unlimited on &&1; 

grant
  CREATE PROCEDURE,
  CREATE SEQUENCE,
  CREATE SESSION,
  CREATE SYNONYM,
  CREATE VIEW,
  CREATE TABLE,
  CREATE TYPE
to odm_mtr;

grant select on dba_data_files to ODM;
grant select on dba_temp_files to ODM;
grant select on dba_jobs_running to ODM;
grant select on v_$session to ODM; 
grant select on v_$parameter to ODM; 

grant execute on dbms_sql to ODM;
grant execute on dbms_output to ODM;
grant execute on dbms_job to ODM;
grant execute on dbms_aqin to ODM;
grant execute on dbms_random to ODM;
grant execute on dbms_java to ODM;
grant execute on dbms_registry to ODM;

execute dbms_java.grant_permission(UPPER('ODM'),'SYS:java.net.SocketPermission','*','connect');
execute dbms_java.grant_permission(UPPER('ODM'),'SYS:java.io.FilePermission','dm/lib/odmapi.jar','read');
