ALTER SESSION SET CURRENT_SCHEMA = "ODM";
WHENEVER SQLERROR CONTINUE;
DROP TABLE CREATE$JAVA$LOB$TABLE CASCADE CONSTRAINTS;
DROP TABLE JAVA$CLASS$MD5$TABLE CASCADE CONSTRAINTS;
DROP TABLE ODM_MS_RESULT_ENTRY CASCADE CONSTRAINTS;
DROP TABLE ODM_MODEL_SEEKER_RESULT CASCADE CONSTRAINTS;
DROP TABLE ODM_MINING_TASK_STATE CASCADE CONSTRAINTS;
DROP TABLE ODM_INTERNAL_CONFIGURATION CASCADE CONSTRAINTS;
DROP TABLE ODM_MINING_TASK CASCADE CONSTRAINTS;
DROP TABLE ODM_A_I_MODEL CASCADE CONSTRAINTS;
DROP TABLE ODM_REVERSE_PIVOT CASCADE CONSTRAINTS;
DROP TABLE ODM_CLUSTER_RULE;
DROP TABLE ODM_CLUSTER;
DROP TABLE ODM_PMML_DTD;
DROP SEQUENCE SEQ_TEST_RESULT_ID;
DROP SEQUENCE SEQ_CLASSIFICATION_RESULT_ID;
DROP SEQUENCE SEQ_MATRIX_ENTRY_ID;
DROP SEQUENCE SEQ_LIFT_RESULT_ID;
DROP SEQUENCE SEQ_ODM_MESSAGE_LOG_ID;
DROP SEQUENCE SEQ_ODM_MINING_TASK_ID;
DROP SEQUENCE SEQ_MS_RESULT_ID;
DROP SEQUENCE SEQ_MS_RESULT_ENTRY_ID;
DROP SEQUENCE SEQ_ODM_UNIQUE_OBJECT_ID;
DROP SEQUENCE UNIQUE_ID;
DROP TYPE numeric_details_list_type;
DROP TYPE number_list_type;
DROP TYPE numeric_details;
DROP TYPE names_list_type;
DROP TYPE categorical_details_list_type;
DROP TYPE categorical_details;
DROP TYPE Cluster_rule_type;
DROP TYPE Cluster_type force;
DROP TYPE Centroid_tab_type;
DROP TYPE Centroid_entry_type;
DROP TYPE Attribute_Histogram_tab_type;
DROP TYPE Attribute_histogram_type;
DROP TYPE Histogram_entry_tab_type;
DROP TYPE Histogram_entry_type;
DROP TYPE Child_tab_type;
DROP TYPE Child_type;
DROP TYPE Cluster_rule_element_tab_type;
DROP TYPE Cluster_rule_element_type;
DROP TYPE Cl_predicate_tab_type;
DROP TYPE Cl_predicate_type;
DROP TYPE Predicate_tab_type;
DROP TYPE Predicate_type;
DROP TYPE Category_tab_type;
DROP TYPE Category_type;
drop type Cell_type;
drop type Cluster_Node_type;
drop type Cluster_internal_type;
drop type Range_tab_type;
drop type Range_array_type;
drop type Histogram_tab_type;
drop type Number_tab_type;
drop type Integer_tab_type;
DROP TYPE NBSection FORCE;
DROP TYPE BayesInputs FORCE;
DROP TYPE "BayesInput" FORCE;
DROP TYPE PairCountList FORCE;
DROP TYPE "PairCounts" FORCE;
DROP TYPE BayesOutput FORCE;
DROP TYPE TargetValueCounts FORCE;
DROP TYPE "TargetValueCount" FORCE;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
PROMPT Creating Table 'ODM_MS_RESULT_ENTRY'
CREATE TABLE ODM_MS_RESULT_ENTRY
 (ID NUMBER(20) NOT NULL
 ,RESULT_SEQUENCE NUMBER(5)
 ,MODEL_SEEKER_RESULT_ID NUMBER(20)
 ,START_TIMESTAMP TIMESTAMP
 ,END_TIMESTAMP TIMESTAMP
 ,MODEL_NAME VARCHAR2(64 CHAR)
 ,BUILD_DURATION NUMBER
 ,ALGORITHM_NAME VARCHAR2(64)
 ,TEST_RESULT_NAME VARCHAR2(64 CHAR)
 ,LIFT_RESULT_NAME VARCHAR2(64 CHAR)
 ,MINING_FUNCTION_SETTINGS_NAME VARCHAR2(64 CHAR)
 ,FIGURE_OF_MERIT NUMBER
 )
/
PROMPT Creating Table 'ODM_MODEL_SEEKER_RESULT'
CREATE TABLE ODM_MODEL_SEEKER_RESULT
 (ID NUMBER(20) NOT NULL
 ,NAME VARCHAR2(64 CHAR) NOT NULL
 ,BEST_MODEL_ENTRY_ID NUMBER(20)
 ,START_TIMESTAMP TIMESTAMP
 ,END_TIMESTAMP TIMESTAMP
 ,FUNCTION_SETTINGS_NAME VARCHAR2(64 CHAR)
 ,BUILD_DATA_LOCATION VARCHAR2(61)
 ,TEST_DATA_LOCATION VARCHAR2(61)
 )
/
PROMPT Creating Table 'ODM_MINING_TASK'
CREATE TABLE ODM_MINING_TASK
 (ID NUMBER(13) NOT NULL
 ,NAME VARCHAR2(64 CHAR) NOT NULL
 ,TYPE VARCHAR2(30) NOT NULL
 ,SERIALIZED_OBJECT BLOB
 ,CLEAN_FLAG NUMBER(1)
 ,INSTANCE VARCHAR2(16)
 ,JOB_ID NUMBER
 )
 INITRANS 1
 MAXTRANS 255
 PCTUSED 40
 PCTFREE 10
 STORAGE
 (
   INITIAL 65536
   MINEXTENTS 1
   MAXEXTENTS UNLIMITED
 )
 NOCACHE
/
PROMPT Creating Table 'ODM_INTERNAL_CONFIGURATION'
CREATE TABLE ODM_INTERNAL_CONFIGURATION
 (DATA_TYPE VARCHAR2(32) NOT NULL
 ,NAME VARCHAR2(128) NOT NULL
 ,VALUE VARCHAR2(128)
 ,DESCRIPTION VARCHAR2(256)
 )
 INITRANS 1
 MAXTRANS 255
 PCTUSED 40
 PCTFREE 10
 STORAGE
 (
   INITIAL 65536
   MINEXTENTS 1
   MAXEXTENTS UNLIMITED
 )
 NOCACHE
/
PROMPT Creating Table 'ODM_MINING_TASK_STATE'
CREATE TABLE ODM_MINING_TASK_STATE
 (ID NUMBER(20) NOT NULL
 ,ENTRY_TIMESTAMP TIMESTAMP NOT NULL
 ,STATE VARCHAR2(16) NOT NULL
 ,STATE_TEXT VARCHAR2(1300 CHAR)
 )
 INITRANS 1
 MAXTRANS 255
 PCTUSED 40
 PCTFREE 10
 STORAGE
 (
   INITIAL 65536
   MINEXTENTS 1
   MAXEXTENTS UNLIMITED
 )
 NOCACHE
/
PROMPT Creating Table 'ODM_A_I_MODEL'
CREATE TABLE ODM_A_I_MODEL (
         ATTRIBUTE_NAME VARCHAR2(30) NOT NULL
        ,ATTRIBUTE_IMPORTANCE_VALUE NUMBER NOT NULL
        ,ATTRIBUTE_RANK NUMBER NOT NULL
 )
 INITRANS 1
 MAXTRANS 255
 PCTUSED 40
 PCTFREE 10
 STORAGE
 (
   INITIAL 65536
   MINEXTENTS 1
   MAXEXTENTS UNLIMITED
 )
 NOCACHE
/
PROMPT Creating Table 'ODM_PMML_DTD'
CREATE TABLE ODM_PMML_DTD (DTD CLOB);
PROMPT Creating Primary Key on 'ODM_MINING_TASK'
ALTER TABLE ODM_MINING_TASK
 ADD (CONSTRAINT MINING_TASK_PK PRIMARY KEY
  (ID)
 USING INDEX
 INITRANS 2
 MAXTRANS 255
 PCTFREE 10
 STORAGE
 (
   INITIAL 65536
   MINEXTENTS 1
   MAXEXTENTS UNLIMITED
 ))
/
PROMPT Creating Primary Key on 'ODM_INTERNAL_CONFIGURATION'
ALTER TABLE ODM_INTERNAL_CONFIGURATION
 ADD (CONSTRAINT ODM_INTERNAL_CONFIG_PK PRIMARY KEY
  (NAME)
 USING INDEX
 INITRANS 2
 MAXTRANS 255
 PCTFREE 10
 STORAGE
 (
   INITIAL 65536
   MINEXTENTS 1
   MAXEXTENTS UNLIMITED
 ))
/
PROMPT Creating Primary Key on 'ODM_MS_RESULT_ENTRY'
ALTER TABLE ODM_MS_RESULT_ENTRY
 ADD (CONSTRAINT RESULT_ENTRY_PK PRIMARY KEY
  (ID))
/
PROMPT Creating Primary Key on 'ODM_MODEL_SEEKER_RESULT'
ALTER TABLE ODM_MODEL_SEEKER_RESULT
 ADD (CONSTRAINT MS_RESULT_PK PRIMARY KEY
  (ID))
/
PROMPT Creating Primary Key on 'ODM_A_I_MODEL'
ALTER TABLE ODM_A_I_MODEL
 ADD (CONSTRAINT ODM_A_I_MODEL_PK PRIMARY KEY
 (attribute_name))
/
PROMPT Creating Unique Key on 'ODM_MINING_TASK'
ALTER TABLE ODM_MINING_TASK
 ADD (CONSTRAINT ODM_MINING_TASK_UK UNIQUE
  (NAME)
 USING INDEX
 INITRANS 2
 MAXTRANS 255
 PCTFREE 10
 STORAGE
 (
   INITIAL 65536
   MINEXTENTS 1
   MAXEXTENTS UNLIMITED
 ))
/
PROMPT Creating Unique Key on 'ODM_MODEL_SEEKER_RESULT'
ALTER TABLE ODM_MODEL_SEEKER_RESULT
 ADD (CONSTRAINT ODM_MODEL_SEEKER_RESULT_UK UNIQUE
  (NAME))
/
PROMPT Creating Foreign Key on 'ODM_MINING_TASK_STATE'
ALTER TABLE ODM_MINING_TASK_STATE ADD (CONSTRAINT
 MINING_TASK_STATE_FK FOREIGN KEY
  (ID) REFERENCES ODM_MINING_TASK
  (ID) ON DELETE CASCADE)
/
PROMPT Creating Foreign Key on 'ODM_MS_RESULT_ENTRY'
ALTER TABLE ODM_MS_RESULT_ENTRY ADD (CONSTRAINT
 MS_RESULT_FK FOREIGN KEY
  (MODEL_SEEKER_RESULT_ID) REFERENCES ODM_MODEL_SEEKER_RESULT
  (ID))
/
PROMPT Creating Foreign Key on 'ODM_MS_RESULT_ENTRY'
ALTER TABLE ODM_MS_RESULT_ENTRY ADD (CONSTRAINT
 TEST_RESULT_FK FOREIGN KEY
  (TEST_RESULT_NAME) REFERENCES ODM_TEST_RESULT
  (NAME))
/
PROMPT Creating Foreign Key on 'ODM_MS_RESULT_ENTRY'
ALTER TABLE ODM_MS_RESULT_ENTRY ADD (CONSTRAINT
 LIFT_RESULT_FK FOREIGN KEY
  (LIFT_RESULT_NAME) REFERENCES ODM_LIFT_RESULT
  (NAME))
/
PROMPT Creating Sequence 'SEQ_TEST_RESULT_ID'
CREATE SEQUENCE SEQ_TEST_RESULT_ID
 INCREMENT BY 1
 START WITH 1
 NOMAXVALUE
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'SEQ_ODM_MESSAGE_LOG_ID'
CREATE SEQUENCE SEQ_ODM_MESSAGE_LOG_ID
 INCREMENT BY 1
 START WITH 1
 NOMAXVALUE
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'SEQ_MATRIX_ENTRY_ID'
CREATE SEQUENCE SEQ_MATRIX_ENTRY_ID
 INCREMENT BY 1
 START WITH 1
 NOMAXVALUE
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'SEQ_LIFT_RESULT_ID'
CREATE SEQUENCE SEQ_LIFT_RESULT_ID
 INCREMENT BY 1
 START WITH 1
 NOMAXVALUE
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'SEQ_CLASSIFICATION_RESULT_ID'
CREATE SEQUENCE SEQ_CLASSIFICATION_RESULT_ID
 INCREMENT BY 1
 START WITH 1
 NOMAXVALUE
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'SEQ_ODM_MINING_TASK_ID'
CREATE SEQUENCE SEQ_ODM_MINING_TASK_ID
 INCREMENT BY 1
 START WITH 1
 MAXVALUE 9999999999999
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'SEQ_MS_RESULT_ID'
CREATE SEQUENCE SEQ_MS_RESULT_ID
 INCREMENT BY 1
 START WITH 1
 NOMAXVALUE
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'SEQ_MS_RESULT_ENTRY_ID'
CREATE SEQUENCE SEQ_MS_RESULT_ENTRY_ID
 INCREMENT BY 1
 START WITH 1
 NOMAXVALUE
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'SEQ_ODM_UNIQUE_OBJECT_ID'
CREATE SEQUENCE SEQ_ODM_UNIQUE_OBJECT_ID
 INCREMENT BY 1
 START WITH 1
 MAXVALUE 9999999999999
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
PROMPT Creating Sequence 'UNIQUE_ID'
CREATE SEQUENCE UNIQUE_ID
 INCREMENT BY 1
 START WITH 1 
 NOMAXVALUE
 MINVALUE 1
 NOCYCLE
 CACHE 20
 ORDER
/
CREATE TYPE numeric_details wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
8
2 :e:
1TYPE:
1NUMERIC_DETAILS:
1OBJECT:
1ATTR_NAME:
1VARCHAR2:
130:
1NUM_QUANTILES:
1NUMBER:
0

0
0
19
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 77 a0 102 a0 c6 1d 17
b5 
19
2
0 3 5b b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 3f 7 62 64 68 6a 6b
74 
19
2
0 1 6 19 1 22 2c 35
34 2c :2 22 3a :2 48 :2 3a 1 :2 4e
:5 1 
19
4
0 :18 1 
76
4
:3 0 1 :3 0 2
:3 0 3 :3 0 9
:3 0 13 1 11
:9 0 7 3f 0
:2 5 :3 0 6 :2 0
3 6 8 :6 0
4 :6 0 a 9
0 4 0 2
0 4 0 8
:3 0 d :7 0 7
:6 0 f e 0
4 0 2 4
2 1 :3 0 12
0 2 :2 0 2
14 11 0 16
15 18 :8 0 
c
4
:3 0 1 7 1
5 1 c 2
b 10 
1
4
0 
17
0
1
14
1
3
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
5 1 0
c 1 0
2 0 1
0

/
CREATE TYPE numeric_details_list_type AS VARRAY(1000) OF numeric_details
/
CREATE TYPE number_list_type AS VARRAY(1000) OF NUMBER
/
CREATE TYPE names_list_type AS VARRAY(1000) OF VARCHAR2(100)
/
CREATE TYPE categorical_details wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
9
2 :e:
1TYPE:
1CATEGORICAL_DETAILS:
1OBJECT:
1ATTR_NAME:
1VARCHAR2:
1100:
1TOPN:
1NUMBER:
1OTHER_NAME:
0

0
0
20
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 a3 a0 51 a5 1c b0 81
77 a0 102 a0 c6 1d 17 b5 
20
2
0 3 77 b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 6b 5b 5f 62 63 42 72
7 7e 3f 82 86 88 89 92 
20
2
0 1 6 1d 1 26 30 39
38 30 :2 26 3f :2 44 :2 3f 4c 57
60 5f 57 :2 4c 1 :2 64 :5 1 
20
4
0 :1f 1 
94
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 d :3 0 1a
1 18 :9 0 7
3f 0 :2 5 :3 0
6 :2 0 3 6
8 :6 0 4 :6 0
a 9 0 4
0 19 :2 0 b
8 :3 0 d :7 0
7 :6 0 f e
0 4 0 5
:3 0 6 :2 0 9
12 14 :6 0 9
:6 0 16 15 0
4 0 2 4
2 1 :3 0 2
:3 0 2 :2 0 2
1b 18 0 1d
1c 1f :8 0 
11
4
:3 0 1 7 1
5 1 c 1
13 1 11 3
b 10 17 
1
4
0 
1e
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
2 0 1
5 1 0
c 1 0
11 1 0
0

/
CREATE TYPE categorical_details_list_type  AS VARRAY(1000) OF categorical_details
/
CREATE TYPE Category_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
6
2 :e:
1TYPE:
1CATEGORY_TYPE:
1OBJECT:
1VALUE:
1NUMBER:
15:
0

0
0
14
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 77 a0 102 a0
c6 1d 17 b5 
14
2
0 3 3f b f 33 23 27
2a 2b 22 3a 7 46 1f 4a
4e 50 51 5a 
14
2
0 1 6 17 1 4 1a 21
20 1a :2 4 :8 1 
14
4
0 :4 1 :7 2 1
:2 3 :5 1 
5c
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 7 :3 0 e
1 c :9 0 d
:2 0 :2 5 :3 0 6
:2 0 3 6 8
:6 0 4 :6 0 a
9 0 4 0
2 4 2 1
:3 0 2 :3 0 2
:2 0 2 f c
0 11 10 13
:8 0 
9
4
:3 0 1 7 1
5 1 b 
1
4
0 
12
0
1
14
1
2
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
5 1 0
2 0 1
0

/
CREATE TYPE Category_tab_type AS TABLE OF Category_type
/
CREATE TYPE Predicate_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
d
2 :e:
1TYPE:
1PREDICATE_TYPE:
1OBJECT:
1ATTRIBUTE_NAME:
1VARCHAR2:
130:
1ATTRIBUTE_ID:
1NUMBER:
16:
1COMPARISON_FUNCTION:
12:
1VALUE:
1CATEGORY_TAB_TYPE:
0

0
0
27
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 51 a5
1c b0 81 a3 a0 51 a5 1c
b0 81 a3 a0 1c b0 81 77
a0 102 a0 c6 1d 17 b5 
27
2
0 3 95 b f 33 23 27
2a 2b 22 3a 50 43 1f 47
48 42 57 6d 60 3f 64 65
5f 74 89 7d 81 5c 90 79
7 9c 9e a2 a4 a5 ae 
27
2
0 1 6 18 1 4 1a 23
22 1a :3 4 1a 21 20 1a :3 4
1a 21 20 1a :3 4 :2 1a :2 4 :8 1

27
4
0 :4 1 :7 2 :7 3
:7 4 :5 5 1 :2 6
:5 1 
b0
4
:3 0 1 :3 0 2
:3 0 3 :3 0 11
:3 0 21 1 1f
:9 0 9 :2 0 :2 5
:3 0 6 :2 0 3
6 8 :6 0 4
:6 0 a 9 0
4 0 b :2 0
9 8 :3 0 7
d f :6 0 7
:6 0 11 10 0
4 0 f 79
0 d 8 :3 0
b 14 16 :6 0
a :6 0 18 17
0 4 0 2
0 4 0 d
:3 0 1b :7 0 c
:6 0 1d 1c 0
4 0 2 4
2 1 :3 0 20
0 2 :2 0 2
22 1f 0 24
23 26 :8 0 
16
4
:3 0 1 7 1
5 1 e 1
c 1 15 1
13 1 1a 4
b 12 19 1e

1
4
0 
25
0
1
14
1
5
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
5 1 0
c 1 0
1a 1 0
13 1 0
2 0 1
0

/
CREATE TYPE Predicate_tab_type AS TABLE OF Predicate_type
/
CREATE TYPE Cl_predicate_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
8
2 :e:
1TYPE:
1CL_PREDICATE_TYPE:
1OBJECT:
1COMPARISON_FUNCTION:
1NUMBER:
12:
1VALUE:
1CATEGORY_TAB_TYPE:
0

0
0
19
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 77 a0 102 a0 c6 1d 17
b5 
19
2
0 3 5b b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 3f 7 62 64 68 6a 6b
74 
19
2
0 1 6 1b 1 7 1c 23
22 1c :3 7 :2 1c :2 7 :8 1 
19
4
0 :4 1 :7 2 :5 3
1 :2 4 :5 1 
76
4
:3 0 1 :3 0 2
:3 0 3 :3 0 9
:3 0 13 1 11
:9 0 7 3f 0
:2 5 :3 0 6 :2 0
3 6 8 :6 0
4 :6 0 a 9
0 4 0 2
0 4 0 8
:3 0 d :7 0 7
:6 0 f e 0
4 0 2 4
2 1 :3 0 12
0 2 :2 0 2
14 11 0 16
15 18 :8 0 
c
4
:3 0 1 7 1
5 1 c 2
b 10 
1
4
0 
17
0
1
14
1
3
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
c 1 0
2 0 1
5 1 0
0

/
CREATE TYPE Cl_predicate_tab_type AS TABLE OF Cl_predicate_type
/
CREATE TYPE Cluster_rule_element_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
e
2 :e:
1TYPE:
1CLUSTER_RULE_ELEMENT_TYPE:
1OBJECT:
1ATTRIBUTE_NAME:
1VARCHAR2:
130:
1ATTRIBUTE_ID:
1NUMBER:
16:
1ATTRIBUTE_RELEVANCE:
1RECORD_COUNT:
110:
1ENTRIES:
1CL_PREDICATE_TAB_TYPE:
0

0
0
2c
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 51 a5
1c b0 81 a3 a0 1c b0 81
a3 a0 51 a5 1c b0 81 a3
a0 1c b0 81 77 a0 102 a0
c6 1d 17 b5 
2c
2
0 3 b0 b f 33 23 27
2a 2b 22 3a 50 43 1f 47
48 42 57 6c 60 64 3f 73
88 78 7c 7f 80 5f 8f a4
98 9c 5c ab 94 7 b7 b9
bd bf c0 c9 
2c
2
0 1 6 23 1 4 1a 23
22 1a :3 4 1a 21 20 1a :3 4
:2 1a :3 4 1a 21 20 1a :3 4 :2 1a
:2 4 :8 1 
2c
4
0 :4 1 :7 2 :7 3
:5 4 :7 5 :5 6 1
:2 7 :5 1 
cb
4
:3 0 1 :3 0 2
:3 0 3 :3 0 13
:3 0 26 1 24
:9 0 9 :2 0 :2 5
:3 0 6 :2 0 3
6 8 :6 0 4
:6 0 a 9 0
4 0 b 5c
0 9 8 :3 0
7 d f :6 0
7 :6 0 11 10
0 4 0 11
94 0 f 8
:3 0 14 :7 0 a
:6 0 16 15 0
4 0 8 :3 0
c :2 0 d 19
1b :6 0 b :6 0
1d 1c 0 4
0 2 0 4
0 e :3 0 20
:7 0 d :6 0 22
21 0 4 0
2 4 2 1
:3 0 25 0 2
:2 0 2 27 24
0 29 28 2b
:8 0 
19
4
:3 0 1 7 1
5 1 e 1
c 1 13 1
1a 1 18 1
1f 5 b 12
17 1e 23 
1
4
0 
2a
0
1
14
1
6
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
13 1 0
5 1 0
c 1 0
1f 1 0
2 0 1
18 1 0
0

/
CREATE TYPE Cluster_rule_element_tab_type AS TABLE OF Cluster_rule_element_type
/
CREATE TYPE Centroid_entry_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
b
2 :e:
1TYPE:
1CENTROID_ENTRY_TYPE:
1OBJECT:
1ATTRIBUTE_NAME:
1VARCHAR2:
130:
1ATTRIBUTE_ID:
1NUMBER:
16:
1VALUE:
15:
0

0
0
22
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 51 a5
1c b0 81 a3 a0 51 a5 1c
b0 81 77 a0 102 a0 c6 1d
17 b5 
22
2
0 3 79 b f 33 23 27
2a 2b 22 3a 50 43 1f 47
48 42 57 6d 60 3f 64 65
5f 74 7 80 5c 84 88 8a
8b 94 
22
2
0 1 6 1d 1 5 17 20
1f 17 :3 5 17 1e 1d 17 :3 5
17 1e 1d 17 :2 5 :8 1 
22
4
0 :4 1 :7 2 :7 3
:7 4 1 :2 5 :5 1

96
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 f :3 0 1c
1 1a :9 0 9
:2 0 :2 5 :3 0 6
:2 0 3 6 8
:6 0 4 :6 0 a
9 0 4 0
b :2 0 9 8
:3 0 7 d f
:6 0 7 :6 0 11
10 0 4 0
1b :2 0 d 8
:3 0 b 14 16
:6 0 a :6 0 18
17 0 4 0
2 4 2 1
:3 0 2 :3 0 2
:2 0 2 1d 1a
0 1f 1e 21
:8 0 
13
4
:3 0 1 7 1
5 1 e 1
c 1 15 1
13 3 b 12
19 
1
4
0 
20
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
5 1 0
c 1 0
13 1 0
2 0 1
0

/
CREATE TYPE Centroid_tab_type AS TABLE OF Centroid_entry_type
/
CREATE TYPE Histogram_entry_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
7
2 :e:
1TYPE:
1HISTOGRAM_ENTRY_TYPE:
1OBJECT:
1COUNT:
1NUMBER:
1VALUE:
15:
0

0
0
19
2
0 a0 9d a0 60 a3 a0 1c
b0 81 a3 a0 51 a5 1c b0
81 77 a0 102 a0 c6 1d 17
b5 
19
2
0 3 58 b f 2f 23 27
22 36 4c 3f 1f 43 44 3e
53 7 5f 3b 63 67 69 6a
73 
19
2
0 1 6 1e 1 5 :2 17 :3 5
17 1e 1d 17 :2 5 :8 1 
19
4
0 :4 1 :5 2 :7 3
1 :2 4 :5 1 
75
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 9 :3 0 13
1 11 :9 0 7
:2 0 3 5 :3 0
6 :7 0 4 :6 0
8 7 0 4
0 12 :2 0 7
5 :3 0 5 b
d :6 0 6 :6 0
f e 0 4
0 2 4 2
1 :3 0 2 :3 0
2 :2 0 2 14
11 0 16 15
18 :8 0 
c
4
:3 0 1 5 1
c 1 a 2
9 10 
1
4
0 
17
0
1
14
1
3
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
a 1 0
2 0 1
5 1 0
0

/
CREATE TYPE Histogram_entry_tab_type AS TABLE OF Histogram_entry_type
/
CREATE TYPE Attribute_histogram_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
b
2 :e:
1TYPE:
1ATTRIBUTE_HISTOGRAM_TYPE:
1OBJECT:
1ATTRIBUTE_NAME:
1VARCHAR2:
132:
1ATTRIBUTE_ID:
1NUMBER:
16:
1ENTRIES:
1HISTOGRAM_ENTRY_TAB_TYPE:
0

0
0
20
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 51 a5
1c b0 81 a3 a0 1c b0 81
77 a0 102 a0 c6 1d 17 b5 
20
2
0 3 78 b f 33 23 27
2a 2b 22 3a 50 43 1f 47
48 42 57 6c 60 64 3f 73
5c 7 7f 81 85 87 88 91 
20
2
0 1 6 22 1 5 17 20
1f 17 :3 5 17 1e 1d 17 :3 5
:2 17 :2 5 :8 1 
20
4
0 :4 1 :7 2 :7 3
:5 4 1 :2 5 :5 1

93
4
:3 0 1 :3 0 2
:3 0 3 :3 0 d
:3 0 1a 1 18
:9 0 9 :2 0 :2 5
:3 0 6 :2 0 3
6 8 :6 0 4
:6 0 a 9 0
4 0 b 5c
0 9 8 :3 0
7 d f :6 0
7 :6 0 11 10
0 4 0 2
0 4 0 b
:3 0 14 :7 0 a
:6 0 16 15 0
4 0 2 4
2 1 :3 0 19
0 2 :2 0 2
1b 18 0 1d
1c 1f :8 0 
11
4
:3 0 1 7 1
5 1 e 1
c 1 13 3
b 12 17 
1
4
0 
1e
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
5 1 0
c 1 0
13 1 0
2 0 1
0

/
CREATE TYPE Attribute_histogram_tab_type AS TABLE OF Attribute_histogram_type
/
CREATE TYPE Child_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
6
2 :e:
1TYPE:
1CHILD_TYPE:
1OBJECT:
1ID:
1NUMBER:
17:
0

0
0
14
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 77 a0 102 a0
c6 1d 17 b5 
14
2
0 3 3f b f 33 23 27
2a 2b 22 3a 7 46 1f 4a
4e 50 51 5a 
14
2
0 1 6 14 1 6 17 1e
1d 17 :2 6 :8 1 
14
4
0 :4 1 :7 2 1
:2 3 :5 1 
5c
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 7 :3 0 e
1 c :9 0 d
:2 0 :2 5 :3 0 6
:2 0 3 6 8
:6 0 4 :6 0 a
9 0 4 0
2 4 2 1
:3 0 2 :3 0 2
:2 0 2 f c
0 11 10 13
:8 0 
9
4
:3 0 1 7 1
5 1 b 
1
4
0 
12
0
1
14
1
2
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
5 1 0
2 0 1
0

/
CREATE TYPE Child_tab_type AS TABLE OF Child_type
/
CREATE TYPE Cluster_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
12
2 :e:
1TYPE:
1CLUSTER_TYPE:
1OBJECT:
1ID:
1NUMBER:
17:
1RECORD_COUNT:
110:
1TREE_LEVEL:
1PARENT:
1SPLIT_PREDICATE:
1PREDICATE_TAB_TYPE:
1CENTROID:
1CENTROID_TAB_TYPE:
1HISTOGRAM:
1ATTRIBUTE_HISTOGRAM_TAB_TYPE:
1CHILD:
1CHILD_TAB_TYPE:
0

0
0
3d
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 51 a5
1c b0 81 a3 a0 51 a5 1c
b0 81 a3 a0 51 a5 1c b0
81 a3 a0 1c b0 81 a3 a0
1c b0 81 a3 a0 1c b0 81
a3 a0 1c b0 81 77 a0 102
a0 c6 1d 17 b5 
3d
2
0 3 fe b f 33 23 27
2a 2b 22 3a 50 43 1f 47
48 42 57 6d 60 3f 64 65
5f 74 8a 7d 5c 81 82 7c
91 a6 9a 9e 79 ad be b2
b6 99 c5 da ce d2 96 e1
f2 e6 ea cd f9 7 105 ca
109 10d 10f 110 119 
3d
2
0 1 6 16 1 6 21 28
27 21 :3 6 21 28 27 21 :3 6
21 28 27 21 :3 6 21 28 27
21 :3 6 :2 21 :3 6 :2 21 :3 6 :2 21 :3 6
:2 21 :2 6 :8 1 
3d
4
0 :4 1 :7 2 :7 3
:7 4 :7 5 :5 6 :5 7
:5 8 :5 9 1 :2 a
:5 1 
11b
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 1b :3 0 37
1 35 :9 0 8
:2 0 :2 5 :3 0 6
:2 0 3 6 8
:6 0 4 :6 0 a
9 0 4 0
6 :2 0 9 5
:3 0 7 d f
:6 0 7 :6 0 11
10 0 4 0
6 :2 0 d 5
:3 0 b 14 16
:6 0 9 :6 0 18
17 0 4 0
13 96 0 11
5 :3 0 f 1b
1d :6 0 a :6 0
1f 1e 0 4
0 17 ca 0
15 c :3 0 22
:7 0 b :6 0 24
23 0 4 0
e :3 0 27 :7 0
d :6 0 29 28
0 4 0 36
:2 0 19 10 :3 0
2c :7 0 f :6 0
2e 2d 0 4
0 12 :3 0 31
:7 0 11 :6 0 33
32 0 4 0
2 4 2 1
:3 0 2 :3 0 2
:2 0 2 38 35
0 3a 39 3c
:8 0 
24
4
:3 0 1 7 1
5 1 e 1
c 1 15 1
13 1 1c 1
1a 1 21 1
26 1 2b 1
30 8 b 12
19 20 25 2a
2f 34 
1
4
0 
3b
0
1
14
1
9
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
13 1 0
5 1 0
26 1 0
2b 1 0
21 1 0
30 1 0
1a 1 0
2 0 1
c 1 0
0

/
CREATE TABLE ODM_CLUSTER OF Cluster_type (id PRIMARY KEY)
OBJECT ID PRIMARY KEY
NESTED TABLE centroid  STORE AS centroid_nestedtab(
      (PRIMARY KEY(NESTED_TABLE_ID, attribute_name))
       ORGANIZATION INDEX COMPRESS 1
)
NESTED TABLE histogram STORE AS histogram_nestedtab (
      (PRIMARY KEY(NESTED_TABLE_ID, attribute_name))
       ORGANIZATION INDEX COMPRESS 1
       NESTED TABLE entries STORE AS entries_nestedtab
       ((PRIMARY KEY(NESTED_TABLE_ID, value))
        ORGANIZATION INDEX COMPRESS 1
       )
)
NESTED TABLE split_predicate STORE AS split_predicate_nestedtab(
      (PRIMARY KEY(NESTED_TABLE_ID, attribute_name, comparison_function))
       ORGANIZATION INDEX COMPRESS 1
       NESTED TABLE value STORE AS value_nestedtab(
         (PRIMARY KEY(NESTED_TABLE_ID,value))
         ORGANIZATION INDEX COMPRESS 1
       )
)
NESTED TABLE child STORE AS child_nestedtab(
      (PRIMARY KEY(NESTED_TABLE_ID,id))
      ORGANIZATION INDEX COMPRESS 1
)
/
CREATE TYPE Cluster_rule_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
a
2 :e:
1TYPE:
1CLUSTER_RULE_TYPE:
1OBJECT:
1CLUSTER_ID:
1NUMBER:
17:
1RECORD_COUNT:
110:
1ANTECEDENT:
1CLUSTER_RULE_ELEMENT_TAB_TYPE:
0

0
0
20
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 51 a5
1c b0 81 a3 a0 1c b0 81
77 a0 102 a0 c6 1d 17 b5 
20
2
0 3 78 b f 33 23 27
2a 2b 22 3a 50 43 1f 47
48 42 57 6c 60 64 3f 73
5c 7 7f 81 85 87 88 91 
20
2
0 1 6 1b 1 6 21 28
27 21 :3 6 21 28 27 21 :3 6
:2 21 :2 6 :8 1 
20
4
0 :4 1 :7 2 :7 3
:5 4 1 :2 5 :5 1

93
4
:3 0 1 :3 0 2
:3 0 3 :3 0 d
:3 0 1a 1 18
:9 0 8 :2 0 :2 5
:3 0 6 :2 0 3
6 8 :6 0 4
:6 0 a 9 0
4 0 b 5c
0 9 5 :3 0
7 d f :6 0
7 :6 0 11 10
0 4 0 2
0 4 0 a
:3 0 14 :7 0 9
:6 0 16 15 0
4 0 2 4
2 1 :3 0 19
0 2 :2 0 2
1b 18 0 1d
1c 1f :8 0 
11
4
:3 0 1 7 1
5 1 e 1
c 1 13 3
b 12 17 
1
4
0 
1e
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
13 1 0
2 0 1
c 1 0
5 1 0
0

/
CREATE TABLE ODM_CLUSTER_RULE OF Cluster_rule_type (cluster_id PRIMARY KEY)
OBJECT ID PRIMARY KEY
NESTED TABLE antecedent  STORE AS antecedent_nestedtab(
      (PRIMARY KEY(NESTED_TABLE_ID, attribute_name))
       ORGANIZATION INDEX COMPRESS 1
       NESTED TABLE entries STORE AS cluster_predicate_nestedtab(
        (PRIMARY KEY(NESTED_TABLE_ID, comparison_function))
        ORGANIZATION INDEX COMPRESS 1
        NESTED TABLE value STORE AS rule_value_nestedtab(
          (PRIMARY KEY(NESTED_TABLE_ID,value))
          ORGANIZATION INDEX COMPRESS 1
        )
       )
)
;
CREATE OR REPLACE TYPE Integer_tab_type IS TABLE OF NUMBER(10)
/
CREATE OR REPLACE TYPE Number_tab_type IS TABLE OF NUMBER
/
CREATE OR REPLACE TYPE Range_array_type IS VARRAY(2) OF NUMBER(5)
/
CREATE OR REPLACE TYPE Range_tab_type IS TABLE OF Range_array_type
/
CREATE OR REPLACE TYPE Histogram_tab_type IS TABLE OF Integer_tab_type
/
CREATE OR REPLACE TYPE Cluster_node_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
c
2 :e:
1TYPE:
1CLUSTER_NODE_TYPE:
1OBJECT:
1PARENT:
1NUMBER:
17:
1CHILDREN:
1INTEGER_TAB_TYPE:
1TREE_LEVEL:
1POINTS:
1SPLITTER:
16:
0

0
0
2c
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 a3 a0 51 a5 1c b0 81
a3 a0 1c b0 81 a3 a0 51
a5 1c b0 81 77 a0 102 a0
c6 1d 17 b5 
2c
2
0 3 af b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 6b 5b 5f 62 63 42 72
87 7b 7f 3f 8e a3 93 97
9a 9b 7a aa 7 b6 77 ba
be c0 c1 ca 
2c
2
0 1 6 1b 1 b 16 1d
1c 16 :3 b :2 16 :3 b 16 1d 1c
16 :3 b :2 16 :3 b 16 1d 1c 16
:2 b 1 :2 1f :5 1 
2c
4
0 :4 1 :7 2 :5 3
:7 4 :5 5 :7 6 1
:2 6 :5 1 
cc
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 13 :3 0 26
1 24 :9 0 7
3f 0 :2 5 :3 0
6 :2 0 3 6
8 :6 0 4 :6 0
a 9 0 4
0 d 77 0
b 8 :3 0 d
:7 0 7 :6 0 f
e 0 4 0
5 :3 0 6 :2 0
9 12 14 :6 0
9 :6 0 16 15
0 4 0 25
:2 0 11 8 :3 0
19 :7 0 a :6 0
1b 1a 0 4
0 5 :3 0 c
:2 0 f 1e 20
:6 0 b :6 0 22
21 0 4 0
2 4 2 1
:3 0 2 :3 0 2
:2 0 2 27 24
0 29 28 2b
:8 0 
19
4
:3 0 1 7 1
5 1 c 1
13 1 11 1
18 1 1f 1
1d 5 b 10
17 1c 23 
1
4
0 
2a
0
1
14
1
6
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
11 1 0
c 1 0
2 0 1
18 1 0
1d 1 0
5 1 0
0

/
CREATE OR REPLACE TYPE Cell_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
a
2 :e:
1TYPE:
1CELL_TYPE:
1OBJECT:
1COUNT:
1NUMBER:
110:
1RANGES:
1RANGE_TAB_TYPE:
1HISTOGRAMS:
1HISTOGRAM_TAB_TYPE:
0

0
0
1e
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 a3 a0 1c b0 81 77 a0
102 a0 c6 1d 17 b5 
1e
2
0 3 73 b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 67 5b 5f 42 6e 7 7a
3f 7e 82 84 85 8e 
1e
2
0 1 6 13 1 b 17 1e
1d 17 :3 b :2 17 :3 b :2 17 :2 b 1
:2 29 :5 1 
1e
4
0 :4 1 :7 2 :5 3
:5 4 1 :2 4 :5 1

90
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 b :3 0 18
1 16 :9 0 7
3f 0 :2 5 :3 0
6 :2 0 3 6
8 :6 0 4 :6 0
a 9 0 4
0 17 :2 0 9
8 :3 0 d :7 0
7 :6 0 f e
0 4 0 a
:3 0 12 :7 0 9
:6 0 14 13 0
4 0 2 4
2 1 :3 0 2
:3 0 2 :2 0 2
19 16 0 1b
1a 1d :8 0 
f
4
:3 0 1 7 1
5 1 c 1
11 3 b 10
15 
1
4
0 
1c
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
2 0 1
11 1 0
5 1 0
c 1 0
0

/
CREATE OR REPLACE TYPE Cluster_internal_type wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
b
2 :e:
1TYPE:
1CLUSTER_INTERNAL_TYPE:
1OBJECT:
1NUMBER_POINTS:
1NUMBER:
110:
1CENTROID:
1NUMBER_TAB_TYPE:
1HISTOGRAMS:
1HISTOGRAM_TAB_TYPE:
1DISPERSION:
0

0
0
23
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 a3 a0 1c b0 81 a3 a0
1c b0 81 77 a0 102 a0 c6
1d 17 b5 
23
2
0 3 8f b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 67 5b 5f 42 6e 83 77
7b 3f 8a 73 7 96 98 9c
9e 9f a8 
23
2
0 1 6 1f 1 8 16 1d
1c 16 :3 8 :2 16 :3 8 :2 16 :3 8 :2 16
:2 8 1 :2 1c :5 1 
23
4
0 :4 1 :7 2 :5 3
:5 4 :5 5 1 :2 5
:5 1 
aa
4
:3 0 1 :3 0 2
:3 0 3 :3 0 d
:3 0 1d 1 1b
:9 0 7 3f 0
:2 5 :3 0 6 :2 0
3 6 8 :6 0
4 :6 0 a 9
0 4 0 b
73 0 9 8
:3 0 d :7 0 7
:6 0 f e 0
4 0 a :3 0
12 :7 0 9 :6 0
14 13 0 4
0 2 0 4
0 5 :3 0 17
:7 0 b :6 0 19
18 0 4 0
2 4 2 1
:3 0 1c 0 2
:2 0 2 1e 1b
0 20 1f 22
:8 0 
12
4
:3 0 1 7 1
5 1 c 1
11 1 16 4
b 10 15 1a

1
4
0 
21
0
1
14
1
5
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
c 1 0
5 1 0
16 1 0
11 1 0
2 0 1
0

/
CREATE TYPE "TargetValueCount" wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
8
2 :e:
1TYPE:
1TargetValueCount:
1OBJECT:
1@value:
1VARCHAR2:
164:
1@count:
1NUMBER:
0

0
0
19
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 77 a0 102 a0 c6 1d 17
b5 
19
2
0 3 5b b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 3f 7 62 64 68 6a 6b
74 
19
2
0 1 6 1c 1 3 c 15
14 c :2 3 1a :2 23 :2 1a 1 :2 2a
:5 1 
19
4
0 :4 1 :c 2 1
:2 2 :5 1 
76
4
:3 0 1 :3 0 2
:3 0 3 :3 0 9
:3 0 13 1 11
:9 0 7 3f 0
:2 5 :3 0 6 :2 0
3 6 8 :6 0
4 :5 0 1 a
9 0 4 0
2 0 4 0
8 :3 0 d :7 0
7 :5 0 1 f
e 0 4 0
2 4 2 1
:3 0 12 0 2
:2 0 2 14 11
0 16 15 18
:8 0 
c
4
:3 0 1 7 1
5 1 c 2
b 10 
1
4
0 
17
0
1
14
1
3
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
c 1 0
5 1 0
2 0 1
0

/
CREATE TYPE TargetValueCounts AS TABLE OF "TargetValueCount";
/
CREATE TYPE "PairCounts" wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
8
2 :e:
1TYPE:
1PairCounts:
1OBJECT:
1@value:
1VARCHAR2:
164:
1TargetValueCounts:
1TARGETVALUECOUNTS:
0

0
0
19
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 77 a0 102 a0 c6 1d 17
b5 
19
2
0 3 5b b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 3f 7 62 64 68 6a 6b
74 
19
2
0 1 6 16 1 3 c 15
14 c :2 3 1a :2 2e :2 1a 1 :2 40
:5 1 
19
4
0 :4 1 :c 2 1
:2 2 :5 1 
76
4
:3 0 1 :3 0 2
:3 0 3 :3 0 9
:3 0 13 1 11
:9 0 7 3f 0
:2 5 :3 0 6 :2 0
3 6 8 :6 0
4 :5 0 1 a
9 0 4 0
2 0 4 0
8 :3 0 d :7 0
7 :5 0 1 f
e 0 4 0
2 4 2 1
:3 0 12 0 2
:2 0 2 14 11
0 16 15 18
:8 0 
c
4
:3 0 1 7 1
5 1 c 2
b 10 
1
4
0 
17
0
1
14
1
3
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
2 0 1
c 1 0
5 1 0
0

/
CREATE TYPE PairCountList AS TABLE OF "PairCounts";
/
CREATE TYPE "BayesInput" wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
8
2 :e:
1TYPE:
1BayesInput:
1OBJECT:
1@fieldName:
1VARCHAR2:
164:
1PairCountList:
1PAIRCOUNTLIST:
0

0
0
19
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 77 a0 102 a0 c6 1d 17
b5 
19
2
0 3 5b b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 3f 7 62 64 68 6a 6b
74 
19
2
0 1 6 16 1 3 13 1c
1b 13 :3 3 :2 13 :2 3 1 :2 21 :5 1

19
4
0 :4 1 :7 2 :5 3
1 :2 3 :5 1 
76
4
:3 0 1 :3 0 2
:3 0 3 :3 0 9
:3 0 13 1 11
:9 0 7 3f 0
:2 5 :3 0 6 :2 0
3 6 8 :6 0
4 :5 0 1 a
9 0 4 0
2 0 4 0
8 :3 0 d :7 0
7 :5 0 1 f
e 0 4 0
2 4 2 1
:3 0 12 0 2
:2 0 2 14 11
0 16 15 18
:8 0 
c
4
:3 0 1 7 1
5 1 c 2
b 10 
1
4
0 
17
0
1
14
1
3
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
c 1 0
2 0 1
5 1 0
0

/
CREATE TYPE BayesInputs AS TABLE OF "BayesInput";
/
CREATE TYPE BayesOutput wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
8
2 :e:
1TYPE:
1BAYESOUTPUT:
1OBJECT:
1@fieldName:
1VARCHAR2:
164:
1TargetValueCounts:
1TARGETVALUECOUNTS:
0

0
0
19
2
0 a0 9d a0 60 a3 a0 51
a5 1c b0 81 a3 a0 1c b0
81 77 a0 102 a0 c6 1d 17
b5 
19
2
0 3 5b b f 33 23 27
2a 2b 22 3a 4f 43 47 1f
56 3f 7 62 64 68 6a 6b
74 
19
2
0 1 6 15 1 3 10 19
18 10 :2 3 1e :2 32 :2 1e 1 :2 44
:5 1 
19
4
0 :4 1 :c 2 1
:2 2 :5 1 
76
4
:3 0 1 :3 0 2
:3 0 3 :3 0 9
:3 0 13 1 11
:9 0 7 3f 0
:2 5 :3 0 6 :2 0
3 6 8 :6 0
4 :5 0 1 a
9 0 4 0
2 0 4 0
8 :3 0 d :7 0
7 :5 0 1 f
e 0 4 0
2 4 2 1
:3 0 12 0 2
:2 0 2 14 11
0 16 15 18
:8 0 
c
4
:3 0 1 7 1
5 1 c 2
b 10 
1
4
0 
17
0
1
14
1
3
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
2 0 1
c 1 0
5 1 0
0

/
CREATE TYPE NBSection wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
7
2 :e:
1TYPE:
1NBSECTION:
1OBJECT:
1BayesInputs:
1BAYESINPUTS:
1BayesOutput:
1BAYESOUTPUT:
0

0
0
17
2
0 a0 9d a0 60 a3 a0 1c
b0 81 a3 a0 1c b0 81 77
a0 102 a0 c6 1d 17 b5 
17
2
0 3 57 b f 2f 23 27
22 36 4b 3f 43 1f 52 3b
7 5e 60 64 66 67 70 
17
2
0 1 6 13 1 3 :2 11 :2 3
1e :2 2c :2 1e 1 :2 38 :5 1 
17
4
0 :4 1 :a 2 1
:2 2 :5 1 
72
4
:3 0 1 :3 0 2
:3 0 3 :3 0 7
:3 0 11 1 f
:9 0 5 3b 0
3 5 :3 0 6
:7 0 4 :5 0 1
8 7 0 4
0 2 0 4
0 7 :3 0 b
:7 0 6 :5 0 1
d c 0 4
0 2 4 2
1 :3 0 10 0
2 :2 0 2 12
f 0 14 13
16 :8 0 
a
4
:3 0 1 5 1
a 2 9 e

1
4
0 
15
0
1
14
1
3
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
5 1 0
2 0 1
a 1 0
0

/
