ALTER SESSION SET CURRENT_SCHEMA = "ODM";
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('int', 'AUTO_BIN_CATEGORICAL_NUM', '5', 'Number of bins used by automated binning for categorical attributes');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('STRING', 'AUTO_BIN_CATEGORICAL_OTHER', 'OTHER_CATEGORY', 'Name of the OTHER bin');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'NUMBER', 'AUTO_BIN_NUMERICAL_NUM', '5', 'Number of bins used by automated binning for numerical attributes');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'NUMBER', 'ABN_ALG_SETTING_NF_DEPTH', '10', 'Maximum depth of any NetworkFeature for ABN setting');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'NUMBER', 'ABN_ALG_SETTING_NUM_NF', '10', 'Maximum number of Network Feature for ABN setting');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'NUMBER', 'ABN_ALG_SETTING_NUM_PRUNED_NF', '-1', 'Maximum number of consecutive pruned Network Feature for ABN setting');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'STRING', 'ProductBanner','Oracle9i Data Mining (ODM Schema) Version 9.2.0.1.0 - PRODUCTION','Product Banner');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'string', 'ODM_SCHEMA', 'ODM', 'ODM SCHEMA REPOSITORY OWNER');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'NUMBER', 'CL_ALG_SETTING_KM_FACTOR','20','Controls the number of points produced by summarization for K-Means.The larger the value the more points.The formula used for computing the number of points is:No. Points=CL_ALG_SETTING_KM_FACTOR*Num_Attributes*Num_Clusters.No. of points is capped at 1000');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'NUMBER', 'CL_ALG_SETTING_CHI2_LOW', '1.353','Controls the level of statistical significance for O-Cluster to determine if more data is necessary to refine a model. (Default=1.353)');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'int', 'CL_ALG_SETTING_MIN_CHI2_POINTS', '10','Controls the minimum number of rows required by O-Cluster to find a cluster (default = 10).  This parameter may be tuned for datasets with a very small number of rows. In this case it should be set to a small number in the [3,10] range.');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'int', 'CL_ALG_SETTING_KM_BUFFER','10000','Number of rows used by the in-memory buffer used by K-Means (default=10000). For an installation with limited memory this number should be set to a smaller value than the default size.');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'int', 'CL_ALG_SETTING_OC_BUFFER', '50000','Number of rows used by the in-memory buffer used by O-Cluster (default=50,000). For an installation with limited memory this number should be set to a smaller value than the default size.');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ( 'int','AUTO_BIN_CL_NUMERICAL_NUM','100','Maximum number of bins allowed for numerical attributes (default=100). Useful range: 2-100.');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('NUMBER','CL_ALG_SETTING_KM_BIN_FACTOR','2','Factor used in automatic bin number computation for the K-Means algorithm (default=2).');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('NUMBER','CL_ALG_SETTING_OC_BIN_FACTOR','0.9','Factor used in automatic bin number computation for the O-Cluster algorithm (default=0.9).');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('int', 'CL_ALG_SETTING_TREE_GROWTH','1','Flag indicating if K-Means should be a balanced tree (1) or an unbalanced tree(2). The default is balanced tree(1).');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('int','CLASSIFICATION_BUILD_SEQ_PER_PARTITION','50000','No max limit. Minimum should be about 1,000. The effect
 is two-fold. Keeps the computations constrained to memory-sized chunks. Determines the size of the random sample used for MDL computations (scoring within build)');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('int','CLASSIFICATION_APPLY_SEQ_PER_PARTITION','50000','Goal is to keep constrain the scoring to memory-sized chunks of the data and loop thru such chunks. This will depend on typical # transactions per sequence id and SGA.');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('int','CLUSTERING_APPLY_SEQ_PER_PARTITION','50000','Maximum number of unique sequence IDs per partition used by clustering apply (default=50,000).');
INSERT INTO ODM_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('int','AI_BUILD_SEQ_PER_PARTITION','50000','Maximum number of unique sequence IDs per partition used by Attribute Importance (default=50,000).');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('string', 'DBMS_JOB', '', '');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'HOST_ID_COLUMN_LENGTH','100','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'CONFIG_NAME_COLUMN_LENGTH','128','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'TASK_STATE_COLUMN_LENGTH','16','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'CONFIG_DESC_COLUMN_LENGTH','256','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'USER_NAME_COLUMN_LENGTH','30','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'DATA_TYPE_COLUMN_LENGTH','32','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'LOCATION_COLUMN_LENGTH','61','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'FUNCT_NAME_COLUMN_LENGTH','64','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('byte', 'USER_ID_COLUMN_LENGTH','80','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('char', 'OBJECT_NAME_COLUMN_LENGTH','64','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('char', 'TEXT_COLUMN_LENGTH','1000','');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES ('int','TASK_WAIT_INTERVAL','30','This attribute is used to control the wait interval of the mining task, when it is polling from the state.');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES('NUMBER','ABN_PRED_BIT_FRACTION','0.2','controls ABN feature selection for bioinformatics data, top k predictors chosen for model build as fraction of baseline description');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES('int','ABN_MAX_ATTRIBUTES','25','controls ABN feature selection for business data (wide-deep), top k predictors chosen for model build');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES('NUMBER','ABN_COMPLEXITY_BIAS','0.0','BIAS (in bits) against entry of new predictor in feature or new feature in model: bits below current minimum description length required for model entry');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES('int','ABN_NUM_DETAILED_RULES','0','Number of detailed rules returned by apply operation');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
VALUES('int','ABN_NUM_AGGREGATE_RULES','0','Number of decision tree (aggregate) rules returned by apply operation');
INSERT INTO ODM_INTERNAL_CONFIGURATION (DATA_TYPE, NAME, VALUE, DESCRIPTION)
    VALUES ('int', 'AR_MAX_PARTITIONS', '4', 'Maximum number of partitions allowed for the second level of AR build');
COMMIT;
WHENEVER SQLERROR CONTINUE;
DROP TRIGGER odm_mining_model_trigger;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
CREATE OR REPLACE TRIGGER odm_mining_model_trigger
AFTER DELETE ON odm_mining_model
FOR EACH ROW
DECLARE
  PRAGMA AUTONOMOUS_TRANSACTION;
  v_cnt  NUMBER;
BEGIN
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_1;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_2;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_3;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_4;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_5;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_6;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_7;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    SELECT COUNT(*) INTO v_cnt
      FROM odm_mining_model 
      WHERE bin_numerical_table = :old.bin_numerical_table;
    IF v_cnt = 1 THEN
      EXECUTE IMMEDIATE 'DROP TABLE '|| :old.bin_numerical_table;
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    SELECT COUNT(*) INTO v_cnt
      FROM odm_mining_model 
      WHERE bin_categorical_table = :old.bin_categorical_table;
    IF v_cnt = 1 THEN
      EXECUTE IMMEDIATE 'DROP TABLE '|| :old.bin_categorical_table;
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
EXCEPTION 
  WHEN OTHERS THEN
    NULL;
END;
/
SHOW ERRORS
BEGIN
  BEGIN
    DBMS_AQADM.STOP_QUEUE( 'ODM.TASK_QUEUE' );
    DBMS_AQADM.DROP_QUEUE( 'ODM.TASK_QUEUE' );
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
  BEGIN
    DBMS_AQADM.DROP_QUEUE_TABLE ( 'ODM.DMS_QUEUE_TABLE' );
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
DBMS_AQADM.CREATE_QUEUE_TABLE(
  queue_table => 'ODM.DMS_QUEUE_TABLE',
  queue_payload_type => 'SYS.AQ$_JMS_TEXT_MESSAGE',
  sort_list => 'enq_time',
  multiple_consumers => FALSE,
  comment => 'ODM Task Queues maintained in this table'
);
DBMS_AQADM.CREATE_QUEUE (
  queue_name => 'ODM.TASK_QUEUE',
  queue_table => 'ODM.DMS_QUEUE_TABLE'
);
DBMS_AQADM.START_QUEUE( 'ODM.TASK_QUEUE' );
END;
/
WHENEVER SQLERROR CONTINUE;
