--------------------------------------------------------------------------------
--
-- $Header: dmmtrnt_mig.sql 29-apr-2002.14:58:13 xbarr Exp $
--
-- dmmtrnt_mig.sql
--
--  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
--
--    NAME
--    dmmtrnt_mig.sql
--
--    DESCRIPTION
--      This script creates ODM_MTR schema objects and loads datasets via sqlldr
--
--    NOTES
--      This will be replaced to use Sample SH schema data and some new MTR views for Rel2. 
--            For now just use the previous set of MTR census data
--
--    MODIFIED   (MM/DD/YY)
--       xbarr    04/29/02 - fix bug 2339555
--       xbarr    03/12/02 - xbarr_update_dbca_registry
--       xbarr    03/12/02 - modified to be used for Upgrade on NT
--       xbarr    03/07/02 - xbarr_tmini_update_translation
--       xbarr    03/07/02 - modified to be used by DBUA (no logfile dir)
--       xbarr    02/26/02 - Add sqlldr section for DBCA. Add log entry  
--       xbarr    02/12/02 - Reset SQLERROR CONTINUE at the end of the script 
--       xbarr    01/14/02 - Add SQLERROR statements 
--       mmcracke 12/10/01 - Add 6 more data sets..
--       mmcracke 12/07/01 - Rewrite for 9.2
--       xbarr    10/16/01 - Initial creation.
--
--------------------------------------------------------------------------------

WHENEVER SQLERROR CONTINUE;

DROP TABLE census_2d_build_unbinned cascade constraints;
DROP TABLE census_2d_test_unbinned cascade constraints;
DROP TABLE census_2d_apply_unbinned cascade constraints;
DROP TABLE census_2d_build_binned cascade constraints;
DROP TABLE census_2d_test_binned cascade constraints;
DROP TABLE census_2d_apply_binned cascade constraints;
DROP TABLE market_basket_2d_binned cascade constraints;
DROP TABLE market_basket_tx_binned cascade constraints;
DROP TABLE magazine_2d_build_binned cascade constraints;
DROP TABLE magazine_2d_test_binned cascade constraints;
DROP TABLE eight_clouds_build_unbinned cascade constraints;
DROP TABLE eight_clouds_apply_unbinned cascade constraints;

WHENEVER SQLERROR EXIT FAILURE ROLLBACK;

CREATE TABLE CENSUS_2D_BUILD_UNBINNED (
  PERSON_ID      NUMBER(10),                                         
  AGE            NUMBER,
  WORKCLASS      VARCHAR2(10),
  WEIGHT         NUMBER,
  EDUCATION      VARCHAR2(10),
  EDUCATION_NUM  NUMBER,
  MARITAL_STATUS VARCHAR2(12),
  OCCUPATION     VARCHAR2(10),
  RELATIONSHIP   VARCHAR2(10),
  RACE           VARCHAR2(10),
  SEX            VARCHAR2(8),
  CAPITAL_GAIN   NUMBER,
  CAPITAL_LOSS   NUMBER,
  HOURS_PER_WEEK NUMBER,
  NATIVE_COUNTRY VARCHAR2(10),
  CLASS          NUMBER(2))
/

CREATE TABLE CENSUS_2D_TEST_UNBINNED (
  PERSON_ID      NUMBER(10),                                         
  AGE            NUMBER,
  WORKCLASS      VARCHAR2(10),
  WEIGHT         NUMBER,
  EDUCATION      VARCHAR2(10),
  EDUCATION_NUM  NUMBER,
  MARITAL_STATUS VARCHAR2(12),
  OCCUPATION     VARCHAR2(10),
  RELATIONSHIP   VARCHAR2(10),
  RACE           VARCHAR2(10),
  SEX            VARCHAR2(8),
  CAPITAL_GAIN   NUMBER,
  CAPITAL_LOSS   NUMBER,
  HOURS_PER_WEEK NUMBER,
  NATIVE_COUNTRY VARCHAR2(10),
  CLASS          NUMBER(2))
/

CREATE TABLE CENSUS_2D_APPLY_UNBINNED (
  PERSON_ID      NUMBER(10),                                         
  AGE            NUMBER,
  WORKCLASS      VARCHAR2(10),
  WEIGHT         NUMBER,
  EDUCATION      VARCHAR2(10),
  EDUCATION_NUM  NUMBER,
  MARITAL_STATUS VARCHAR2(12),
  OCCUPATION     VARCHAR2(10),
  RELATIONSHIP   VARCHAR2(10),
  RACE           VARCHAR2(10),
  SEX            VARCHAR2(8),
  CAPITAL_GAIN   NUMBER,
  CAPITAL_LOSS   NUMBER,
  HOURS_PER_WEEK NUMBER,
  NATIVE_COUNTRY VARCHAR2(10),
  CLASS          NUMBER(2))
/

CREATE TABLE CENSUS_2D_BUILD_BINNED (
  PERSON_ID      NUMBER(10),                                         
  AGE            NUMBER,
  WORKCLASS      NUMBER,
  WEIGHT         NUMBER,
  EDUCATION      NUMBER,
  EDUCATION_NUM  NUMBER,
  MARITAL_STATUS NUMBER,
  OCCUPATION     NUMBER,
  RELATIONSHIP   NUMBER,
  RACE           NUMBER,
  SEX            NUMBER,
  CAPITAL_GAIN   NUMBER,
  CAPITAL_LOSS   NUMBER,
  HOURS_PER_WEEK NUMBER,
  NATIVE_COUNTRY NUMBER,
  CLASS          NUMBER(2))
/

CREATE TABLE CENSUS_2D_TEST_BINNED (
  PERSON_ID      NUMBER(10),                                         
  AGE            NUMBER,
  WORKCLASS      NUMBER,
  WEIGHT         NUMBER,
  EDUCATION      NUMBER,
  EDUCATION_NUM  NUMBER,
  MARITAL_STATUS NUMBER,
  OCCUPATION     NUMBER,
  RELATIONSHIP   NUMBER,
  RACE           NUMBER,
  SEX            NUMBER,
  CAPITAL_GAIN   NUMBER,
  CAPITAL_LOSS   NUMBER,
  HOURS_PER_WEEK NUMBER,
  NATIVE_COUNTRY NUMBER,
  CLASS          NUMBER(2))
/

CREATE TABLE CENSUS_2D_APPLY_BINNED (
  PERSON_ID      NUMBER(10),                                         
  AGE            NUMBER,
  WORKCLASS      NUMBER,
  WEIGHT         NUMBER,
  EDUCATION      NUMBER,
  EDUCATION_NUM  NUMBER,
  MARITAL_STATUS NUMBER,
  OCCUPATION     NUMBER,
  RELATIONSHIP   NUMBER,
  RACE           NUMBER,
  SEX            NUMBER,
  CAPITAL_GAIN   NUMBER,
  CAPITAL_LOSS   NUMBER,
  HOURS_PER_WEEK NUMBER,
  NATIVE_COUNTRY NUMBER,
  CLASS          NUMBER(2))
/
  
CREATE TABLE MARKET_BASKET_2D_BINNED (                                       
  ID             NUMBER,
  DELI           NUMBER,
  CANNED_GOODS   NUMBER,
  PRODUCE        NUMBER,
  DAIRY_GOODS    NUMBER,
  SEAFOOD        NUMBER,
  BUTCHER_SHOP   NUMBER,
  TV_DINNER      NUMBER,
  BEER           NUMBER,
  WINE           NUMBER,
  SODA           NUMBER,
  CANDY          NUMBER)
/

CREATE TABLE MARKET_BASKET_TX_BINNED (
  SEQUENCE_ID    NUMBER,
  ATTRIBUTE_NAME VARCHAR2(64),
  VALUE          NUMBER)
/
  
CREATE TABLE MAGAZINE_2D_BUILD_BINNED (
  AG18_24M  NUMBER,
  MAK1      NUMBER,
  PIMY1     NUMBER,
  PRI1      NUMBER,
  RELIGION  NUMBER,
  AG0_17    NUMBER,
  AG35_54M  NUMBER,
  DWELSIZE  NUMBER,
  AG0_5     NUMBER,
  AG18_24F  NUMBER,
  AG45_54M  NUMBER,
  AG65P     NUMBER,
  AVMV      NUMBER,
  CYL1      NUMBER,
  PPI       NUMBER,
  YDL       NUMBER,
  ACTVCNSR  NUMBER,
  AG18_34F  NUMBER,
  AG18_34M  NUMBER,
  AG35_44M  NUMBER,
  AG55_64M  NUMBER,
  AG6_11    NUMBER,
  HHSIZE3P  NUMBER,
  LISTTYPE  NUMBER,
  PIMY2     NUMBER,
  AG12_17   NUMBER,
  AG35_54F  NUMBER,
  AG55_64F  NUMBER,
  FUL1      NUMBER,
  HHSIZE12  NUMBER,
  STATE     NUMBER,
  TITLE     NUMBER,
  AG35_44F  NUMBER,
  CRCT      NUMBER,
  FIND      NUMBER,
  INTF2534  NUMBER,
  YER1      NUMBER,
  AG0_11    NUMBER,
  AG18_44F  NUMBER,
  AG45_54F  NUMBER,
  BOD1      NUMBER,
  MR_MAG    NUMBER,
  POLITICS  NUMBER,
  SER1      NUMBER,
  ACTVBANK  NUMBER,
  AG12_17F  NUMBER,
  AG12_17M  NUMBER,
  AG50P     NUMBER,
  HVMV      NUMBER,
  INTM2534  NUMBER)
/

CREATE TABLE MAGAZINE_2D_TEST_BINNED (
  AG18_24M  NUMBER,
  MAK1      NUMBER,
  PIMY1     NUMBER,
  PRI1      NUMBER,
  RELIGION  NUMBER,
  AG0_17    NUMBER,
  AG35_54M  NUMBER,
  DWELSIZE  NUMBER,
  AG0_5     NUMBER,
  AG18_24F  NUMBER,
  AG45_54M  NUMBER,
  AG65P     NUMBER,
  AVMV      NUMBER,
  CYL1      NUMBER,
  PPI       NUMBER,
  YDL       NUMBER,
  ACTVCNSR  NUMBER,
  AG18_34F  NUMBER,
  AG18_34M  NUMBER,
  AG35_44M  NUMBER,
  AG55_64M  NUMBER,
  AG6_11    NUMBER,
  HHSIZE3P  NUMBER,
  LISTTYPE  NUMBER,
  PIMY2     NUMBER,
  AG12_17   NUMBER,
  AG35_54F  NUMBER,
  AG55_64F  NUMBER,
  FUL1      NUMBER,
  HHSIZE12  NUMBER,
  STATE     NUMBER,
  TITLE     NUMBER,
  AG35_44F  NUMBER,
  CRCT      NUMBER,
  FIND      NUMBER,
  INTF2534  NUMBER,
  YER1      NUMBER,
  AG0_11    NUMBER,
  AG18_44F  NUMBER,
  AG45_54F  NUMBER,
  BOD1      NUMBER,
  MR_MAG    NUMBER,
  POLITICS  NUMBER,
  SER1      NUMBER,
  ACTVBANK  NUMBER,
  AG12_17F  NUMBER,
  AG12_17M  NUMBER,
  AG50P     NUMBER,
  HVMV      NUMBER,
  INTM2534  NUMBER)
/

CREATE TABLE EIGHT_CLOUDS_BUILD_UNBINNED (
  X1        NUMBER,
  X2        NUMBER)
/

CREATE TABLE EIGHT_CLOUDS_APPLY_UNBINNED (
  X1        NUMBER,
  X2        NUMBER)
/

  
grant select on census_2d_build_unbinned to ODM;
grant select on census_2d_test_unbinned to ODM;
grant select on census_2d_apply_unbinned to ODM;
grant select on census_2d_build_binned to ODM;
grant select on census_2d_test_binned to ODM;
grant select on census_2d_apply_binned to ODM;
grant select on market_basket_2d_binned to ODM;
grant select on market_basket_tx_binned to ODM;
grant select on magazine_2d_build_binned to ODM;
grant select on magazine_2d_test_binned to ODM;
grant select on eight_clouds_build_unbinned to ODM;
grant select on eight_clouds_apply_unbinned to ODM;
   
Rem load MTR datasets via SQLLDR. 

Rem Census data sets
Rem ================
HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmcenbub.ctl data=%ORACLE_HOME%/dm/demo/data/dmcenbub.txt direct=yes 

HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmcentub.ctl data=%ORACLE_HOME%/dm/demo/data/dmcentub.txt direct=yes 

HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmcenaub.ctl data=%ORACLE_HOME%/dm/demo/data/dmcenaub.txt direct=yes 

HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmcenbb.ctl  data=%ORACLE_HOME%/dm/demo/data/dmcenbb.txt direct=yes 

HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmcentb.ctl  data=%ORACLE_HOME%/dm/demo/data/dmcentb.txt direct=yes 

HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmcenab.ctl  data=%ORACLE_HOME%/dm/demo/data/dmcenab.txt direct=yes 

Rem  Market Basket data sets
Rem  =======================
HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmmbb.ctl data=%ORACLE_HOME%/dm/demo/data/dmmbb.txt direct=yes 

HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmmbtxb.ctl  data=%ORACLE_HOME%/dm/demo/data/dmmbtxb.txt direct=yes 

Rem Magazine data sets
Rem ==================
HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmmagbb.ctl  data=%ORACLE_HOME%/dm/demo/data/dmmagbb.txt direct=yes 

HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dmmagtb.ctl  data=%ORACLE_HOME%/dm/demo/data/dmmagtb.txt direct=yes 

Rem Eight Clouds data sets
Rem ======================
HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dm8cbub.ctl  data=%ORACLE_HOME%/dm/demo/data/dm8cbub.txt direct=yes 

HOST %ORACLE_HOME%/bin/sqlldr userid=ODM_MTR/MTRPW control=%ORACLE_HOME%/dm/demo/data/dm8caub.ctl  data=%ORACLE_HOME%/dm/demo/data/dm8caub.txt direct=yes 

WHENEVER SQLERROR CONTINUE;
