Rem
Rem   ODM 9202 dmschema patch
Rem 

-- Real-time scoring types

WHENEVER SQLERROR CONTINUE;

DROP TYPE targ_list;
DROP TYPE targ_rec;
DROP TYPE rule_grp;
DROP TYPE rule_res;
DROP TYPE pred_grp;
DROP TYPE pred_res;
DROP TYPE abn_pred_grp;
DROP TYPE abn_pred_res;
DROP TYPE abn_evidwt_grp;
DROP TYPE abn_evidwt_res;
DROP TYPE rec_inst;
DROP TYPE attr_inst;

-- ABN Detailed Rule Types
DROP TYPE num_list_type;
DROP TYPE strval_list_type;

-- Real-time scoring types

CREATE TYPE attr_inst AS OBJECT (
  attr VARCHAR2(30),
  sval VARCHAR2(4000),
  nval NUMBER);
/

CREATE TYPE rec_inst AS TABLE OF attr_inst;
/

CREATE TYPE pred_res AS OBJECT (
  sprd VARCHAR2(4000),
  nprd NUMBER,
  prob NUMBER,
  rank NUMBER);
/

CREATE TYPE pred_grp AS TABLE OF pred_res;
/

CREATE TYPE rule_res AS OBJECT (
  sprd VARCHAR2(4000),
  nprd NUMBER,
  rule NUMBER,
  rank NUMBER);
/

CREATE TYPE rule_grp AS TABLE OF rule_res;
/

CREATE TYPE abn_pred_res AS OBJECT 
  (sprd                  VARCHAR2(4000)
  ,nprd                  NUMBER
  ,prob                  NUMBER
  ,rank                  NUMBER
  ,rule_id               NUMBER  
  )
/
CREATE TYPE abn_pred_grp AS TABLE OF abn_pred_res;
/

CREATE TYPE abn_evidwt_res AUTHID CURRENT_USER AS OBJECT 
  (attr_name_value       VARCHAR2(4030)
  ,starget_value         VARCHAR2(4000)
  ,ntarget_value         NUMBER
  ,weight_of_evidence    NUMBER  
  )
/
CREATE TYPE abn_evidwt_grp AS TABLE OF abn_evidwt_res;
/

CREATE TYPE targ_rec AS OBJECT (
  ntrg NUMBER,
  strg VARCHAR2(4000));
/

CREATE TYPE targ_list AS TABLE OF targ_rec;
/

-- ABN Detailed Rule Types
CREATE OR REPLACE TYPE num_list_type IS VARRAY(1000) OF NUMBER;
/
CREATE OR REPLACE TYPE strval_list_type IS VARRAY(1000) OF VARCHAR2(128);
/


commit;
