Rem ##########################################################################
Rem 
Rem Copyright (c) 1991, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      odmpatch.sql
Rem
Rem    DESCRIPTION
Rem	 Script for Data Mining patch loading 
Rem
Rem    RETURNS
Rem 
Rem    NOTES
Rem      This script must be run while connected as SYS. After running the script, 
Rem      ODM should be at 9203 patch release level   
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    xbarr    09/21/05 - updates for 9.2.0.8
Rem    xbarr    04/14/05 - fix bug 4274747 
Rem    xbarr    04/07/05 - clean ups 
Rem    xbarr    02/11/05 - update for 9207 
Rem    xbarr    10/08/04 - Fix bug 3917128 
Rem    xbarr    07/30/04 - change upgraded to loaded for the registry 
Rem    xbarr    07/29/04 - remove deleting error table part 
Rem    xbarr    05/06/04 - update DM 9206 patch release 
Rem    xbarr    01/11/04 - update install for RDBMS/ODM 9205 release 
Rem    xbarr    08/22/03 - grant restricted session to ODM 
Rem    xbarr    07/24/03 - compile all DM PL/SQL packages
Rem    xbarr    07/23/03 - reloading dmmuh & dmnbb 
Rem    xbarr    07/18/03 - recompile ABN package 
Rem    xbarr    07/16/03 - add validation 
Rem    xbarr    07/15/03 - add upgraded version and banner for registry 
Rem    xbarr    06/30/03 - remove check_server_instance 
Rem    xbarr    05/30/03 - updated for ODM 9204 patch release 
Rem    xbarr    02/14/03 - xbarr_txn106309
Rem    xbarr    02/12/03 - Creation
Rem
Rem #########################################################################


ALTER SESSION SET CURRENT_SCHEMA = "SYS";

set serveroutput on;

execute dbms_java.grant_permission(UPPER('ODM'),'SYS:java.io.FilePermission','dm/lib/odmapi.jar','read');

GRANT restricted session to ODM;

Rem  revoke ANY privileges for security 

BEGIN
  EXECUTE IMMEDIATE
   'REVOKE CREATE ANY TABLE from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1952) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/


BEGIN
  EXECUTE IMMEDIATE
   'REVOKE DROP ANY TABLE from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1952) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE
   'REVOKE CREATE ANY VIEW from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1952) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE
   'REVOKE DROP ANY VIEW from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1952) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE
   'REVOKE INSERT ANY TABLE from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1952) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE
   'REVOKE SELECT ANY TABLE from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1952) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE
   'REVOKE UPDATE ANY TABLE from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1952) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/


BEGIN
  EXECUTE IMMEDIATE
   'REVOKE CREATE ANY INDEX from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1952) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE
   'REVOKE SELECT_CATALOG_ROLE from ODM';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1951) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/


BEGIN
  EXECUTE IMMEDIATE
   'REVOKE SELECT_CATALOG_ROLE from ODM_MTR';
EXCEPTION
   WHEN OTHERS THEN
      IF SQLCODE IN (-1951) THEN NULL;
      ELSE RAISE;
      END IF;
END;
/

commit;

Rem  Load ODM validation proc into SYS
Rem
@@odmproc.sql

ALTER SESSION SET CURRENT_SCHEMA = "ODM"

Rem  Drop ODM existing Java classes

ALTER SESSION SET CURRENT_SCHEMA = "ODM";

DECLARE
  dropall_cmd VARCHAR2(1000);
begin
  for drop_rec in
    (select dbms_java.longname(object_name) jname
      from dba_objects
      where owner = 'ODM' and object_type = 'JAVA CLASS')
  loop
     execute immediate
    'DROP JAVA CLASS "ODM' || '"."' || drop_rec.jname ||'"';
  end loop;
  commit;
  exception when others then
  null;
  end;
/

commit;

Rem   Load ODM 9208 java classes

ALTER SESSION SET CURRENT_SCHEMA = "ODM";

call dbms_java.set_output(10000);

call sys.dbms_java.loadjava('-schema ODM -force -verbose -resolve -synonym -grant PUBLIC dm/lib/odmapi.jar');

Rem Upgrade DM Schemas objects and PL/SQL packages

@@dmschema_patch.sql

@@dmerrh.plb
@@dmerrb.plb

@@dmmuh.plb
@@dmmub.plb

@@dmmth.plb
@@dmmtb.plb

@@dmsuperh.plb
@@dmsuperb.plb

@@dmabh.plb
@@dmabb.plb

@@dmarh.plb
@@dmarb.plb

@@dmaih.plb
@@dmaib.plb

@@dmcuh.plb
@@dmcub.plb
@@dmoch.plb
@@dmocb.plb
@@dmkmh.plb
@@dmkmb.plb

@@dmnbah.plb
@@dmnbab.plb

@@dmnbh.plb
@@dmnbb.plb

@@dmmon.plb

Rem Recreate ODM_MINING_MODEL_TRIGGER (Bug#4274747)

CREATE OR REPLACE TRIGGER odm_mining_model_trigger
AFTER DELETE ON odm_mining_model
FOR EACH ROW
DECLARE
  PRAGMA AUTONOMOUS_TRANSACTION;
  v_cnt  NUMBER;
BEGIN
  -- drop table_1
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_1;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

  -- drop table_2
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_2;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

  -- drop table_3
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_3;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

  -- drop table_4
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_4;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

  -- drop table_5
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_5;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

  -- drop table_6
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_6;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

  -- drop table_7
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE '|| :old.table_7;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

  -- drop bin_numerical_table
  BEGIN
    SELECT COUNT(*) INTO v_cnt
      FROM odm_mining_model
      WHERE bin_numerical_table = :old.bin_numerical_table;

    IF v_cnt = 1 THEN
      EXECUTE IMMEDIATE 'DROP TABLE '|| :old.bin_numerical_table;
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;

  -- drop bin_categorical_table
  BEGIN
    SELECT COUNT(*) INTO v_cnt
      FROM odm_mining_model
      WHERE bin_categorical_table = :old.bin_categorical_table;

    IF v_cnt = 1 THEN
      EXECUTE IMMEDIATE 'DROP TABLE '|| :old.bin_categorical_table;
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
EXCEPTION
  WHEN OTHERS THEN
    NULL;
END;
/
SHOW ERRORS

commit;

Rem Recompile ODM packages

alter package ODM.DMT_ODM compile;
alter package ODM.DMT_OPUTIL compile;
alter package ODM.DMT_VERSION_UTIL compile;
alter package ODM.ODM_MODEL_UTIL compile;
alter package ODM.ODM_MODEL_UTIL compile body;
alter package ODM.ODM_SUPERVISED_MODEL compile;
alter package ODM.ODM_SUPERVISED_MODEL compile body;
alter package ODM.OP_COMMON compile;
alter package ODM.OP_COMMON compile body;

alter package ODM.odm_clustering_util compile;
alter package ODM.odm_clustering_util compile body;
alter package ODM.odm_oc_clustering_model compile;
alter package ODM.odm_oc_clustering_model compile body;
alter package ODM.odm_km_clustering_model compile;
alter package ODM.odm_km_clustering_model compile body;

alter package ODM.ODM_ASSOCIATION_RULE_MODEL compile;
alter package ODM.ODM_ASSOCIATION_RULE_MODEL compile body;

alter package ODM.ODM_ATTRIBUTE_IMPORTANCE_MODEL compile;
alter package ODM.ODM_ATTRIBUTE_IMPORTANCE_MODEL compile body;

alter package ODM.ODM_MINING_TRANSFORMATION compile;
alter package ODM.ODM_MINING_TRANSFORMATION compile body;

alter package ODM.ODM_NAIVE_BAYES_APPLY compile;
alter package ODM.ODM_NAIVE_BAYES_APPLY compile body;

alter package ODM.odm_abn_model compile;
alter package ODM.odm_abn_model compile body;

alter package ODM.ODM_NAIVE_BAYES_MODEL compile;
alter package ODM.ODM_NAIVE_BAYES_MODEL compile body;

alter trigger ODM_MINING_MODEL_TRIGGER compile;

commit;

Rem Update Version in ODM_CONFIGURATION table

alter session set current_schema = "ODM";

update odm_configuration
set value='Oracle9i Data Mining (ODM Schema) Version 9.2.0.8.0 - PRODUCTION'
where name = 'ProductBanner';

commit;

ALTER SESSION SET CURRENT_SCHEMA = "SYS";

execute sys.dbms_registry.loaded('ODM','9.2.0.8.0','Oracle Data Mining - Production');

execute sys.validate_odm;

commit;
