Rem ##########################################################################
Rem 
Rem Copyright (c) 1991, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      odmrelod.sql
Rem
Rem    DESCRIPTION
Rem	 Script for loading Data Mining component after downgrade from 10i.
Rem      It uses 9204 patch release code to reload 9204 version of ODM
Rem
Rem    RETURNS
Rem 
Rem    NOTES
Rem      This script must be run while connected as SYS. 
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    xbarr    03/24/06 - update versions
Rem    xbarr    02/11/05 - load validation proc to SYS
Rem    xbarr    02/09/05 - lrg_1829395 
Rem    xbarr    01/13/05 - fix lrg_1794875 
Rem    xbarr    05/28/04 - update reload for 9206 
Rem    xbarr    02/13/04 - update reload for 9205 
Rem    xbarr    06/30/03 - remove check_server_instance 
Rem    xbarr    05/30/03 - updated for reloading ODM 9204 release after downgrade from 10.1 
Rem    xbarr    02/14/03 - xbarr_txn106309
Rem    xbarr    02/12/03 - Creation
Rem
Rem #########################################################################


ALTER SESSION SET CURRENT_SCHEMA = "SYS";

execute sys.dbms_registry.loading('ODM','Oracle Data Mining',NULL,'ODM');

Rem Load ODM validation proc into SYS
@@odmproc.sql

Rem DM Java objects

set serveroutput on;

execute dbms_java.grant_permission(UPPER('ODM'),'SYS:java.io.FilePermission','dm/lib/odmapi.jar','read');

commit;

Rem  Drop ODM existing Java classes

ALTER SESSION SET CURRENT_SCHEMA = "ODM";

DECLARE
  dropall_cmd VARCHAR2(1000);
begin
  for drop_rec in
    (select dbms_java.longname(object_name) jname
      from dba_objects
      where owner = 'ODM' and object_type = 'JAVA CLASS')
  loop
     execute immediate
    'DROP JAVA CLASS "ODM' || '"."' || drop_rec.jname ||'"';
  end loop;
  commit;
  exception when others then
  null;
  end;
/

commit;

Rem   Load ODM 9207 java classes

ALTER SESSION SET CURRENT_SCHEMA = "ODM";

call dbms_java.set_output(10000);

call sys.dbms_java.loadjava('-schema ODM -force -verbose -resolve -synonym -grant PUBLIC dm/lib/odmapi.jar');

Rem Reload DM Schemas objects and PL/SQL packages

@@dmschema_patch.sql

@@dmutil.plb
@@dmapi.plb

@@dmerrh.plb
@@dmerrb.plb

@@dmmuh.plb
@@dmmub.plb

@@dmmth.plb
@@dmmtb.plb

@@dmsuperh.plb
@@dmsuperb.plb

@@dmabh.plb
@@dmabb.plb

@@dmarh.plb
@@dmarb.plb

@@dmaih.plb
@@dmaib.plb

@@dmcuh.plb
@@dmcub.plb
@@dmoch.plb
@@dmocb.plb
@@dmkmh.plb
@@dmkmb.plb

@@dmnbah.plb
@@dmnbab.plb

@@dmnbh.plb
@@dmnbb.plb

@@dmmon.plb

commit;


Rem Recompile ODM packages

alter package ODM.DMT_ODM compile;
alter package ODM.DMT_OPUTIL compile;
alter package ODM.DMT_VERSION_UTIL compile;
alter package ODM.ODM_MODEL_UTIL compile;
alter package ODM.ODM_MODEL_UTIL compile body;
alter package ODM.ODM_SUPERVISED_MODEL compile;
alter package ODM.ODM_SUPERVISED_MODEL compile body;
alter package ODM.OP_COMMON compile;
alter package ODM.OP_COMMON compile body;

alter package ODM.odm_clustering_util compile;
alter package ODM.odm_clustering_util compile body;
alter package ODM.odm_oc_clustering_model compile;
alter package ODM.odm_oc_clustering_model compile body;
alter package ODM.odm_km_clustering_model compile;
alter package ODM.odm_km_clustering_model compile body;

alter package ODM.ODM_ASSOCIATION_RULE_MODEL compile;
alter package ODM.ODM_ASSOCIATION_RULE_MODEL compile body;

alter package ODM.ODM_ATTRIBUTE_IMPORTANCE_MODEL compile;
alter package ODM.ODM_ATTRIBUTE_IMPORTANCE_MODEL compile body;

alter package ODM.ODM_MINING_TRANSFORMATION compile;
alter package ODM.ODM_MINING_TRANSFORMATION compile body;

alter package ODM.ODM_NAIVE_BAYES_APPLY compile;
alter package ODM.ODM_NAIVE_BAYES_APPLY compile body;

alter package ODM.odm_abn_model compile;
alter package ODM.odm_abn_model compile body;

alter package ODM.ODM_NAIVE_BAYES_MODEL compile;
alter package ODM.ODM_NAIVE_BAYES_MODEL compile body;

Rem Remove deprecated package

drop package ODM.DM_JSTP;

commit;

Rem Delete and Reload DM error messages

delete from odm.odm_error_table;

commit;

@@dmerrtbl_patch.sql

commit;


Rem Update Version in ODM_CONFIGURATION table

alter session set current_schema = "ODM";

update odm_configuration
set value='Oracle9i Data Mining (ODM Schema) Version 9.2.0.8.0 - PRODUCTION'
where name = 'ProductBanner';

commit;

ALTER SESSION SET CURRENT_SCHEMA = "SYS";

execute sys.dbms_registry.loaded('ODM','9.2.0.8.0','Oracle Data Mining - Production');

execute sys.validate_odm;

commit;
