Rem ##########################################################################
Rem 
Rem Copyright (c) 1991, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      odmu901.sql
Rem
Rem    DESCRIPTION
Rem	 Run all sql scripts for Data Mining Migration from 901 to 920 
Rem      Script to be called by ?/dm/admin/odmdbmig.sql
Rem
Rem    RETURNS
Rem 
Rem    NOTES
Rem      This script must be run while connected as SYS   
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       xbarr    06/02/03 - remove revoke statement AQ privs statement 
Rem       xbarr    08/02/02 - xbarr_txn102957
Rem       xbarr    06/06/02 - relocate odmdbmig script to in dm/admin/odmu901.sql
Rem       xbarr    03/12/02 - add dmerrtbl_mig 
Rem       xbarr    03/08/02 - add registry information in dba_registry 
Rem       xbarr    03/07/02 - add error table loading
Rem       xbarr    03/07/02 - use separate sqlldr related file
Rem       xbarr    03/07/02 - remove odmupd line
Rem       xbarr    01/24/02 - add dmmig.sql for R2 privileges 
Rem       xbarr    01/21/02 - add PMML dataset addition 
Rem       xbarr    01/14/02 - commented out dmupd. Will be replaced by dmconfig
Rem       xbarr    01/14/02 - use .plb 
Rem       xbarr    12/10/01 - Merged xbarr_update_shipit
Rem       xbarr    12/04/01 - Merged xbarr_migration_scripts
Rem
Rem    xbarr    12/10/01 - Updated script name and location
Rem    xbarr    12/03/01 - Updated to be called by ODMA
Rem    xbarr    10/27/01 - Creation
Rem
Rem #########################################################################

Rem Add ODM component into registry

execute sys.dbms_registry.upgrading('ODM');

Rem Grant DM920 privileges as SYS
@dmmig.sql

ALTER SESSION SET CURRENT_SCHEMA = "ODM";

Rem Migrate DM901 objects to DM920
@dmmig1.sql    

Rem Load DM 920 Schemas objects
@dmmig2.plb
@dmmig3.plb

Rem Load DM Java objects
@dmmig4.sql

Rem Load DM Error messages
@dmutil.plb

Rem Load ODM API JSPs
@dmapi.plb

Rem DM Procedures
@dmproc.sql

Rem DM PMML dataset loading
@dmpmml_mig.sql

Rem DM Error table loading
@dmerrtbl_mig.sql

ALTER SESSION SET CURRENT_SCHEMA = "ODM_MTR";

Rem DM MTR Data load
@dmmtr_mig.sql

ALTER SESSION SET CURRENT_SCHEMA = "SYS";

execute sys.dbms_registry.upgraded('ODM','9.2.0.1.0','Oracle Data Mining - Production');
