Rem ##########################################################################
Rem 
Rem Copyright (c) 1991, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      odmu920.sql
Rem
Rem    DESCRIPTION
Rem	 Run all sql scripts for Data Mining Migration from 920 to 10i 
Rem      Script to be called by ?/dm/admin/odmdbmig.sql
Rem
Rem    RETURNS
Rem 
Rem    NOTES
Rem      This script must be run while connected as SYS   
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       xbarr    06/02/03 - update DM User dataset loading, remove dmpsysup 
Rem       xbarr    03/10/03 - add dmcl.plb loading 
Rem       xbarr    03/08/03 - remove error table loading 
Rem       xbarr    02/03/03 - add validate proc 
Rem       xbarr    01/27/03 - change order of registry 
Rem       xbarr    01/13/03 - update schema registration 
Rem       xbarr    12/17/02 - change ODM to DMSYS in registry 
Rem       xbarr    11/18/02 - change notation to @@
Rem       xbarr    11/13/02 - update grant  
Rem       xbarr    09/25/02 - xbarr_txn104463
Rem       xbarr    09/24/02 - updated for 10i upgrade 
Rem       xbarr    09/24/02 - replicated from 9202 branch
Rem       xbarr    08/02/02 - xbarr_txn102957
Rem       xbarr    06/06/02 - relocate odmdbmig script to in dm/admin/odmu901.sql
Rem       xbarr    03/12/02 - add dmerrtbl_mig 
Rem       xbarr    03/08/02 - add registry information in dba_registry 
Rem       xbarr    03/07/02 - add error table loading
Rem       xbarr    03/07/02 - use separate sqlldr related file
Rem       xbarr    03/07/02 - remove odmupd line
Rem       xbarr    01/24/02 - add dmmig.sql for R2 privileges 
Rem       xbarr    01/21/02 - add PMML dataset addition 
Rem       xbarr    01/14/02 - commented out dmupd. Will be replaced by dmconfig
Rem       xbarr    01/14/02 - use .plb 
Rem       xbarr    12/10/01 - Merged xbarr_update_shipit
Rem       xbarr    12/04/01 - Merged xbarr_migration_scripts
Rem
Rem    xbarr    12/10/01 - Updated script name and location
Rem    xbarr    12/03/01 - Updated to be called by ODMA
Rem    xbarr    10/27/01 - Creation
Rem
Rem #########################################################################


Rem Create 10i DMSYS schema
@@odmcrtm.sql

Rem Add ODM component into registry with new DMSYS schema
execute sys.dbms_registry.upgrading('ODM',NULL,'validate_odm','DMSYS',NULL);

ALTER SESSION SET CURRENT_SCHEMA = "DMSYS";

Rem Load 10i Java objects
@@dmloadj.sql

Rem Load 10i DMSYS schema definition
@@dmsyssch.plb

Rem Load 10i PL/SQL API schema
@@dmpsysch.sql

Rem Migrate 920 schema objects to 10i
@@odmtab.sql

Rem Load ODM Error messages
@@dmutil.plb

Rem Load API JSPs
@@dmapi.plb

Rem Load DMSYS package/procedure objects
@@dmproc.sql

Rem Load Trusted Code NMF 
@@dmnmf.plb

Rem Load Trusted Code SVM
@@dmsvm.plb

Rem Load Trusted Code KMN
@@dmcl.plb

Rem Load Trusted Code Blast
@@dmblast.plb

Rem Load ODM PL/SQL api packages
@@dmpproc.sql

Rem DM PMML dataset loading
@@odmpmml_mig.sql

Rem DM validate proc
@@odmproc.sql

ALTER SESSION SET CURRENT_SCHEMA = "ODM";

Rem grant ODM access privs to DMSYS
@@odmgrant.sql

Rem Load DM Java Migration utility
@@initodm.sql

Rem Load DM User datasets(full demo datasets)
@@dmuserld.sql


ALTER SESSION SET CURRENT_SCHEMA = "SYS";

execute sys.dbms_registry.upgraded('ODM','10.1.0.0','Oracle Data Mining - Beta2');

Rem  Revoke DMSYS privs for security
revoke CREATE LIBRARY from DMSYS; 
