@echo off
REM
REM Copyright (c) 2001, 2006, Oracle. All rights reserved.  
REM
REM    DESCRIPTION
REM    This is a wrapper script to opatch perl scripts to save the 
REM    customer needing to find a version of perl.
REM
REM    NOTES: 1. This does make the assumption that Apache was installed
REM              as part of Oracle and $ORACLE_HOME is set.
REM           2. Assumes the version of perl is installed as "perl". If not
REM              either edit this file or call it manually.
REM           3. See the opatch file for the bourne shell script version.
REM
REM    BUGS
REM    * <if you know of any bugs, put them here!>
REM
REM    MODIFIED   (MM/DD/YY)
REM    vsriram     01/06/06 - Support 5.8.3 perl for IA.
REM    vsriram     12/20/05 - Support 5.8.3 perl.
REM    vsriram     08/30/05 - vjayaram: Add new trywin6410i label 
REM    shgangul    01/04/05 - Change no perl found message 
REM    shgangul    12/17/04 - Show messages only for debug 
REM    shgangul    11/26/04 - undo bug 3963463 
REM    shgangul    11/22/04 - Bug 3963463: Pick perl correctly for Win 64 
REM    phnguyen    10/07/04 - touch up error msg if OH not set 
REM    shgangul    10/07/03 - Iron out -oh and ORACLE_HOME issues
REM    shgangul    04/27/04 - bug 3494054: return exit code 
REM    phnguyen    04/02/04 - Use the same error message as in opatch.sh
REM    phnguyen    02/20/04 - Add new Perl path for 9iR2, Win 64-bit
REM    phnguyen    11/18/03 - Add new Perl path for 10G
REM    shgangul    09/04/03 - DPO to DP0 with a 0 not O 
REM    phnguyen    08/29/03 - Merge Shamik's below 
REM    shgangul    07/31/03 - Bug 3063368
REM    cdalessi    08/06/02  Made it work.
REM    rvadraha    05/08/02  Rewrite of the code.
REM    daevans     31/05/02  Inital code.
REM

setlocal

REM # Set the base path
set BASE=%~DP0%

REM # Get ORACLE_HOME from environment variable "ORACLE_HOME"
set OH=%ORACLE_HOME%

REM # Check for OPATCH_DEBUG env variable
set DEBUG=%OPATCH_DEBUG%

REM # Look for OPATCH_PLATFORM_ID
set PLATFORM=%OPATCH_PLATFORM_ID%

REM # If -oh is specified, use it to over-ride env. var. ORACLE_HOME
set getOH=0

REM # If -jre or -jdk are specified, use it to launch opatch,
REM #   with -jdk > -jre.  And we expect there is a "bin/java" underneath
REM #   the value supplied
set getJRE=0
set getJDK=0

set JDK=
set JRE=
set PARAMS=%*

:FORLOOP

if "%1" == "" goto DONELOOP

:CHECK1
if NOT "%getOH%" == "1" goto CHECK2 
set OH=%1
set getOH=0

:CHECK2
if NOT "%getJRE%" == "1" goto CHECK3 
set JRE=%1
set getJRE=0

:CHECK3
if NOT "%getJDK%" == "1" goto CHECK4 
set JDK=%1
set getJDK=1

:CHECK4
if NOT "%1" == "-oh" goto CHECK5
set getOH=1

:CHECK5
if NOT "%1" == "-jre" goto CHECK6
set getJRE=1

:CHECK6
if NOT "%1" == "-jdk" goto FORCHECK 
set getJDK=1

:FORCHECK
shift
goto FORLOOP

:DONELOOP

REM # Check for OPATCH_DEBUG env variable
:CHECK7
set DEBUGVAL=false
if NOT "%DEBUG%" == "TRUE" goto CHECK8
set DEBUGVAL=true

:CHECK8
if NOT "%DEBUG%" == "true" goto CHECK9
set DEBUGVAL=true

:CHECK9
REM # If Oracle Home not set, error out
if NOT "%OH%" == "" goto entry
echo Oracle Home is not set.  Set ORACLE_HOME or use -oh option. 
set %ERRORLEVEL% = 1
goto OPATCHDONE

:entry
REM Set ORACLE_HOME to used to later scripts
set ORACLE_HOME=%OH%

REM Is there a version of perl that's usable?
REM The default is to use the one with Apache so if it's not there check
REM to see what's happening.

if NOT EXIST %OH%\perl\5.6.1\bin\MSWin32-x86\perl.exe goto try9iperl

  set LIBRARIES=%OH%\perl\5.6.1\lib
  set PERL_BIN=%OH%\perl\5.6.1\bin\MSWin32-x86\perl.exe
  set PERL5LIB=%LIBRARIES% 
  if NOT "%DEBUGVAL%" == "true" goto CALLOPATCHNODEBUG1
  echo "set PERL5LIB=%LIBRARIES%"
  echo "%PERL_BIN% %BASE%opatch.pl ..."

:CALLOPATCHNODEBUG1
  %PERL_BIN% %BASE%opatch.pl %*
  goto end

:try9iperl

if NOT EXIST %OH%\Apache\perl\5.00503\bin\MSWin32-x86\perl.exe goto trywin6410i

  set LIBRARIES=%OH%\Apache\perl\lib\5.00503
  set PERL_BIN=%OH%\Apache\perl\5.00503\bin\MSWin32-x86\perl.exe
  set PERL5LIB=%LIBRARIES% 
  if NOT "%DEBUGVAL%" == "true" goto CALLOPATCHNODEBUG2
  echo "set PERL5LIB=%LIBRARIES%"
  echo "%PERL_BIN% %BASE%opatch.pl ..."

:CALLOPATCHNODEBUG2
  %PERL_BIN% %BASE%opatch.pl %*
  goto end

:trywin6410i
if NOT EXIST %OH%\perl\5.8.2\bin\MSWin32-IA64\perl.exe goto trywin649i

  set LIBRARIES=%OH%\perl\5.8.2\lib
  set PERL_BIN=%OH%\perl\5.8.2\bin\MSWin32-IA64\perl.exe 
  set PERL5LIB=%LIBRARIES% 
  if NOT "%DEBUGVAL%" == "true" goto CALLOPATCHNODEBUG3
  echo "set PERL5LIB=%LIBRARIES%"
  echo "%PERL_BIN% %BASE%opatch.pl ..."

:CALLOPATCHNODEBUG3
  %PERL_BIN% %BASE%opatch.pl %*
  goto end


:trywin649i
if NOT EXIST %OH%\perl\5.8.3\bin\MSWin32-x86-multi-thread\perl.exe goto tryApache

  set LIBRARIES=%OH%\perl\5.8.3\lib
  set PERL_BIN=%OH%\perl\5.8.3\bin\MSWin32-x86-multi-thread\perl.exe
  set PERL5LIB=%LIBRARIES%
  if NOT "%DEBUGVAL%" == "true" goto CALLOPATCHNODEBUG4
  echo "set PERL5LIB=%LIBRARIES%"
  echo "%PERL_BIN% %BASE%opatch.pl ..."

:CALLOPATCHNODEBUG4
  %PERL_BIN% %BASE%opatch.pl %*
  goto end


:tryApache
if NOT EXIST %OH%\Apache\perl\5.00503\bin\MSWin32-IA64\perl.exe goto trywinIA583

  set LIBRARIES=%OH%\Apache\perl\lib\5.00503
  set PERL_BIN=%OH%\Apache\perl\5.00503\bin\MSWin32-IA64\perl.exe
  set PERL5LIB=%LIBRARIES% 
  if NOT "%DEBUGVAL%" == "true" goto CALLOPATCHNODEBUG5
  echo "set PERL5LIB=%LIBRARIES%"
  echo "%PERL_BIN% %BASE%opatch.pl ..."

:CALLOPATCHNODEBUG5
  %PERL_BIN% %BASE%opatch.pl %*
  goto end

:trywinIA583
if NOT EXIST %OH%\perl\5.8.3\bin\MSWin32-IA64-multi-thread\perl.exe goto errperl

  set LIBRARIES=%OH%\perl\5.8.3\lib
  set PERL_BIN=%OH%\perl\5.8.3\bin\MSWin32-IA64-multi-thread\perl.exe
  set PERL5LIB=%LIBRARIES%
  if NOT "%DEBUGVAL%" == "true" goto CALLOPATCHNODEBUG6
  echo "set PERL5LIB=%LIBRARIES%"
  echo "%PERL_BIN% %BASE%opatch.pl ..."

:CALLOPATCHNODEBUG6
  %PERL_BIN% %BASE%opatch.pl %*
  goto end

:err

  echo "Please set the environment variable ORACLE_HOME and try again"
  goto end

:errperl

  echo.
  echo "OPatch could not detect Perl. Please set PERL5LIB appropriately and invoke Perl."
  echo "OPatch is certified with Perl Version 5.6.1."
  echo "Invoke OPatch manually using the following command format:"
  echo "  <path to Perl>/perl <path to OPatch>/opatch.pl <patch command> [options]"
  echo "You can use the following command format to view help information:"
  echo "  <path to Perl>/perl <path to OPatch>/opatch.pl  [<patch command>] -help"
  echo.

:end
:OPATCHDONE
set RESULT=%ERRORLEVEL%
if "%ERRORLEVEL%" == "0" goto SUCCEXIT
echo.
echo OPatch returns with error code = %RESULT%
goto EXIT

:SUCCEXIT
echo.
echo OPatch returns with error code = %RESULT%
goto EXIT

:EXIT
REM exit %RESULT%
