#defines the EMD up down event
# that is used to check if the emd is up or down


oradefine event /oracle/host/fault/emdupdn
oradefine end

oraeventpersist last_err_msg {}

# The main event checking functions
proc EvalEvent {} {
    
    global tcl_platform
    global last_report output
    global last_err_msg

    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    
    #clear output message from last time
    set output ""

    # figure out what platform we are running on
    #get EMDROOT
    set emdroot [EMDROOT_FUNC]
    if { $emdroot == $SCRIPT_FAIL} {
        ORATCL_DEBUG "emdupdn : [oratime] : Could not get EMD root"
        return [FailureCheck last_report last_err_msg $output ]
    }
    set EMDROOT $emdroot
    
    
    # make sure EMDROOT was set
    if { [info exists EMDROOT] == 0 } {
        lappend output "Could not get the EMDROOT."
        [EMDROOT_NOTEXIST_MSG]
        ORATCL_DEBUG "emdupdn : [oratime] : $output"
        return [FailureCheck last_report last_err_msg $output]
    }
    
     
    # set path for the targets file
    set emctl [EMCTL $EMDROOT]
    
    #check that emctl exists where we think it does
    if { [file exists $emctl] == 0 } {
        #emctl does not exist
        lappend output "emctl: $emctl does not exist."
        ORATCL_DEBUG "emdupdn : [oratime] : $output"
        return [FailureCheck last_report last_err_msg $output]
    }

    # check that emctl has execute permissions set
    if { [file executable $emctl] == 0 } {
        #emctl does not have execute permissions set
        lappend output "emctl does not have execute permssions set."
        ORATCL_DEBUG "emdupdn : [oratime] : $output"
        return [FailureCheck last_report last_err_msg $output]
    }

      

    if { [catch {exec $emctl status} em_status] != 0} {
        #status returned a non zero status..i.e. something is wrong
        #with emd status or with execution of the emctl 
        ORATCL_DEBUG "emdupdn : [oratime] : Non zero status $em_status"
        lappend output $em_status
        return [FailureCheck last_report last_err_msg $output]
    }
            
    if { [string first "200" $em_status] >= 0 } {
        #emctl returned a good status 200
        if { $last_report == $ALERT_EVENT || $last_report == $SCRIPT_FAIL } {
            ORATCL_DEBUG "emdupdn : [oratime] : Clear event"
            set last_report $CLEAR_EVENT
            return $CLEAR_EVENT
        } else {
            #last report must have been NO_EVENT
            ORATCL_DEBUG "emdupdn : [oratime] : No event"
            return $NO_EVENT
        } 
    }

    # an alert
    set report $ALERT_EVENT
    if { $last_report == $report } {
        ORATCL_DEBUG "emdupdn : [oratime] : No event"
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "emdupdn : [oratime] : Alert"
        set last_report $ALERT_EVENT
        return $ALERT_EVENT
    }
    
}

