# NAME :
#
#   shutdown.tcl : Script to shutdown OPS
#
# ARGUEMENTS :
#
#   1. <OPSname>
#   2. <Connect_string>
#   3. SYSDBA|SYSOPER
#   4. {NORMAL|ABORT|IMMEDIATE}[,ALL][,INTERMRSLT][,STAGESTAT=<level>]
#   5. CONFIG=[<filename>]
#   6. SID=[<sidlist>]
#
#

#
# Procedure to mark special operations
#
proc isOpted { a } {
    global modelist

    set alower [string tolower $a]
    set aupper [string toupper $a]

    set ixlower [lsearch [lrange $modelist 0 end] $alower*]
    set ixupper [lsearch [lrange $modelist 0 end] $aupper*]
    if {$ixlower >= 0} {
        return $ixlower
    } elseif {$ixupper >= 0} {
        return $ixupper
    } else {
        return -1
    }
}

#
# Description of parameters
#
oradefine job /oracle/ops/general/shutdown description=VOC-02211
oraarguments opsname connect_str user_role shutdown_mode config_file sid_list
oravardesc opsname string
oravardesc connect_str string
oravardesc user_role string
oravardesc shutdown_mode string
oravardesc config_file string
oravardesc sid_list string
oradefine end

global modelist

# address for intermediate results via orajobstat
set addr [lindex [orainfo] 2]

# get opsname and wholeopsname
set fullOPSname [lindex $argv 0]
set OPSname $fullOPSname
regsub -nocase {^([a-z0-9]+)\..+$} $OPSname {\1} OPSname    ;# Take out domainname

# Set ORACLE_PSRV environment variable 
set env(ORACLE_PSRV) $OPSname 

# handle agent's ORACLE_HOME being different from that of the
# OPS being managed
#
# Save the current ORACLE_HOME
# Get the proper ORACLE_HOME for the OPS (from the routine
# get_ops_home(targetname) defined in orainit.tcl; Set the environment
# variable ORACLE_HOME accordingly. Reset the environment variable
# ORACLE_HOME to this saved value at the time of exit.
# Note: do not use oramsg(orahome) because it's not correctly set.
if {[info exists env(ORACLE_HOME)]} {
   set saved_ORACLE_HOME $env(ORACLE_HOME)
}
if {[catch {set my_OH [get_ops_home $OPSname]} err1]} {
    if {[catch {set my_OH [get_ops_home $fullOPSname]} err2]} {
        orafail "Failed to Stop Cluster DB; cannot get oraclehome: $err1; $err2"
    }
}
set env(ORACLE_HOME) $my_OH

#orajobstat $addr "-- env(ORACLE_HOME) is $env(ORACLE_HOME)"

#
# get srvctl version
#
set stopexe [concatname [list $env(ORACLE_HOME) bin srvctl.bat ] ]
if { [file executable $stopexe] } {
    if [ catch { exec $stopexe config -V } versionout ] {
        if {[info exists saved_ORACLE_HOME]} {
            set env(ORACLE_HOME) $saved_ORACLE_HOME
        }
        puts $versionout
        orafail "Failed to Check version"
    }
    if {[regexp { 9\.2\.} $versionout]} {
        set version 92
    } else {
        set version 91
    }
} else {
    set stopexe [concatname [list $env(ORACLE_HOME) bin opsctl.exe ] ]
    set version 8
    if { ! [file executable $stopexe] } {
        if {[info exists saved_ORACLE_HOME]} {
            set env(ORACLE_HOME) $saved_ORACLE_HOME
        }
        orafail "cannot find $stopexe"
    }
}

#
# build command line
#

if { $version == 92 } {
    # using 9iR2 srvctl

    set SID_LIST [lindex $argv 5]
    regexp {(SID=)(.*)} $SID_LIST dummy1 dummy2 sidlist
    set sidlist [string trimright $sidlist ,]

    lappend stopargs "stop"

    if {[string length $sidlist] > 0} {
        lappend stopargs "instance"
    } else {
        lappend stopargs "database"
    }

    lappend stopargs "-d"
    lappend stopargs $OPSname
    lappend stopargs "-c"
    if {[string compare [lindex $argv 2] NORMAL] == 0} {
        lappend stopargs [format "%s" [lindex $argv 1] ]
    } else {
        lappend stopargs [format "%s as %s" [lindex $argv 1] [lindex $argv 2] ]
    }

    set modelist [split [lindex $argv 3] ,]

    #if {[isOpted ALL] == -1} {
    #    lappend stopargs "-s"
    #    lappend stopargs "inst"
    #}

    if {[isOpted INTERMRSLT] != -1} {
        set dispIntermResult 1
    } else {
        set dispIntermResult 0
    }

    set inxSTAGESTAT [isOpted STAGESTAT] ;
    if {$inxSTAGESTAT != -1} {
        set dispStatus 1
        regexp {(STAGESTAT=)(.*)} [lindex $modelist $inxSTAGESTAT] dummy1 dummy2 levelStatus
        lappend stopargs "-S"
        lappend stopargs $levelStatus
    } else {
        set dispStatus 0
    }

    if {[isOpted IMMEDIATE] != -1} {
        lappend stopargs "-o"
        lappend stopargs "immediate"
    } elseif {[isOpted ABORT] != -1} {
        lappend stopargs "-o"
        lappend stopargs "abort"
    } elseif {[isOpted NORMAL] != -1} {
        lappend stopargs "-o"
        lappend stopargs "normal"
    } elseif {[isOpted TRANSACTIONAL] != -1} {
        lappend stopargs "-o"
        lappend stopargs "transactional"
    }

    set stopargs [linsert $stopargs 0 $stopexe]

    if {$dispStatus} {
        if {!$dispIntermResult} {
            puts "#@=stagestatavail:"
        } else {
            orajobstat $addr "#@=stagestatavail:"
        }
    }

    #
    # If SHOWCMD is opted then
    #    Prepare the display command-string in which the password should be
    #    hidden Display it
    #
    if {[isOpted SHOWCMD] != -1} {
        set showargs $stopargs
        set connstr_index 6
        set connstr [lindex $showargs $connstr_index]
        set regexp_0 "(.*)/(\[^ \]*)(.*)"
        if {[regexp $regexp_0 $connstr match m1 m2 m3]} {
            set regexp_1 "(.*)@(.*)"
            if {[regexp $regexp_1 $m2 match m4 m5]} {
                set dispstr $m1/******@$m5$m3
            } else {
                set dispstr $m1/******$m3
            }
        } else {
            set dispstr $connstr
        }
        set showargs [lreplace $showargs $connstr_index $connstr_index $dispstr]
        if {!$dispIntermResult} {
            puts [format "%s" $showargs]
        } else {
            orajobstat $addr [format "%s" $showargs]
        }
    }
} elseif { $version == 91 } {
    # using 9iR1 srvctl

    lappend stopargs "stop"
    lappend stopargs "-p"
    lappend stopargs $OPSname
    lappend stopargs "-c"
    if {[string compare [lindex $argv 2] NORMAL] == 0} {
        lappend stopargs [format "%s" [lindex $argv 1] ]
    } else {
        lappend stopargs [format "%s as %s" [lindex $argv 1] [lindex $argv 2] ]
    }

    set SID_LIST [lindex $argv 5]
    regexp {(SID=)(.*)} $SID_LIST dummy1 dummy2 sidlist
    set sidlist [string trimright $sidlist ,]
    if {[string length $sidlist] > 0} {
        # handle <sid>_<nodename> target names in the SID= parameter
        # by stripping off everything after the first "_"
        foreach i [split $sidlist ,] {
            regexp {(.*)_(.*)} $i dummy1 sid dummy2
            if {[info exists sid]} {
                append short_sidlist "$sid,"
                unset sid
            } else {
                append short_sidlist "$i,"
            }
        }
        set short_sidlist [string trimright $short_sidlist ,]

        lappend stopargs "-i"
        lappend stopargs $short_sidlist
    }

    set modelist [split [lindex $argv 3] ,]

    if {[isOpted ALL] == -1} {
        lappend stopargs "-s"
        lappend stopargs "inst"
    }

    if {[isOpted INTERMRSLT] != -1} {
        set dispIntermResult 1
    } else {
        set dispIntermResult 0
    }

    set inxSTAGESTAT [isOpted STAGESTAT] ;
    if {$inxSTAGESTAT != -1} {
        set dispStatus 1
        regexp {(STAGESTAT=)(.*)} [lindex $modelist $inxSTAGESTAT] dummy1 dummy2 levelStatus
        lappend stopargs "-S"
        lappend stopargs $levelStatus
    } else {
        set dispStatus 0
    }

    if {[isOpted IMMEDIATE] != -1} {
        lappend stopargs "-o"
        lappend stopargs "immediate"
    } elseif {[isOpted ABORT] != -1} {
        lappend stopargs "-o"
        lappend stopargs "abort"
    } elseif {[isOpted NORMAL] != -1} {
        lappend stopargs "-o"
        lappend stopargs "normal"
    } elseif {[isOpted TRANSACTIONAL] != -1} {
        lappend stopargs "-o"
        lappend stopargs "transactional"
    }

    set stopargs [linsert $stopargs 0 $stopexe]

    if {$dispStatus} {
        if {!$dispIntermResult} {
            puts "#@=stagestatavail:"
        } else {
            orajobstat $addr "#@=stagestatavail:"
        }
    }

    #
    # If SHOWCMD is opted then
    #    Prepare the display command-string in which the password should be
    #    hidden Display it
    #
    if {[isOpted SHOWCMD] != -1} {
        set showargs $stopargs
        set connstr_index 5
        set connstr [lindex $showargs $connstr_index]
        set regexp_0 "(.*)/(\[^ \]*)(.*)"
        if {[regexp $regexp_0 $connstr match m1 m2 m3]} {
            set regexp_1 "(.*)@(.*)"
            if {[regexp $regexp_1 $m2 match m4 m5]} {
                set dispstr $m1/******@$m5$m3
            } else {
                set dispstr $m1/******$m3
            }
        } else {
            set dispstr $connstr
        }
        set showargs [lreplace $showargs $connstr_index $connstr_index $dispstr]
        if {!$dispIntermResult} {
            puts [format "%s" $showargs]
        } else {
            orajobstat $addr [format "%s" $showargs]
        }
    }

} else {
    # using 8i opsctl

    lappend stopargs "stop"
    lappend stopargs [format "-n%s" $OPSname]

    if {[string compare [lindex $argv 2] NORMAL] == 0} {
        lappend stopargs [format "-C%s" [lindex $argv 1] ]
    } else {
        lappend stopargs [format "-C%s as %s" [lindex $argv 1] [lindex $argv 2] ]
    }

    set CONFIG_FILE [lindex $argv 4]
    regexp {(CONFIG=)(.*)} $CONFIG_FILE dummy1 dummy2 filename
    if {[string length $filename] > 0} {
        lappend stopargs [format "-c%s" $filename]
    }

    set SID_LIST [lindex $argv 5]
    regexp {(SID=)(.*)} $SID_LIST dummy1 dummy2 sidlist
    if {[string length $sidlist] > 0} {
        # handle <sid>_<nodename> target names in the SID= parameter
        # by stripping off everything after the first "_"
        foreach i [split $sidlist ,] {
            regexp {(.*)_(.*)} $i dummy1 sid dummy2
            if {[info exists sid]} {
                append short_sidlist "$sid,"
                unset sid
            } else {
                append short_sidlist "$i,"
            }
        }
        set short_sidlist [string trimright $short_sidlist ,]

        lappend stopargs [format "-I%s" $short_sidlist]
    }

    set modelist [split [lindex $argv 3] ,]

    if {[isOpted INTERMRSLT] != -1} {
        set dispIntermResult 1
    } else {
        set dispIntermResult 0
    }
 
    if {[isOpted ABORT] != -1} {
        lappend stopargs "-F"
    }
    if {[isOpted NORMAL] != -1} {
        lappend stopargs "-M"
    }

    set stopargs [linsert $stopargs 0 $stopexe]
}

# Fix for bug 3760624
if {$version == 92} {
   if {[string length $sidlist] > 0} {
      set saved_stopargs $stopargs
      foreach i [split $sidlist ,] {
         regexp {(.*)_(.*)} $i dummy1 sid dummy2
         if {[info exists sid]} {
            set instvar $sid
         } else {
            set instvar $i
         }
         if {[info exists instvar]} {
            append stopargs " -i "
            append stopargs $instvar
         }
         lappend stopargs "2>@stdout"
	 set stopargs [linsert $stopargs 0 "|"]
	 
         if [catch {open $stopargs r} result] {
            if {[info exists saved_stopargs]} {
               set stopargs $saved_stopargs
            }
            if {[info exists saved_ORACLE_HOME]} {
               set env(ORACLE_HOME) $saved_ORACLE_HOME
            }
             puts $result 
	     orafail "Failed to Stop Cluster DB"
	     break            
         } else {
           if {[info exists saved_stopargs]} {
              set stopargs $saved_stopargs
           }
           if {[info exists saved_ORACLE_HOME]} {
              set env(ORACLE_HOME) $saved_ORACLE_HOME
           }
           while {[gets $result line] >= 0} {
              if {!$dispIntermResult} {
                 puts [format "%s" $line]
              } else {
                 orajobstat $addr [format "%s" $line]
              }
           }
           if [catch {close $result} close_result] {
              orafail "Failed to Stop Cluster DB"
           }
         }
      }
   }
} else {

   lappend stopargs "2>@stdout"
   set stopargs [linsert $stopargs 0 "|"]

   #
   # Execute the 'srvctl' command and send back the intermediate results
   #
   if [catch {open $stopargs r} result] {
      if {[info exists saved_ORACLE_HOME]} {
         set env(ORACLE_HOME) $saved_ORACLE_HOME
      }
      puts $result 
      orafail "Failed to Stop Cluster DB"
   } else {
      if {[info exists saved_ORACLE_HOME]} {
         set env(ORACLE_HOME) $saved_ORACLE_HOME
      }
      while {[gets $result line] >= 0} {
         if {!$dispIntermResult} {
            puts [format "%s" $line]
         } else {
            orajobstat $addr [format "%s" $line]
         }
      }
      if [catch {close $result} close_result] {
         orafail "Failed to Stop Cluster DB"
      }
    }
}
