# NAME :
#
#   startup.tcl : Script to startup OPS
#
# ARGUEMENTS :
#
#   1. <OPSname>
#   2. <Connect_string>
#   3. SYSDBA|SYSOPER|NORMAL
#   4. {NORMAL|FORCE}[,RESTRICT][,NOMOUNT|,OPEN|,MOUNT][,SHOWCMD]
#		[,INTERMRSLT][,STAGESTAT=<level>]
#      (default is OPEN)
#   5. CONFIG=[<filename>]
#   6. SID=[<sidlist>]
#
#

#
# Procedure to mark special operations
#
proc isOpted { a } {
    global modelist

    set ix [lsearch [lrange $modelist 0 end] $a*]
    if {$ix >= 0} {
        return $ix
    } else {
        return -1
    }
}

#
# Description of parameters
#
oradefine job /oracle/ops/general/startup description=VOC-02201
oraarguments opsname connect_str user_role startup_mode config_file sid_list
oravardesc opsname string
oravardesc connect_str string
oravardesc user_role string
oravardesc startup_mode string
oravardesc config_file string
oravardesc sid_list string
oradefine end

global modelist

# address for intermediate results via orajobstat
set addr [lindex [orainfo] 2]

# get opsname and wholeopsname
set fullOPSname [lindex $argv 0]
set OPSname $fullOPSname
regsub -nocase {^([a-z0-9]+)\..+$} $OPSname {\1} OPSname    ;# Take out domainname

# handle agent's ORACLE_HOME being different from that of the
# OPS being managed
#
# Save the current ORACLE_HOME
# Get the proper ORACLE_HOME for the OPS (from the routine
# get_ops_home(targetname) defined in orainit.tcl; this routine gets
# OracleHome for service name specified, from snmp_ro.ora file)
# Set the environment variable ORACLE_HOME accordingly. Reset the
# environment variable ORACLE_HOME to this saved value at the time of exit.
#
# Note1: do not call "get_ops_name oramsg(oraobject)". the value of
# oramsg(oraobject) depends on the way a starup job is submitted. it is
# not always the service name. for example, if a job with target type
# Node is submitted, the value of oramsg(oraobject) will be the node name.
# Note2: do not use oramsg(orahome) because it's not correctly set.
if {[info exists env(ORACLE_HOME)]} {
    set saved_ORACLE_HOME $env(ORACLE_HOME)
}
if {[catch {set my_OH [get_ops_home $OPSname]} err1]} {
    if {[catch {set my_OH [get_ops_home $fullOPSname]} err2]} {
        orafail "Failed to Start Cluster DB; cannot get oraclehome: $err1; $err2"
    }
}
set env(ORACLE_HOME) $my_OH

#orajobstat $addr "-- env(ORACLE_HOME) is $env(ORACLE_HOME)"

#
# find out srvctl version
#
set startexe [concatname [list $env(ORACLE_HOME) bin srvctl.bat ] ]
if { [file executable $startexe] } {
    if [ catch { exec $startexe config -V } versionout ] {
        if {[info exists saved_ORACLE_HOME]} {
            set env(ORACLE_HOME) $saved_ORACLE_HOME
        }
        puts $versionout
        orafail "Failed to Check version"
    }
    if {[regexp { 9\.2\.} $versionout]} {
        set version 92
    } else {
        set version 91
    }
} else {
    set startexe [concatname [list $env(ORACLE_HOME) bin opsctl.exe ] ]
    set version 8
    if { ! [file executable $startexe] } {
        if {[info exists saved_ORACLE_HOME]} {
            set env(ORACLE_HOME) $saved_ORACLE_HOME
        }
        orafail "cannot find $startexe"
    }
}

#
# build command line
#

if { $version == 92 } { 
    # using 9iR1 srvctl
    set SID_LIST [lindex $argv 5]
    regexp {(SID=)(.*)} $SID_LIST dummy1 dummy2 sidlist
    set sidlist [string trimright $sidlist ,]

    lappend startargs "start"

    if {[string length $sidlist] > 0} {
        lappend startargs "instance"
    } else {
        lappend startargs "database"
    }

    lappend startargs "-d"
    lappend startargs $OPSname
    lappend startargs "-c"
    if {[string compare [lindex $argv 2] NORMAL] == 0} {
        lappend startargs [format "%s" [lindex $argv 1] ]
    } else {
        lappend startargs [format "%s as %s" [lindex $argv 1] [lindex $argv 2]]
    }

    set modelist [split [lindex $argv 3] ,]
    
    if {[isOpted INTERMRSLT] != -1} {
        set dispIntermResult 1
    } else {
        set dispIntermResult 0
    }

    set inxSTAGESTAT [isOpted STAGESTAT] ;
    if {$inxSTAGESTAT != -1} {
        set dispStatus 1
        regexp {(STAGESTAT=)(.*)} [lindex $modelist $inxSTAGESTAT] dummy1 dummy2 levelStatus
        lappend startargs "-S"
        lappend startargs $levelStatus
    } else {
        set dispStatus 0
    }

    # note: pay no attention to CONFIG= argument. it's obsolete in 9i.

    set start_mode ""
    if {[isOpted FORCE] != -1} {
        set start_mode [format "%s force" $start_mode]
    }
    if {[isOpted RESTRICT] != -1} {
        set start_mode [format "%s restrict" $start_mode]
    }
    if {[isOpted NOMOUNT] != -1} {
        set start_mode [format "%s nomount" $start_mode]
    }
    if {[isOpted MOUNT] != -1} {
        set start_mode [format "%s mount" $start_mode]
    }
    set start_mode [string trim $start_mode]
    if {[string length $start_mode] > 0} {
        lappend startargs "-o"
        lappend startargs $start_mode
    }

    set startargs [linsert $startargs 0 $startexe]

    if {$dispStatus} {
        if {!$dispIntermResult} {
            puts "#@=stagestatavail:"
        } else {
            orajobstat $addr "#@=stagestatavail:"
        }
    }

    #
    # If SHOWCMD is opted then
    #    Prepare the display command-string in which the password should be
    #    hidden Display it
    #
    if {[isOpted SHOWCMD] != -1} {
        set showargs $startargs
        set connstr_index 6
        set connstr [lindex $showargs $connstr_index]
        set regexp_0 "(.*)/(\[^ \]*)(.*)"
        if {[regexp $regexp_0 $connstr match m1 m2 m3]} {
            set regexp_1 "(.*)@(.*)"
            if {[regexp $regexp_1 $m2 match m4 m5]} {
                set dispstr $m1/******@$m5$m3
            } else {
                set dispstr $m1/******$m3
            }
        } else {
            set dispstr $connstr
        }
        set showargs [lreplace $showargs $connstr_index $connstr_index $dispstr]
        if {!$dispIntermResult} {
            puts [format "%s" $showargs]
        } else {
            orajobstat $addr [format "%s" $showargs]
        }
    }

} elseif { $version == 91 } { 
    # using 9iR1 srvctl

    lappend startargs "start"
    lappend startargs "-p"
    lappend startargs $OPSname
    lappend startargs "-c"
    if {[string compare [lindex $argv 2] NORMAL] == 0} {
        lappend startargs [format "%s" [lindex $argv 1] ]
    } else {
        lappend startargs [format "%s as %s" [lindex $argv 1] [lindex $argv 2]]
    }

    set SID_LIST [lindex $argv 5]
    regexp {(SID=)(.*)} $SID_LIST dummy1 dummy2 sidlist
    set sidlist [string trimright $sidlist ,]
    if {[string length $sidlist] > 0} {
        # handle <sid>_<nodename> target names in the SID= parameter
        # by stripping off everything after the first "_"
        foreach i [split $sidlist ,] {
            regexp {(.*)_(.*)} $i dummy1 sid dummy2
            if {[info exists sid]} {
                append short_sidlist "$sid,"
                unset sid
            } else {
                append short_sidlist "$i,"
            }
        }
        set short_sidlist [string trimright $short_sidlist ,]

        lappend startargs "-i"
        lappend startargs $short_sidlist
    }

    set modelist [split [lindex $argv 3] ,]
    
    if {[isOpted INTERMRSLT] != -1} {
        set dispIntermResult 1
    } else {
        set dispIntermResult 0
    }

    set inxSTAGESTAT [isOpted STAGESTAT] ;
    if {$inxSTAGESTAT != -1} {
        set dispStatus 1
        regexp {(STAGESTAT=)(.*)} [lindex $modelist $inxSTAGESTAT] dummy1 dummy2 levelStatus
        lappend startargs "-S"
        lappend startargs $levelStatus
    } else {
        set dispStatus 0
    }

    # note: pay no attention to CONFIG= argument. it's obsolete in 9i.

    set start_mode ""
    if {[isOpted FORCE] != -1} {
        set start_mode [format "%s force" $start_mode]
    }
    if {[isOpted RESTRICT] != -1} {
        set start_mode [format "%s restrict" $start_mode]
    }
    if {[isOpted NOMOUNT] != -1} {
        set start_mode [format "%s nomount" $start_mode]
    }
    if {[isOpted MOUNT] != -1} {
        set start_mode [format "%s mount" $start_mode]
    }
    set start_mode [string trim $start_mode]
    if {[string length $start_mode] > 0} {
        lappend startargs "-o"
        lappend startargs $start_mode
    }

    set startargs [linsert $startargs 0 $startexe]

    if {$dispStatus} {
        if {!$dispIntermResult} {
            puts "#@=stagestatavail:"
        } else {
            orajobstat $addr "#@=stagestatavail:"
        }
    }

    #
    # If SHOWCMD is opted then
    #    Prepare the display command-string in which the password should be
    #    hidden Display it
    #
    if {[isOpted SHOWCMD] != -1} {
        set showargs $startargs
        set connstr_index 5
        set connstr [lindex $showargs $connstr_index]
        set regexp_0 "(.*)/(\[^ \]*)(.*)"
        if {[regexp $regexp_0 $connstr match m1 m2 m3]} {
            set regexp_1 "(.*)@(.*)"
            if {[regexp $regexp_1 $m2 match m4 m5]} {
                set dispstr $m1/******@$m5$m3
            } else {
                set dispstr $m1/******$m3
            }
        } else {
            set dispstr $connstr
        }
        set showargs [lreplace $showargs $connstr_index $connstr_index $dispstr]
        if {!$dispIntermResult} {
            puts [format "%s" $showargs]
        } else {
            orajobstat $addr [format "%s" $showargs]
        }
    }

} else {
    # using 8i opsctl

    lappend startargs "start"
    lappend startargs [format "-n%s" $OPSname]

    if {[string compare [lindex $argv 2] NORMAL] == 0} {
        lappend startargs [format "-C%s" [lindex $argv 1] ]
    } else {
        lappend startargs [format "-C%s as %s" [lindex $argv 1] [lindex $argv 2] ]
    }

    set CONFIG_FILE [lindex $argv 4]
    regexp {(CONFIG=)(.*)} $CONFIG_FILE dummy1 dummy2 filename
    if {[string length $filename] > 0} {
        lappend startargs [format "-c%s" $filename]
    }

    set SID_LIST [lindex $argv 5]
    regexp {(SID=)(.*)} $SID_LIST dummy1 dummy2 sidlist
    if {[string length $sidlist] > 0} {
        # handle <sid>_<nodename> target names in the SID= parameter
        # by stripping off everything after the first "_"
        foreach i [split $sidlist ,] {
            regexp {(.*)_(.*)} $i dummy1 sid dummy2
            if {[info exists sid]} {
                append short_sidlist "$sid,"
                unset sid
            } else {
                append short_sidlist "$i,"
            }
        }
        set short_sidlist [string trimright $short_sidlist ,]

        lappend startargs [format "-I%s" $short_sidlist]
    }

    set modelist [split [lindex $argv 3] ,]

    if {[isOpted INTERMRSLT] != -1} {
        set dispIntermResult 1
    } else {
        set dispIntermResult 0
    }

    if {[isOpted FORCE] != -1} {
        lappend startargs "-F"
    }
    if {[isOpted RESTRICT] != -1} {
        lappend startargs "-T"
    }
    if {[isOpted NOMOUNT] != -1} {
        lappend startargs "-U"
    }
    if {[isOpted MOUNT] != -1} {
        lappend startargs "-M"
    }

    set startargs [linsert $startargs 0 $startexe]
}

# Fix for bug 3760624
if {$version == 92} {
  if {[string length $sidlist] > 0} {
     set saved_startargs $startargs
     foreach i [split $sidlist ,] {
        regexp {(.*)_(.*)} $i dummy1 sid dummy2
        if {[info exists sid]} {
           set instvar $sid
        } else {
           set instvar $i
        }
        if {[info exists instvar]} {
           append startargs " -i "
           append startargs $instvar
        }
        lappend startargs "2>@stdout"
        set startargs [linsert $startargs 0 "|"]
        
        if [catch {open $startargs r} result] {
           if {[info exists saved_startargs]} {
              set startargs $saved_startargs
           }
	   if {[info exists saved_ORACLE_HOME]} {
	      set env(ORACLE_HOME) $saved_ORACLE_HOME
	   }
	   puts $result 
	   orafail "Failed to Start Cluster DB"
	   break;
	} else {
           if {[info exists saved_startargs]} {
              set startargs $saved_startargs
           }
	   if {[info exists saved_ORACLE_HOME]} {
	      set env(ORACLE_HOME) $saved_ORACLE_HOME
	   }
	   while {[gets $result line] >= 0} {
	      if {!$dispIntermResult} {
	         puts [format "%s" $line]
	      } else {
	         orajobstat $addr [format "%s" $line]
	      }
	   }
	   if [catch {close $result} close_result] {
	      orafail "Failed to Start Cluster DB"
	   }
	}
     }
  }
} else {
  lappend startargs "2>@stdout"
  set startargs [linsert $startargs 0 "|"]

  #
  # Execute the 'srvctl' command and send back the intermediate results
  #
  if [catch {open $startargs r} result] {
     if {[info exists saved_ORACLE_HOME]} {
        set env(ORACLE_HOME) $saved_ORACLE_HOME
     }
     puts $result 
     orafail "Failed to Start Cluster DB"
  } else {
     if {[info exists saved_ORACLE_HOME]} {
        set env(ORACLE_HOME) $saved_ORACLE_HOME
     }
     while {[gets $result line] >= 0} {
        if {!$dispIntermResult} {
            puts [format "%s" $line]
        } else {
            orajobstat $addr [format "%s" $line]
        }
     }
     if [catch {close $result} close_result] {
        orafail "Failed to Start Cluster DB"
     }
  }
}
