#
# Copyright (c) 1996, 2004, Oracle. All rights reserved.  
#
# NAME: otrcflis.tcl - Trace CLI fdf info list script
#
# VERSION: 817 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home
#
# INPUT FILES:
#
#      none
#

oradefine job /oracle/otrace/general/otrcflis

global oramsg



### Define otrcflis_* procs ...


# Form list of Oracle homes from NT registry (new method as of 817) ...

proc otrcflis_getOrahomeList {} {

    set home_list {}

    if {[catch {registry keys HKEY_LOCAL_MACHINE\\Software\\Oracle} oracleKeyList] != 0} {
        puts "Could not retrieve registry subkeys under HKEY_LOCAL_MACHINE\\Software\\Oracle"
        return $home_list
    }

    foreach oracleKey $oracleKeyList {
        if {[string match "HOME*" $oracleKey] == 1} {
            if {[catch {registry get HKEY_LOCAL_MACHINE\\Software\\Oracle\\$oracleKey ORACLE_HOME} ohome] == 0} {
                # Trim whitespace and trailing backslash, if any , before appending to list ...
                set ohome [string trimright [string trim $ohome] "\\"]
                lappend  home_list  $ohome
            } else {
                puts "Could not retrieve registry value ORACLE_HOME under HKEY_LOCAL_MACHINE\\Software\\Oracle\\$oracleKey"
            }
        }
    }

    # As with db_list, convert any '\' in home_list to '/' ...
    set backslashed [regsub -all {\\} $home_list {/} home_list]

    return $home_list;
}



### Start otrcflis main ...


set epc_s_begclijob       87
set epc_s_comclijob      133

set agent_addr [lindex [orainfo] 2]

#Load registry package 
package ifneeded registry 1.1 [list load tclreg11.dll registry]
package require registry

# If optional oracle_home was provided, use it;
# else use default ...

set ohome [lindex $argv 0]
if { $ohome == "" } {
    set ohome $oramsg(orahome)
}
set env(ORACLE_HOME) $ohome

# Send job started intermediate status ...
### Note versioned Trace directory for NT!

if { [file isdirectory [concatname [list $ohome otrace80]]] } {
    catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_begclijob]]} cstat
} else {
    catch {orajobstat $agent_addr "EPC-00087: Beginning CLI job ..."} cstat
}

# Obtain list of DBs, etc monitored by this agent ...

set db_list [lindex [orainfo] 1]

# If no DBs in orainfo, default to current ohome ...
### What missing SID/service strings???

if { [llength $db_list] == 0 } {
    set db_list [list [concat "No_Services"  $ohome  "No_SIDs"]]
}

### If any "\" char in db_list, eg for NT ohome, "/" them ...
### (Changed to "/" in OEM 160 and agent 805 timeframe for bug 658177 fix.)
set backslashed [regsub -all {\\} $db_list {/} db_list]


# List info by Oracle home ...
set home_list [otrcflis_getOrahomeList]

if { [llength $home_list] == 0 } {
    puts " "
    puts "  No Oracle homes!"
    orafail "  No Oracle homes!"
}

foreach ohome $home_list {
    puts " "
    puts "Oracle home: [convertout $oramsg(agent_characterset) $ohome]"

# List any known DB's service name and SID for this Oracle home ...

    foreach dbinfo $db_list {
	if { [string toupper [lindex $dbinfo 1]] == [string toupper $ohome] } {
	    puts " "
            puts " Service = [convertout $oramsg(agent_characterset) [lindex $dbinfo 0]]"
	    puts "     SID = [convertout $oramsg(agent_characterset) [lindex $dbinfo 2]]"
	}
    }

# List fdf file info for this Oracle home ...
### Note versioned Trace directory for NT 73x and 80x!

    set trace_prod_dir ""

    if { [file isdirectory [concatname [list $ohome otrace]]] } {
	set trace_prod_dir "otrace"
    } elseif { [file isdirectory [concatname [list $ohome otrace80]]] } {
	set trace_prod_dir "otrace80"
    } elseif { [file isdirectory [concatname [list $ohome otrace73]]] } {
	set trace_prod_dir "otrace73"
    }

    if { $trace_prod_dir == "" } {
	puts " "
	puts "   No Trace directory under this ORACLE_HOME"
	continue
    }

### Note for NT: image name must include .exe extension ...
    set cliexe [concatname [list $ohome bin otrccol.exe ] ]
    if { ! [file executable $cliexe] } {
	puts " "
	puts "   No Trace CLI executable found under this ORACLE_HOME"
        continue
    }

# Set current Oracle home environment variable, then execute CLI ...

    set env(ORACLE_HOME) $ohome

    if {[catch {exec $cliexe _version} vers_ret ] } {
        orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
    } else {
	puts " "
        puts " Trace CLI version = [convertout $oramsg(agent_characterset) $vers_ret]"
    }

### Note versioned Trace directory for NT!

    if { ! [catch { set fname_list [glob [concatname [list $ohome $trace_prod_dir admin fdf "*" ]]] } glob_stat]} {

# If multiple fdf names, enclose in () before executing CLI; but only if CLI 
# version is 2 or greater, ie for 8.0.2 or later (JMc, 11/12/96)

	if { ([llength $fname_list] > 1) && ($vers_ret >= "2" ) } {
	    set fname_list [concat "(" $fname_list ")"]
	}
	if {[catch {exec $cliexe _fdflist $fname_list } flis_ret ] } {
		puts [convertout $oramsg(agent_characterset) $flis_ret]
		orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
	} else {
	    puts [convertout $oramsg(agent_characterset) $flis_ret]
	}
    } else {
	puts " "
	puts "   (No fdf files found)"
	puts " "
    }
}

# Send job completed intermediate status; note last ohome may not have Trace
# product directory, and therefore no Trace MSB file ...
### Note versioned Trace directory for NT!

if { [file isdirectory [concatname [list $ohome $trace_prod_dir]]] } {
    catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_comclijob]]} cstat
} else {
    catch {orajobstat $agent_addr "EPC-00133: Completed CLI job"} cstat
}

