# $Header: rman.tcl 30-may-2004.10:25:25 mkiran Exp $
#
# Copyright (c) 2000, 2004, Oracle. All rights reserved.  
#
# NAME:
#
#  rman.tcl : Script to execute an rman script
#
# ARGUMENTS:
#        
#        Argv(0) : Argument list.   Valid formats are:
#            target x/x@xx nocatalog
#            target x/x@xx catalog x/x@xx             
#            target x/x@xx nocatalog auxiliary x/x@xx
#            target x/x@xx catalog x/x@xx auxiliary x/x@xx           
#        Argv(1) :  Parameters including debug, msglog, trace and append
#
#        Actual scripts to run are in $oramsg(orainput)
#
# Untested on an 8.2 agent yet.

oradefine job /oracle/rdbms/general/rman description=VOC-02061
oraarguments arg_list parameters
oravardesc arg_list string message=VOC-02062
oravardesc parameters string message=VOC-02062
oradefine end

proc RMANEXE { target_str inputfile outputfile arg_list arg_length params} {
    global oramsg
    if {$arg_length == 3} {
        set f1 [open "|[RMAN] $params nocatalog >$outputfile" w]
        puts $f1 [format "connect target %s" $target_str]
    } elseif {$arg_length == 4} {
        set f1 [open "|[RMAN] $params >$outputfile" w]
        puts $f1 [format "connect target %s" $target_str]
        puts $f1 [format "connect catalog %s" [convertin $oramsg(agent_characterset) [lindex $arg_list 3]]]
    } elseif {$arg_length == 5} {
        set f1 [open "|[RMAN] $params nocatalog >$outputfile" w]
        puts $f1 [format "connect target %s" $target_str]
        puts $f1 [format "connect auxiliary %s" [convertin $oramsg(agent_characterset) [lindex $arg_list 4]]]
    } elseif {$arg_length == 6} {
        set f1 [open "|[RMAN] $params >$outputfile" w]
        puts $f1 [format "connect target %s" $target_str]
        puts $f1 [format "connect catalog %s" [convertin $oramsg(agent_characterset) [lindex $arg_list 3]]]
        puts $f1 [format "connect auxiliary %s" [convertin $oramsg(agent_characterset) [lindex $arg_list 5]]]
    }
    puts $f1 @$inputfile
    close $f1
}


# convert input file to agent characterset
set cvtfile [tempfile $oramsg(jobid)]
set rawhndl [open [lindex $oramsg(orainput) 0] r]
set cvthndl [open $cvtfile w]
puts $cvthndl [convertin $oramsg(agent_characterset) [read $rawhndl]]
close $cvthndl
close $rawhndl

set arg_list [lindex $argv 0]
set params [lindex $argv 1]

# the target connect string as user/passwd@service_name
set target_addr [lindex $arg_list 1]

set ValidService 0
set target_str [lindex [split [convertin $oramsg(agent_characterset) $target_addr] "@"] 0]
append target_str "@"
set servicename [lindex [split $target_addr "@"] 1]

foreach service [oraagent services] {
    if {[string match $servicename $service]} {
        set ValidService 1
    }
}

if {$ValidService} {

    set target_desc $oramsg(db_address)
    regsub -all " " $target_desc "" target_desc
    regsub -all "\t" $target_desc "" target_desc
    append target_str $target_desc

    set arg_length [llength $arg_list]

#   setOracleEnvironment
    if { [info exists env(ORACLE_HOME)] } {
	set setOracleEnvironment_OracleHome $env(ORACLE_HOME)
	set env(ORACLE_HOME) [ORACLE_HOME]
    }

    if {[file executable [RMAN]]} {
        set outputfile [tempfile $oramsg(jobid)]
        if { [catch { RMANEXE $target_str $cvtfile $outputfile $arg_list $arg_length $params } outx] } {
            rmfile $cvtfile 
            if { [file exists $outputfile] } {
                set f2 [open $outputfile r]
                set output [read $f2]
                close $f2
                rmfile $outputfile 
                error [convertout $oramsg(agent_characterset) $output]
            }
            error [convertout $oramsg(agent_characterset) $outx]
        }

#       restoreOracleEnvironment
	if { [info exists env(ORACLE_HOME)] } {
	    set env(ORACLE_HOME) $setOracleEnvironment_OracleHome
	}

        rmfile $cvtfile 
        if { [file exists $outputfile] } {
            set f2 [open $outputfile r]
            set output [read $f2]
            close $f2
            if {[regexp {RMAN-00569} $output] == 1} {
                error [convertout $oramsg(agent_characterset) $output]
            } else {
                puts [convertout $oramsg(agent_characterset) $output]
            }
            rmfile $outputfile 
        }
    } else {
#       restoreOracleEnvironment
	if { [info exists env(ORACLE_HOME)] } {
	    set env(ORACLE_HOME) $setOracleEnvironment_OracleHome
	}

        rmfile $cvtfile 
        orafail [msgtxt [NETWORK] nms 1029]
    } 
} else {
    orafail [msgtxt [NETWORK] nms 1082]
}
