# $Header: sqldba.tcl 27-jan-2005.00:06:03 bkesavan Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  sqldba.tcl : Script to execute an sqldba script
#
#      Invokes Server Manager line mode if it exists and if 
#      not tries to invokes Sql* DBA to execute the script that is
#      in the orainput file.
#
# ARGUMENTS:
#        
#           argv(0) == database connect string
#           argv(1) == role (either sysdba or sysoper)
#
# $Log:  $
# Revision 1.6  1996/08/22  21:24:16  yliu
# use tempfile and rmfile
#
# Revision 1.5  1996/02/16  02:50:52  yliu
# minor change
#
# Revision 1.4  1996/02/16  02:44:06  yliu
# changed parameters
#
# Revision 1.3  1996/02/15 18:26:41  yliu
# fixed bug in svrmgr execution
#
# Revision 1.2  1996/01/11 02:16:27  yliu
# use message file
#
# Revision 1.1  1995/10/12 00:18:59  yliu
# Initial revision
#

oradefine job /oracle/rdbms/general/sqldba description=VOC-02151
oraarguments connect_str role
oravardesc connect_str oracle_signon
oravardesc role string
oradefine end


#This is to fix bug#639904, to prevent the bogus error message from being sent back
#to the Console "syntax error in expression "" ".
#So instead, we will check the validity of the service name sent from the Console.
#The Agnet may be out of Sync. with the Console if a new service was added on the 
#agent and that node was no re-discovered from the Console. 

set osid "" 
set ValidService 0
set addr [lindex [split [convertin $oramsg(agent_characterset) [lindex $argv 0]] "@"] 0]
append addr "@"
set servicename [lindex [split [lindex $argv 0] "@"] 1]

foreach service [oraagent services] {
	if {[string match $servicename $service]} {
		set ValidService 1
	}
}
if {$ValidService} {
        append addr $oramsg(db_address)
        set tmpfile [tempfile $oramsg(jobid)]
        set f1 [open $tmpfile w ]
        set tmpfileSP [tempfile $oramsg(jobid)]
        set fSP [open $tmpfileSP w ]
        set outputfile [tempfile $oramsg(jobid)]
        if {[string length [lindex $argv 1]]} {
               set svrconnstr [format "connect %s as %s" $addr [lindex $argv 1]]
               set connstr [format "%s as %s" $addr [lindex $argv 1]]

        } else {
                set svrconnstr [format "connect %s" $addr]
                set connstr [format "%s" $addr]
        }
        set f2 [open [lindex $oramsg(orainput) 0] r]
        while {[gets $f2 line] >= 0} {
                set cvtline [convertin $oramsg(agent_characterset) $line]
                puts $f1 $cvtline
                puts $fSP $cvtline
        }
        close $f1
        close $fSP
        close $f2  

        set svrmgrlexec [SVRMGRL]
        set sqlplusexec [SQLPLUS]

	if { [info exists env(ORACLE_HOME)] } {
		set ooh $env(ORACLE_HOME)
		set env(ORACLE_HOME) [ORACLE_HOME]
	}
	if { [info exists env(ORACLE_SID)] } {
             set osid $env(ORACLE_SID)
        }
        set env(ORACLE_SID) [ORACLE_SID]

        if {[file executable $svrmgrlexec]} {
               if { [catch { SQLEXEC $svrmgrlexec $svrconnstr $tmpfile $outputfile } outx] } {
	               if { [info exists env(ORACLE_HOME)] } {
                                 set env(ORACLE_HOME) $ooh
                       }
                       set env(ORACLE_SID) $osid
                       rmfile $tmpfile
                       rmfile $tmpfileSP
                       rmfile $outputfile
                       puts [convertout $oramsg(agent_characterset) $outx]
                       orafail [format [msgtxt [NETWORK] nms 915] ""]
               }
	       if { [info exists env(ORACLE_HOME)] } {
                    set env(ORACLE_HOME) $ooh
               }
               if { [string equal $osid ""] } {
                  unset env(ORACLE_SID)
               } else {
                  set env(ORACLE_SID) $osid
               }
               rmfile $tmpfile
               rmfile $tmpfileSP
               rmfile $outputfile
               if {[regexp {(ORA-)([0-9]+)} $outx whole sub1 sub2] == 1} {
                       puts [convertout $oramsg(agent_characterset) $outx]
                       orafail [msgtxt [RDBMS] ora $sub2]
               } elseif {[regexp {(MGR-)([0-9]+)} $outx whole sub1 sub2] == 1} {
                        puts [convertout $oramsg(agent_characterset) $outx]
                        orafail [msgtxt [SVRMGRL] mgr $sub2]
                } else {
                        puts [convertout $oramsg(agent_characterset) $outx]
                }
        } elseif {[file executable $sqlplusexec]} {
               if { [catch { SQLEXEC $sqlplusexec $connstr $tmpfileSP $outputfile } outx] } {
			if { [info exists env(ORACLE_HOME)] } {
				set env(ORACLE_HOME) $ooh
			}
                        set env(ORACLE_SID) $osid
			rmfile $tmpfile
                        rmfile $tmpfileSP
                        rmfile $outputfile
			puts [convertout $oramsg(agent_characterset) $outx]
			orafail [format [msgtxt [NETWORK] nms 915] ""]
               }
               if { [info exists env(ORACLE_HOME)] } {
			set env(ORACLE_HOME) $ooh
               }
               if { [string equal $osid ""] } {
                  unset env(ORACLE_SID)
               } else {
                  set env(ORACLE_SID) $osid
               }
	       rmfile $tmpfile
               rmfile $tmpfileSP
               rmfile $outputfile
	       if {[regexp {(ORA-)([0-9]+)} $outx whole sub1 sub2] == 1} {
			puts [convertout $oramsg(agent_characterset) $outx]
			orafail [msgtxt [RDBMS] ora $sub2]
               } elseif {[regexp {(SP2-)([0-9]+)} $outx whole sub1 sub2] == 1} {
			puts [convertout $oramsg(agent_characterset) $outx]
			orafail [msgtxt [SQLPLUS] mgr $sub2]
		} else {
			puts [convertout $oramsg(agent_characterset) $outx]
		}
	} else {
		if { [info exists env(ORACLE_HOME)] } {
			set env(ORACLE_HOME) $ooh
		}
                set env(ORACLE_SID) $osid
		rmfile $tmpfile
                rmfile $tmpfileSP
		orafail [msgtxt [NETWORK] nms 1010]
	}
} else {
	orafail [msgtxt [NETWORK] nms 1082]
}






