# $Header: sqlplus.tcl 17-jan-2003.16:22:37 rzkrishn Exp $
#
# Copyright (c) 1995, 2003, Oracle Corporation.  All rights reserved.  
#
# NAME:
#
#  sqlplus.tcl : Script to execute an sqlplus script
#
# ARGUMENTS:
#        
#        Argv(0) : Connect string
#        Argv(1) : parameters to the input script
#
#        Actual scripts to run are in $oramsg(orainput)
#
# $Log:  $
# Revision 1.4  1996/08/22  21:35:27  yliu
# use tempfile and rmfile
#
# Revision 1.3  1996/02/07  22:06:33  yliu
# use character set conversion
#
# Revision 1.2  1996/01/11 02:20:36  yliu
# use oramsg(orahome)
#
# Revision 1.1  1995/09/26 21:51:59  yliu
# Initial revision
#


oradefine job /oracle/rdbms/general/sqlplus description=VOC-02061
oraarguments connect_str parameters
oravardesc connect_str oracle_signon message=VOC-02062
oravardesc parameters string message=VOC-02063
oradefine end

# convert input file to agent characterset
set cvtfile [tempfile $oramsg(jobid)]
set rawhndl [open [lindex $oramsg(orainput) 0] r]
set cvthndl [open $cvtfile w]
puts $cvthndl [convertin $oramsg(agent_characterset) "whenever sqlerror exit sql.sqlcode"]
puts $cvthndl [convertin $oramsg(agent_characterset) "whenever oserror exit 20"]
puts $cvthndl [convertin $oramsg(agent_characterset) [read $rawhndl]]
close $cvthndl
close $rawhndl

#This is to fix bug#639904, to prevent the bogus error message from being sent back
#to the Console "syntax error in expression "" ".
#So instead, we will check the validity of the service name sent from the Console.
#The Agnet may be out of Sync. with the Console if a new service was added on the 
#agent and that node was no re-discovered from the Console. 

set ValidService 0
set addr [lindex [split [convertin $oramsg(agent_characterset) [lindex $argv 0]] "@"] 0]
append addr "@"
set servicename [lindex [split [lindex $argv 0] "@"] 1]

foreach service [oraagent services] {
	if {[string match $servicename $service]} {
		set ValidService 1
	}
}
if {$ValidService} {

	# Strip white spaces from connect string
	# Otherwise sqlplus job will fail
	# See bug 666781 for details
	set connect_string $oramsg(db_address)
	regsub -all " " $connect_string "" connect_string
	regsub -all "\t" $connect_string "" connect_string
	append addr $connect_string

	set tmpfile [tempfile $oramsg(jobid)]
	set f1 [open $tmpfile w]
	if {[string length [lindex $argv 1]]} {
		puts $f1 [format "start %s %s" $cvtfile [convertin $oramsg(agent_characterset) [lindex $argv 1]]]
	} else {
		puts $f1 [format "start %s" $cvtfile ]
	}
	close $f1
       
        set sqlplusexec [SQLPLUS]

	if { [info exists env(ORACLE_HOME)] } {
		set ooh $env(ORACLE_HOME)
		set env(ORACLE_HOME) [ORACLE_HOME]
	}
	if {[file executable $sqlplusexec]} {
                 # Try to find if database is running
                 # to catch database not running error
                set loginoutput [tempfile $oramsg(jobid)]
                catch { SQLEXEC $sqlplusexec $addr NULL $loginoutput } outx
                rmfile $loginoutput
                if {[regexp {(ORA-)([0-9]+)} $outx whole sub1 sub2] == 1} {
                   if { [info exists env(ORACLE_HOME)] } {
                            set env(ORACLE_HOME) $ooh
                   }
                   puts [convertout $oramsg(agent_characterset) $outx]
                   rmfile $cvtfile
                   rmfile $tmpfile
                   orafail [msgtxt [RDBMS] ora $sub2] 
                }
                set outputfile [tempfile $oramsg(jobid)]
		if { [catch { SQLEXEC $sqlplusexec $addr $tmpfile $outputfile } outx] } {
			if { [info exists env(ORACLE_HOME)] } {
				set env(ORACLE_HOME) $ooh
			}
			rmfile $tmpfile
			rmfile $cvtfile 
                        rmfile $outputfile
			puts [convertout $oramsg(agent_characterset) $outx]
			orafail [format [msgtxt [NETWORK] nms 915] ""]
		}
		if { [info exists env(ORACLE_HOME)] } {
			set env(ORACLE_HOME) $ooh
		}
		rmfile $tmpfile
		rmfile $cvtfile 
                rmfile $outputfile
		puts [convertout $oramsg(agent_characterset) $outx]
	} else {
		if { [info exists env(ORACLE_HOME)] } {
			set env(ORACLE_HOME) $ooh
		}
		rmfile $tmpfile
		rmfile $cvtfile 
		orafail [msgtxt [NETWORK] nms 1013]
        }
} else {
	orafail [msgtxt [NETWORK] nms 1082]
}
