# $Header: startup.tcl 17-jan-2003.16:22:38 rzkrishn Exp $
#
# Copyright (c) 1995, 2003, Oracle Corporation.  All rights reserved.  
#
# NAME:
#
#  startup.tcl : Script to startup database
#
#      Invokes Server Manager line mode if it exists and if 
#      not tries to invokes Sql* DBA to execute the startup script that is
#      in the orainput file.
#
# ARGUMENTS:
#  
#           argv(0) == database connect string
#           argv(1) == role (either sysdba or sysoper)
#  
# $Log:  $
# Revision 1.11  1996/08/23  21:59:48  yliu
# fixed bug 379964
#
# Revision 1.10  1996/08/22  21:27:25  yliu
# use tempfile and rmfile
#
# Revision 1.9  1996/02/16  02:50:35  yliu
# minor change
#
# Revision 1.8  1996/02/16  02:44:20  yliu
# changed parameters
#
# Revision 1.7  1996/01/25 16:52:15  ebosco
# Fixed command= bug
#
# Revision 1.6  1996/01/11  02:19:41  yliu
# use message file
#

oradefine job /oracle/rdbms/general/startup description=VOC-02041
oraarguments connect_str role
oravardesc connect_str oracle_signon 
oravardesc role string 
oradefine end

set osid ""
set ignore_errors {ORA-9352}
set addr [lindex [split [convertin $oramsg(agent_characterset) [lindex $argv 0]] "@"] 0]
append addr "@"
append addr $oramsg(db_address)
set tmpfile [tempfile $oramsg(jobid)]
set f1 [open $tmpfile w]
set outputfile [tempfile $oramsg(jobid)]
if {[string length [lindex $argv 1]]} {
    set svrconnstr [format "connect %s as %s" $addr [lindex $argv 1]]
    set connstr [format "%s as %s" $addr [lindex $argv 1]]
} else {
    set svrconnstr [format "connect %s" $addr]
    set connstr [format "%s" $addr]
}
set f2 [open [lindex $oramsg(orainput) 0] r]

# we do not need to provide the location of the default file if user does
# not provide. The database finds the appropriate default file whether
# it needs to look for SPFILE or PFILE. if user provides the configuration
# file they need to be specific as whether SPFILE or PFILE.

while {[gets $f2 line] >= 0} {
    puts $f1 $line
}
close $f1
close $f2
# for bug 1197576: for >= 8.1, ignore "already started" error if just started
# nt service (since this starts db too in >= 8.1).  If nt service already
# there, "already started" may be accurate.
set db_version [DB_VERSION]
if {[string compare $db_version "81"] >= 0} {
    if {$startStatus == 0 } {
        lappend ignore_errors {ORA-01081}
    }
}

set sqlplusexec [SQLPLUS]
set svrmgrlexec [SVRMGRL]

if { [info exists env(ORACLE_HOME)] } {
    set ooh $env(ORACLE_HOME)
    set env(ORACLE_HOME) [ORACLE_HOME]
}
if { [info exists env(ORACLE_SID)] } {
    set osid $env(ORACLE_SID)
}
set env(ORACLE_SID) [ORACLE_SID]

if {[set startStatus [catch {StartDbService} out]]} {
    puts [convertout $oramsg(agent_characterset) $out]
    puts [msgtxt [NETWORK] nms 1084]
}

if {[file executable $svrmgrlexec]} {
    if { [catch { SQLEXEC $svrmgrlexec $svrconnstr $tmpfile $outputfile } outx] } {
	if { [info exists env(ORACLE_HOME)] } {
		set env(ORACLE_HOME) $ooh
	}
        set env(ORACLE_SID) $osid
	rmfile $tmpfile
        rmfile $outputfile
	puts [convertout $oramsg(agent_characterset) $outx]
	orafail [format [msgtxt [NETWORK] nms 915] ""]
    }
    if { [info exists env(ORACLE_HOME)] } {
		set env(ORACLE_HOME) $ooh
    }
    set env(ORACLE_SID) $osid
    rmfile $tmpfile
    rmfile $outputfile
    if {[regexp {(ORA-)([0-9]+)} $outx whole sub1 sub2] == 1} {
                set ignore 0
                foreach error $ignore_errors {
                        if {[string first $error $outx] >= 0} {
                             set ignore 1                       
                        }
                }
                if { $ignore == 1 } {
                        puts [msgtxt1 [NETWORK] nms 1101]
                } else {                          
        		puts [convertout $oramsg(agent_characterset) $outx]
	        	orafail [msgtxt [RDBMS] ora $sub2]
                }
    } elseif {[regexp {(MGR-)([0-9]+)} $outx whole sub1 sub2] == 1} {
		puts [convertout $oramsg(agent_characterset) $outx]
		orafail [msgtxt [SVRMGRL] mgr $sub2]
    } else {
		puts [msgtxt1 [NETWORK] nms 1101]
    }
} elseif {[file executable $sqlplusexec]} {
    if { [catch { SQLEXEC $sqlplusexec $connstr $tmpfile $outputfile } outx] } {
		if { [info exists env(ORACLE_HOME)] } {
			set env(ORACLE_HOME) $ooh
		}
                set env(ORACLE_SID) $osid
		rmfile $tmpfile
                rmfile $outputfile
		puts [convertout $oramsg(agent_characterset) $outx]
		orafail [format [msgtxt [NETWORK] nms 915] ""]
    }
    if { [info exists env(ORACLE_HOME)] } {
		set env(ORACLE_HOME) $ooh
    }
    set env(ORACLE_SID) $osid
    rmfile $tmpfile
    rmfile $outputfile
    if {[regexp {(ORA-)([0-9]+)} $outx whole sub1 sub2] == 1} {
                set ignore 0
                foreach error $ignore_errors {
                        if {[string first $error $outx] >= 0} {
                             set ignore 1                       
                        }
                }
                if { $ignore == 1 } {
                        puts [msgtxt1 [NETWORK] nms 1101]
                } else {                          
                        puts [convertout $oramsg(agent_characterset) $outx]
                        orafail [msgtxt [RDBMS] ora $sub2]
                }
    } elseif {[regexp {(SP2-)([0-9]+)} $outx whole sub1 sub2] == 1} {
		puts [convertout $oramsg(agent_characterset) $outx]
		orafail [msgtxt [SQLPLUS] mgr $sub2]
    } else {
		puts [convertout $oramsg(agent_characterset) $outx]
    }
} else {
    if { [info exists env(ORACLE_HOME)] } {
		set env(ORACLE_HOME) $ooh
    }
    set env(ORACLE_SID) $osid
    rmfile $tmpfile
    orafail [msgtxt [NETWORK] nms 1010]
}

