REM
REM $Header: catmd.sql 20-may-2003.10:27:23 sravada Exp $
REM
REM Copyright (c) 1992, 2003, Oracle Corporation.  All rights reserved.  
REM
REM NAME:
REM    catmd.sql 
REM DESCRIPTION:
REM    Installs 
REM             - SDO_GEOM package
REM             - SDO_ADMIN package
REM             - SDO_TUNE package
REM             - SDOTYPES The definition of Spatial Object Types
REM             - SDO_3GL package for trusted callouts
REM             - SDO_CS  package for coordinate systems
REM             - SDO_LRS package for linear referencing systems
REM             - SDO_UTIL package
REM NOTES:
REM    Must be run as MDSYS.
REM    Packages obsoleted/removed in 8.2
REM		- MD3 data dictionary tables 
REM		- MD3 data dictionary user views
REM		- MDSQL packages for MD operations
REM		- MDWEX packages for extracting data 
REM		- MDGTRIG package for generating triggers
REM             - SDO_SERV_PART package
REM

REM MODIFIED     (DD-MON-YY)  DESCRIPTION
REM wexu          19-SEP-01   Add sdo_pridx package
REM jcwang	  21-SEP-01   Add LRS metadata sdolrsmd.sql
REM wexu          24-MAY-01   Add sdo_util package
REM qxie          15-DEC-00   Add sdocsdef for CS related tables
REM jcwang        15-AUG-00   Add prvtlrsh.plb prvtlrsb.plb sdolrsh.sql sdolrsb.plb
REM jsharma       29-JUL-99   Remove 7.3.2 functionality packages
REM sravada       29-JUL-99   Add CS and LRS files
REM pfwang        01-JUL-98   Change sdocat.sql to .plb, prvtcat.sql to .plb
REM gvincent      10-MAY-98   Add sdomig.sql, prvtmig.plb
REM sravada       14-APR-98   Add prvtoper.plb
REM pfwang        10-APR-98   Add OGIS metadata support
REM gvincent      08-APR-98   Put indexing load right after types
REM gvincent      30-MAR-98   Fix ordering of calls - 3gl before md2
REM ranwei        18-FEB-98   Add trusted callout package SDO_3GL
REM gvincent      13-FEB-98   Add call to create trusted lib ORDMDLIBS
REM gvincent      23-JAN-98   Create relate table before installing md2
REM pfwang        01-JAN-98   Add relate lookup table setup
REM jsharma       24-DEC-1997 Remove prvt{gtes,tess,mett,spop}.sql
REM jsharma       18-DEC-1997 Add install of Spatial Object Types (sdotypes.sql
REM                           and sdotypeg.sql)
REM jsharma       18-DEC-1997 Add install of Validate Geometry 
REM jsharma       06-SEP-97   Add tuning utility functions (prvttune)
REM Vretanos      19-JUN-96   Add second pass filter functions
REM NRaabe        14-JUN-96   Add ADMIN & GEOM  package installation.
REM NAgarwal      11-JUN-96   Add Server Partitioning Installation
REM Vretanos      28-MAY-96   Add METT package installation.
REM NRaabe        30-MAY-96   Add package installation for new kernel functions.
REM NRaabe        08-MAY-96   Remove the MDD (pod) package.
REM NRaabe        08-MAY-96   Add a prompt before installing mdtrig package.
REM Vretanos      24-JAN-96   Remove PRVTLIMS.SQL file.
REM Feng          27-DEC-95   Reorder execution of prvtboot with md package
REM Vretanos      28-SEP-95   Modify order of installation of MDD.
REM Vretanos      22-SEP-95   Add MDLIMS pacakge.
REM Vretanos      21-SEP-95   Update MD_WEX installation.
REM Feng          01-AUG-95   Add MDDICT dictionary package
REM Vretanos      22-NOV-94   Creation
REM

REM change the session to set the current schema
Alter session set current_schema=MDSYS;

REM Add component registry entry to mark sdo loading
EXECUTE dbms_registry.loading('SDO','Spatial',NULL,'MDSYS');


REM Creating MD package ...              
--prompt Creating package MD ...         
@@md                                     
show errors;                             
@@prvtmd.plb                             
show errors;                             
                                         
commit;                                  

REM Creating MDERR package ...
--prompt Creating package MDERR ...
@@prvterr.plb
show errors;

REM Install the SDO Object Data Types (ODTs)
REM and grant execute privilege to PUBLIC
--prompt Installing SDO Object Types ...
@@sdotypes.sql
@@sdotypeg.sql

REM Install the Geometry Metadata Views
@@prvtgmd.plb

REM Create the LRS Package
@@prvtlrsh.plb
@@sdolrsh.sql


Rem Create the CoordSystems Package
Rem We need this here as other packages refer to these functions
@@sdocs.sql

REM Load the header for Index_Method supporting routines (sdo_idx package)
--prompt Installing the sdo_idx package
@@sdopidx.sql

REM Install the Extensible Indexing package.
--prompt Installing type spatial_im package ...
@@prvtsidx.plb
REM Load the body for Index_Method supporting routines (sdo_idx package)
--prompt Installing the sdo_idx package body
@@prvtpidx.plb
@@prvtsipt.plb


REM Relate table lookup setup
--prompt Installing SDO_GEOM.RELATE() table...
@@relate.sql

REM Install the 3GL package header.
REM  This should be before prvtmd2.
--prompt Installing SDO_3GL package header ...
@@prvt3glh.plb

REM Install the SDO package.
--prompt Installing SDO package ...
@@prvtmd1.plb
@@prvtmd2.plb
@@sdo.sql
@@prvtsdo.plb


REM Install the ADMIN package.
--prompt Installing SDO_ADMIN package ...
@@sdoadmin.sql
@@prvtadmn.plb

REM Install the SDO_TUNE package
@@sdotune.sql

Rem Load SDO_UTIL package header
@@sdoutlh.sql

REM Install the GEOM package.
--prompt Installing SDO_GEOM package ...
@@sdogeom.sql
@@prvtgeom.plb

REM Install the 3GL package body.
--prompt Installing SDO_3GL package body ...
@@prvt3gl.plb

REM Installing OGIS Style catalog
--prompt Installing OGIS style catalog
@@sdocat.plb
@@prvtcat.plb
REM Installing SDO operators
--prompt Installing SDO operators
@@prvtoper.plb

REM Install migration to 8.1 package
--prompt Installing migration package
@@sdomig.sql
@@prvtmig.plb

--Rem Create the indextypes and operator
--@@prvtlctr.plb
 
Rem Create the geocoder_http package header
@@sdogcdr.sql
  
Rem Create the functions in the geocoder_http package
@@prvtgcdr.plb


Rem Create the CoordSystems Package Body
@@prvtcs.plb

Rem Load the WKT/SRID/Datum Table
@@sdowkt.sql

Rem Load the LRS Packages
@@prvtlrsb.plb
@@sdolrsb.plb


Rem Load Rtree ops for N-dimensional objects
@@prvtrtr.plb

Rem Install sdo_tune package body
@@prvttune.plb

Rem Load SDO Utilities  
@@sdoutl.plb

Rem Load Synonyms for Old Obsoleted SQL functions
@@sdosfs.sql

Rem Load Types and functions for Aggregate functions
@@sdoaggrh.sql
@@sdoaggrb.plb

Rem Load SDO_UNIT names
@@sdounit.sql

Rem Load ellipsoid, datum and projection tables
@@sdocsdef.sql

Rem Load SDO_UTIL package body
@@sdoutlb.plb

Rem Load the SDOMAP Definitions
@@sdomapd.sql

Rem Load SDO_PRIDX package
@@prvtprdx.plb

Rem Load the LRS Metadata
@@sdolrsmd.sql

REM update the component registry
REM this should be the last one in catmd (ALWAYS!!)
@@sdocmprg.sql
commit;

Alter session set current_schema=SYS;

