declare
begin
   begin
    execute immediate 
  ' CREATE TABLE SDO_GEOM_METADATA_TABLE ( ' ||
    '  SDO_OWNER varchar2(32), ' ||
    '  SDO_TABLE_NAME varchar2(32), ' ||
    '  SDO_COLUMN_NAME varchar2(1024),  ' ||
    '  SDO_DIMINFO MDSYS.SDO_DIM_ARRAY, ' ||
    '  SDO_SRID number, ' ||
    '  CONSTRAINT unique_layers  ' ||
    '   PRIMARY KEY (SDO_OWNER,SDO_TABLE_NAME, SDO_COLUMN_NAME)) ' ;
   exception when others then null;
  end;
end;
/
drop index SDO_GEOM_IDX;
CREATE INDEX SDO_GEOM_IDX ON SDO_GEOM_METADATA_TABLE(SDO_OWNER,SDO_TABLE_NAME);
drop view USER_SDO_GEOM_METADATA;
CREATE VIEW USER_SDO_GEOM_METADATA AS
SELECT SDO_TABLE_NAME TABLE_NAME,
       SDO_COLUMN_NAME COLUMN_NAME,
       SDO_DIMINFO DIMINFO,
       SDO_SRID SRID
FROM SDO_GEOM_METADATA_TABLE,
     (select sys_context('userenv', 'CURRENT_SCHEMA') username from dual)
WHERE  sdo_owner = username;
drop view all_SDO_GEOM_METADATA;
CREATE VIEW ALL_SDO_GEOM_METADATA AS
SELECT SDO_OWNER OWNER,
       SDO_TABLE_NAME TABLE_NAME,
       SDO_COLUMN_NAME COLUMN_NAME,
       SDO_DIMINFO DIMINFO,
       SDO_SRID SRID
FROM SDO_GEOM_METADATA_TABLE
WHERE 
(exists
   (select table_name from all_tables
    where table_name=sdo_table_name
      and owner = sdo_owner
    union all
      select table_name from all_object_tables
      where table_name=sdo_table_name
      and owner = sdo_owner
    union all
    select view_name table_name from all_views
    where  view_name=sdo_table_name
      and owner = sdo_owner));
drop view DBA_SDO_GEOM_METADATA;
grant select,insert, delete, update on user_sdo_geom_metadata to public;
grant select on all_sdo_geom_metadata to public;
drop  public synonym user_sdo_geom_metadata;
create public synonym user_sdo_geom_metadata for mdsys.user_sdo_geom_metadata;
drop public synonym all_sdo_geom_metadata;
create public synonym all_sdo_geom_metadata for mdsys.all_sdo_geom_metadata;
commit;
create or replace trigger sdo_drop_user
after drop on DATABASE
declare 
   stmt varchar2(200);
BEGIN
     if dictionary_obj_type = 'USER' THEN
       stmt := 'DELETE FROM SDO_GEOM_METADATA_TABLE ' ||
               ' WHERE SDO_OWNER = ''' || dictionary_obj_name || ''' ';
       EXECUTE IMMEDIATE stmt;
       stmt := 'DELETE FROM SDO_MAPS_TABLE ' ||
               ' WHERE SDO_OWNER = ''' || dictionary_obj_name || ''' ';
       EXECUTE IMMEDIATE stmt;
       stmt := 'DELETE FROM SDO_STYLES_TABLE ' ||
           ' WHERE SDO_OWNER = ''' || dictionary_obj_name || ''' ';
       EXECUTE IMMEDIATE stmt;
       stmt := 'DELETE FROM SDO_THEMES_TABLE ' ||
           ' WHERE SDO_OWNER = ''' || dictionary_obj_name || ''' ';
       EXECUTE IMMEDIATE stmt;
       stmt := 'DELETE FROM SDO_LRS_METADATA_TABLE ' ||
           ' WHERE SDO_OWNER = ''' || dictionary_obj_name || ''' ';
       EXECUTE IMMEDIATE stmt;
    end if;
end;
/
show errors;
CREATE OR REPLACE TRIGGER SDO_GEOM_TRIG_INS1
INSTEAD OF INSERT ON user_sdo_geom_metadata
REFERENCING NEW AS n
FOR EACH ROW
declare
 tname varchar2(32);
 stmt  varchar2(2048);
 vcount INTEGER;
BEGIN
  EXECUTE IMMEDIATE
  'SELECT user FROM dual' into tname; 
  if ( (instr(:n.table_name, ' ') > 0 ) OR
       (instr(:n.table_name, '''') > 0 ) )  then
   mderr.raise_md_error('MD', 'SDO', -13223,
               :n.table_name||'.'||:n.column_name);
   end if;
  if ( (instr(:n.column_name, ' ') > 0 ) OR
       (instr(:n.column_name, '''') > 0 ) ) then
   mderr.raise_md_error('MD', 'SDO', -13223,
               :n.table_name||'.'||:n.column_name);
   end if;
  stmt :=  'SELECT count(*) FROM SDO_GEOM_METADATA_TABLE ' ||
  'WHERE sdo_owner = :tname  AND sdo_table_name = :table_name  '||
  '  AND  sdo_column_name = :column_name  ';
EXECUTE IMMEDIATE stmt INTO vcount
   USING tname, :n.table_name, :n.column_name;
  IF vcount = 0 THEN
    INSERT INTO sdo_geom_metadata_table values
             (upper(tname), 
             upper(:n.table_name), upper(:n.column_name), :n.diminfo,
             :n.srid);
  ELSE 
   mderr.raise_md_error('MD', 'SDO', -13223,
               :n.table_name||'.'||:n.column_name);
 END IF;
END;
/
show errors;
CREATE OR REPLACE  TRIGGER SDO_GEOM_TRIG_DEL1
INSTEAD OF DELETE ON user_sdo_geom_metadata
REFERENCING OLD AS n
FOR EACH ROW
declare
 tname varchar2(32);
 stmt  varchar2(2048);
 vcount INTEGER;
BEGIN
  EXECUTE IMMEDIATE
  'SELECT user FROM dual' into tname; 
    DELETE FROM  sdo_geom_metadata_table 
    WHERE SDO_OWNER = tname
      AND SDO_TABLE_NAME = upper(:n.table_name) 
      AND SDO_COLUMN_NAME = upper(:n.column_name);
END;
/
show errors;
CREATE  OR REPLACE TRIGGER SDO_GEOM_TRIG_UPD1
INSTEAD OF UPDATE ON user_sdo_geom_metadata
REFERENCING OLD AS old NEW AS n
FOR EACH ROW
declare
 tname varchar2(32);
 stmt  varchar2(2048);
 vcount INTEGER;
BEGIN
  EXECUTE IMMEDIATE
  'SELECT user FROM dual' into tname; 
    UPDATE sdo_geom_metadata_table 
    SET (SDO_TABLE_NAME, SDO_COLUMN_NAME, SDO_DIMINFO, SDO_SRID)  = 
     (SELECT upper(:n.table_name), upper(:n.column_name), :n.diminfo, 
      :n.srid  FROM DUAL)
    WHERE SDO_OWNER = tname
      AND SDO_TABLE_NAME = upper(:old.table_name)
      AND SDO_COLUMN_NAME = upper(:old.column_name); 
END;
/
show errors;
create or replace package SDO_META wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
9
9200000
1
4
0 
e
2 :e:
1PACKAGE:
1SDO_META:
1AUTHID:
1CURRENT_USER:
1CHANGE_ALL_SDO_GEOM_METADATA:
1OWNER:
1VARCHAR2:
1TABLE_NAME:
1COLUMN_NAME:
1DIMINFO:
1MDSYS:
1SDO_DIM_ARRAY:
1SRID:
1NUMBER:
0

0
0
3c
2
0 a0 97 :2 a0 9a 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f :2 a0 6b b0 3d b4 55
6a 9a 8f a0 b0 3d 8f a0
b0 3d 8f a0 b0 3d 8f :2 a0
6b b0 3d 8f a0 b0 3d b4
55 6a :2 aa 59 58 1d 17 b5 
3c
2
0 3 13 b f 1d 35 31
a 3d 4a 46 7 52 5b 57
45 63 74 6c 70 42 6b 7c
68 81 85 89 a5 a1 a0 ad
ba b6 9d c2 cb c7 b5 d3
e4 dc e0 b2 db ec f9 f5
d8 101 f4 106 10a f1 10e 110
113 116 117 120 
3c
2
0 1 9 12 19 b 28 31
:2 28 24 32 :3 24 33 :2 24 8 13
19 13 :2 8 27 :2 1 b 28 31
:2 28 24 32 :3 24 33 :3 24 2f 35
2f :3 24 2c :2 24 27 :9 1 
3c
4
0 :4 1 :5 2 :4 3
:4 4 :6 5 :3 2 :5 7
:4 8 :4 9 :6 a :4 b
:3 7 :7 1 
122
4
:3 0 1 :3 0 5
42 0 :2 3 :3 0
4 :3 0 2 :6 0
1 :2 0 5 :a 0
1a 2 :7 0 7
:3 0 6 :7 0 8
7 :3 0 13 14
0 :2 7 :3 0 8
:7 0 c b :3 0
7 :3 0 9 :7 0
10 f :3 0 b
:2 0 9 b :3 0
c :2 0 4 a
:7 0 16 15 :3 0
18 :2 0 1a 5
19 0 35 5
:a 0 34 3 :7 0
12 b2 0 10
7 :3 0 6 :7 0
1e 1d :3 0 29
2a 0 14 7
:3 0 8 :7 0 22
21 :3 0 7 :3 0
9 :7 0 26 25
:3 0 18 f1 0
16 b :3 0 c
:2 0 4 a :7 0
2c 2b :3 0 20
37 0 1a e
:3 0 d :7 0 30
2f :3 0 32 :2 0
34 1b 33 0
35 0 37 35
36 38 2 37
3a 0 39 38
3b :4 0 4 :3 0

23
4
:3 0 1 6 1
a 1 e 1
12 4 9 d
11 17 1 1c
1 20 1 24
1 28 1 2e
5 1f 23 27
2d 31 2 1a
34 
1
4
0 
3a
0
1
14
3
c
0 1 1 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
1b 1 3
5 1 2
2e 3 0
28 3 0
12 2 0
24 3 0
e 2 0
2 0 1
1c 3 0
6 2 0
20 3 0
a 2 0
0

/
show errors;
create or replace package body SDO_META wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
b
9200000
1
4
0 
16
2 :e:
1PACKAGE:
1BODY:
1SDO_META:
1CHANGE_ALL_SDO_GEOM_METADATA:
1OWNER:
1VARCHAR2:
1TABLE_NAME:
1COLUMN_NAME:
1DIMINFO:
1MDSYS:
1SDO_DIM_ARRAY:
1SRID:
1NUMBER:
1STMT:
12048:
1CNT:
1SDO_GEOM_METADATA_TABLE:
1SDO_OWNER:
1=:
1SDO_TABLE_NAME:
1SDO_COLUMN_NAME:
1UPPER:
0

0
0
8d
2
0 :2 a0 97 9a 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
8f :2 a0 6b b0 3d b4 55 6a
:5 a0 4d a5 57 b7 a4 b1 11
68 4f 9a 8f a0 b0 3d 8f
a0 b0 3d 8f a0 b0 3d 8f
:2 a0 6b b0 3d 8f a0 b0 3d
b4 55 6a a3 a0 51 a5 1c
81 b0 a3 a0 1c 81 b0 :2 a0
6b :2 a0 7e b4 2e :2 a0 7e b4
2e a 10 :2 a0 7e b4 2e a
10 cd e9 :2 a0 6b :2 a0 a5 b
:2 a0 a5 b :2 a0 a5 b :2 a0 5
d7 b2 5 e9 b7 a4 b1 11
68 4f b1 b7 a4 11 a0 b1
56 4f 1d 17 b5 
8d
2
0 3 7 b 15 31 2d 2c
39 46 42 29 4e 57 53 41
5f 70 68 6c 3e 67 78 64
7d 81 85 89 8d 91 95 99
9a 9b a0 a2 a6 a8 b4 b8
ba d6 d2 d1 de eb e7 ce
f3 fc f8 e6 104 115 10d 111
e3 10c 11d 12a 126 109 132 125
137 13b 155 143 122 147 148 150
142 171 160 164 16c 13f 15c 178
17c 17f 183 187 18a 18b 190 194
198 19b 19c 1 1a1 1a6 1aa 1ae
1b1 1b2 1 1b7 1bc 1c1 1c6 1ca
1ce 1d1 1d5 1d9 1da 1dc 1e0 1e4
1e5 1e7 1eb 1ef 1f0 1f2 1f6 1fa
1fe 206 207 20b 210 212 216 218
224 228 22a 22c 22e 232 23e 242
244 247 249 24a 253 
8d
2
0 1 9 e b 28 31 :2 28
24 32 :3 24 33 :3 24 2f 35 2f
:2 24 27 :2 1 3 20 26 31 3d
45 :2 3 :6 1 b 28 31 :2 28 f
1d :2 f 24 33 :2 24 8 13 19
13 :2 8 24 2c :2 24 27 :3 1 6
f e :2 6 :2 1 :3 5 1 f 15
f 9 15 :3 13 9 1a :3 18 :3 9
1b :3 19 :2 9 :2 3 e 14 e b
11 :2 b 19 1f :2 19 2c 32 :2 2c
3f 47 a :4 2 :a 1 5 :6 1 
8d
4
0 :3 1 :5 2 :4 3
:4 4 :6 5 :3 2 :8 7
:2 6 :4 2 :5 9 :4 a
:4 b :6 c :4 d :3 9
:7 e :5 f :3 14 :5 15
:5 16 :2 15 :5 17 :2 15
:2 14 :3 18 :f 19 :4 18
:2 10 :4 9 :4 2 1c
:6 1 
255
4
:3 0 1 :3 0 2
:3 0 3 :6 0 1
:2 0 4 :a 0 26
2 :7 0 5 3e
0 3 6 :3 0
5 :7 0 7 6
:3 0 12 13 0
7 6 :3 0 7
:7 0 b a :3 0
6 :3 0 8 :7 0
f e :3 0 b
:2 0 9 a :3 0
b :2 0 4 9
:7 0 15 14 :3 0
17 :2 0 26 4
18 :2 0 4 :3 0
5 :3 0 7 :3 0
8 :3 0 9 :4 0
10 1a 20 :2 0
22 16 25 :3 0
25 0 25 24
22 23 :6 0 26
1 0 4 18
25 87 :2 0 4
:a 0 80 3 :7 0
1a e3 0 18
6 :3 0 5 :7 0
2b 2a :3 0 36
37 0 1c 6
:3 0 7 :7 0 2f
2e :3 0 6 :3 0
8 :7 0 33 32
:3 0 20 122 0
1e a :3 0 b
:2 0 4 9 :7 0
39 38 :3 0 f
:2 0 22 d :3 0
c :7 0 3d 3c
:3 0 3f :2 0 80
28 40 :2 0 2c
15c 0 2a 6
:3 0 28 43 45
:6 0 48 46 0
7e 0 e :6 0
a :3 0 d :3 0
4a :7 0 4d 4b
0 7e 0 10
:6 0 11 :2 0 4
4e 4f 0 12
:3 0 5 :3 0 13
:2 0 30 53 54
:3 0 14 :3 0 7
:3 0 13 :2 0 35
58 59 :3 0 55
5b 5a :2 0 15
:3 0 8 :3 0 13
:2 0 3a 5f 60
:3 0 5c 62 61
:2 0 50 63 0
65 :2 0 64 :2 0
7c a :3 0 11
:2 0 4 66 67
0 16 :3 0 5
:3 0 3d 69 6b
16 :3 0 7 :3 0
3f 6d 6f 16
:3 0 8 :3 0 41
71 73 9 :3 0
c :3 0 43 :3 0
68 79 7a 7b
:5 0 49 :4 0 78
:2 0 7c 4b 7f
:3 0 7f 4e 7f
7e 7c 7d :6 0
80 1 0 28
40 7f 87 :3 0
85 0 85 :3 0
85 87 83 84
:6 0 88 :2 0 3
:3 0 51 0 3
85 8b :3 0 8a
88 8c :8 0 
54
4
:3 0 1 5 1
9 1 d 1
11 4 8 c
10 16 5 1b
1c 1d 1e 1f
1 21 1 29
1 2d 1 31
1 35 1 3b
5 2c 30 34
3a 3e 1 44
1 42 1 49
1 52 2 51
52 1 57 2
56 57 1 5e
2 5d 5e 1
6a 1 6e 1
72 5 6c 70
74 75 76 1
77 2 65 7b
2 47 4c 2
26 80 
1
4
0 
8b
0
1
14
3
e
0 1 1 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
28 1 3
4 1 2
3b 3 0
49 3 0
35 3 0
11 2 0
42 3 0
31 3 0
d 2 0
3 0 1
29 3 0
5 2 0
2d 3 0
9 2 0
0

/
show errors;
grant execute on SDO_META to public;
create or replace function SDO_VERSION wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
8
9200000
1
4
0 
a
2 :e:
1FUNCTION:
1SDO_VERSION:
1RETURN:
1VARCHAR2:
130:
1VERSION:
1DBA_REGISTRY:
1COMP_ID:
1=:
1SDO:
0

0
0
2b
2
0 a0 8d a0 b4 a0 2c 6a
a3 a0 51 a5 1c 81 b0 a0
ac :2 a0 b2 ee a0 7e 6e b4
2e ac e5 d0 b2 e9 :2 a0 65
b7 a4 b1 11 68 4f 1d 17
b5 
2b
2
0 3 f b a 23 27 2b
45 33 7 37 38 40 32 4c
2f 50 54 58 59 60 64 67
6c 6d 72 73 79 7d 7e 83
87 8b 8f 91 95 97 a3 a7
a9 aa b3 
2b
2
0 1 a 2 0 9 :2 1 2
e 17 16 :2 e 2 :2 9 16 7
2 7 1a 21 22 :2 21 :5 2 3
b 3 :9 1 
2b
4
0 :2 1 2 0
2 :2 1 :7 3 :3 5
:9 6 :4 5 :3 8 :2 4
:7 1 
b5
4
:3 0 1 :3 0 5
:3 0 3 :3 0 2
:a 0 26 1 :7 0
4 :3 0 4 5
0 26 2 6
:2 0 7 :2 0 5
4 :3 0 3 9
b :6 0 e c
0 24 0 2
:6 0 6 :3 0 2
:3 0 7 :3 0 9
13 19 0 1a
:3 0 8 :3 0 9
:2 0 a :4 0 d
16 18 :4 0 1c
1d :5 0 10 14
0 10 0 1b
:2 0 22 3 :3 0
2 :3 0 20 :2 0
22 12 25 :3 0
25 15 25 24
22 23 :6 0 26
:2 0 2 6 25
29 :3 0 28 26
2a :8 0 
17
4
:3 0 1 a 1
8 1 f 1
12 1 17 2
15 17 1 11
2 1e 21 1
d 
1
4
0 
29
1
1
14
1
2
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
8 1 0
2 0 1
0

/
grant execute on SDO_VERSION to public;
create public synonym SDO_VERSION for mdsys.SDO_VERSION;
