create  or replace operator
  sdo_nn binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  compute ancillary data
  using prvt_idx.nn;
grant execute on sdo_nn to public with grant option;
create or replace operator sdo_nn_distance
  binding (number)
return number
  ancillary to sdo_nn (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
  using  prvt_idx.nndistance;
grant execute on sdo_nn_distance to public with grant option;
create  or replace operator 
  sdo_relate binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) 
return varchar2 
  with index context,
  SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.relate;
grant execute on sdo_relate to public with grant option;
create  or replace operator 
  sdo_filter binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) 
return varchar2 
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.filter;
grant execute on sdo_filter to public with grant option;
create  or replace operator 
  sdo_rtree_filter binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) 
return varchar2 
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.filter;
grant execute on sdo_rtree_filter to public with grant option;
create  or replace operator 
  sdo_rtree_relate binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) 
return varchar2 
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.relate;
grant execute on sdo_rtree_relate to public with grant option;
create  or replace operator 
sdo_within_distance binding(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) 
return varchar2 
  with index context,
  SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.within_distance;
grant execute on sdo_within_distance to public with grant option;
create  or replace operator 
  sdo_int_relate binding (mdsys.sdo_geometry, mdsys.sdo_geometry, ROWID,
                          varchar2, varchar2, varchar2,number,number, number) 
return varchar2 
  with index context,
  SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.relate;
grant execute on sdo_int_relate to public with grant option;
create or replace operator 
  sdo_int_filter binding (mdsys.sdo_geometry, mdsys.sdo_geometry, ROWID,
                          varchar2, varchar2, varchar2,number,number, number) 
return varchar2 
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.filter;
grant execute on sdo_int_filter to public with grant option;
create  or replace operator 
  sdo_int2_relate binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) 
return varchar2 
  with index context,
  SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.relate;
grant execute on sdo_int2_relate to public with grant option;
create  or replace operator 
  sdo_int2_filter binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) 
return varchar2 
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.filter;
grant execute on sdo_int2_filter to public with grant option;
create or replace operator
 locator_within_distance 
  binding(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
 with index context,
 SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.within_distance;
grant execute on locator_within_distance to public with grant option;
drop function sdo_dummy_function;
create function sdo_dummy_function wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
8
9200000
1
4
0 
a
2 :e:
1FUNCTION:
1SDO_DUMMY_FUNCTION:
1GEOM1:
1MDSYS:
1SDO_GEOMETRY:
1GEOM2:
1PARAM:
1VARCHAR2:
1RETURN:
1DUMMY:
0

0
0
24
2
0 a0 8d 8f :2 a0 6b b0 3d
8f :2 a0 6b b0 3d 8f a0 b0
3d b4 :2 a0 2c 6a a0 6e 65
b7 a4 b1 11 68 4f 1d 17
b5 
24
2
0 3 7 2a 1f 23 27 1e
32 43 3b 3f 1b 3a 4b 58
54 37 60 53 65 69 6d 71
75 79 7e 50 82 86 88 94
98 9a 9b a4 
24
2
0 1 a 1e 27 2d 27 :3 1e
27 2d 27 :2 1e 3b 44 :2 3b 1d
1 8 :2 1 3 a 3 :9 1 
24
4
0 :8 1 :a 2 1
:2 3 :2 1 :3 5 :2 4
:7 1 
a6
4
:3 0 1 :3 0 2
:a 0 1f 1 :7 0
a b 0 3
4 :3 0 5 :2 0
:2 4 5 0 3
:7 0 7 6 :3 0
7 50 0 5
4 :3 0 5 :2 0
4 6 :7 0 d
c :3 0 d 1e
0 9 8 :3 0
7 :7 0 11 10
:3 0 9 :3 0 8
:3 0 13 15 0
1f 2 16 :2 0
9 :3 0 a :4 0
19 :2 0 1b :3 0
1e 0 1e 1d
1b 1c :6 0 1f
:2 0 2 16 1e
22 :3 0 21 1f
23 :8 0 
f
4
:3 0 1 3 1
9 1 f 3
8 e 12 1
1a 
1
4
0 
22
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
3 1 0
9 1 0
f 1 0
2 0 1
0

/
grant execute on sdo_dummy_function to public with grant option;
declare
 stmt varchar2(200);
begin
 stmt := ' drop operator sdo_dummy ';
 begin
    EXECUTE IMMEDIATE stmt;
   EXCEPTION
         WHEN OTHERS THEN
   return;
 end;
end;
/
declare
 stmt varchar2(400);
begin
 stmt := ' create  operator '||
   ' sdo_dummy binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) '||
  ' return varchar2 using sdo_dummy_function ';
 begin
    EXECUTE IMMEDIATE stmt;
   EXCEPTION
         WHEN OTHERS THEN
   return;
 end;
end;
/
grant execute on sdo_dummy to public with grant option;
create or replace indextype spatial_index for
sdo_dummy(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
using sdo_index_method_9i
with local range partition;
alter indextype spatial_index add
sdo_nn_distance(number);
alter indextype spatial_index add
sdo_nn(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index add
sdo_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) rewrite JOIN;
alter indextype spatial_index add
sdo_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) rewrite JOIN;
alter indextype spatial_index add
sdo_rtree_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index add
sdo_rtree_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index add
sdo_int_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2, varchar2, 
               varchar2, varchar2,number,number, number);
alter indextype spatial_index add
sdo_int_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2, varchar2, 
               varchar2, varchar2,number,number, number);
alter indextype spatial_index add
sdo_within_distance(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index add
locator_within_distance(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index add
sdo_int2_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index add
sdo_int2_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) ;
alter indextype spatial_index
drop sdo_dummy(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
drop operator sdo_dummy;
drop function sdo_dummy_function;
grant execute on spatial_index to public with grant option;
create public  synonym sdo_nn for mdsys.sdo_nn;
create public  synonym sdo_nn_distance for mdsys.sdo_nn_distance;
create public  synonym sdo_filter for mdsys.sdo_filter;
create public  synonym sdo_relate for mdsys.sdo_relate;
create public  synonym sdo_rtree_filter for mdsys.sdo_rtree_filter;
create public  synonym sdo_rtree_relate for mdsys.sdo_rtree_relate;
create public  synonym sdo_within_distance for mdsys.sdo_within_distance;
create public  synonym locator_within_distance for
                                           mdsys.locator_within_distance;
commit;
  CREATE  TABLE SDO_INDEX_METADATA_TABLE
     (SDO_INDEX_OWNER varchar2(32),
      SDO_INDEX_TYPE varchar2(32),
      SDO_LEVEL NUMBER,
      SDO_NUMTILES NUMBER, SDO_MAXLEVEL NUMBER,
      SDO_COMMIT_INTERVAL NUMBER,  SDO_INDEX_TABLE varchar2(32),
      SDO_INDEX_NAME varchar2(32), SDO_INDEX_PRIMARY NUMBER,
      SDO_TSNAME varchar2(32),
      SDO_COLUMN_NAME varchar2(2048),
      SDO_RTREE_HEIGHT  number, 
      SDO_RTREE_NUM_NODES number,
      SDO_RTREE_DIMENSIONALITY number,
      SDO_RTREE_FANOUT number,
      SDO_RTREE_ROOT varchar2(32),
      SDO_RTREE_SEQ_NAME varchar2(32),
      SDO_FIXED_META RAW(255), SDO_TABLESPACE varchar2(32),
      SDO_INITIAL_EXTENT  varchar2(32), SDO_NEXT_EXTENT varchar2(32),
      SDO_PCTINCREASE NUMBER, SDO_MIN_EXTENTS NUMBER, SDO_MAX_EXTENTS NUMBER,
      SDO_INDEX_DIMS number,
      SDO_LAYER_GTYPE varchar2(32),
      SDO_RTREE_PCTFREE number,
      SDO_INDEX_PARTITION varchar2(32),
      SDO_PARTITIONED number,
      SDO_RTREE_QUALITY number,
      SDO_INDEX_VERSION number,
      SDO_INDEX_GEODETIC varchar2(8),
      SDO_INDEX_STATUS varchar2(32));
declare
begin
   begin
     execute immediate  ' alter table sdo_index_metadata_table add  ' ||
             ' (SDO_ROOT_MBR mdsys.sdo_geometry) ';
     exception when others then NULL;
  end;
end;
/
drop view user_sdo_index_metadata;
drop view dba_sdo_index_metadata;
drop view all_sdo_index_metadata;
create view user_sdo_index_metadata as
 select SDO_INDEX_OWNER, SDO_INDEX_TYPE,
        SDO_INDEX_NAME, SDO_INDEX_TABLE, SDO_INDEX_PRIMARY,
        SDO_INDEX_PARTITION, SDO_PARTITIONED,
        SDO_TSNAME, SDO_COLUMN_NAME, SDO_INDEX_DIMS, 
        SDO_RTREE_HEIGHT, SDO_RTREE_NUM_NODES,
        SDO_RTREE_DIMENSIONALITY, SDO_RTREE_FANOUT,
        SDO_RTREE_ROOT, SDO_RTREE_SEQ_NAME,
        SDO_RTREE_PCTFREE, SDO_LAYER_GTYPE,
        SDO_LEVEL, SDO_NUMTILES, SDO_MAXLEVEL, SDO_COMMIT_INTERVAL,
        SDO_FIXED_META, SDO_TABLESPACE, SDO_INITIAL_EXTENT,
        SDO_NEXT_EXTENT, SDO_PCTINCREASE, SDO_MIN_EXTENTS,
        SDO_MAX_EXTENTS, SDO_RTREE_QUALITY, SDO_INDEX_VERSION,  
        SDO_INDEX_GEODETIC, SDO_INDEX_STATUS, SDO_ROOT_MBR
 from SDO_INDEX_METADATA_TABLE
 where
 (exists
   (select index_name from user_indexes, (select username from user_users)
    where index_name=sdo_index_name and
          username = sdo_index_owner));
create view all_sdo_index_metadata as
 select SDO_INDEX_OWNER, SDO_INDEX_TYPE,
        SDO_INDEX_NAME, SDO_INDEX_TABLE, SDO_INDEX_PRIMARY,
        SDO_INDEX_PARTITION, SDO_PARTITIONED,
        SDO_TSNAME, SDO_COLUMN_NAME,SDO_INDEX_DIMS, 
        SDO_RTREE_HEIGHT, SDO_RTREE_NUM_NODES,
        SDO_RTREE_DIMENSIONALITY, SDO_RTREE_FANOUT,
        SDO_RTREE_ROOT, SDO_RTREE_SEQ_NAME,
        SDO_RTREE_PCTFREE, SDO_LAYER_GTYPE,
        SDO_LEVEL, SDO_NUMTILES, SDO_MAXLEVEL, SDO_COMMIT_INTERVAL,
        SDO_FIXED_META, SDO_TABLESPACE, SDO_INITIAL_EXTENT,
        SDO_NEXT_EXTENT, SDO_PCTINCREASE, SDO_MIN_EXTENTS,
        SDO_MAX_EXTENTS, SDO_RTREE_QUALITY, SDO_INDEX_VERSION,
        SDO_INDEX_GEODETIC, SDO_INDEX_STATUS, SDO_ROOT_MBR
 from SDO_INDEX_METADATA_TABLE
 where
 (exists
   (select index_name from all_indexes
    where index_name=sdo_index_name and
          owner = sdo_index_owner));
create view dba_sdo_index_metadata as
 select SDO_INDEX_OWNER, SDO_INDEX_TYPE,
        SDO_INDEX_NAME, SDO_INDEX_TABLE, SDO_INDEX_PRIMARY,
        SDO_INDEX_PARTITION, SDO_PARTITIONED,
        SDO_TSNAME, SDO_COLUMN_NAME, SDO_INDEX_DIMS,
        SDO_RTREE_HEIGHT, SDO_RTREE_NUM_NODES,
        SDO_RTREE_DIMENSIONALITY, SDO_RTREE_FANOUT,
        SDO_RTREE_ROOT, SDO_RTREE_SEQ_NAME,
        SDO_RTREE_PCTFREE, SDO_LAYER_GTYPE,
        SDO_LEVEL, SDO_NUMTILES, SDO_MAXLEVEL, SDO_COMMIT_INTERVAL,
        SDO_FIXED_META, SDO_TABLESPACE, SDO_INITIAL_EXTENT,
        SDO_NEXT_EXTENT, SDO_PCTINCREASE, SDO_MIN_EXTENTS,
        SDO_MAX_EXTENTS, SDO_RTREE_QUALITY, SDO_INDEX_VERSION,
        SDO_INDEX_GEODETIC, SDO_INDEX_STATUS, SDO_ROOT_MBR
 from SDO_INDEX_METADATA_TABLE
 where
 (exists
   (select index_name from dba_indexes
    where index_name=sdo_index_name));
create index sdo_idx_mdata_idx on 
sdo_index_metadata_table(sdo_index_owner, sdo_index_name, sdo_index_partition);
grant select on user_sdo_index_metadata to public;
grant select on all_sdo_index_metadata to public;
grant select on dba_sdo_index_metadata to public;
drop public synonym sdo_index_metadata;
drop public synonym user_sdo_index_metadata;
drop public synonym all_sdo_index_metadata;
drop public synonym dba_sdo_index_metadata;
create public synonym sdo_index_metadata for mdsys.user_sdo_index_metadata;
create public synonym user_sdo_index_metadata for mdsys.user_sdo_index_metadata;
create public synonym dba_sdo_index_metadata for mdsys.dba_sdo_index_metadata;
create public synonym all_sdo_index_metadata for mdsys.all_sdo_index_metadata; 
commit;
drop view user_sdo_index_info;
create view user_sdo_index_info as
 select SDO_INDEX_NAME index_name,  table_name,
       ltrim(rtrim(sdo_column_name, '"'), '"')  column_name,
       SDO_INDEX_TYPE, SDO_INDEX_TABLE, SDO_INDEX_STATUS
 from user_sdo_index_metadata,
     user_indexes
 where index_name = sdo_index_name;
grant select on user_sdo_index_info to public;
create public synonym user_sdo_index_info for mdsys.user_sdo_index_info;
drop view dba_sdo_index_info;
create view dba_sdo_index_info as
 select SDO_INDEX_OWNER, SDO_INDEX_NAME index_name,  table_name,
       ltrim(rtrim(sdo_column_name, '"'), '"')  column_name,
       SDO_INDEX_TYPE, SDO_INDEX_TABLE, SDO_INDEX_STATUS
 from dba_sdo_index_metadata,
     dba_indexes
 where index_name = sdo_index_name;
grant select on dba_sdo_index_info to public;
create public synonym dba_sdo_index_info for mdsys.dba_sdo_index_info;
drop view all_sdo_index_info;
create view all_sdo_index_info as
 select SDO_INDEX_OWNER, SDO_INDEX_NAME index_name,  table_name,
       REPLACE(sdo_column_name, '"')  column_name,
       SDO_INDEX_TYPE, SDO_INDEX_TABLE, SDO_INDEX_STATUS
 from all_sdo_index_metadata,
     all_indexes
 where index_name = sdo_index_name and owner=sdo_index_owner;
grant select on all_sdo_index_info to public;
create public synonym all_sdo_index_info for mdsys.all_sdo_index_info;
