declare
begin
  begin
   execute immediate
    'DROP TYPE sdo_numtab';
   execute immediate
    ' DROP TYPE sdo_stattab ';
   execute immediate
    ' DROP TYPE sdo_stat ';
   exception when others then NULL;
  end;
end;
/
CREATE OR REPLACE TYPE sdo_numtab AS TABLE OF NUMBER;
/
show errors;
CREATE OR REPLACE TYPE sdo_stat wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
d
9200000
1
4
0 
7
2 :e:
1TYPE:
1SDO_STAT:
1OBJECT:
1NC:
1NUMBER:
1AREA:
1NN:
0

0
0
1c
2
0 a0 9d a0 60 a3 a0 1c
b0 81 a3 a0 1c b0 81 a3
a0 1c b0 81 77 a0 102 a0
c6 1d 17 b5 
1c
2
0 3 6f b f 2f 23 27
22 36 4b 3f 43 1f 52 63
57 5b 3e 6a 7 76 3b 7a
7e 80 81 8a 
1c
2
0 1 6 12 1 1a :2 1d :2 1a
25 :2 2a :2 25 32 :2 35 :2 32 1 :2 3c
:5 1 
1c
4
0 :1b 1 
8c
4
:3 0 1 :3 0 2
0 4 0 3
:3 0 9 :3 0 16
1 14 :9 0 5
3b 0 3 5
:3 0 6 :7 0 4
:6 0 8 7 0
4 0 15 :2 0
7 5 :3 0 b
:7 0 6 :6 0 d
c 0 4 0
5 :3 0 10 :7 0
7 :6 0 12 11
0 4 0 2
4 2 1 :3 0
2 :3 0 2 :2 0
2 17 14 0
19 18 1b :8 0

d
4
:3 0 1 5 1
a 1 f 3
9 e 13 
1
4
0 
1a
0
1
14
1
4
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
5 1 0
f 1 0
2 0 1
a 1 0
0

/
show errors;
CREATE OR REPLACE TYPE sdo_stattab AS TABLE OF sdo_stat;
/
show errors;
CREATE OR REPLACE PACKAGE sdo_pridx wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
9
9200000
1
4
0 
32
2 :e:
1PACKAGE:
1SDO_PRIDX:
1AUTHID:
1CURRENT_USER:
1FUNCTION:
1GEN_RID_RANGE_BY_AREA:
1TSNAME:
1VARCHAR2:
1TNAME:
1PTNAME:
1COLNAME:
1RGTAB:
1ARTAB:
1TBL_SPACE:
1FUNCIDX:
1NUMBER:
1EDOP:
1RETURN:
1GEN_RID_RANGE:
1TESSELLATE:
1RC:
1SYS_REFCURSOR:
1IA:
1SYS:
1ODCIINDEXINFO:
1IDXTAB:
1PARAMS:
1SDO_NUMTAB:
1PARALLEL_ENABLE:
1PARTITION:
1PIPELINED:
1MDPRTESSELLATE:
1RID1:
1RID2:
1INDEXLOAD:
1TTAB:
1MDPRTXFERGM:
1RTCLUSTER:
1IDX_TAB:
1LVL:
1OIDSTR:
1SDO_STATTAB:
1MDPRCLUSTER:
1TBL:
1NUM:
1PTBL:
1NC:
1OUT:
1AREA:
1NN:
0

0
0
126
2
0 a0 97 :3 a0 8d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d b4 :2 a0 2c 6a a0 8d 8f
a0 b0 3d 8f a0 b0 3d 8f
a0 b0 3d 8f a0 b0 3d b4
:2 a0 2c 6a a0 8d 8f a0 b0
3d 8f :2 a0 6b b0 3d 8f a0
b0 3d 8f a0 b0 3d b4 :5 a0
126 12b a0 12b 2c 6a a0 8d
8f :2 a0 6b b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d b4 :2 a0 2c
6a a0 8d 8f a0 b0 3d 8f
:2 a0 6b b0 3d 8f a0 b0 3d
8f a0 b0 3d b4 :5 a0 126 12b
a0 12b 2c 6a a0 8d 8f :2 a0
6b b0 3d 8f a0 b0 3d 8f
a0 b0 3d 8f a0 b0 3d 8f
a0 b0 3d b4 :2 a0 2c 6a a0
8d 8f a0 b0 3d 8f :2 a0 6b
b0 3d 8f a0 b0 3d 8f a0
b0 3d 8f a0 b0 3d 8f a0
b0 3d b4 :5 a0 126 12b a0 12b
2c 6a 9a 8f :2 a0 6b b0 3d
8f a0 b0 3d 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
8f a0 b0 3d 96 :2 a0 b0 54
96 :2 a0 b0 54 96 :2 a0 b0 54
b4 55 6a a0 :2 aa 59 58 1d
17 b5 
126
2
0 3 13 b f 7 1d 39
35 34 41 4e 4a 31 56 5f
5b 49 67 74 70 46 7c 85
81 6f 8d 9a 96 6c a2 ab
a7 95 b3 c0 bc 92 c8 d1
cd bb d9 b8 de e2 e6 ea
ee f2 10e 10a 109 116 123 11f
106 12b 134 130 11e 13c 149 145
11b 151 144 156 15a 15e 162 166
16a 186 182 141 18e 19e 193 197
19b 181 1a6 1b3 1af 17e 1bb 1c4
1c0 1ae 1cc 1ab 1d1 1d5 1d9 1dd
1e1 1e5 1e9 1ee 1f2 1f7 1fb 1ff
203 226 21b 21f 223 21a 22e 23b
237 217 243 24c 248 236 254 261
25d 233 269 272 26e 25c 27a 259
27f 283 287 28b 28f 293 2af 2ab
2aa 2b7 2c8 2c0 2c4 2a7 2bf 2d0
2dd 2d9 2bc 2e5 2ee 2ea 2d8 2f6
2d5 2fb 2ff 303 307 30b 30f 313
318 31c 321 325 329 32d 350 345
349 34d 344 358 365 361 341 36d
376 372 360 37e 38b 387 35d 393
39c 398 386 3a4 383 3a9 3ad 3b1
3b5 3b9 3bd 3d9 3d5 3d4 3e1 3f2
3ea 3ee 3d1 3e9 3fa 407 403 3e6
40f 418 414 402 420 42d 429 3ff
435 43e 43a 428 446 425 44b 44f
453 457 45b 45f 463 468 46c 471
475 479 49c 491 495 499 490 4a4
4b1 4ad 48d 4b9 4c2 4be 4ac 4ca
4d7 4d3 4a9 4df 4e8 4e4 4d2 4f0
4fd 4f9 4cf 505 50e 50a 4f8 516
523 51f 4f5 52b 538 530 534 51e
53f 550 548 54c 51b 557 564 55c
560 547 56b 544 570 574 578 57c
57e 580 583 586 587 590 
126
2
0 1 9 13 1a 3 c 22
29 :2 22 33 39 :2 33 22 29 :2 22
33 3b :2 33 22 28 :2 22 32 38
:2 32 22 2c :3 22 2a :2 22 32 37
:2 32 21 5 c :3 3 c 1a 21
:2 1a 2b 31 :2 2b 1a 20 :2 1a 2a
2f :2 2a 19 5 c :3 3 c 17
1a :2 17 29 2c 30 2c :2 29 17
1e :2 17 28 2f :2 28 16 5 c
5 16 20 16 :3 5 :3 3 c 1b
1e 22 1e :2 1b 31 38 :2 31 1b
22 :2 1b 2c 31 :2 2c 3b 40 :2 3b
1a 5 c :3 3 c 16 19 :2 16
28 2b 2f 2b :2 28 16 1b :2 16
25 2c :2 25 15 5 c 5 16
20 16 :3 5 :3 3 c 18 1b 1f
1b :2 18 2e 33 :2 2e 18 1f :2 18
29 2e :2 29 38 3d :2 38 17 5
c :3 3 c 16 19 :2 16 28 2b
2f 2b :2 28 16 1e :2 16 28 2f
:2 28 39 3d :2 39 16 1d :2 16 15
5 c 5 16 20 16 :3 5 :2 3
d 19 1c 20 1c :2 19 2f 37
:2 2f 19 20 :2 19 2a 2e :2 2a 36
3a :2 36 19 1e :2 19 26 2a :2 26
32 39 :2 32 19 1c 20 :2 19 28
2d 31 :2 28 39 3c 40 :2 39 18
:2 3 5 :7 1 
126
4
0 :4 1 :a 3 :8 4
:8 5 :4 6 :8 7 3
:2 8 :2 3 :a 9 :8 a
9 :2 b :2 9 :c d
:8 e d :2 f :5 10
:2 11 :2 d :c 13 :c 14
13 :2 15 :2 13 :c 17
:8 18 17 :2 19 :5 1a
:2 1b :2 17 :c 1d :c 1e
1d :2 1f :2 1d :c 21
:c 22 :4 23 21 :2 24
:5 25 :2 26 :2 21 :b 28
:c 29 :c 2a :f 2b :3 28
2c :7 1 
592
4
:3 0 1 :3 0 5
:3 0 3 :3 0 4
:3 0 2 :6 0 1
:2 0 6 :a 0 2f
2 :7 0 5 46
0 3 8 :3 0
7 :7 0 9 8
:3 0 9 6c 0
7 8 :3 0 9
:7 0 d c :3 0
8 :3 0 a :7 0
11 10 :3 0 d
92 0 b 8
:3 0 b :7 0 15
14 :3 0 8 :3 0
c :7 0 19 18
:3 0 11 b8 0
f 8 :3 0 d
:7 0 1d 1c :3 0
8 :3 0 e :7 0
21 20 :3 0 15
:2 0 13 10 :3 0
f :7 0 25 24
:3 0 10 :3 0 11
:7 0 29 28 :3 0
12 :3 0 10 :3 0
2b 2d 0 2f
6 2e 0 11f
5 :3 0 13 :a 0
46 3 :7 0 21
11b 0 1f 8
:3 0 7 :7 0 34
33 :3 0 25 141
0 23 8 :3 0
9 :7 0 38 37
:3 0 8 :3 0 c
:7 0 3c 3b :3 0
2c 17e 0 27
10 :3 0 11 :7 0
40 3f :3 0 12
:3 0 10 :3 0 42
44 0 46 31
45 0 11f 5
:3 0 14 :a 0 66
4 1504 :3 0 64
:2 0 30 1ab 0
2e 16 :3 0 15
:7 0 4b 4a :3 0
18 :3 0 19 :2 0
4 4e 4f 0
17 :7 0 51 50
:3 0 34 :2 0 32
8 :3 0 1a :7 0
55 54 :3 0 8
:3 0 1b :7 0 59
58 :3 0 12 :3 0
1c :3 0 1d :3 0
1e :3 0 15 :3 0
1004 60 0 62
1104 61 :3 0 1f
:3 0 1504 61 :3 0
5b 5d 0 66
48 65 0 11f
5 :3 0 20 :a 0
83 5 :7 0 3b
233 0 39 18
:3 0 19 :2 0 4
6a 6b 0 17
:7 0 6d 6c :3 0
3f 259 0 3d
8 :3 0 1a :7 0
71 70 :3 0 8
:3 0 1b :7 0 75
74 :3 0 43 :2 0
41 8 :3 0 21
:7 0 79 78 :3 0
8 :3 0 22 :7 0
7d 7c :3 0 12
:3 0 10 :3 0 7f
81 0 83 68
82 0 11f 5
:3 0 23 :a 0 a3
6 1504 :3 0 a1
:2 0 8b 8c 0
49 16 :3 0 15
:7 0 88 87 :3 0
4d 2d5 0 4b
18 :3 0 19 :2 0
4 17 :7 0 8e
8d :3 0 51 :2 0
4f 8 :3 0 24
:7 0 92 91 :3 0
8 :3 0 1b :7 0
96 95 :3 0 12
:3 0 1c :3 0 1d
:3 0 1e :3 0 15
:3 0 1004 9d 0
9f 1104 9e :3 0
1f :3 0 1504 9e
:3 0 98 9a 0
a3 85 a2 0
11f 5 :3 0 25
:a 0 c0 7 :7 0
58 35d 0 56
18 :3 0 19 :2 0
4 a7 a8 0
17 :7 0 aa a9
:3 0 5c 383 0
5a 8 :3 0 24
:7 0 ae ad :3 0
8 :3 0 1b :7 0
b2 b1 :3 0 60
:2 0 5e 8 :3 0
21 :7 0 b6 b5
:3 0 8 :3 0 22
:7 0 ba b9 :3 0
12 :3 0 10 :3 0
bc be 0 c0
a5 bf 0 11f
5 :3 0 26 :a 0
e8 8 1504 :3 0
e6 :2 0 c8 c9
0 66 16 :3 0
15 :7 0 c5 c4
:3 0 6a 3ff 0
68 18 :3 0 19
:2 0 4 17 :7 0
cb ca :3 0 6e
425 0 6c 8
:3 0 27 :7 0 cf
ce :3 0 8 :3 0
1b :7 0 d3 d2
:3 0 72 :2 0 70
10 :3 0 28 :7 0
d7 d6 :3 0 8
:3 0 29 :7 0 db
da :3 0 12 :3 0
2a :3 0 1d :3 0
1e :3 0 15 :3 0
1004 e2 0 e4
1104 e3 :3 0 1f
:3 0 1504 e3 :3 0
dd df 0 e8
c2 e7 0 11f
2b :a 0 11d 9
:7 0 7b 4a9 0
79 18 :3 0 19
:2 0 4 eb ec
0 17 :7 0 ee
ed :3 0 7f 4cf
0 7d 8 :3 0
27 :7 0 f2 f1
:3 0 8 :3 0 1b
:7 0 f6 f5 :3 0
83 4f5 0 81
10 :3 0 2c :7 0
fa f9 :3 0 10
:3 0 2d :7 0 fe
fd :3 0 87 51b
0 85 10 :3 0
2e :7 0 102 101
:3 0 10 :3 0 28
:7 0 106 105 :3 0
8b 544 0 89
8 :3 0 29 :7 0
10a 109 :3 0 30
:3 0 10 :3 0 2f
:6 0 10f 10e :3 0
8f :2 0 8d 30
:3 0 10 :3 0 31
:6 0 114 113 :3 0
30 :3 0 10 :3 0
32 :6 0 119 118
:3 0 11b :2 0 11d
e9 11c 0 11f
2 :3 0 9b 121
0 121 11f 120
122 2 121 124
0 123 122 125
:4 0 4 :3 0 
a4
4
:3 0 1 7 1
b 1 f 1
13 1 17 1
1b 1 1f 1
23 1 27 9
a e 12 16
1a 1e 22 26
2a 1 32 1
36 1 3a 1
3e 4 35 39
3d 41 1 49
1 4d 1 53
1 57 4 4c
52 56 5a 1
69 1 6f 1
73 1 77 1
7b 5 6e 72
76 7a 7e 1
86 1 8a 1
90 1 94 4
89 8f 93 97
1 a6 1 ac
1 b0 1 b4
1 b8 5 ab
af b3 b7 bb
1 c3 1 c7
1 cd 1 d1
1 d5 1 d9
6 c6 cc d0
d4 d8 dc 1
ea 1 f0 1
f4 1 f8 1
fc 1 100 1
104 1 108 1
10c 1 111 1
116 b ef f3
f7 fb ff 103
107 10b 110 115
11a 8 2f 46
66 83 a3 c0
e8 11d 
1
4
0 
124
0
1
14
9
39
0 1 1 1 1 1 1 1
1 0 0 0 0 0 0 0
0 0 0 0 
23 2 0
2 0 1
ac 7 0
90 6 0
ea 9 0
c7 8 0
a6 7 0
8a 6 0
69 5 0
4d 4 0
f 2 0
3a 3 0
17 2 0
108 9 0
d9 8 0
10c 9 0
32 3 0
7 2 0
31 1 3
1b 2 0
c3 8 0
86 6 0
49 4 0
b4 7 0
77 5 0
116 9 0
b8 7 0
7b 5 0
48 1 4
13 2 0
e9 1 9
f8 9 0
c2 1 8
f0 9 0
cd 8 0
111 9 0
36 3 0
b 2 0
a5 1 7
104 9 0
d5 8 0
f4 9 0
d1 8 0
b0 7 0
94 6 0
73 5 0
57 4 0
68 1 5
fc 9 0
6f 5 0
53 4 0
3e 3 0
27 2 0
85 1 6
100 9 0
1f 2 0
6 1 2
0

/
show errors;
CREATE OR REPLACE  PUBLIC SYNONYM sdo_pridx FOR mdsys.sdo_pridx
/
CREATE OR REPLACE  LIBRARY ordmd_pridx_libs wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
16
9200000
1
4
0 
4
2 :e:
1LIBRARY:
1ORDMD_PRIDX_LIBS:
1TRUSTED:
1STATIC:
0

0
0
9
2
0 a0 109 :2 a0 ff 1d 17 b5 
9
2
0 3 7 b f 13 17 18
21 
9
2
0 1 9 1a 25 :4 1 
9
4
0 :8 1 
23
4
:3 0 1 :3 0 2
:3 0 3 :3 0 4
:3 0 2 0 3
:2 0 6 5 8
:8 0 
3
4
:3 0 
1
4
0 
7
0
1
14
0
0
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
0

/
GRANT EXECUTE ON ordmd_pridx_libs TO PUBLIC;
CREATE OR REPLACE PACKAGE BODY sdo_pridx wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
b
9200000
1
4
0 
d4
2 :e:
1PACKAGE:
1BODY:
1SDO_PRIDX:
1FUNCTION:
1GEN_RID_RANGE_BY_AREA:
1TSNAME:
1VARCHAR2:
1TNAME:
1PTNAME:
1COLNAME:
1RGTAB:
1ARTAB:
1TBL_SPACE:
1FUNCIDX:
1NUMBER:
1EDOP:
1RETURN:
1PRAGMA:
1AUTONOMOUS_TRANSACTION:
1TYPE:
1VSRECTYPE:
1RECORD:
1RID:
1ROWID:
1AREA:
1VSCURTYPE:
1REF:
1CURSOR:
1VREC:
1VCUR:
1STMT:
1500:
1HINT:
150:
1INST:
1100:
1LAYER:
1256:
1TSUM:
1VSUM:
1DSUM:
1RID1:
1MRID:
1NROW:
10:
1NPRT:
1IFLG:
1ROWID_TYPE:
1OBJECT_NUMBER:
1RELATIVE_FNO:
1BLOCK_NUMBER:
1ROW_NUMBER:
1DOP:
1NEW_COLNAME:
11024:
1CUR_STMT:
14096:
1TMP_VAR:
1PTAB_LEN:
1IS NOT NULL:
1INSTR:
1NLS_UPPER:
1 PARTITION(:
1>:
11:
1SUBSTR:
1-:
1DBMS_ASSERT:
1SIMPLE_SQL_NAME:
1(:
1+:
1LENGTH:
1SCHEMA_NAME:
1||:
1.:
1NOOP:
1colname, funcidx :
1,:
1TO_CHAR:
1=:
1QUALIFIED_SQL_NAME:
1PRVT_IDX:
1ASSERT_FNCOL:
1!=:
1DEFAULT:
1/*+ parallel(a:
1ODCICONST:
1DEFAULTDEGREE:
1) */:
164:
1create table :
1(rid, area) nologging :
1 tablespace :
1 as select :
1 a.rowid, sdo_geom.sdo_area(:
1a.:
1, m.diminfo) from :
1 a, all_sdo_geom_metadata m:
1 where m.owner=':
1' and m.table_name=':
1' and m.column_name=':
1':
1EXECUTE:
1IMMEDIATE:
1select :
1 count(*), sum(a.area) from :
1 a:
1IS NULL:
1drop table :
1GEN_RID_RANGE:
1 max(a.rid) from :
1DBMS_ROWID:
1ROWID_INFO:
1ROWID_CREATE:
1/:
1insert into :
1 values (::1, ::2):
1 a.rid, a.area from :
1 a order by a.rid:
1OPEN:
1LOOP:
1EXIT:
1NOTFOUND:
1USING:
1ELSIF:
1<:
1OTHERS:
1MDERR:
1RAISE_MD_ERROR:
1MD:
1 :
113390:
1Incorrect arg:: :
1RAISE:
1RIDTAB:
118:
1BINARY_INTEGER:
1RNKTAB:
1RIDT:
1RIDT2:
1RNKT:
15000:
1STR0:
1ROWS:
1CNPB:
1INTEGER:
1CROW:
1 count(*) from :
1FLOOR:
1rank in (:
1I:
12:
1):
1select rid, rank from (select :
1 a.rowid rid, rank() over (order by a.rowid) rank from :
1 a) where :
1 order by rank:
1BULK:
1COLLECT:
1COUNT:
1EXTEND:
1LAST:
1COMMIT:
1WORK:
1TESSELLATE:
1RC:
1SYS_REFCURSOR:
1IA:
1SYS:
1ODCIINDEXINFO:
1IDXTAB:
1PARAMS:
1SDO_NUMTAB:
1PARALLEL_ENABLE:
1PARTITION:
1PIPELINED:
1RID2:
1CNT:
1MDPRTESSELLATE:
1PIPE:
1ROW:
1CLOSE:
1LANGUAGE:
1C:
1NAME:
1mdprtessellate:
1LIBRARY:
1ORDMD_PRIDX_LIBS:
1CONTEXT:
1PARAMETERS:
1INDICATOR:
1STRUCT:
1OCISTRING:
1OCINUMBER:
1INDEXLOAD:
1TTAB:
1MDPRTXFERGM:
1mdprtxfergm:
1RTCLUSTER:
1IDX_TAB:
1LVL:
1OIDSTR:
1SDO_STATTAB:
1TBL:
1NUM:
1PTBL:
1NC:
1NN:
1MDPRCLUSTER:
1SDO_STAT:
1OUT:
1mdprcluster:
0

0
0
92b
2
0 :2 a0 97 a0 8d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d b4 :2 a0 2c 6a :2 a0 b4 5d
a0 9d a0 a3 a0 1c b0 81
a3 a0 1c b0 81 60 77 a0
9d :2 a0 c8 77 a3 a0 1c 81
b0 a3 a0 1c 81 b0 a3 a0
51 a5 1c 81 b0 a3 a0 51
a5 1c 81 b0 a3 a0 51 a5
1c 81 b0 a3 a0 51 a5 1c
81 b0 a3 a0 1c 81 b0 a3
a0 1c 81 b0 a3 a0 1c 81
b0 a3 a0 1c 81 b0 a3 a0
1c 81 b0 a3 a0 1c 51 81
b0 a3 a0 1c 51 81 b0 a3
a0 1c 51 81 b0 a3 a0 1c
81 b0 a3 a0 1c 81 b0 a3
a0 1c 81 b0 a3 a0 1c 81
b0 a3 a0 1c 81 b0 a3 a0
1c a0 81 b0 a3 a0 51 a5
1c 81 b0 a3 a0 51 a5 1c
81 b0 a3 a0 51 a5 1c 81
b0 a3 a0 1c 81 b0 a0 7e
b4 2e 5a :4 a0 a5 b 6e a5
b d a0 7e 51 b4 2e 5a
:3 a0 51 a0 7e 51 b4 2e a5
b d :3 a0 6b a0 a5 b d
:4 a0 a5 b 6e a5 b 7e 51
b4 2e d :6 a0 a5 b 7e a0
b4 2e a5 b d :3 a0 6b a0
a5 b d b7 :3 a0 6b a0 a5
b d b7 :2 19 3c b7 19 3c
:3 a0 6b a0 a5 b 7e 6e b4
2e 7e :2 a0 6b a0 a5 b b4
2e d :2 a0 d :3 a0 6b a0 a5
b d :2 a0 d :3 a0 6b a0 a5
b d :2 a0 d :3 a0 6b a0 a5
b d a0 6e 7e a0 b4 2e
7e 6e b4 2e 7e :2 a0 a5 b
b4 2e d a0 7e 51 b4 2e
5a :3 a0 6b a0 a5 b d b7
:3 a0 6b a0 a5 b d b7 :2 19
3c a0 7e 6e b4 2e 5a :3 a0
6b a0 a5 b d b7 19 3c
a0 6e d :2 a0 7e a0 6b b4
2e :2 a0 7e 6e b4 2e d a0
51 d b7 :2 a0 7e 6e b4 2e
7e a0 b4 2e 7e 6e b4 2e
d b7 :2 19 3c a0 6e 7e :2 a0
6b a0 a5 b b4 2e 7e 6e
b4 2e d a0 7e 6e b4 2e
5a :2 a0 7e 6e b4 2e 7e :2 a0
6b a0 a5 b b4 2e d b7
19 3c :2 a0 7e 6e b4 2e 7e
a0 b4 2e 7e 6e b4 2e d
a0 7e 51 b4 2e :2 a0 7e 6e
b4 2e 7e :2 a0 6b a0 a5 b
b4 2e d b7 :2 a0 7e :2 a0 6b
a0 a5 b b4 2e d b7 :2 19
3c :2 a0 7e 6e b4 2e 7e :2 a0
6b a0 a5 b b4 2e 7e 6e
b4 2e 7e 6e b4 2e 7e :2 a0
6b a0 a5 b b4 2e 7e 6e
b4 2e 7e :2 a0 6b a0 a5 b
b4 2e 7e 6e b4 2e 7e :2 a0
6b a0 a5 b b4 2e 7e 6e
b4 2e d :3 a0 11e 11d a0 6e
7e a0 b4 2e 7e 6e b4 2e
7e :2 a0 6b a0 a5 b b4 2e
7e 6e b4 2e d :5 a0 11e 5
11d a0 7e 51 b4 2e a0 7e
b4 2e 52 10 a0 6e 7e :2 a0
6b a0 a5 b b4 2e d :3 a0
11e 11d a0 51 65 b7 19 3c
a0 7e 51 b4 2e a0 6e 7e
:2 a0 6b a0 a5 b b4 2e d
:3 a0 11e 11d :6 a0 a5 b 65 b7
19 3c a0 6e 7e a0 b4 2e
7e 6e b4 2e 7e :2 a0 6b a0
a5 b b4 2e 7e 6e b4 2e
d :4 a0 11e 11d :2 a0 6b :6 a0 a5
57 :2 a0 7e 51 b4 2e d :3 a0
6b :5 a0 a5 b d :2 a0 7e a0
b4 2e d a0 51 d a0 6e
7e :2 a0 6b a0 a5 b b4 2e
7e 6e b4 2e d a0 6e 7e
a0 b4 2e 7e 6e b4 2e 7e
:2 a0 6b a0 a5 b b4 2e 7e
6e b4 2e d :3 a0 11c 11d :3 a0
e9 d3 :3 a0 f 2b a0 7e 51
b4 2e a0 7e 51 b4 2e :5 a0
112 :2 a0 6b 112 11e 11a 11d :2 a0
7e 51 b4 2e d :2 a0 7e a0
b4 2e d :2 a0 7e a0 7e a0
b4 2e 5a b4 2e d a0 51
d b7 19 3c :3 a0 6b d :3 a0
6b d :2 a0 7e 51 b4 2e d
a0 b7 a0 7e :2 a0 6b b4 2e
a0 7e b4 2e :2 a0 7e :2 a0 6b
b4 2e d :2 a0 7e 51 b4 2e
d a0 b7 19 a0 7e :2 a0 6b
b4 2e a0 7e b4 2e a0 51
d a0 51 d b7 19 :5 a0 112
:2 a0 6b 112 11e 11a 11d :2 a0 7e
51 b4 2e d :2 a0 7e a0 b4
2e d :2 a0 7e a0 7e a0 b4
2e 5a b4 2e d :3 a0 6b d
:3 a0 6b d a0 51 d b7 :2 19
3c :2 a0 :2 7e 51 b4 2e b4 2e
:5 a0 112 a0 112 11e 11a 11d a0
2b b7 19 3c b7 a0 47 a0
6e 7e :2 a0 6b a0 a5 b b4
2e d :3 a0 11e 11d :2 a0 65 b7
a0 53 :2 a0 6b :2 6e 7e 51 b4
2e 6e 7e a0 b4 2e a5 57
a0 62 b7 a6 9 a4 b1 11
68 4f a0 8d 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
8f a0 b0 3d b4 :2 a0 2c 6a
:2 a0 b4 5d a0 9d a0 51 a5
1c a0 40 a8 c 77 a0 9d
a0 1c a0 40 a8 c 77 a3
a0 1c 81 b0 a3 a0 1c 81
b0 a3 a0 1c 81 b0 a3 a0
51 a5 1c 81 b0 a3 a0 51
a5 1c 81 b0 a3 a0 51 a5
1c 81 b0 a3 a0 51 a5 1c
81 b0 a3 a0 1c 81 b0 a3
a0 1c 81 b0 a3 a0 1c 81
b0 a3 a0 1c 81 b0 a3 a0
1c 81 b0 a3 a0 1c 81 b0
a3 a0 1c 81 b0 a3 a0 1c
81 b0 a3 a0 1c 81 b0 a3
a0 1c a0 81 b0 a3 a0 51
a5 1c 81 b0 a3 a0 51 a5
1c 81 b0 a3 a0 1c 81 b0
a0 7e b4 2e 5a :4 a0 a5 b
6e a5 b d a0 7e 51 b4
2e 5a :3 a0 51 a0 7e 51 b4
2e a5 b d :3 a0 6b a0 a5
b d :4 a0 a5 b 6e a5 b
7e 51 b4 2e d :6 a0 a5 b
7e a0 b4 2e a5 b d :3 a0
6b a0 a5 b d b7 :3 a0 6b
a0 a5 b d b7 :2 19 3c b7
19 3c a0 6e d :2 a0 7e a0
6b b4 2e :2 a0 7e 6e b4 2e
d a0 51 d b7 :2 a0 7e 6e
b4 2e 7e a0 b4 2e 7e 6e
b4 2e d b7 :2 19 3c :3 a0 6b
a0 a5 b 7e 6e b4 2e 7e
:2 a0 6b a0 a5 b b4 2e d
a0 6e 7e a0 b4 2e 7e 6e
b4 2e 7e :2 a0 6b a0 a5 b
b4 2e 7e 6e b4 2e d :4 a0
11e 11d a0 7e 51 b4 2e a0
51 65 b7 19 3c :2 a0 7e b4
2e :2 a0 d b7 19 3c :3 a0 7e
a0 b4 2e a5 b d a0 51
d a0 6e 7e a0 b4 2e d
91 51 :2 a0 63 37 :2 a0 7e a0
b4 2e d :2 a0 7e 6e b4 2e
7e a0 b4 2e d b7 a0 47
:2 a0 7e 6e b4 2e 7e a0 b4
2e 7e 6e b4 2e d a0 6e
7e a0 b4 2e 7e 6e b4 2e
7e :2 a0 6b a0 a5 b b4 2e
7e 6e b4 2e 7e :2 a0 6b a0
a5 b b4 2e 7e 6e b4 2e
d :7 a0 11e 5 11d :2 a0 6b a0
7e b4 2e 5a :2 a0 6b 51 a5
57 :3 a0 6b a5 b :3 a0 6b 7e
51 b4 2e a5 b d b7 19
3c :4 a0 6b a5 b d :2 a0 6b
:6 a0 a5 57 :2 a0 7e 51 b4 2e
d :3 a0 6b :5 a0 a5 b d :3 a0
6b a5 b a0 d a0 6e 7e
:2 a0 6b a0 a5 b b4 2e 7e
6e b4 2e d :2 a0 b4 2e d
:2 a0 6b a0 a5 57 91 51 :2 a0
63 37 :2 a0 a5 b :2 a0 7e 51
b4 2e a5 b d b7 a0 47
91 51 :2 a0 63 37 :6 a0 a5 b
112 :2 a0 a5 b 112 11e 11a 11d
b7 a0 47 :2 a0 57 a0 b4 e9
:2 a0 65 b7 a4 b1 11 68 4f
a0 8d 8f a0 b0 3d 8f :2 a0
6b b0 3d 8f a0 b0 3d 8f
a0 b0 3d b4 :5 a0 126 12b a0
12b 2c 6a :2 a0 b4 5d a3 a0
1c 81 b0 a3 a0 1c 81 b0
a3 a0 1c 81 b0 :4 a0 e9 d3
5 :3 a0 f 2b :7 a0 a5 b d
a0 57 a0 b4 e9 :3 a0 129 b7
a0 47 :2 a0 e9 c1 a0 57 a0
b4 e9 a0 65 b7 a4 b1 11
68 4f a0 8d 8f :2 a0 6b b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d b4 :2 a0 2c 6a :2 a0 fe :2 a0
6e :5 a0 104 :2 105 :2 a0 105 a0 105
a0 105 a0 105 a0 105 a0 105
a0 105 a0 105 :3 a0 107 :2 a0 107
10a 68 a0 8d 8f a0 b0 3d
8f :2 a0 6b b0 3d 8f a0 b0
3d 8f a0 b0 3d b4 :5 a0 126
12b a0 12b 2c 6a :2 a0 b4 5d
a3 a0 1c 81 b0 a3 a0 1c
81 b0 a3 a0 1c 81 b0 :4 a0
e9 d3 5 :3 a0 f 2b :7 a0 a5
b d a0 57 a0 b4 e9 :3 a0
129 b7 a0 47 :2 a0 e9 c1 a0
57 a0 b4 e9 a0 65 b7 a4
b1 11 68 4f a0 8d 8f :2 a0
6b b0 3d 8f a0 b0 3d 8f
a0 b0 3d 8f a0 b0 3d 8f
a0 b0 3d b4 :2 a0 2c 6a :2 a0
fe :2 a0 6e :5 a0 104 :2 105 :2 a0 105
a0 105 a0 105 a0 105 a0 105
a0 105 a0 105 a0 105 :3 a0 107
:2 a0 107 10a 68 a0 8d 8f a0
b0 3d 8f :2 a0 6b b0 3d 8f
a0 b0 3d 8f a0 b0 3d 8f
a0 b0 3d 8f a0 b0 3d b4
:5 a0 126 12b a0 12b 2c 6a :2 a0
b4 5d a3 a0 1c 81 b0 a3
a0 1c 81 b0 a3 a0 1c 81
b0 a3 a0 1c 81 b0 a3 a0
1c 81 b0 a3 a0 1c 81 b0
:5 a0 e9 d3 5 :3 a0 f 2b :c a0
a5 57 a0 57 a0 b4 e9 :6 a0
a5 b 129 b7 a0 47 :2 a0 e9
c1 a0 57 a0 b4 e9 a0 65
b7 a4 b1 11 68 4f 9a 8f
:2 a0 6b b0 3d 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
96 :2 a0 b0 54 96 :2 a0 b0 54
96 :2 a0 b0 54 b4 55 6a :2 a0
fe :2 a0 6e :5 a0 104 :2 105 :2 a0 105
a0 105 a0 105 a0 105 a0 105
a0 105 a0 105 a0 105 a0 105
a0 105 a0 105 a0 105 a0 105
a0 105 a0 105 a0 105 a0 105
a0 105 a0 105 a0 105 a0 10a
68 b1 b7 a4 11 b1 56 4f
1d 17 b5 
92b
2
0 3 7 b 15 19 35 31
30 3d 4a 46 2d 52 5b 57
45 63 70 6c 42 78 81 7d
6b 89 96 92 68 9e a7 a3
91 af bc b8 8e c4 cd c9
b7 d5 b4 da de e2 e6 ea
ee f2 f3 f6 14a fe 112 106
10a 105 119 12e 122 126 102 135
13a 11e fa 161 155 159 15d 151
17d 16c 170 178 16b 199 188 18c
194 168 1b5 1a0 1a4 1a7 1a8 1b0
187 1d2 1c0 184 1c4 1c5 1cd 1bf
1ef 1dd 1bc 1e1 1e2 1ea 1dc 20c
1fa 1d9 1fe 1ff 207 1f9 228 217
21b 223 1f6 240 22f 233 23b 216
25c 24b 24f 257 213 274 263 267
26f 24a 290 27f 283 28b 247 2ab
297 29b 2a3 2a6 27e 2c7 2b6 2ba
27b 2c2 2b5 2e3 2d2 2d6 2b2 2de
2d1 2ff 2ee 2f2 2fa 2ce 317 306
30a 312 2ed 333 322 326 32e 2ea
34b 33a 33e 346 321 367 356 35a
362 31e 383 36e 372 37a 37e 355
3a0 38e 352 392 393 39b 38d 3bd
3ab 38a 3af 3b0 3b8 3aa 3da 3c8
3a7 3cc 3cd 3d5 3c7 3f6 3e5 3e9
3f1 3c4 3e1 3fd 400 401 406 409
40d 411 415 419 41a 41c 421 422
424 428 42c 42f 432 433 438 43b
43f 443 447 44a 44e 451 454 455
45a 45b 45d 461 465 469 46d 470
474 475 477 47b 47f 483 487 48b
48c 48e 493 494 496 499 49c 49d
4a2 4a6 4aa 4ae 4b2 4b6 4ba 4be
4bf 4c1 4c4 4c8 4c9 4ce 4cf 4d1
4d5 4d9 4dd 4e1 4e4 4e8 4e9 4eb
4ef 4f1 4f5 4f9 4fd 500 504 505
507 50b 50d 511 515 518 51a 51e
521 525 529 52d 530 534 535 537
53a 53f 540 545 548 54c 550 553
557 558 55a 55b 560 564 568 56c
570 574 578 57c 57f 583 584 586
58a 58e 592 596 59a 59e 5a2 5a5
5a9 5aa 5ac 5b0 5b4 5b8 5bc 5c0
5c4 5c8 5cb 5cf 5d0 5d2 5d6 5da
5df 5e2 5e6 5e7 5ec 5ef 5f4 5f5
5fa 5fd 601 605 606 608 609 60e
612 616 619 61c 61d 622 625 629
62d 631 634 638 639 63b 63f 641
645 649 64d 650 654 655 657 65b
65d 661 665 668 66c 66f 674 675
67a 67d 681 685 689 68c 690 691
693 697 699 69d 6a0 6a4 6a9 6ad
6b1 6b5 6b8 6bc 6bf 6c0 6c5 6c9
6cd 6d0 6d5 6d6 6db 6df 6e3 6e6
6ea 6ec 6f0 6f4 6f7 6fc 6fd 702
705 709 70a 70f 712 717 718 71d
721 723 727 72b 72e 732 737 73a
73e 742 745 749 74a 74c 74d 752
755 75a 75b 760 764 768 76b 770
771 776 779 77d 781 784 789 78a
78f 792 796 79a 79d 7a1 7a2 7a4
7a5 7aa 7ae 7b0 7b4 7b7 7bb 7bf
7c2 7c7 7c8 7cd 7d0 7d4 7d5 7da
7dd 7e2 7e3 7e8 7ec 7f0 7f3 7f6
7f7 7fc 800 804 807 80c 80d 812
815 819 81d 820 824 825 827 828
82d 831 833 837 83b 83e 842 846
849 84d 84e 850 851 856 85a 85c
860 864 867 86b 86f 872 877 878
87d 880 884 888 88b 88f 890 892
893 898 89b 8a0 8a1 8a6 8a9 8ae
8af 8b4 8b7 8bb 8bf 8c2 8c6 8c7
8c9 8ca 8cf 8d2 8d7 8d8 8dd 8e0
8e4 8e8 8eb 8ef 8f0 8f2 8f3 8f8
8fb 900 901 906 909 90d 911 914
918 919 91b 91c 921 924 929 92a
92f 933 937 93b 93f 944 948 94c
951 954 958 959 95e 961 966 967
96c 96f 973 977 97a 97e 97f 981
982 987 98a 98f 990 995 999 99d
9a1 9a5 9a9 9ad 9b2 9b6 9ba 9be
9c1 9c4 9c5 9ca 9ce 9d1 9d2 1
9d7 9dc 9e0 9e5 9e8 9ec 9f0 9f3
9f7 9f8 9fa 9fb a00 a04 a08 a0c
a10 a15 a19 a1d a20 a24 a26 a2a
a2d a31 a34 a37 a38 a3d a41 a46
a49 a4d a51 a54 a58 a59 a5b a5c
a61 a65 a69 a6d a71 a76 a7a a7e
a82 a86 a8a a8e a92 a93 a95 a99
a9b a9f aa2 aa6 aab aae ab2 ab3
ab8 abb ac0 ac1 ac6 ac9 acd ad1
ad4 ad8 ad9 adb adc ae1 ae4 ae9
aea aef af3 af7 afb aff b03 b08
b0c b10 b14 b17 b1b b1f b23 b27
b2b b2f b30 b35 b39 b3d b40 b43
b44 b49 b4d b51 b55 b59 b5c b60
b64 b68 b6c b70 b71 b73 b77 b7b
b7f b82 b86 b87 b8c b90 b94 b97
b9b b9f ba4 ba7 bab baf bb2 bb6
bb7 bb9 bba bbf bc2 bc7 bc8 bcd
bd1 bd5 bda bdd be1 be2 be7 bea
bef bf0 bf5 bf8 bfc c00 c03 c07
c08 c0a c0b c10 c13 c18 c19 c1e
c22 c26 c2a c2e c31 c35 c39 c3d
c41 c46 c4b c4f c53 c57 c5c c62
c66 c69 c6c c6d c72 c76 c79 c7c
c7d c82 c86 c8a c8e c92 c96 c97
c9b c9f ca2 ca3 ca8 ca9 cad cb1
cb5 cb8 cbb cbc cc1 cc5 cc9 ccd
cd0 cd4 cd5 cda cde ce2 ce6 ce9
ced cf0 cf4 cf5 cfa cfd cfe d03
d07 d0b d0e d12 d14 d18 d1b d1f
d23 d27 d2a d2e d32 d36 d3a d3d
d41 d45 d49 d4c d4f d50 d55 d59
d5d d5f d63 d66 d6a d6e d71 d72
d77 d7b d7e d7f d84 d88 d8c d8f
d93 d97 d9a d9b da0 da4 da8 dac
daf db2 db3 db8 dbc dc0 dc2 dc6
dca dcd dd1 dd5 dd8 dd9 dde de2
de5 de6 deb def df2 df6 dfa dfd
e01 e03 e07 e0b e0f e13 e17 e1b
e1c e20 e24 e27 e28 e2d e2e e32
e36 e3a e3d e40 e41 e46 e4a e4e
e52 e55 e59 e5a e5f e63 e67 e6b
e6e e72 e75 e79 e7a e7f e82 e83
e88 e8c e90 e94 e98 e9b e9f ea3
ea7 eab eae eb2 eb6 eb9 ebd ebf
ec3 ec7 eca ece ed2 ed5 ed8 edb
edc ee1 ee2 ee7 eeb eef ef3 ef7
efb efc f00 f01 f06 f07 f0b f0f
f15 f17 f1b f1e f20 f24 f2b f2f
f34 f37 f3b f3f f42 f46 f47 f49
f4a f4f f53 f57 f5b f5f f64 f68
f6c f70 f74 f76 1 f7a f7e f82
f85 f8a f8f f92 f95 f96 f9b fa0
fa3 fa7 fa8 fad fae fb3 fb7 fba
fbc fbd fc2 fc6 fc8 fd4 fd8 fda
fde ffa ff6 ff5 1002 100f 100b ff2
1017 1020 101c 100a 1028 1035 1031 1007
103d 1030 1042 1046 104a 104e 1052 1056
102d 105a 105d 1080 1065 1069 106c 106d
1075 1079 107a 107b 1061 1087 10a6 108f
1093 109b 109f 10a0 10a1 108b 10c2 10b1
10b5 10bd 10b0 10de 10cd 10d1 10d9 10ad
10f6 10e5 10e9 10f1 10cc 1113 1101 10c9
1105 1106 110e 1100 1130 111e 10fd 1122
1123 112b 111d 114d 113b 111a 113f 1140
1148 113a 116a 1158 1137 115c 115d 1165
1157 1186 1175 1179 1181 1154 119e 118d
1191 1199 1174 11ba 11a9 11ad 11b5 1171
11d2 11c1 11c5 11cd 11a8 11ee 11dd 11e1
11e9 11a5 1206 11f5 11f9 1201 11dc 1222
1211 1215 121d 11d9 123a 1229 122d 1235
1210 1256 1245 1249 1251 120d 1272 125d
1261 1269 126d 1244 128f 127d 1241 1281
1282 128a 127c 12ac 129a 1279 129e 129f
12a7 1299 12c8 12b7 12bb 12c3 1296 12b3
12cf 12d2 12d3 12d8 12db 12df 12e3 12e7
12eb 12ec 12ee 12f3 12f4 12f6 12fa 12fe
1301 1304 1305 130a 130d 1311 1315 1319
131c 1320 1323 1326 1327 132c 132d 132f
1333 1337 133b 133f 1342 1346 1347 1349
134d 1351 1355 1359 135d 135e 1360 1365
1366 1368 136b 136e 136f 1374 1378 137c
1380 1384 1388 138c 1390 1391 1393 1396
139a 139b 13a0 13a1 13a3 13a7 13ab 13af
13b3 13b6 13ba 13bb 13bd 13c1 13c3 13c7
13cb 13cf 13d2 13d6 13d7 13d9 13dd 13df
13e3 13e7 13ea 13ec 13f0 13f3 13f7 13fc
1400 1404 1408 140b 140f 1412 1413 1418
141c 1420 1423 1428 1429 142e 1432 1436
1439 143d 143f 1443 1447 144a 144f 1450
1455 1458 145c 145d 1462 1465 146a 146b
1470 1474 1476 147a 147e 1481 1485 1489
148d 1490 1494 1495 1497 149a 149f 14a0
14a5 14a8 14ac 14b0 14b3 14b7 14b8 14ba
14bb 14c0 14c4 14c8 14cd 14d0 14d4 14d5
14da 14dd 14e2 14e3 14e8 14eb 14ef 14f3
14f6 14fa 14fb 14fd 14fe 1503 1506 150b
150c 1511 1515 1519 151d 1521 1525 152a
152e 1532 1535 1538 1539 153e 1542 1545
1549 154b 154f 1552 1556 155a 155d 155e
1563 1567 156b 156f 1571 1575 1578 157c
1580 1584 1587 158b 158c 1591 1592 1594
1598 159c 159f 15a3 15a7 15ac 15af 15b3
15b4 15b9 15bd 15c1 15c4 15c8 15cc 15d0
15d2 15d6 15da 15dd 15e1 15e2 15e7 15eb
15ef 15f3 15f6 15fb 15fc 1601 1604 1608
1609 160e 1612 1614 1618 161f 1623 1627
162a 162f 1630 1635 1638 163c 163d 1642
1645 164a 164b 1650 1654 1658 165d 1660
1664 1665 166a 166d 1672 1673 1678 167b
167f 1683 1686 168a 168b 168d 168e 1693
1696 169b 169c 16a1 16a4 16a8 16ac 16af
16b3 16b4 16b6 16b7 16bc 16bf 16c4 16c5
16ca 16ce 16d2 16d6 16da 16de 16e2 16e6
16ea 16ef 16f3 16f7 16fb 16ff 1702 1706
1709 170a 170f 1712 1716 171a 171d 1720
1721 1726 172a 172e 1732 1735 1736 1738
173c 1740 1744 1747 174a 174d 174e 1753
1754 1756 175a 175c 1760 1763 1767 176b
176f 1773 1776 1777 1779 177d 1781 1785
1788 178c 1790 1794 1798 179c 17a0 17a1
17a6 17aa 17ae 17b1 17b4 17b5 17ba 17be
17c2 17c6 17ca 17cd 17d1 17d5 17d9 17dd
17e1 17e2 17e4 17e8 17ec 17f0 17f4 17f7
17f8 17fa 17fe 1802 1806 180b 180e 1812
1816 1819 181d 181e 1820 1821 1826 1829
182e 182f 1834 1838 183c 1840 1841 1846
184a 184e 1852 1855 1859 185a 185f 1863
1866 186a 186e 1872 1874 1878 187c 187d
187f 1883 1887 188a 188d 188e 1893 1894
1896 189a 189c 18a0 18a7 18ab 18ae 18b2
18b6 18ba 18bc 18c0 18c4 18c8 18cc 18d0
18d4 18d5 18d7 18d8 18dc 18e0 18e1 18e3
18e4 18e9 18ea 18ee 18f0 18f4 18fb 18ff
1903 1908 190c 190d 1912 1916 191a 191e
1920 1924 1926 1932 1936 1938 193c 1958
1954 1953 1960 1971 1969 196d 1950 1968
1979 1986 1982 1965 198e 1997 1993 1981
199f 197e 19a4 19a8 19ac 19b0 19b4 19b8
19bc 19c1 19c5 19ca 19ce 19d2 19d6 19da
19db 19f3 19e2 19e6 19ee 19e1 1a0f 19fe
1a02 1a0a 19de 1a27 1a16 1a1a 1a22 19fd
1a2e 1a32 1a36 1a3a 1a3e 1a43 1a48 1a4c
1a50 1a54 1a58 1a5d 1a63 1a67 1a6b 1a6f
1a73 1a77 1a7b 19fa 1a7f 1a81 1a85 1a89
1a8e 1a92 1a93 1a98 1a9c 1aa0 1aa4 1aa8
1aaa 1aae 1ab5 1ab9 1abd 1ac2 1ac4 1ac8
1acd 1ad1 1ad2 1ad7 1adb 1adf 1ae1 1ae5
1ae7 1af3 1af7 1af9 1afd 1b20 1b15 1b19
1b1d 1b14 1b28 1b35 1b31 1b11 1b3d 1b46
1b42 1b30 1b4e 1b5b 1b57 1b2d 1b63 1b6c
1b68 1b56 1b74 1b53 1b79 1b7d 1b81 1b85
1b89 1b8d 1b91 1b9e 1ba2 1ba6 1bab 1baf
1bb3 1bb7 1bbb 1bbf 1bc1 1bc5 1bc9 1bcd
1bd1 1bd5 1bd9 1bdd 1be1 1be5 1be9 1bed
1bf1 1bf5 1bf9 1bfd 1c01 1c05 1c09 1c0d
1c11 1c15 1c19 1c1b 1c1f 1c23 1c25 1c26
1c2a 1c2e 1c4a 1c46 1c45 1c52 1c63 1c5b
1c5f 1c42 1c5a 1c6b 1c78 1c74 1c57 1c80
1c89 1c85 1c73 1c91 1c70 1c96 1c9a 1c9e
1ca2 1ca6 1caa 1cae 1cb3 1cb7 1cbc 1cc0
1cc4 1cc8 1ccc 1ccd 1ce5 1cd4 1cd8 1ce0
1cd3 1d01 1cf0 1cf4 1cfc 1cd0 1d19 1d08
1d0c 1d14 1cef 1d20 1d24 1d28 1d2c 1d30
1d35 1d3a 1d3e 1d42 1d46 1d4a 1d4f 1d55
1d59 1d5d 1d61 1d65 1d69 1d6d 1cec 1d71
1d73 1d77 1d7b 1d80 1d84 1d85 1d8a 1d8e
1d92 1d96 1d9a 1d9c 1da0 1da7 1dab 1daf
1db4 1db6 1dba 1dbf 1dc3 1dc4 1dc9 1dcd
1dd1 1dd3 1dd7 1dd9 1de5 1de9 1deb 1def
1e12 1e07 1e0b 1e0f 1e06 1e1a 1e27 1e23
1e03 1e2f 1e38 1e34 1e22 1e40 1e4d 1e49
1e1f 1e55 1e5e 1e5a 1e48 1e66 1e45 1e6b
1e6f 1e73 1e77 1e7b 1e7f 1e83 1e90 1e94
1e98 1e9d 1ea1 1ea5 1ea9 1ead 1eb1 1eb3
1eb7 1ebb 1ebf 1ec3 1ec7 1ecb 1ecf 1ed3
1ed7 1edb 1edf 1ee3 1ee7 1eeb 1eef 1ef3
1ef7 1efb 1eff 1f03 1f07 1f0b 1f0d 1f11
1f15 1f17 1f18 1f1c 1f20 1f3c 1f38 1f37
1f44 1f55 1f4d 1f51 1f34 1f4c 1f5d 1f6a
1f66 1f49 1f72 1f7b 1f77 1f65 1f83 1f90
1f8c 1f62 1f98 1fa1 1f9d 1f8b 1fa9 1f88
1fae 1fb2 1fb6 1fba 1fbe 1fc2 1fc6 1fcb
1fcf 1fd4 1fd8 1fdc 1fe0 1fe4 1fe5 1ffd
1fec 1ff0 1ff8 1feb 2019 2008 200c 2014
1fe8 2031 2020 2024 202c 2007 204d 203c
2040 2048 2004 2065 2054 2058 2060 203b
2081 2070 2074 207c 2038 206c 2088 208c
2090 2094 2098 209d 20a2 20a6 20aa 20ae
20b2 20b7 20bd 20c1 20c5 20c9 20cd 20d1
20d5 20d9 20dd 20e1 20e5 20e9 20ed 20ee
20f3 20f7 20fc 2100 2101 2106 210a 210e
2112 2116 211a 211e 211f 2121 2125 2127
212b 2132 2136 213a 213f 2141 2145 214a
214e 214f 2154 2158 215c 215e 2162 2164
2170 2174 2176 2199 218e 2192 2196 218d
21a1 21ae 21aa 218a 21b6 21bf 21bb 21a9
21c7 21d4 21d0 21a6 21dc 21e5 21e1 21cf
21ed 21fa 21f6 21cc 2202 220b 2207 21f5
2213 2220 221c 21f2 2228 2235 222d 2231
221b 223c 224d 2245 2249 2218 2254 2261
2259 225d 2244 2268 2241 226d 2271 2275
2279 227d 228a 228e 2292 2297 229b 229f
22a3 22a7 22ab 22ad 22b1 22b5 22b9 22bd
22c1 22c5 22c9 22cd 22d1 22d5 22d9 22dd
22e1 22e5 22e9 22ed 22f1 22f5 22f9 22fd
2301 2305 2309 230d 2311 2315 2319 231d
2321 2325 2329 232d 2331 2335 2339 233d
2341 2345 2349 234d 2351 2355 2359 235d
235e 2362 2364 2366 236a 2376 2378 237b
237d 237e 2387 
92b
2
0 1 9 e 3 c 22 29
:2 22 33 39 :2 33 22 29 :2 22 33
3b :2 33 22 28 :2 22 32 38 :2 32
22 2c :3 22 2a :2 22 32 37 :2 32
21 3 a :3 3 a :2 3 5 a
17 1f :2 23 :2 1f 2a :2 2f :2 2a 17
:2 5 a 17 1b 17 :2 5 :3 a :2 5
:3 a :2 5 a 13 12 :2 a :2 5 a
13 12 :2 a :2 5 a 13 12 :2 a
:2 5 b 14 13 :2 b :2 5 :3 a :2 5
:3 a :2 5 :3 a :2 5 :3 a :2 5 :3 a :2 5
:2 a 14 a :2 5 :2 a 14 a :2 5
:2 a 14 a :2 5 :3 10 :2 5 :3 13 :2 5
:3 12 :2 5 :3 12 :2 5 :3 10 :2 5 :2 9 13
9 :2 5 11 1a 19 :2 11 :2 5 e
17 16 :2 e :2 5 e 17 16 :2 e
:2 5 :3 e 5 :4 9 8 7 13 19
23 :2 19 2c :2 13 7 b 14 15
:2 14 a 9 15 1c 24 27 2f
30 :2 27 :2 15 :2 9 14 :2 20 30 :2 14
:2 9 15 1b 25 :2 1b 2e :2 15 33
34 :2 15 :2 9 15 1c 24 2e 35
:2 2e 3c 3d :2 2e :2 15 :2 9 14 :2 20
30 :2 14 9 18 9 14 :2 20 30
:2 14 9 :4 7 1d :3 5 e :2 1a 26
:2 e 2e 31 :2 e 35 7 :2 13 18
:2 7 :2 e :2 5 11 :2 5 10 :2 1c 2c
:2 10 :2 5 11 :2 5 10 :2 1c 2c :2 10
:2 5 11 :2 5 10 :2 1c 2c :2 10 :2 5
11 25 28 :2 11 30 33 :2 11 36
39 41 :2 39 :2 11 5 9 11 13
:2 11 8 7 16 :2 22 35 :2 16 7
16 7 16 :2 1f 2c :2 16 7 :4 5
9 13 16 :2 13 8 7 13 :2 1f
2f :2 13 7 21 :3 5 d 5 8
e c :2 18 :2 c 7 f 14 17
:2 f :2 7 e 7 26 7 f 14
17 :2 f 1b 1e :2 f 22 25 :2 f
7 :5 5 d 1d d :2 19 1e :4 d
25 28 :2 d 5 9 13 16 :2 13
8 7 f 14 17 :2 f 26 29
:2 35 3a :2 29 :2 f 7 21 :3 5 d
12 15 :2 d 23 26 :2 d 2b 2e
:2 d 5 8 10 12 :2 10 7 f
14 17 :2 f 1c 1f :2 2b 30 :2 1f
:2 f 7 14 7 f 14 17 :2 23
28 :2 17 :2 f 7 :5 5 d 12 15
:2 d 2a 2d :2 39 3e :2 2d :2 d 45
:3 d 2b :3 d 21 24 :2 30 35 :2 24
:2 d 3d 6 :2 d 1f d :2 19 1e
:4 d 25 28 :2 d 42 6 :2 12 17
:2 6 :2 d 24 27 :2 d :2 5 d 17
:3 5 d 17 1a :2 d 1f 22 :2 d
41 d :2 19 1e :4 d 25 28 :2 d
:2 5 d 17 21 27 :3 5 8 d
f :2 d :4 15 :2 8 7 f 1d 20
:2 2c 31 :2 20 :2 f :2 7 f 19 :3 7
e 7 22 :2 5 8 d f :2 d
7 f 1d 20 :2 2c 31 :2 20 :2 f
:2 7 f 19 :3 7 e 1c 24 2c
33 :2 e 7 11 :3 5 d 17 1a
:2 d 1f 22 :2 d 36 6 :2 12 17
:2 6 :2 d 1e 21 :2 d :2 5 d 17
21 :3 5 :2 10 1b 21 2d 1a 28
36 :3 5 13 1d 1e :2 13 :2 5 d
:2 18 25 31 1a 28 36 :2 d :2 5
d 12 14 :2 d :2 5 d :2 5 d
1c 1f :2 2b 30 :2 1f :2 d 6 9
:2 d :2 5 d 17 1a :2 d 1f 22
:2 d 39 6 :2 12 17 :2 6 :2 d 1e
:3 d :2 5 a :2 13 :2 5 d 17 :3 7
11 16 11 7 a f 11 :2 f
c 11 13 :2 11 b 13 1d 22
28 22 2e :2 33 2c :4 b 13 18
1a :2 13 :2 b 13 18 1a :2 13 :2 b
13 18 1b 1f 21 :2 1b 1a :2 13
:2 b 13 b 15 :3 9 11 :2 16 :2 9
11 :2 16 :2 9 11 16 18 :2 11 9
7 13 d 11 12 :2 17 :2 d 1e
:3 1c 9 11 16 18 :2 1d :2 11 :2 9
11 16 18 :2 11 9 7 23 13
d 11 12 :2 17 :2 d 1e :3 1c 9
11 :2 9 11 9 23 13 9 11
1b 20 26 20 2c :2 31 2a :4 9
11 16 18 :2 11 :2 9 11 16 18
:2 11 :2 9 11 16 19 1d 1f :2 19
18 :2 11 :2 9 11 :2 16 :2 9 11 :2 16
:2 9 11 9 :4 7 a 11 f 14
15 :2 11 :2 f 9 11 1b 20 26
20 2c 2a :5 9 17 :2 7 5 9
3 5 d 1b 1e :2 2a 2f :2 1e
:2 d :2 5 d 17 :3 5 c 5 3
:2 a 9 :2 f 1e 24 29 2a :2 29
31 43 46 :2 31 :2 9 :2 7 11 :2 5
:6 3 c 1a 21 :2 1a 2b 31 :2 2b
1a 20 :2 1a 2a 2f :2 2a 19 3
a :3 3 a :2 3 5 a 1d 26
25 1d :4 14 :2 5 a :2 1d :4 14 :2 5
:3 a :2 5 :3 b :2 5 :3 a :2 5 a 13
12 :2 a :2 5 a 13 12 :2 a :2 5
a 13 12 :2 a :2 5 b 14 13
:2 b :2 5 :3 a :2 5 :3 a :2 5 :3 a :2 5
:3 a :2 5 :3 10 :2 5 :3 13 :2 5 :3 12 :2 5
:3 12 :2 5 :3 10 :2 5 :2 9 13 9 :2 5
11 1a 19 :2 11 :2 5 11 1a 19
:2 11 :2 5 :3 11 5 :4 9 8 7 13
19 23 :2 19 2b :2 13 7 b 14
15 :2 14 a 9 15 1c 23 26
2e 2f :2 26 :2 15 :2 9 14 :2 20 30
:2 14 :2 9 15 1b 25 :2 1b 2d :2 15
32 33 :2 15 :2 9 15 1c 23 2d
34 :2 2d 3a 3b :2 2d :2 15 :2 9 14
:2 20 30 :2 14 9 18 9 14 :2 20
30 :2 14 9 :4 7 1c :3 5 d 5
8 e c :2 18 :2 c 7 f 14
17 :2 f :2 7 e 7 26 7 f
14 17 :2 f 1b 1e :2 f 22 25
:2 f 7 :5 5 e :2 1a 26 :2 e 2e
31 :2 e 35 7 :2 13 18 :2 7 :2 e
:2 5 d 17 1a :2 d 1f 22 :2 d
34 6 :2 12 17 :2 6 :2 d 1e 21
:2 d :2 5 d 17 21 :2 5 8 d
f :2 d 7 e 7 11 :2 5 8
f :3 d 7 e 7 13 :3 5 d
13 18 1a :2 13 :2 d :2 5 d :2 5
d 19 1c :2 d 5 9 e 11
15 e 5 7 f 13 14 :2 f
:2 7 f 14 17 :2 f 1b 1e :2 f
7 15 9 :2 5 d 12 15 :2 d
19 1c :2 d 21 24 :2 d :2 5 d
2e 31 :2 d 36 :4 d 10 :2 1c 21
:2 10 :2 d 28 2b :2 d 6 9 :2 15
1a :2 9 :2 d 20 23 :2 d :2 5 d
17 1c 21 2e 34 :3 5 9 :2 e
16 :3 14 8 7 :2 c 13 :3 7 c
:2 11 :2 7 1b 20 :2 25 29 2a :2 20
:2 1b 7 1b :3 5 d 12 :2 17 :2 d
:2 5 :2 10 1b 21 2d 1a 28 36
:3 5 13 1d 1e :2 13 :2 5 d :2 18
25 31 1a 28 36 :2 d :2 5 a
:2 f :2 5 18 :2 5 d 1c 1f :2 2b
3b :2 1f :3 d 10 :2 d :2 5 :3 e :2 5
:2 b 12 :2 5 9 e 11 15 e
5 7 d :2 7 13 18 19 1a
:2 18 :2 13 7 15 9 5 9 e
11 16 e 5 7 f 19 1e
24 29 :2 24 1e 2d 33 :2 2d 2b
:3 7 16 9 :2 5 c :5 5 c 5
:7 3 c 17 1a :2 17 29 2c 30
2c :2 29 17 1e :2 17 28 2f :2 28
16 5 c 5 16 20 16 :3 5
:2 3 5 c :2 5 7 :3 c :2 7 :3 c
:2 7 :3 c 7 5 d 15 1b :4 7
11 14 11 :2 7 e 1d 21 29
31 37 :2 e :7 7 c 10 7 5
9 3 5 b :9 5 :7 3 c 1b
1e 22 1e :2 1b 31 38 :2 31 1b
22 :2 1b 2c 31 :2 2c 3b 40 :2 3b
1a 5 c :2 3 8 11 :2 5 a
11 5 d a 5 :4 7 a 14
7 e 7 e 7 e 7 e
7 c 7 c 7 c 7 c
7 e :2 7 e 7 f :2 3 c
16 19 :2 16 28 2b 2f 2b :2 28
16 1b :2 16 25 2c :2 25 15 5
c 5 16 20 16 :3 5 :2 3 5
c :2 5 7 :3 c :2 7 :3 c :2 7 :3 c
7 5 d 15 1b :4 7 11 14
11 :2 7 e 1a 1e 24 2c 32
:2 e :7 7 c 10 7 5 9 3
5 b :9 5 :7 3 c 18 1b 1f
1b :2 18 2e 33 :2 2e 18 1f :2 18
29 2e :2 29 38 3d :2 38 17 5
c :2 3 8 11 :2 5 a 11 5
d a 5 :4 7 a 14 7 c
7 c 7 e 7 e 7 c
7 c 7 c 7 c 7 e
:2 7 e 7 f :2 3 c 16 19
:2 16 28 2b 2f 2b :2 28 16 1e
:2 16 28 2f :2 28 16 1a :2 16 22
29 :2 22 15 5 c 5 16 20
16 :3 5 :2 3 5 c :2 5 7 :3 c
:2 7 :3 c :2 7 :3 c :2 7 :3 c :2 7 :3 c
:2 7 :3 c 7 5 d 15 1a 1f
:4 7 11 14 11 :2 7 13 16 1e
25 29 2d 32 36 3d 40 45
:8 7 c 10 19 1c 21 :2 10 7
5 9 3 5 b :9 5 :6 3 d
19 1c 20 1c :2 19 2f 37 :2 2f
19 20 :2 19 2a 2e :2 2a 36 3a
:2 36 19 1e :2 19 26 2a :2 26 32
39 :2 32 19 1c 20 :2 19 28 2d
31 :2 28 39 3c 40 :2 39 18 :2 3
8 11 18 5 a 11 5 d
a 5 :4 7 a 14 7 f 7
f 7 e 7 e 7 b 7
b 7 b 7 b 7 c 7
c 7 b 7 b 7 e 7
e 7 a 7 a 7 c 7
c 7 a 7 a f :5 3 :6 1

92b
4
0 :3 1 :a 3 :8 4
:8 5 :4 6 :8 7 3
:2 8 :2 3 :4 9 :f a
:6 b :5 c :5 d :7 e
:7 f :7 10 :7 11 :5 12
:5 13 :5 14 :5 15 :5 16
:6 17 :6 18 :6 19 :5 1a
:5 1b :5 1c :5 1d :5 1e
:6 1f :7 20 :7 21 :7 22
:5 23 :5 26 :a 27 :6 28
:c 29 :8 2b :e 2c :f 2d
:8 2f 28 :8 31 30
:3 28 :3 26 :c 35 :6 36
:3 35 :3 37 :8 38 :3 39
:8 3a :3 3b :8 3c :12 3e
:6 3f :8 40 3f :8 42
41 :3 3f :6 44 :8 45
:3 44 :3 4a :7 4b :7 4c
:3 4e 4b :f 50 4f
:3 4b :3 53 :6 54 :2 53
:2 54 :3 53 :6 56 :10 57
:3 56 :f 5a :5 5c :10 5d
5c :c 5f 5e :3 5c
:10 62 63 :2 62 63
64 :2 62 :7 64 :2 62
64 65 :2 62 65
:6 66 :2 62 :2 66 :2 62
66 :6 67 :2 62 :2 67
:3 62 :5 69 :b 6b :6 6c
:2 6b :2 6c :3 6b :8 6d
:b 70 :c 71 :5 72 :3 73
:3 70 :5 78 :c 79 :5 7a
:9 7b :3 78 :b 7f :6 80
:2 7f :2 80 :3 7f :6 81
:6 84 :3 85 :2 84 :7 86
:6 87 :3 88 :3 87 :7 8a
:3 8b :b 8d :2 8e :3 8d
:b 90 :6 91 :2 90 91
92 :3 90 :5 93 94
:4 95 :5 96 :5 98 :5 99
:d 9a :7 9b :7 9c :c 9d
:3 9e :3 99 :5 a0 :5 a1
:7 a2 a3 98 :b a3
:9 a4 :7 a5 a6 a3
98 :b a6 :3 a7 :3 a8
a6 98 :d aa :7 ab
:7 ac :c ad :5 ae :5 af
:3 b0 a9 :3 98 :9 b3
:b b4 :2 b5 :3 b3 94
b7 24 :c b9 :5 ba
:3 bc 24 :2 be :10 bf
:2 c0 :3 be bd :4 3
:a c3 :8 c4 c3 :2 c5
:2 c3 :4 c6 :b c7 :9 c8
:5 c9 :5 ca :5 cb :7 cc
:7 cd :7 ce :7 cf :5 d0
:5 d1 :5 d2 :5 d3 :5 d4
:5 d5 :5 d6 :5 d7 :5 d8
:6 d9 :7 da :7 db :5 dc
:5 df :a e0 :6 e1 :c e2
:8 e4 :e e5 :f e6 :8 e8
e1 :8 ea e9 :3 e1
:3 df :3 f1 :7 f2 :7 f3
:3 f5 f2 :f f7 f6
:3 f2 :c fa :6 fb :3 fa
:b fc :6 fd :2 fc :2 fd
:3 fc :6 fe :5 100 :3 101
:3 100 :5 104 :3 105 :3 104
:a 108 :3 10d :7 10e :6 10f
:7 110 :b 111 10f 112
10f :f 115 :7 117 118
:2 117 :7 119 :2 117 :2 119
:2 117 :7 11a :2 117 :2 11a
:3 117 :a 11d :8 122 :6 123
:11 124 :3 122 :8 12a :6 12d
:3 12e :2 12d :7 12f :6 130
:3 131 :3 130 :8 134 :b 136
:2 137 :3 136 :5 139 :6 13a
:6 13b :d 13c 13b 13d
13b :6 13f :11 140 13f
142 13f :6 143 :3 145
:2 dd :4 c3 :c 148 :8 149
148 :2 14a :5 14b :2 14c
:2 148 :4 14d :5 14e :5 14f
:5 150 152 :6 153 :5 154
:a 156 :5 157 :4 158 152
159 151 :4 15a :5 15c
:2 15d :2 151 :4 148 :c 160
:c 161 160 :2 162 :2 160
:2 163 162 :2 164 163
:2 165 166 167 :2 168
169 :3 16a :2 16b :2 16c
:2 16d :2 16e :2 16f :2 170
:2 171 :2 172 :3 173 :3 174
167 160 :c 176 :8 177
176 :2 178 :5 179 :2 17a
:2 176 :4 17b :5 17c :5 17d
:5 17e 180 :6 181 :5 182
:a 184 :5 185 :4 186 180
187 17f :4 188 :5 18a
:2 18b :2 17f :4 176 :c 18e
:c 18f 18e :2 190 :2 18e
:2 191 190 :2 192 191
:2 193 194 195 :2 196
197 :3 198 :2 199 :2 19a
:2 19b :2 19c :2 19d :2 19e
:2 19f :2 1a0 :3 1a1 :3 1a2
195 18e :c 1a4 :8 1a5
:8 1a6 1a4 :2 1a7 :5 1a8
:2 1a9 :2 1a4 :4 1aa :5 1ab
:5 1ac :5 1ad :5 1ae :5 1af
:5 1b0 1b2 :7 1b3 :5 1b4
:e 1b6 :5 1b7 :9 1b8 1b2
1b9 1b1 :4 1ba :5 1bc
:2 1bd :2 1b1 :4 1a4 :b 1c0
:c 1c1 :c 1c2 :f 1c3 :3 1c0
:2 1c4 1c0 :2 1c5 1c4
:2 1c6 1c7 1c8 :2 1c9
1ca :3 1cb :2 1cc :2 1cd
:2 1ce :2 1cf :2 1d0 :2 1d1
:2 1d2 :2 1d3 :2 1d4 :2 1d5
:2 1d6 :2 1d7 :2 1d8 :2 1d9
:2 1da :2 1db :2 1dc :2 1dd
:2 1de :2 1df 1c8 1c0
:4 3 :6 1 
2389
4
:3 0 1 :3 0 2
:3 0 3 :6 0 1
:2 0 4 :3 0 5
:a 0 44d 2 :7 0
5 42 0 3
7 :3 0 6 :7 0
8 7 :3 0 9
68 0 :2 7 :3 0
8 :7 0 c b
:3 0 7 :3 0 9
:7 0 10 f :3 0
d 8e 0 b
7 :3 0 a :7 0
14 13 :3 0 7
:3 0 b :7 0 18
17 :3 0 11 b4
0 f 7 :3 0
c :7 0 1c 1b
:3 0 7 :3 0 d
:7 0 20 1f :3 0
15 :2 0 13 f
:3 0 e :7 0 24
23 :3 0 f :3 0
10 :7 0 28 27
:3 0 11 :3 0 f
:3 0 2a 2c 0
44d 5 2d :2 0
12 :3 0 13 :4 0
30 31 44b 14
:3 0 14 :3 0 16
:3 0 21 11e 0
1f 18 :3 0 37
:7 0 17 :6 0 39
38 0 40 0
34 0 40 44b
f :3 0 3c :7 0
19 :6 0 3e 3d
0 40 0 23
:4 0 3 :a 0 15
40 34 3 :3 0
43 0 46 44b
1b :3 0 1c :7 0
1a 46 43 :4 0
28 184 0 26
15 :3 0 49 :7 0
4c 4a 0 44b
0 1d :6 0 22
:2 0 2c 1a :3 0
4e :7 0 51 4f
0 44b 0 1e
:6 0 7 :3 0 20
:2 0 2a 53 55
:6 0 58 56 0
44b 0 1f :6 0
24 :2 0 30 7
:3 0 2e 5a 5c
:6 0 5f 5d 0
44b 0 21 :6 0
26 :2 0 34 7
:3 0 32 61 63
:6 0 66 64 0
44b 0 23 :6 0
3a 213 0 38
7 :3 0 36 68
6a :6 0 6d 6b
0 44b 0 25
:6 0 3e 247 0
3c f :3 0 6f
:7 0 72 70 0
44b 0 27 :6 0
f :3 0 74 :7 0
77 75 0 44b
0 28 :6 0 42
27b 0 40 f
:3 0 79 :7 0 7c
7a 0 44b 0
29 :6 0 18 :3 0
7e :7 0 81 7f
0 44b 0 2a
:6 0 2d :2 0 44
18 :3 0 83 :7 0
86 84 0 44b
0 2b :6 0 f
:3 0 88 :7 0 2d
:2 0 8c 89 8a
44b 0 2c :6 0
2d :2 0 46 f
:3 0 8e :7 0 92
8f 90 44b 0
2e :6 0 4a 2ea
0 48 f :3 0
94 :7 0 98 95
96 44b 0 2f
:6 0 4e 31e 0
4c f :3 0 9a
:7 0 9d 9b 0
44b 0 30 :6 0
f :3 0 9f :7 0
a2 a0 0 44b
0 31 :6 0 52
352 0 50 f
:3 0 a4 :7 0 a7
a5 0 44b 0
32 :6 0 f :3 0
a9 :7 0 ac aa
0 44b 0 33
:6 0 37 :2 0 54
f :3 0 ae :7 0
b1 af 0 44b
0 34 :6 0 f
:3 0 b3 :7 0 10
:3 0 b7 b4 b5
44b 0 35 :6 0
39 :2 0 58 7
:3 0 56 b9 bb
:6 0 be bc 0
44b 0 36 :6 0
39 :2 0 5c 7
:3 0 5a c0 c2
:6 0 c5 c3 0
44b 0 38 :6 0
62 3e1 0 60
7 :3 0 5e c7
c9 :6 0 cc ca
0 44b 0 3a
:6 0 9 :3 0 f
:3 0 ce :7 0 d1
cf 0 44b 0
3b :6 0 3c :2 0
64 d3 d4 :3 0
d5 :2 0 3b :3 0
3d :3 0 3e :3 0
9 :3 0 66 d9
db 3f :4 0 68
d8 de d7 df
0 12d 3b :3 0
40 :2 0 41 :2 0
6d e2 e4 :3 0
e5 :2 0 38 :3 0
42 :3 0 9 :3 0
41 :2 0 3b :3 0
43 :2 0 41 :2 0
70 ec ee :3 0
73 e8 f0 e7
f1 0 120 3a
:3 0 44 :3 0 45
:3 0 f4 f5 0
38 :3 0 77 f6
f8 f3 f9 0
120 3b :3 0 3d
:3 0 3e :3 0 9
:3 0 79 fd ff
46 :4 0 7b fc
102 47 :2 0 41
:2 0 7e 104 106
:3 0 fb 107 0
120 38 :3 0 42
:3 0 9 :3 0 3b
:3 0 48 :3 0 9
:3 0 81 10d 10f
43 :2 0 3b :3 0
83 111 113 :3 0
86 10a 115 109
116 0 120 3a
:3 0 44 :3 0 45
:3 0 119 11a 0
38 :3 0 8a 11b
11d 118 11e 0
120 8c 12a 3a
:3 0 44 :3 0 45
:3 0 122 123 0
9 :3 0 92 124
126 121 127 0
129 94 12b e6
120 0 12c 0
129 0 12c 96
0 12d 99 12e
d6 12d 0 12f
9c 0 432 25
:3 0 44 :3 0 49
:3 0 131 132 0
6 :3 0 9e 133
135 4a :2 0 4b
:4 0 a0 137 139
:3 0 4a :2 0 44
:3 0 4c :3 0 13c
13d 0 9 :3 0
a3 13e 140 a5
13b 142 :3 0 130
143 0 432 38
:3 0 8 :3 0 145
146 0 432 3a
:3 0 44 :3 0 45
:3 0 149 14a 0
8 :3 0 a8 14b
14d 148 14e 0
432 38 :3 0 c
:3 0 150 151 0
432 3a :3 0 44
:3 0 45 :3 0 154
155 0 c :3 0
aa 156 158 153
159 0 432 38
:3 0 b :3 0 15b
15c 0 432 3a
:3 0 44 :3 0 45
:3 0 15f 160 0
b :3 0 ac 161
163 15e 164 0
432 38 :3 0 4d
:4 0 4a :2 0 a
:3 0 ae 168 16a
:3 0 4a :2 0 4e
:4 0 b1 16c 16e
:3 0 4a :2 0 4f
:3 0 e :3 0 b4
171 173 b6 170
175 :3 0 166 176
0 432 e :3 0
50 :2 0 2d :2 0
bb 179 17b :3 0
17c :2 0 36 :3 0
44 :3 0 51 :3 0
17f 180 0 a
:3 0 be 181 183
17e 184 0 186
c0 190 36 :3 0
52 :3 0 53 :3 0
188 189 0 a
:3 0 c2 18a 18c
187 18d 0 18f
c4 191 17d 186
0 192 0 18f
0 192 c6 0
432 d :3 0 54
:2 0 55 :4 0 cb
194 196 :3 0 197
:2 0 38 :3 0 44
:3 0 45 :3 0 19a
19b 0 d :3 0
ce 19c 19e 199
19f 0 1a1 d0
1a2 198 1a1 0
1a3 d2 0 432
21 :3 0 56 :4 0
1a4 1a5 0 432
35 :3 0 57 :3 0
50 :2 0 58 :3 0
1a8 1aa 0 d6
1a9 1ac :3 0 21
:3 0 21 :3 0 4a
:2 0 59 :4 0 d9
1b0 1b2 :3 0 1ae
1b3 0 1b8 35
:3 0 5a :2 0 1b5
1b6 0 1b8 dc
1c9 21 :3 0 21
:3 0 4a :2 0 4e
:4 0 df 1bb 1bd
:3 0 4a :2 0 35
:3 0 e2 1bf 1c1
:3 0 4a :2 0 59
:4 0 e5 1c3 1c5
:3 0 1b9 1c6 0
1c8 e8 1ca 1ad
1b8 0 1cb 0
1c8 0 1cb ea
0 432 1f :3 0
5b :4 0 4a :2 0
44 :3 0 4c :3 0
1cf 1d0 0 c
:3 0 ed 1d1 1d3
ef 1ce 1d5 :3 0
4a :2 0 5c :4 0
f2 1d7 1d9 :3 0
1cc 1da 0 432
d :3 0 54 :2 0
55 :4 0 f7 1dd
1df :3 0 1e0 :2 0
1f :3 0 1f :3 0
4a :2 0 5d :4 0
fa 1e4 1e6 :3 0
4a :2 0 44 :3 0
4c :3 0 1e9 1ea
0 d :3 0 fd
1eb 1ed ff 1e8
1ef :3 0 1e2 1f0
0 1f2 102 1f3
1e1 1f2 0 1f4
104 0 432 1f
:3 0 1f :3 0 4a
:2 0 5e :4 0 106
1f7 1f9 :3 0 4a
:2 0 21 :3 0 109
1fb 1fd :3 0 4a
:2 0 5f :4 0 10c
1ff 201 :3 0 1f5
202 0 432 e
:3 0 50 :2 0 2d
:2 0 111 205 207
:3 0 1f :3 0 1f
:3 0 4a :2 0 60
:4 0 114 20b 20d
:3 0 4a :2 0 44
:3 0 4c :3 0 210
211 0 36 :3 0
117 212 214 119
20f 216 :3 0 209
217 0 219 11c
227 1f :3 0 1f
:3 0 4a :2 0 44
:3 0 4c :3 0 21d
21e 0 36 :3 0
11e 21f 221 120
21c 223 :3 0 21a
224 0 226 123
228 208 219 0
229 0 226 0
229 125 0 432
1f :3 0 1f :3 0
4a :2 0 61 :4 0
128 22c 22e :3 0
4a :2 0 44 :3 0
4c :3 0 231 232
0 25 :3 0 12b
233 235 12d 230
237 :3 0 4a :2 0
62 :4 0 130 239
23b :3 0 4a :2 0
63 :4 0 133 23d
23f :3 0 4a :2 0
44 :3 0 4c :3 0
242 243 0 6
:3 0 136 244 246
138 241 248 :3 0
4a :2 0 64 :4 0
13b 24a 24c :3 0
4a :2 0 44 :3 0
4c :3 0 24f 250
0 8 :3 0 13e
251 253 140 24e
255 :3 0 4a :2 0
65 :4 0 143 257
259 :3 0 4a :2 0
44 :3 0 4c :3 0
25c 25d 0 36
:3 0 146 25e 260
148 25b 262 :3 0
4a :2 0 66 :4 0
14b 264 266 :3 0
22a 267 0 432
67 :3 0 68 :3 0
1f :3 0 26b :4 0
26c :2 0 432 1f
:3 0 69 :4 0 4a
:2 0 21 :3 0 14e
270 272 :3 0 4a
:2 0 6a :4 0 151
274 276 :3 0 4a
:2 0 44 :3 0 4c
:3 0 279 27a 0
c :3 0 154 27b
27d 156 278 27f
:3 0 4a :2 0 6b
:4 0 159 281 283
:3 0 26e 284 0
432 67 :3 0 68
:3 0 1f :3 0 29
:3 0 27 :3 0 288
28c :3 0 15c :3 0
28b :2 0 432 29
:3 0 50 :2 0 2d
:2 0 161 28f 291
:3 0 27 :3 0 6c
:2 0 164 294 295
:3 0 292 297 296
:2 0 1f :3 0 6d
:4 0 4a :2 0 44
:3 0 4c :3 0 29c
29d 0 c :3 0
166 29e 2a0 168
29b 2a2 :3 0 299
2a3 0 2ad 67
:3 0 68 :3 0 1f
:3 0 2a7 :4 0 2a8
:2 0 2ad 11 :3 0
2d :2 0 2ab :2 0
2ad 16b 2ae 298
2ad 0 2af 16f
0 432 27 :3 0
50 :2 0 2d :2 0
173 2b1 2b3 :3 0
1f :3 0 6d :4 0
4a :2 0 44 :3 0
4c :3 0 2b8 2b9
0 c :3 0 176
2ba 2bc 178 2b7
2be :3 0 2b5 2bf
0 2cf 67 :3 0
68 :3 0 1f :3 0
2c3 :4 0 2c4 :2 0
2cf 11 :3 0 6e
:3 0 6 :3 0 9
:3 0 b :3 0 35
:3 0 17b 2c7 2cc
2cd :2 0 2cf 180
2d0 2b4 2cf 0
2d1 184 0 432
1f :3 0 69 :4 0
4a :2 0 21 :3 0
186 2d4 2d6 :3 0
4a :2 0 6f :4 0
189 2d8 2da :3 0
4a :2 0 44 :3 0
4c :3 0 2dd 2de
0 c :3 0 18c
2df 2e1 18e 2dc
2e3 :3 0 4a :2 0
6b :4 0 191 2e5
2e7 :3 0 2d2 2e8
0 432 67 :3 0
68 :3 0 1f :3 0
2b :3 0 2ec 2ed
:3 0 2ee :2 0 432
70 :3 0 71 :3 0
2f0 2f1 0 2b
:3 0 30 :3 0 31
:3 0 32 :3 0 33
:3 0 34 :3 0 194
2f2 2f9 :2 0 432
34 :3 0 34 :3 0
47 :2 0 41 :2 0
19b 2fd 2ff :3 0
2fb 300 0 432
2b :3 0 70 :3 0
72 :3 0 303 304
0 30 :3 0 31
:3 0 32 :3 0 33
:3 0 34 :3 0 19e
305 30b 302 30c
0 432 29 :3 0
27 :3 0 73 :2 0
35 :3 0 1a4 310
312 :3 0 30e 313
0 432 28 :3 0
2d :2 0 315 316
0 432 23 :3 0
74 :4 0 4a :2 0
44 :3 0 4c :3 0
31b 31c 0 b
:3 0 1a7 31d 31f
1a9 31a 321 :3 0
4a :2 0 75 :4 0
1ac 323 325 :3 0
318 326 0 432
1f :3 0 69 :4 0
4a :2 0 21 :3 0
1af 32a 32c :3 0
4a :2 0 76 :4 0
1b2 32e 330 :3 0
4a :2 0 44 :3 0
4c :3 0 333 334
0 c :3 0 1b5
335 337 1b7 332
339 :3 0 4a :2 0
77 :4 0 1ba 33b
33d :3 0 328 33e
0 432 78 :3 0
1e :3 0 1f :3 0
341 342 0 343
:2 0 432 79 :3 0
1e :3 0 1d :4 0
349 :2 0 41b 346
347 :3 0 7a :3 0
1e :3 0 7b :3 0
34b 34c :4 0 34d
:3 0 41b 2c :3 0
50 :2 0 2d :2 0
1bf 350 352 :3 0
2f :3 0 50 :2 0
41 :2 0 1c4 355
357 :3 0 67 :3 0
68 :3 0 23 :3 0
7c :3 0 2a :3 0
35d 1d :3 0 17
:3 0 35f 360 0
361 35b 0 364
:2 0 1c7 363 :2 0
383 2e :3 0 2e
:3 0 47 :2 0 41
:2 0 1ca 368 36a
:3 0 366 36b 0
383 27 :3 0 27
:3 0 43 :2 0 28
:3 0 1cd 36f 371
:3 0 36d 372 0
383 29 :3 0 27
:3 0 73 :2 0 35
:3 0 43 :2 0 2e
:3 0 1d0 378 37a
:3 0 37b :2 0 1d3
376 37d :3 0 374
37e 0 383 2f
:3 0 2d :2 0 380
381 0 383 1d6
384 358 383 0
385 1dc 0 398
2a :3 0 1d :3 0
17 :3 0 387 388
0 386 389 0
398 28 :3 0 1d
:3 0 19 :3 0 38c
38d 0 38b 38e
0 398 2c :3 0
2c :3 0 47 :2 0
41 :2 0 1de 392
394 :3 0 390 395
0 398 7d :3 0
1e1 3ff 28 :3 0
47 :2 0 1d :3 0
19 :3 0 39b 39c
0 1e6 39a 39e
:3 0 29 :3 0 7e
:2 0 1eb 3a1 3a2
:3 0 28 :3 0 28
:3 0 47 :2 0 1d
:3 0 19 :3 0 3a7
3a8 0 1ee 3a6
3aa :3 0 3a4 3ab
0 3b5 2c :3 0
2c :3 0 47 :2 0
41 :2 0 1f1 3af
3b1 :3 0 3ad 3b2
0 3b5 7d :3 0
1f4 3b6 3a3 3b5
0 401 28 :3 0
47 :2 0 1d :3 0
19 :3 0 3b9 3ba
0 1f7 3b8 3bc
:3 0 29 :3 0 50
:2 0 1fc 3bf 3c0
:3 0 2f :3 0 41
:2 0 3c2 3c3 0
3c8 2c :3 0 2d
:2 0 3c5 3c6 0
3c8 1ff 3c9 3c1
3c8 0 401 67
:3 0 68 :3 0 23
:3 0 7c :3 0 2a
:3 0 3ce 1d :3 0
17 :3 0 3d0 3d1
0 3d2 3cc 0
3d5 :2 0 202 3d4
:2 0 3fe 2e :3 0
2e :3 0 47 :2 0
41 :2 0 205 3d9
3db :3 0 3d7 3dc
0 3fe 27 :3 0
27 :3 0 43 :2 0
28 :3 0 208 3e0
3e2 :3 0 3de 3e3
0 3fe 29 :3 0
27 :3 0 73 :2 0
35 :3 0 43 :2 0
2e :3 0 20b 3e9
3eb :3 0 3ec :2 0
20e 3e7 3ee :3 0
3e5 3ef 0 3fe
2a :3 0 1d :3 0
17 :3 0 3f2 3f3
0 3f1 3f4 0
3fe 28 :3 0 1d
:3 0 19 :3 0 3f7
3f8 0 3f6 3f9
0 3fe 2c :3 0
41 :2 0 3fb 3fc
0 3fe 211 400
353 398 0 401
0 3fe 0 401
219 0 41b 2e
:3 0 35 :3 0 50
:2 0 43 :2 0 41
:2 0 21e 405 407
:3 0 223 404 409
:3 0 67 :3 0 68
:3 0 23 :3 0 7c
:3 0 2a :3 0 40f
2b :3 0 411 40d
0 414 :2 0 226
413 :2 0 418 7a
:8 0 418 229 419
40a 418 0 41a
22c 0 41b 22e
41d 79 :4 0 41b
:4 0 432 1f :3 0
6d :4 0 4a :2 0
44 :3 0 4c :3 0
421 422 0 c
:3 0 233 423 425
235 420 427 :3 0
41e 428 0 432
67 :3 0 68 :3 0
1f :3 0 42c :4 0
42d :2 0 432 11
:3 0 35 :3 0 430
:2 0 432 238 44c
7f :3 0 80 :3 0
81 :3 0 435 436
0 82 :4 0 83
:4 0 43 :2 0 84
:2 0 25e 43a 43c
:3 0 85 :4 0 4a
:2 0 38 :3 0 260
43f 441 :3 0 263
437 443 :2 0 447
86 :5 0 447 268
449 26b 448 447
:2 0 44a 26d :2 0
44c 26f 44c 44b
432 44a :6 0 44d
1 0 5 2d
44c 925 :2 0 4
:3 0 6e :a 0 6d3
5 :7 0 28d 1007
0 28b 7 :3 0
6 :7 0 453 452
:3 0 291 102d 0
28f 7 :3 0 8
:7 0 457 456 :3 0
7 :3 0 b :7 0
45b 45a :6 0 293
f :3 0 10 :7 0
45f 45e :3 0 11
:3 0 f :3 0 461
463 0 6d3 450
464 :2 0 12 :3 0
13 :3 0 467 468
6d1 14 :3 0 46b
0 473 6d1 7
:3 0 88 :2 0 298
46c 46e :6 0 89
:3 0 470 29a 472
46f :2 0 1 87
473 46b :4 0 14
:3 0 476 0 47c
6d1 f :3 0 477
:7 0 89 :3 0 479
29c 47b 478 :2 0
1 8a 47c 476
:4 0 2a0 10c9 0
29e 87 :3 0 47f
:7 0 482 480 0
6d1 0 8b :6 0
8e :2 0 2a2 87
:3 0 484 :7 0 487
485 0 6d1 0
8c :6 0 8a :3 0
489 :7 0 48c 48a
0 6d1 0 8d
:6 0 22 :2 0 2a6
7 :3 0 2a4 48e
490 :6 0 493 491
0 6d1 0 1f
:6 0 8e :2 0 2aa
7 :3 0 2a8 495
497 :6 0 49a 498
0 6d1 0 21
:6 0 26 :2 0 2ae
7 :3 0 2ac 49c
49e :6 0 4a1 49f
0 6d1 0 8f
:6 0 2b4 1171 0
2b2 7 :3 0 2b0
4a3 4a5 :6 0 4a8
4a6 0 6d1 0
25 :6 0 2b8 11a5
0 2b6 f :3 0
4aa :7 0 4ad 4ab
0 6d1 0 90
:6 0 92 :3 0 4af
:7 0 4b2 4b0 0
6d1 0 91 :6 0
2bc 11d9 0 2ba
92 :3 0 4b4 :7 0
4b7 4b5 0 6d1
0 93 :6 0 18
:3 0 4b9 :7 0 4bc
4ba 0 6d1 0
2b :6 0 2c0 120d
0 2be f :3 0
4be :7 0 4c1 4bf
0 6d1 0 30
:6 0 f :3 0 4c3
:7 0 4c6 4c4 0
6d1 0 31 :6 0
2c4 1241 0 2c2
f :3 0 4c8 :7 0
4cb 4c9 0 6d1
0 32 :6 0 f
:3 0 4cd :7 0 4d0
4ce 0 6d1 0
33 :6 0 39 :2 0
2c6 f :3 0 4d2
:7 0 4d5 4d3 0
6d1 0 34 :6 0
f :3 0 4d7 :7 0
10 :3 0 4db 4d8
4d9 6d1 0 35
:6 0 39 :2 0 2ca
7 :3 0 2c8 4dd
4df :6 0 4e2 4e0
0 6d1 0 38
:6 0 2d0 12b3 0
2ce 7 :3 0 2cc
4e4 4e6 :6 0 4e9
4e7 0 6d1 0
3a :6 0 8 :3 0
f :3 0 4eb :7 0
4ee 4ec 0 6d1
0 3b :6 0 3c
:2 0 2d2 4f0 4f1
:3 0 4f2 :2 0 3b
:3 0 3d :3 0 3e
:3 0 8 :3 0 2d4
4f6 4f8 3f :4 0
2d6 4f5 4fb 4f4
4fc 0 54a 3b
:3 0 40 :2 0 41
:2 0 2db 4ff 501
:3 0 502 :2 0 38
:3 0 42 :3 0 8
:3 0 41 :2 0 3b
:3 0 43 :2 0 41
:2 0 2de 509 50b
:3 0 2e1 505 50d
504 50e 0 53d
3a :3 0 44 :3 0
45 :3 0 511 512
0 38 :3 0 2e5
513 515 510 516
0 53d 3b :3 0
3d :3 0 3e :3 0
8 :3 0 2e7 51a
51c 46 :4 0 2e9
519 51f 47 :2 0
41 :2 0 2ec 521
523 :3 0 518 524
0 53d 38 :3 0
42 :3 0 8 :3 0
3b :3 0 48 :3 0
8 :3 0 2ef 52a
52c 43 :2 0 3b
:3 0 2f1 52e 530
:3 0 2f4 527 532
526 533 0 53d
3a :3 0 44 :3 0
45 :3 0 536 537
0 38 :3 0 2f8
538 53a 535 53b
0 53d 2fa 547
3a :3 0 44 :3 0
45 :3 0 53f 540
0 8 :3 0 300
541 543 53e 544
0 546 302 548
503 53d 0 549
0 546 0 549
304 0 54a 307
54b 4f3 54a 0
54c 30a 0 6cf
21 :3 0 56 :4 0
54d 54e 0 6cf
35 :3 0 57 :3 0
50 :2 0 58 :3 0
551 553 0 30e
552 555 :3 0 21
:3 0 21 :3 0 4a
:2 0 59 :4 0 311
559 55b :3 0 557
55c 0 561 35
:3 0 5a :2 0 55e
55f 0 561 314
572 21 :3 0 21
:3 0 4a :2 0 4e
:4 0 317 564 566
:3 0 4a :2 0 35
:3 0 31a 568 56a
:3 0 4a :2 0 59
:4 0 31d 56c 56e
:3 0 562 56f 0
571 320 573 556
561 0 574 0
571 0 574 322
0 6cf 25 :3 0
44 :3 0 49 :3 0
576 577 0 6
:3 0 325 578 57a
4a :2 0 4b :4 0
327 57c 57e :3 0
4a :2 0 44 :3 0
4c :3 0 581 582
0 8 :3 0 32a
583 585 32c 580
587 :3 0 575 588
0 6cf 1f :3 0
69 :4 0 4a :2 0
21 :3 0 32f 58c
58e :3 0 4a :2 0
94 :4 0 332 590
592 :3 0 4a :2 0
44 :3 0 4c :3 0
595 596 0 25
:3 0 335 597 599
337 594 59b :3 0
4a :2 0 6b :4 0
33a 59d 59f :3 0
58a 5a0 0 6cf
67 :3 0 68 :3 0
1f :3 0 90 :3 0
5a4 5a5 :3 0 5a6
:2 0 6cf 90 :3 0
50 :2 0 2d :2 0
33f 5a9 5ab :3 0
11 :3 0 2d :2 0
5ae :2 0 5b0 342
5b1 5ac 5b0 0
5b2 344 0 6cf
90 :3 0 35 :3 0
7e :2 0 348 5b5
5b6 :3 0 35 :3 0
90 :3 0 5b8 5b9
0 5bb 34b 5bc
5b7 5bb 0 5bd
34d 0 6cf 91
:3 0 95 :3 0 90
:3 0 73 :2 0 35
:3 0 34f 5c1 5c3
:3 0 352 5bf 5c5
5be 5c6 0 6cf
93 :3 0 41 :2 0
5c8 5c9 0 6cf
8f :3 0 96 :4 0
4a :2 0 93 :3 0
354 5cd 5cf :3 0
5cb 5d0 0 6cf
97 :3 0 98 :2 0
35 :3 0 79 :3 0
5d3 5d4 :2 0 5d2
5d6 93 :3 0 93
:3 0 47 :2 0 91
:3 0 357 5da 5dc
:3 0 5d8 5dd 0
5ea 8f :3 0 8f
:3 0 4a :2 0 4e
:4 0 35a 5e1 5e3
:3 0 4a :2 0 93
:3 0 35d 5e5 5e7
:3 0 5df 5e8 0
5ea 360 5ec 79
:3 0 5d7 5ea :4 0
6cf 8f :3 0 8f
:3 0 4a :2 0 4e
:4 0 363 5ef 5f1
:3 0 4a :2 0 90
:3 0 366 5f3 5f5
:3 0 4a :2 0 99
:4 0 369 5f7 5f9
:3 0 5ed 5fa 0
6cf 1f :3 0 9a
:4 0 4a :2 0 21
:3 0 36c 5fe 600
:3 0 4a :2 0 9b
:4 0 36f 602 604
:3 0 4a :2 0 44
:3 0 4c :3 0 607
608 0 25 :3 0
372 609 60b 374
606 60d :3 0 4a
:2 0 9c :4 0 377
60f 611 :3 0 4a
:2 0 44 :3 0 4c
:3 0 614 615 0
8f :3 0 37a 616
618 37c 613 61a
:3 0 4a :2 0 9d
:4 0 37f 61c 61e
:3 0 5fc 61f 0
6cf 67 :3 0 68
:3 0 1f :3 0 9e
:3 0 9f :3 0 8b
:3 0 8d :3 0 623
629 :2 0 1 382
:3 0 628 :2 0 6cf
8b :3 0 a0 :3 0
62b 62c 0 35
:3 0 50 :2 0 387
62f 630 :3 0 631
:2 0 8b :3 0 a1
:3 0 633 634 0
41 :2 0 38a 635
637 :2 0 64a 8b
:3 0 8b :3 0 a2
:3 0 63a 63b 0
38c 639 63d 8b
:3 0 8b :3 0 a2
:3 0 640 641 0
43 :2 0 41 :2 0
38e 643 645 :3 0
391 63f 647 63e
648 0 64a 393
64b 632 64a 0
64c 396 0 6cf
2b :3 0 8b :3 0
8b :3 0 a2 :3 0
64f 650 0 398
64e 652 64d 653
0 6cf 70 :3 0
71 :3 0 655 656
0 2b :3 0 30
:3 0 31 :3 0 32
:3 0 33 :3 0 34
:3 0 39a 657 65e
:2 0 6cf 34 :3 0
34 :3 0 47 :2 0
41 :2 0 3a1 662
664 :3 0 660 665
0 6cf 2b :3 0
70 :3 0 72 :3 0
668 669 0 30
:3 0 31 :3 0 32
:3 0 33 :3 0 34
:3 0 3a4 66a 670
667 671 0 6cf
8b :3 0 8b :3 0
a2 :3 0 674 675
0 3aa 673 677
2b :3 0 678 679
0 6cf 1f :3 0
74 :4 0 4a :2 0
44 :3 0 45 :3 0
67e 67f 0 b
:3 0 3ac 680 682
3ae 67d 684 :3 0
4a :2 0 75 :4 0
3b1 686 688 :3 0
67b 689 0 6cf
8c :3 0 87 :4 0
68c 68d :3 0 68b
68e 0 6cf 8c
:3 0 a1 :3 0 690
691 0 35 :3 0
3b4 692 694 :2 0
6cf 97 :3 0 41
:2 0 35 :3 0 79
:3 0 697 698 :2 0
696 69a 8c :3 0
97 :3 0 3b6 69c
69e 8b :3 0 97
:3 0 47 :2 0 41
:2 0 3b8 6a2 6a4
:3 0 3bb 6a0 6a6
69f 6a7 0 6a9
3bd 6ab 79 :3 0
69b 6a9 :4 0 6cf
97 :3 0 41 :2 0
35 :3 0 79 :3 0
6ad 6ae :2 0 6ac
6b0 67 :3 0 68
:3 0 1f :3 0 7c
:3 0 8b :3 0 97
:3 0 3bf 6b6 6b8
6b9 8c :3 0 97
:3 0 3c1 6bb 6bd
6be 6b4 0 6c1
:2 0 3c3 6c0 :2 0
6c3 3c6 6c5 79
:3 0 6b1 6c3 :4 0
6cf a3 :3 0 a4
:3 0 6c9 6ca :2 0
6cb a3 :5 0 6c8
:2 0 6cf 11 :3 0
35 :3 0 6cd :2 0
6cf 3c8 6d2 :3 0
6d2 3e5 6d2 6d1
6cf 6d0 :6 0 6d3
1 0 450 464
6d2 925 :2 0 4
:3 0 a5 :a 0 739
9 1504 :3 0 6f2
:2 0 6dc 6dd 0
3fd a7 :3 0 a6
:7 0 6d9 6d8 :3 0
401 197e 0 3ff
a9 :3 0 aa :2 0
4 a8 :7 0 6df
6de :3 0 405 :2 0
403 7 :3 0 ab
:7 0 6e3 6e2 :3 0
7 :3 0 ac :7 0
6e7 6e6 :3 0 11
:3 0 ad :3 0 ae
:3 0 af :3 0 a6
:3 0 1004 6ee 0
6f0 1104 6ef :3 0
b0 :3 0 1504 6ef
:3 0 6e9 6eb 0
739 6d6 6f3 :2 0
12 :3 0 13 :4 0
6f6 6f7 737 40c
19fa 0 40a 18
:3 0 6fa :7 0 6fd
6fb 0 737 0
2a :6 0 413 :2 0
40e 18 :3 0 6ff
:7 0 702 700 0
737 0 b1 :6 0
f :3 0 704 :7 0
707 705 0 737
0 b2 :6 0 79
:3 0 a6 :3 0 2a
:3 0 b1 :4 0 70d
:2 0 727 709 70e
:3 0 410 :3 0 7a
:3 0 a6 :3 0 7b
:3 0 710 711 :4 0
712 :3 0 727 b2
:3 0 b3 :3 0 a8
:3 0 ab :3 0 ac
:3 0 2a :3 0 b1
:3 0 715 71b 714
71c 0 727 a3
:3 0 720 721 :2 0
722 a3 :5 0 71f
:2 0 727 b4 :3 0
b5 :3 0 b2 :3 0
725 :2 0 727 419
729 79 :4 0 727
:4 0 735 b6 :3 0
a6 :4 0 72d :2 0
735 72b 0 a3
:3 0 730 731 :2 0
732 a3 :5 0 72f
:2 0 735 11 :6 0
735 41f 738 :3 0
738 424 738 737
735 736 :6 0 739
1 0 6d6 6f3
738 925 :2 0 4
:3 0 b3 :a 0 77f
b :7 0 42b 1b2d
0 429 a9 :3 0
aa :2 0 4 73e
73f 0 a8 :7 0
741 740 :3 0 42f
1b53 0 42d 7
:3 0 ab :7 0 745
744 :3 0 7 :3 0
ac :7 0 749 748
:3 0 433 :2 0 431
7 :3 0 2a :7 0
74d 74c :3 0 7
:3 0 b1 :7 0 751
750 :3 0 11 :3 0
f :3 0 753 755
0 77f 73c 756
:2 0 b7 :3 0 b8
:3 0 75d 75f 77e
0 1 0 1022
77f :5 0 b9 :3 0
ba :2 0 1 ba
:4 0 bb :3 0 bc
:3 0 bd :3 0 be
:3 0 bd :5 0 a8
:3 0 a8 0 1010
1c bf :3 0 c0
:3 0 ab :2 0 14
c1 :3 0 ab 0
10 0 bf :3 0
ac :2 0 14 c1
:3 0 ac 0 10
0 bf :3 0 2a
:2 0 14 c1 :3 0
2a 0 10 0
bf :3 0 b1 :2 0
14 c1 :3 0 b1
0 10 0 bf
:3 0 11 :3 0 bf
:3 0 10 0 11
:3 0 c2 :4 0 13
439 73c 756 75a
925 4 :3 0 c3
:a 0 7e4 c 1504
:3 0 79d :2 0 787
788 0 447 a7
:3 0 a6 :7 0 784
783 :3 0 44b 1c70
0 449 a9 :3 0
aa :2 0 4 a8
:7 0 78a 789 :3 0
44f :2 0 44d 7
:3 0 c4 :7 0 78e
78d :3 0 7 :3 0
ac :7 0 792 791
:3 0 11 :3 0 ad
:3 0 ae :3 0 af
:3 0 a6 :3 0 1004
799 0 79b 1104
79a :3 0 b0 :3 0
1504 79a :3 0 794
796 0 7e4 781
79e :2 0 12 :3 0
13 :4 0 7a1 7a2
7e2 456 1cec 0
454 18 :3 0 7a5
:7 0 7a8 7a6 0
7e2 0 2a :6 0
45d :2 0 458 18
:3 0 7aa :7 0 7ad
7ab 0 7e2 0
b1 :6 0 f :3 0
7af :7 0 7b2 7b0
0 7e2 0 b2
:6 0 79 :3 0 a6
:3 0 2a :3 0 b1
:4 0 7b8 :2 0 7d2
7b4 7b9 :3 0 45a
:3 0 7a :3 0 a6
:3 0 7b :3 0 7bb
7bc :4 0 7bd :3 0
7d2 b2 :3 0 c5
:3 0 a8 :3 0 c4
:3 0 ac :3 0 2a
:3 0 b1 :3 0 7c0
7c6 7bf 7c7 0
7d2 a3 :3 0 7cb
7cc :2 0 7cd a3
:5 0 7ca :2 0 7d2
b4 :3 0 b5 :3 0
b2 :3 0 7d0 :2 0
7d2 463 7d4 79
:4 0 7d2 :4 0 7e0
b6 :3 0 a6 :4 0
7d8 :2 0 7e0 7d6
0 a3 :3 0 7db
7dc :2 0 7dd a3
:5 0 7da :2 0 7e0
11 :6 0 7e0 469
7e3 :3 0 7e3 46e
7e3 7e2 7e0 7e1
:6 0 7e4 1 0
781 79e 7e3 925
:2 0 4 :3 0 c5
:a 0 82a e :7 0
475 1e1f 0 473
a9 :3 0 aa :2 0
4 7e9 7ea 0
a8 :7 0 7ec 7eb
:3 0 479 1e45 0
477 7 :3 0 c4
:7 0 7f0 7ef :3 0
7 :3 0 ac :7 0
7f4 7f3 :3 0 47d
:2 0 47b 7 :3 0
2a :7 0 7f8 7f7
:3 0 7 :3 0 b1
:7 0 7fc 7fb :3 0
11 :3 0 f :3 0
7fe 800 0 82a
7e7 801 :2 0 b7
:3 0 b8 :3 0 808
80a 829 0 1
0 1022 82a :5 0
b9 :3 0 c6 :2 0
1 c6 :4 0 bb
:3 0 bc :3 0 bd
:3 0 be :3 0 bd
:5 0 a8 :3 0 a8
0 1010 1c bf
:3 0 c0 :3 0 c4
:2 0 14 c1 :3 0
c4 0 10 0
bf :3 0 ac :2 0
14 c1 :3 0 ac
0 10 0 bf
:3 0 2a :2 0 14
c1 :3 0 2a 0
10 0 bf :3 0
b1 :2 0 14 c1
:3 0 b1 0 10
0 bf :3 0 11
:3 0 bf :3 0 10
0 11 :3 0 c2
:4 0 13 483 7e7
801 805 925 4
:3 0 c7 :a 0 8b0
f 1504 :3 0 850
:2 0 832 833 0
491 a7 :3 0 a6
:7 0 82f 82e :3 0
495 1f62 0 493
a9 :3 0 aa :2 0
4 a8 :7 0 835
834 :3 0 499 1f88
0 497 7 :3 0
c8 :7 0 839 838
:3 0 7 :3 0 ac
:7 0 83d 83c :3 0
49d :2 0 49b f
:3 0 c9 :7 0 841
840 :3 0 7 :3 0
ca :7 0 845 844
:3 0 11 :3 0 cb
:3 0 ae :3 0 af
:3 0 a6 :3 0 1004
84c 0 84e 1104
84d :3 0 b0 :3 0
1504 84d :3 0 847
849 0 8b0 82c
851 :2 0 12 :3 0
13 :4 0 854 855
8ae 4a6 2004 0
4a4 f :3 0 858
:7 0 85b 859 0
8ae 0 cc :6 0
4aa 2038 0 4a8
f :3 0 85d :7 0
860 85e 0 8ae
0 cd :6 0 f
:3 0 862 :7 0 865
863 0 8ae 0
ce :6 0 4ae 206c
0 4ac f :3 0
867 :7 0 86a 868
0 8ae 0 cf
:6 0 f :3 0 86c
:7 0 86f 86d 0
8ae 0 19 :6 0
79 :3 0 f :3 0
871 :7 0 874 872
0 8ae 0 d0
:6 0 a6 :3 0 cc
:3 0 cd :3 0 ce
:4 0 87b :2 0 89e
876 87c :3 0 4b0
:3 0 7a :3 0 a6
:3 0 7b :3 0 87e
87f :4 0 880 :3 0
89e d1 :3 0 a8
:3 0 c8 :3 0 ac
:3 0 cc :3 0 cd
:3 0 ce :3 0 c9
:3 0 ca :3 0 cf
:3 0 19 :3 0 d0
:3 0 4b4 882 88e
:2 0 89e a3 :3 0
892 893 :2 0 894
a3 :5 0 891 :2 0
89e b4 :3 0 b5
:3 0 d2 :3 0 cf
:3 0 19 :3 0 d0
:3 0 4c0 897 89b
89c :2 0 89e 4c4
8a0 79 :4 0 89e
:4 0 8ac b6 :3 0
a6 :4 0 8a4 :2 0
8ac 8a2 0 a3
:3 0 8a7 8a8 :2 0
8a9 a3 :5 0 8a6
:2 0 8ac 11 :6 0
8ac 4ca 8af :3 0
8af 4cf 8af 8ae
8ac 8ad :6 0 8b0
1 0 82c 851
8af 925 :2 0 d1
:a 0 920 11 :7 0
4d9 21a6 0 4d7
a9 :3 0 aa :2 0
4 8b4 8b5 0
a8 :7 0 8b7 8b6
:3 0 4dd 21cc 0
4db 7 :3 0 c8
:7 0 8bb 8ba :3 0
7 :3 0 ac :7 0
8bf 8be :3 0 4e1
21f2 0 4df f
:3 0 cc :7 0 8c3
8c2 :3 0 f :3 0
cd :7 0 8c7 8c6
:3 0 4e5 2218 0
4e3 f :3 0 ce
:7 0 8cb 8ca :3 0
f :3 0 c9 :7 0
8cf 8ce :3 0 4e9
2241 0 4e7 7
:3 0 ca :7 0 8d3
8d2 :3 0 d3 :3 0
f :3 0 cf :6 0
8d8 8d7 :3 0 4ed
:2 0 4eb d3 :3 0
f :3 0 19 :6 0
8dd 8dc :3 0 d3
:3 0 f :3 0 d0
:6 0 8e2 8e1 :3 0
8e4 :2 0 920 8b2
8e5 :2 0 b7 :3 0
b8 :3 0 8ec 8ee
91f 0 1 0
1022 920 :5 0 b9
:3 0 d4 :2 0 1
d4 :4 0 bb :3 0
bc :3 0 bd :3 0
be :3 0 bd :5 0
a8 :3 0 a8 0
1010 1c bf :3 0
c0 :3 0 c8 :2 0
14 c1 :3 0 c8
0 10 0 bf
:3 0 ac :2 0 14
c1 :3 0 ac 0
10 0 bf :3 0
cc :2 0 13 c2
:3 0 cc 0 10
0 bf :3 0 cd
:2 0 13 c2 :3 0
cd 0 10 0
bf :3 0 ce :2 0
13 c2 :3 0 ce
0 10 0 bf
:3 0 c9 :2 0 13
c2 :3 0 c9 0
10 0 bf :3 0
ca :2 0 14 c1
:3 0 ca 0 10
0 bf :3 0 cf
:2 0 13 c2 :3 0
cf 0 10 0
bf :3 0 19 :2 0
13 c2 :3 0 19
0 10 0 bf
:3 0 d0 :2 0 13
c2 :3 0 d0 0
10 0 bf :3 0
4f9 8b2 8e5 8e9
925 0 924 0
924 :3 0 924 925
922 923 :6 0 926
:2 0 511 0 3
924 929 :3 0 928
926 92a :8 0 
51a
4
:3 0 1 6 1
a 1 e 1
12 1 16 1
1a 1 1e 1
22 1 26 :2 9
d 11 15 19
1d 21 25 29
1 36 1 3b
2 3a 3f 1
48 1 4d 1
54 1 52 1
5b 1 59 1
62 1 60 1
69 1 67 1
6e 1 73 1
78 1 7d 1
82 1 87 1
8d 1 93 1
99 1 9e 1
a3 1 a8 1
ad 1 b2 1
ba 1 b8 1
c1 1 bf 1
c8 1 c6 1
cd 1 d2 1
da 2 dc dd
1 e3 2 e1
e3 2 eb ed
3 e9 ea ef
1 f7 1 fe
2 100 101 2
103 105 1 10e
2 110 112 3
10b 10c 114 1
11c 5 f2 fa
108 117 11f 1
125 1 128 2
12a 12b 2 e0
12c 1 12e 1
134 2 136 138
1 13f 2 13a
141 1 14c 1
157 1 162 2
167 169 2 16b
16d 1 172 2
16f 174 1 17a
2 178 17a 1
182 1 185 1
18b 1 18e 2
190 191 1 195
2 193 195 1
19d 1 1a0 1
1a2 1 1ab 2
1a7 1ab 2 1af
1b1 2 1b4 1b7
2 1ba 1bc 2
1be 1c0 2 1c2
1c4 1 1c7 2
1c9 1ca 1 1d2
2 1cd 1d4 2
1d6 1d8 1 1de
2 1dc 1de 2
1e3 1e5 1 1ec
2 1e7 1ee 1
1f1 1 1f3 2
1f6 1f8 2 1fa
1fc 2 1fe 200
1 206 2 204
206 2 20a 20c
1 213 2 20e
215 1 218 1
220 2 21b 222
1 225 2 227
228 2 22b 22d
1 234 2 22f
236 2 238 23a
2 23c 23e 1
245 2 240 247
2 249 24b 1
252 2 24d 254
2 256 258 1
25f 2 25a 261
2 263 265 2
26f 271 2 273
275 1 27c 2
277 27e 2 280
282 2 289 28a
1 290 2 28e
290 1 293 1
29f 2 29a 2a1
3 2a4 2a9 2ac
1 2ae 1 2b2
2 2b0 2b2 1
2bb 2 2b6 2bd
4 2c8 2c9 2ca
2cb 3 2c0 2c5
2ce 1 2d0 2
2d3 2d5 2 2d7
2d9 1 2e0 2
2db 2e2 2 2e4
2e6 6 2f3 2f4
2f5 2f6 2f7 2f8
2 2fc 2fe 5
306 307 308 309
30a 2 30f 311
1 31e 2 319
320 2 322 324
2 329 32b 2
32d 32f 1 336
2 331 338 2
33a 33c 1 351
2 34f 351 1
356 2 354 356
2 35e 362 2
367 369 2 36e
370 2 377 379
2 375 37c 5
365 36c 373 37f
382 1 384 2
391 393 4 385
38a 38f 396 2
399 39d 1 3a0
2 39f 3a0 2
3a5 3a9 2 3ae
3b0 2 3ac 3b3
2 3b7 3bb 1
3be 2 3bd 3be
2 3c4 3c7 2
3cf 3d3 2 3d8
3da 2 3df 3e1
2 3e8 3ea 2
3e6 3ed 7 3d6
3dd 3e4 3f0 3f5
3fa 3fd 4 3ff
3b6 3c9 400 2
403 406 1 408
2 402 408 2
410 412 2 415
417 1 419 4
348 34e 401 41a
1 424 2 41f
426 25 12f 144
147 14f 152 15a
15d 165 177 192
1a3 1a6 1cb 1db
1f4 203 229 268
26d 285 28d 2af
2d1 2e9 2ef 2fa
301 30d 314 317
327 33f 344 41d
429 42e 431 1
43b 2 43e 440
4 438 439 43d
442 2 444 446
1 434 1 449
1b 32 41 47
4b 50 57 5e
65 6c 71 76
7b 80 85 8b
91 97 9c a1
a6 ab b0 b6
bd c4 cb d0
1 451 1 455
1 459 1 45d
4 454 458 45c
460 1 46d 1
471 1 47a 1
47e 1 483 1
488 1 48f 1
48d 1 496 1
494 1 49d 1
49b 1 4a4 1
4a2 1 4a9 1
4ae 1 4b3 1
4b8 1 4bd 1
4c2 1 4c7 1
4cc 1 4d1 1
4d6 1 4de 1
4dc 1 4e5 1
4e3 1 4ea 1
4ef 1 4f7 2
4f9 4fa 1 500
2 4fe 500 2
508 50a 3 506
507 50c 1 514
1 51b 2 51d
51e 2 520 522
1 52b 2 52d
52f 3 528 529
531 1 539 5
50f 517 525 534
53c 1 542 1
545 2 547 548
2 4fd 549 1
54b 1 554 2
550 554 2 558
55a 2 55d 560
2 563 565 2
567 569 2 56b
56d 1 570 2
572 573 1 579
2 57b 57d 1
584 2 57f 586
2 58b 58d 2
58f 591 1 598
2 593 59a 2
59c 59e 1 5aa
2 5a8 5aa 1
5af 1 5b1 1
5b4 2 5b3 5b4
1 5ba 1 5bc
2 5c0 5c2 1
5c4 2 5cc 5ce
2 5d9 5db 2
5e0 5e2 2 5e4
5e6 2 5de 5e9
2 5ee 5f0 2
5f2 5f4 2 5f6
5f8 2 5fd 5ff
2 601 603 1
60a 2 605 60c
2 60e 610 1
617 2 612 619
2 61b 61d 2
626 627 1 62e
2 62d 62e 1
636 1 63c 2
642 644 1 646
2 638 649 1
64b 1 651 6
658 659 65a 65b
65c 65d 2 661
663 5 66b 66c
66d 66e 66f 1
676 1 681 2
67c 683 2 685
687 1 693 1
69d 2 6a1 6a3
1 6a5 1 6a8
1 6b7 1 6bc
2 6ba 6bf 1
6c2 1c 54c 54f
574 589 5a1 5a7
5b2 5bd 5c7 5ca
5d1 5ec 5fb 620
62a 64c 654 65f
666 672 67a 68a
68f 695 6ab 6c5
6cb 6ce 17 469
474 47d 481 486
48b 492 499 4a0
4a7 4ac 4b1 4b6
4bb 4c0 4c5 4ca
4cf 4d4 4da 4e1
4e8 4ed 1 6d7
1 6db 1 6e1
1 6e5 4 6da
6e0 6e4 6e8 1
6f9 1 6fe 1
703 2 70a 70b
5 716 717 718
719 71a 5 70c
713 71d 722 726
4 729 72c 732
734 4 6f8 6fc
701 706 1 73d
1 743 1 747
1 74b 1 74f
5 742 746 74a
74e 752 d 763
764 765 768 76a
76c 76e 770 772
774 776 77a 77d
1 782 1 786
1 78c 1 790
4 785 78b 78f
793 1 7a4 1
7a9 1 7ae 2
7b5 7b6 5 7c1
7c2 7c3 7c4 7c5
5 7b7 7be 7c8
7cd 7d1 4 7d4
7d7 7dd 7df 4
7a3 7a7 7ac 7b1
1 7e8 1 7ee
1 7f2 1 7f6
1 7fa 5 7ed
7f1 7f5 7f9 7fd
d 80e 80f 810
813 815 817 819
81b 81d 81f 821
825 828 1 82d
1 831 1 837
1 83b 1 83f
1 843 6 830
836 83a 83e 842
846 1 857 1
85c 1 861 1
866 1 86b 1
870 3 877 878
879 b 883 884
885 886 887 888
889 88a 88b 88c
88d 3 898 899
89a 5 87a 881
88f 894 89d 4
8a0 8a3 8a9 8ab
7 856 85a 85f
864 869 86e 873
1 8b3 1 8b9
1 8bd 1 8c1
1 8c5 1 8c9
1 8cd 1 8d1
1 8d5 1 8da
1 8df b 8b8
8bc 8c0 8c4 8c8
8cc 8d0 8d4 8d9
8de 8e3 17 8f2
8f3 8f4 8f7 8f9
8fb 8fd 8ff 901
903 905 907 909
90b 90d 90f 911
913 915 917 919
91b 91d 8 44d
6d3 739 77f 7e4
82a 8b0 920 
1
4
0 
929
0
1
14
11
7a
0 1 2 2 1 5 5 5
1 9 1 1 c 1 1 f
1 0 0 0 
22 2 0
3 0 1
488 5 0
7ee e 0
78c c 0
476 5 0
7ae c 0
703 9 0
494 5 0
59 2 0
4d 2 0
4b3 5 0
4d6 5 0
b2 2 0
8b3 11 0
831 f 0
7e8 e 0
786 c 0
73d b 0
6db 9 0
e 2 0
4a2 5 0
49b 5 0
459 5 0
67 2 0
16 2 0
43 2 0
48 2 0
8d1 11 0
843 f 0
8d5 11 0
866 f 0
451 5 0
78 2 0
6 2 0
450 1 5
34 2 3
4cc 5 0
a8 2 0
1a 2 0
4a9 5 0
82d f 0
782 c 0
6d7 9 0
4ea 5 0
cd 2 0
7f6 e 0
7a4 c 0
74b b 0
6f9 9 0
7d 2 0
8df 11 0
870 f 0
7fa e 0
7a9 c 0
74f b 0
6fe 9 0
4e3 5 0
c6 2 0
6d6 1 9
48d 5 0
52 2 0
12 2 0
8b2 1 11
36 3 0
8c1 11 0
857 f 0
82c 1 f
60 2 0
8b9 11 0
837 f 0
8da 11 0
86b f 0
455 5 0
3b 3 0
6e 2 0
a 2 0
7e7 1 e
8cd 11 0
83f f 0
8bd 11 0
83b f 0
7f2 e 0
790 c 0
747 b 0
6e5 9 0
73c 1 b
4b8 5 0
82 2 0
8c5 11 0
85c f 0
743 b 0
6e1 9 0
45d 5 0
26 2 0
781 1 c
73 2 0
47e 5 0
46b 5 0
4bd 5 0
99 2 0
b8 2 0
6ac 8 0
696 7 0
5d2 6 0
4ae 5 0
4d1 5 0
ad 2 0
8c9 11 0
861 f 0
483 5 0
93 2 0
1e 2 0
5 1 2
8d 2 0
4c2 5 0
9e 2 0
87 2 0
4dc 5 0
bf 2 0
4c7 5 0
a3 2 0
0

/
show errors;
GRANT EXECUTE ON sdo_numtab TO PUBLIC;
GRANT EXECUTE ON sdo_stat TO PUBLIC;
GRANT EXECUTE ON sdo_stattab TO PUBLIC;
GRANT EXECUTE ON sdo_pridx TO PUBLIC;
