create table OGIS_SPATIAL_REFERENCE_SYSTEMS (
   SRID        NUMBER CONSTRAINT pk_srid PRIMARY KEY,
   AUTH_NAME   VARCHAR2(100),
   AUTH_SRID   NUMBER,
   SRTEXT      VARCHAR2(1000),
   SRNUM       NUMBER
);
create table OGIS_GEOMETRY_COLUMNS (
   F_TABLE_SCHEMA       VARCHAR2(64),
   F_TABLE_NAME         VARCHAR2(64),
   F_GEOMETRY_COLUMN    VARCHAR2(64),
   G_TABLE_SCHEMA       VARCHAR2(64),
   G_TABLE_NAME         VARCHAR2(64),
   STORAGE_TYPE         NUMBER,
   GEOMETRY_TYPE        NUMBER,
   COORD_DIMENSION      NUMBER,
   MAX_PPR              NUMBER,
   SRID                 CONSTRAINT fk_srid
                        REFERENCES OGIS_SPATIAL_REFERENCE_SYSTEMS(SRID)
);
commit;
create or replace view DBA_GEOMETRY_COLUMNS as select * from OGIS_GEOMETRY_COLUMNS;
grant select on DBA_GEOMETRY_COLUMNS to select_catalog_role;
drop public synonym DBA_GEOMETRY_COLUMNS;
create public synonym DBA_GEOMETRY_COLUMNS for mdsys.DBA_GEOMETRY_COLUMNS;
create or replace view ALL_GEOMETRY_COLUMNS as 
select * from OGIS_GEOMETRY_COLUMNS where
(exists (select table_name from all_tables
         where table_name=f_table_name and owner=f_table_schema)
 or
 exists (select view_name from all_views
         where view_name=f_table_name and owner=f_table_schema)
 or
 exists (select table_name from all_object_tables
         where table_name=f_table_name and owner=f_table_schema)
)
and 
(exists (select table_name from all_tables
         where table_name=g_table_name and owner=g_table_schema)
 or
 exists (select view_name from all_views
         where view_name=g_table_name and owner=g_table_schema)
 or
 exists (select table_name from all_object_tables
         where table_name=g_table_name and owner=g_table_schema)
);
grant select on ALL_GEOMETRY_COLUMNS to public;
drop public synonym ALL_GEOMETRY_COLUMNS;
create public synonym ALL_GEOMETRY_COLUMNS for mdsys.ALL_GEOMETRY_COLUMNS;
create or replace view USER_GEOMETRY_COLUMNS as
select * from OGIS_GEOMETRY_COLUMNS
where f_table_schema=user and g_table_schema=user;
grant select on USER_GEOMETRY_COLUMNS to public;
drop public synonym USER_GEOMETRY_COLUMNS;
create public synonym USER_GEOMETRY_COLUMNS for mdsys.USER_GEOMETRY_COLUMNS;
grant select on OGIS_SPATIAL_REFERENCE_SYSTEMS to public;
drop public synonym OGIS_SPATIAL_REFERENCE_SYSTEMS;
create public synonym OGIS_SPATIAL_REFERENCE_SYSTEMS
for mdsys.OGIS_SPATIAL_REFERENCE_SYSTEMS;
commit;
create or replace package sdo_catalog wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
9
9200000
1
4
0 
18
2 :e:
1PACKAGE:
1SDO_CATALOG:
1AUTHID:
1DEFINER:
1INSERT_CATALOG:
1F_TABLE_SCHEMA:
1VARCHAR2:
1F_TABLE_NAME:
1F_GEOMETRY_COLUMN:
1G_TABLE_SCHEMA:
1G_TABLE_NAME:
1STORAGE_TYPE:
1NUMBER:
1GEOMETRY_TYPE:
1COORD_DIMENSION:
1MAX_PPR:
1SRID:
1UPDATE_CATALOG:
1F_SCHEMA_NAME:
1G_SCHEMA_NAME:
1COL:
1OLD_VALUE:
1NEW_VALUE:
1DELETE_CATALOG:
0

0
0
69
2
0 a0 97 :2 a0 9a 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d b4 55 6a
9a 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d b4 55 6a
9a 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d b4 55 6a
a0 :2 aa 59 58 1d 17 b5 
69
2
0 3 13 b f 1d 35 31
a 3d 4a 46 7 52 5b 57
45 63 70 6c 42 78 81 7d
6b 89 96 92 68 9e a7 a3
91 af bc b8 8e c4 cd c9
b7 d5 e2 de b4 ea dd ef
f3 f7 113 10f da 11b 124 120
10e 12c 139 135 10b 141 14a 146
134 152 15f 15b 131 167 170 16c
15a 178 185 181 157 18d 180 192
196 19a 1b6 1b2 17d 1be 1c7 1c3
1b1 1cf 1dc 1d8 1ae 1e4 1d7 1e9
1ed 1f1 1d4 1f5 1f7 1fa 1fd 1fe
207 
69
2
0 1 9 15 1c b 1a 2f
:3 1a 2f :3 1a 2f :3 1a 2f :3 1a 2f
:3 1a 2f :3 1a 2f :3 1a 2f :3 1a 2f
:3 1a 2f :2 1a 19 :2 1 b 1a 2c
:3 1a 2c :3 1a 2c :3 1a 2c :3 1a 2c
:3 1a 2c :3 1a 2c :2 1a 19 :2 1 b
1a 2f :3 1a 2f :3 1a 2f :2 1a 19
:2 1 5 :7 1 
69
4
0 :4 1 :5 7 :4 8
:4 9 :4 a :4 b :4 c
:4 d :4 e :4 f :4 10
:3 7 :5 1c :4 1d :4 1e
:4 1f :4 20 :4 21 :4 22
:3 1c :5 2a :4 2b :4 2c
:3 2a 2e :7 1 
209
4
:3 0 1 :3 0 5
42 0 :2 3 :3 0
4 :3 0 2 :6 0
1 :2 0 5 :a 0
30 2 :7 0 7
:3 0 6 :7 0 8
7 :3 0 9 68
0 :2 7 :3 0 8
:7 0 c b :3 0
7 :3 0 9 :7 0
10 f :3 0 d
8e 0 b 7
:3 0 a :7 0 14
13 :3 0 7 :3 0
b :7 0 18 17
:3 0 11 b4 0
f d :3 0 c
:7 0 1c 1b :3 0
d :3 0 e :7 0
20 1f :3 0 15
da 0 13 d
:3 0 f :7 0 24
23 :3 0 d :3 0
10 :7 0 28 27
:3 0 22 10b 0
17 d :3 0 11
:7 0 2c 2b :3 0
2e :2 0 30 5
2f 0 62 12
:a 0 50 3 :7 0
26 131 0 24
7 :3 0 13 :7 0
34 33 :3 0 7
:3 0 8 :7 0 38
37 :3 0 2a 157
0 28 7 :3 0
14 :7 0 3c 3b
:3 0 7 :3 0 b
:7 0 40 3f :3 0
2e 17d 0 2c
7 :3 0 15 :7 0
44 43 :3 0 7
:3 0 16 :7 0 48
47 :3 0 38 1ae
0 30 7 :3 0
17 :7 0 4c 4b
:3 0 4e :2 0 50
31 4f 0 62
18 :a 0 60 4
:7 0 3c 1d4 0
3a 7 :3 0 13
:7 0 54 53 :3 0
7 :3 0 8 :7 0
58 57 :3 0 42
64 0 3e 7
:3 0 9 :7 0 5c
5b :3 0 5e :2 0
60 51 5f 0
62 2 :4 0 64
62 63 65 2
64 67 0 66
65 68 :4 0 4
:3 0 
46
4
:3 0 1 6 1
a 1 e 1
12 1 16 1
1a 1 1e 1
22 1 26 1
2a a 9 d
11 15 19 1d
21 25 29 2d
1 32 1 36
1 3a 1 3e
1 42 1 46
1 4a 7 35
39 3d 41 45
49 4d 1 52
1 56 1 5a
3 55 59 5d
3 30 50 60

1
4
0 
67
0
1
14
4
18
0 1 1 1 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
42 3 0
12 2 0
2a 2 0
6 2 0
22 2 0
31 1 3
56 4 0
36 3 0
a 2 0
1e 2 0
26 2 0
4a 3 0
5 1 2
2 0 1
3a 3 0
52 4 0
32 3 0
51 1 4
46 3 0
3e 3 0
16 2 0
5a 4 0
e 2 0
1a 2 0
0

/
show errors;
commit;
