Rem
Rem $Header: sdocmprg.sql 21-jan-2004.10:45:51 sravada Exp $
Rem
Rem sdocmprg.sql
Rem
Rem Copyright (c) 2001, 2004, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      sdocmprg.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sravada     01/21/04 - add sdo_valid 
Rem    sravada     02/05/02 - update version to 9.2.0.1
Rem    sravada     10/23/01 - owner to schema
Rem    sravada     10/08/01 - Merged sravada_ship_it_ninertwo
Rem    sravada     10/08/01 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

declare 
cnt number;  
BEGIN
     -- there should be two indextypes (atleast)
     select count(*) into cnt from all_objects where status = 'VALID'
             and object_type = 'INDEXTYPE' 
             and OWNER='MDSYS';
          
     if cnt < 2 then
       dbms_registry.invalid('SDO');
       return;
     end if;
 
     -- there should be 14 operators (atleast)
     select count(*) into cnt from all_objects where status = 'VALID'
             and object_type = 'OPERATOR'
             and OWNER='MDSYS';
     if cnt < 14 then
       dbms_registry.invalid('SDO');
       return;
     end if;
     
     -- there should be 10 type bogies (atleast)
     select count(*) into cnt from all_objects where status = 'VALID'
             and object_type = 'TYPE BODY'
             and OWNER='MDSYS';
     if cnt < 10 then
       dbms_registry.invalid('SDO');
       return;
     end if;

     -- there should be 24 package bodies (atleast)
     select count(*) into cnt from all_objects where status = 'VALID'
             and object_type = 'PACKAGE BODY'
             and OWNER='MDSYS';
     if cnt < 24 then
       dbms_registry.invalid('SDO');
       return;
     end if;

   dbms_registry.loaded('SDO');
   dbms_registry.valid('SDO');

END;
/

select COMP_ID, SCHEMA, VERSION, STATUS, COMP_NAME
 from dba_registry where comp_id='SDO';

