Rem
Rem $Header: sdopatch.sql 11-may-2006.09:59:58 sravada Exp $
Rem $Header: sdopatch.sql 11-may-2006.09:59:58 sravada Exp $
Rem
Rem sdopatch.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdopatch.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sravada     05/11/06 - bug 5205589
Rem    jcwang      08/09/05 - backport:4447540
Rem    sravada     04/25/05 - bug 4329181 
Rem    sravada     04/13/05 - bug 4302830 
Rem    sravada     10/13/04 - bug 3948544 
Rem    sravada     10/11/04 - bug 3876537
Rem    rkothuri    09/23/04 - xbranchmerge to 'st_sdo_9.2.0.0.0' 
Rem    sravada     07/08/03 - add sdowktfx 
Rem    rkothuri    06/20/03 - 
Rem    sravada     05/20/03 - 9204 fixes
Rem    sravada     02/14/03 - bug 2802612
Rem    sravada     01/28/03 - 
Rem    rkothuri    12/27/02 - add changes from prvtsidx.plb 
Rem                           (prvtoper.plb changed already added)
Rem    sravada     12/19/02 - 
Rem    rkothuri    12/16/02 - Add sdo_root_mbr to index_metadata table
Rem    sravada     08/15/02 - remove echo on, add version
Rem    sravada     08/02/02 - 
Rem    sravada     07/17/02 - reset session back to sys
Rem    sravada     07/11/02 - sravada_add_sdopatch
Rem    sravada     07/11/02 - Created
Rem
Rem Run this script connect as SYS


ALTER SESSION SET CURRENT_SCHEMA = MDSYS;


EXECUTE dbms_registry.loading('SDO','Spatial',NULL,'MDSYS');               


-- Add this for OS partition query_performance
declare 
begin
   begin
    execute immediate 
  ' alter table sdo_index_metadata_table add 
   (sdo_root_mbr mdsys.sdo_geometry) ';
   exception when others then null;
   end;
end;
/


drop view user_sdo_index_metadata;
create view user_sdo_index_metadata as
 select SDO_INDEX_OWNER, SDO_INDEX_TYPE,
        SDO_INDEX_NAME, SDO_INDEX_TABLE, SDO_INDEX_PRIMARY,
        SDO_INDEX_PARTITION, SDO_PARTITIONED,
        SDO_TSNAME, SDO_COLUMN_NAME, SDO_INDEX_DIMS, 
        SDO_RTREE_HEIGHT, SDO_RTREE_NUM_NODES,
        SDO_RTREE_DIMENSIONALITY, SDO_RTREE_FANOUT,
        SDO_RTREE_ROOT, SDO_RTREE_SEQ_NAME,
        SDO_RTREE_PCTFREE, SDO_LAYER_GTYPE,
        SDO_LEVEL, SDO_NUMTILES, SDO_MAXLEVEL, SDO_COMMIT_INTERVAL,
        SDO_FIXED_META, SDO_TABLESPACE, SDO_INITIAL_EXTENT,
        SDO_NEXT_EXTENT, SDO_PCTINCREASE, SDO_MIN_EXTENTS,
        SDO_MAX_EXTENTS, SDO_RTREE_QUALITY, SDO_INDEX_VERSION,  
        SDO_INDEX_GEODETIC, SDO_INDEX_STATUS, SDO_ROOT_MBR
 from SDO_INDEX_METADATA_TABLE
 where
 (exists
   (select index_name from user_indexes, (select username from user_users)
    where index_name=sdo_index_name and
          username = sdo_index_owner));

drop view all_sdo_index_metadata;
create view all_sdo_index_metadata as
 select SDO_INDEX_OWNER, SDO_INDEX_TYPE,
        SDO_INDEX_NAME, SDO_INDEX_TABLE, SDO_INDEX_PRIMARY,
        SDO_INDEX_PARTITION, SDO_PARTITIONED,
        SDO_TSNAME, SDO_COLUMN_NAME,SDO_INDEX_DIMS, 
        SDO_RTREE_HEIGHT, SDO_RTREE_NUM_NODES,
        SDO_RTREE_DIMENSIONALITY, SDO_RTREE_FANOUT,
        SDO_RTREE_ROOT, SDO_RTREE_SEQ_NAME,
        SDO_RTREE_PCTFREE, SDO_LAYER_GTYPE,
        SDO_LEVEL, SDO_NUMTILES, SDO_MAXLEVEL, SDO_COMMIT_INTERVAL,
        SDO_FIXED_META, SDO_TABLESPACE, SDO_INITIAL_EXTENT,
        SDO_NEXT_EXTENT, SDO_PCTINCREASE, SDO_MIN_EXTENTS,
        SDO_MAX_EXTENTS, SDO_RTREE_QUALITY, SDO_INDEX_VERSION,
        SDO_INDEX_GEODETIC, SDO_INDEX_STATUS, SDO_ROOT_MBR
 from SDO_INDEX_METADATA_TABLE
 where
 (exists
   (select index_name from all_indexes
    where index_name=sdo_index_name and
          owner = sdo_index_owner));

drop view dba_sdo_index_metadata;
create view dba_sdo_index_metadata as
 select SDO_INDEX_OWNER, SDO_INDEX_TYPE,
        SDO_INDEX_NAME, SDO_INDEX_TABLE, SDO_INDEX_PRIMARY,
        SDO_INDEX_PARTITION, SDO_PARTITIONED,
        SDO_TSNAME, SDO_COLUMN_NAME, SDO_INDEX_DIMS,
        SDO_RTREE_HEIGHT, SDO_RTREE_NUM_NODES,
        SDO_RTREE_DIMENSIONALITY, SDO_RTREE_FANOUT,
        SDO_RTREE_ROOT, SDO_RTREE_SEQ_NAME,
        SDO_RTREE_PCTFREE, SDO_LAYER_GTYPE,
        SDO_LEVEL, SDO_NUMTILES, SDO_MAXLEVEL, SDO_COMMIT_INTERVAL,
        SDO_FIXED_META, SDO_TABLESPACE, SDO_INITIAL_EXTENT,
        SDO_NEXT_EXTENT, SDO_PCTINCREASE, SDO_MIN_EXTENTS,
        SDO_MAX_EXTENTS, SDO_RTREE_QUALITY, SDO_INDEX_VERSION,
        SDO_INDEX_GEODETIC, SDO_INDEX_STATUS, SDO_ROOT_MBR
 from SDO_INDEX_METADATA_TABLE
 where
 (exists
   (select index_name from dba_indexes
    where index_name=sdo_index_name));

grant select on user_sdo_index_metadata to public;
grant select on all_sdo_index_metadata to public;
grant select on dba_sdo_index_metadata to public;

drop public synonym sdo_index_metadata;
drop public synonym user_sdo_index_metadata;
drop public synonym all_sdo_index_metadata;
drop public synonym dba_sdo_index_metadata;

create public synonym sdo_index_metadata for mdsys.user_sdo_index_metadata;
create public synonym user_sdo_index_metadata for mdsys.user_sdo_index_metadata;
create public synonym dba_sdo_index_metadata for mdsys.dba_sdo_index_metadata;
create public synonym all_sdo_index_metadata for mdsys.all_sdo_index_metadata; 
commit;




alter view ALL_SDO_INDEX_INFO compile;
alter view USER_SDO_INDEX_INFO compile;
alter view DBA_SDO_INDEX_INFO compile;


CREATE OR REPLACE TRIGGER SDO_GEOM_TRIG_INS1
INSTEAD OF INSERT ON user_sdo_geom_metadata
REFERENCING NEW AS n
FOR EACH ROW
declare
 tname varchar2(32);
 stmt  varchar2(2048);
 vcount INTEGER;
BEGIN
   
  EXECUTE IMMEDIATE
  'SELECT user FROM dual' into tname;
 
  if (instr(:n.table_name, ' ') > 0 ) then
   mderr.raise_md_error('MD', 'SDO', -13223,
               :n.table_name||'.'||:n.column_name);
   end if;
  
  if (instr(:n.column_name, ' ') > 0 ) then
   mderr.raise_md_error('MD', 'SDO', -13223,
               :n.table_name||'.'||:n.column_name);
   end if;

 stmt :=  'SELECT count(*) FROM SDO_GEOM_METADATA_TABLE ' ||
  'WHERE sdo_owner = :tname  AND sdo_table_name = :table_name  '||
  '  AND  sdo_column_name = :column_name  ';
--  '  AND SDO_SRID = '||:n.srid ;
EXECUTE IMMEDIATE stmt INTO vcount
   USING tname, :n.table_name, :n.column_name;
                                                                                
                                                                                
  IF vcount = 0 THEN
    INSERT INTO sdo_geom_metadata_table values
             (upper(tname),
             upper(:n.table_name), upper(:n.column_name), :n.diminfo,
             :n.srid);
  ELSE
   mderr.raise_md_error('MD', 'SDO', -13223,
               :n.table_name||'.'||:n.column_name);
 END IF;
END;
/
show errors;



-- load changes from prvtsidx.plb
-- changes are: drop prvt_idx and reload prvt_idx
-- drop the prvt_idx package as there are no dependencies
drop package prvt_idx;

-- Reload sidx pkg
@@prvtmd.plb
@@prvtmd2.plb
@@sdocat.plb
@@sdogeom.sql
@@sdotune.sql
@@prvtsidx.plb
@@prvtrtr.plb
@@prvtpidx.plb
@@prvtprdx.plb
@@prvtoper.plb
@@prvttune.plb

select text from dba_errors where owner = 'MDSYS';

@@sdogeom.sql
@@prvt3glh.plb
@@sdoutlh.sql
@@sdoutlb.plb
@@prvtgeom.plb
@@prvt3gl.plb
@@sdowktfx.sql
@@prvtprdx.plb
@@prvtcs.plb
@@prvtgmd.plb
@@sdolrsmd.sql

select text from dba_errors where owner = 'MDSYS';

@@prvtlrsh.plb
@@sdolrsh.sql
@@prvtlrsb.plb
@@sdolrsb.plb

declare
begin
   begin
      execute immediate
     ' drop package mdbootstrap ';
      exception when others then NULL;
   end;
end;
/


alter package sdo_tune compile body;
alter package SDO_RTREE_ADMIN compile body;
alter package SDO_LRS compile body;
alter package SDO_3GL compile body;
alter package MD_LRS compile body;
alter type AGGRCONVEXHULL compile body;
alter type SDOAGGR compile body;
alter package MD2 compile body;
alter indextype SPATIAL_INDEX compile;
alter function
HHAND
compile;
 
alter function HHBYTELEN compile;
 
alter function HHCBIT compile;
 
alter function HHCELLBNDRY compile;
 
alter function HHCELLSIZE compile;
 
alter function HHCLDATE compile;
 
alter function HHCOLLAPSE compile;
 
alter function HHCOMMONCODE  compile;
 
alter function HHCOMPARE compile;
 
alter function HHCOMPOSE compile;
 
alter function HHDECODE compile;
 
alter function HHDISTANCE compile;
 
alter function HHENCODE compile;
 
alter function HHENCODE_BYLEVEL compile;
 
alter function HHGBIT compile;
 
alter function HHGETCID compile;
 
alter function HHGROUP compile;
 
alter function HHGTBIT compile;
 
alter function HHIDLPART compile;
 
alter function HHIDPART compile;
 
alter function HHINCRLEV compile;
 
alter function HHJLDATE compile;
 
alter function HHLENGTH compile;
 
alter function HHLEVELS compile;
 
alter function HHMATCH compile;
 
alter function HHMAXCODE compile;
 
alter function HHNCOMPARE  compile;
 
alter function HHNDIM compile;
 
alter function HHOR compile;
 
alter function HHORDER compile;
 
alter function HHPRECISION compile;
 
alter function HHSBIT compile;
 
alter function HHSETCID compile;
 
alter function HHSTBIT compile;
 
alter function HHSTYPE compile;
 
alter function HHSUBDIVIDE compile;
 
alter function HHSUBSTR compile;
 
alter function HHXOR compile;
 
alter package mderr compile body;
alter package sdo_admin compile body;
alter package sdo_catalog compile body;
alter package sdo_geom compile body;
alter package sdo_migrate compile body;



execute dbms_registry.loaded('SDO');                   
execute dbms_registry.valid('SDO');                   

ALTER SESSION SET CURRENT_SCHEMA = SYS;

