Rem
Rem $Header: sdotpev.sql 18-apr-2006.09:50:32 sravada Exp $
Rem
Rem sdotpev.sql
Rem
Rem Copyright (c) 2000, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdotpev.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sravada     04/18/06 - bug 5166774 
Rem    sravada     02/12/02 - add seqname to metadata
Rem    sravada     02/14/02 - remove mddict body
Rem    sravada     02/04/02 - add force for drop operator
Rem    sravada     10/08/01 - update for 9iR2
Rem    sravada     05/01/01 - add sdo_dummy function
Rem    rkothuri    04/18/01 - add upgrade for rtree_index
Rem    sravada     02/26/01 - update sdo_geom_metadata_table
Rem    sravada     01/08/01 - add geodetic flag to index_meta
Rem    sravada     11/30/00 - fix the alter index type
Rem    sravada     11/06/00 - add indextype evolution SQL
Rem    rkothuri    08/10/00 - add column sdo_rtree_quality to index_metadata_ta
Rem    sravada     06/15/00 - Add new columns to sdo_index_metadata_table
Rem    sravada     06/15/00 - Created
Rem


Alter session set current_schema=MDSYS;


create function sdo_dummy_function (geom1 IN mdsys.sdo_geometry, 
                             geom2 IN mdsys.sdo_geometry, param IN varchar2)
return varchar2 is
begin
  return 'DUMMY';
end;
/

create  operator
  sdo_dummy binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  using sdo_dummy_function;


alter indextype spatial_index
add sdo_dummy(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);

alter indextype spatial_index
drop sdo_nn(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index
drop sdo_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index
drop sdo_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index
drop sdo_rtree_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index
drop sdo_rtree_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index
drop sdo_int_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2, varchar2,
               varchar2, varchar2,number,number, number);
alter indextype spatial_index
drop sdo_int_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2, varchar2,
               varchar2, varchar2,number,number, number);
alter indextype spatial_index
drop sdo_within_distance(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index
drop locator_within_distance(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index
drop sdo_int2_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
alter indextype spatial_index
drop sdo_int2_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);


drop operator sdo_nn_distance force;
drop operator sdo_nn2 force;
drop operator sdo_nn force;
drop operator sdo_relate force;
drop operator sdo_filter force;
drop operator sdo_rtree_relate force;
drop operator sdo_rtree_filter force;
drop operator sdo_int_relate force;
drop operator sdo_int_filter force;
drop operator sdo_within_distance force;
drop operator locator_within_distance force;
drop operator sdo_int2_relate force;
drop operator sdo_int2_filter force;

-- Installing the sdo_idx package; this is referred in sdo_index_method
@@sdopidx.sql

@@prvtsidx.plb

-- this should come after the sdo_idnex_method
@@prvt3glh.plb

ALTER INDEXTYPE spatial_index using sdo_index_method_9i
WITH LOCAL range PARTITION;

create  or replace operator
  sdo_nn binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  compute ancillary data
  using prvt_idx.nn;

create or replace operator sdo_nn_distance
  binding (number)
return number
  ancillary to sdo_nn (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
  using  prvt_idx.nndistance;


create  or replace operator
  sdo_relate binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.relate;

create  or replace operator
  sdo_filter binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.filter;

create  or replace operator
  sdo_rtree_filter binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.filter;

create  or replace operator
  sdo_rtree_relate binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.relate;

create  or replace operator
sdo_within_distance binding(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.within_distance;

create  or replace operator
  sdo_int_relate binding (mdsys.sdo_geometry, mdsys.sdo_geometry, ROWID,
                          varchar2, varchar2, varchar2,number,number, number)
return varchar2
  with index context,
  SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.relate;

create or replace operator
  sdo_int_filter binding (mdsys.sdo_geometry, mdsys.sdo_geometry, ROWID,
                          varchar2, varchar2, varchar2,number,number, number)
return varchar2
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.filter;

create  or replace operator
  sdo_int2_relate binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.relate;

create  or replace operator
  sdo_int2_filter binding (mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
  with index context,
  SCAN CONTEXT  sdo_index_method_9i
  using sdo_3gl.filter;

create or replace operator
 locator_within_distance
  binding(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2)
return varchar2
 with index context,
 SCAN CONTEXT sdo_index_method_9i
using sdo_3gl.within_distance;


ALTER INDEXTYPE spatial_index using sdo_index_method_9i
WITH LOCAL range PARTITION;

alter indextype spatial_index
add sdo_nn_distance(number),
add sdo_nn(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2),
add sdo_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) rewrite JOIN,
add sdo_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) rewrite JOIN,
add sdo_rtree_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2),
add sdo_rtree_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2),
add sdo_int_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2, varchar2,
               varchar2, varchar2,number,number, number),
add sdo_int_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2, varchar2,
               varchar2, varchar2,number,number, number),
add sdo_within_distance(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2),
add locator_within_distance(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2),
add sdo_int2_relate(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2),
add sdo_int2_filter(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2) ;

alter indextype spatial_index
drop sdo_dummy(mdsys.sdo_geometry, mdsys.sdo_geometry, varchar2);
drop operator sdo_dummy;
drop function sdo_dummy_function;

grant execute on spatial_index to public;

grant execute on sdo_nn to public;
grant execute on sdo_nn_distance to public;
grant execute on sdo_filter to public;
grant execute on sdo_relate to public;
grant execute on sdo_rtree_filter to public;
grant execute on sdo_rtree_relate to public;
grant execute on sdo_within_distance to public;
grant execute on locator_within_distance to public;
grant execute on sdo_int_filter to public;
grant execute on sdo_int_relate to public;
grant execute on sdo_int2_filter to public;
grant execute on sdo_int2_relate to public;

create public  synonym sdo_nn for mdsys.sdo_nn;
create public  synonym sdo_filter for mdsys.sdo_filter;
create public  synonym sdo_relate for mdsys.sdo_relate;
create public  synonym sdo_rtree_filter for mdsys.sdo_rtree_filter;
create public  synonym sdo_rtree_relate for mdsys.sdo_rtree_relate;
create public  synonym sdo_within_distance for mdsys.sdo_within_distance;
create public  synonym locator_within_distance for
                                           mdsys.locator_within_distance;
commit;


drop type rtree_index_method force;
drop indextype rtree_index force;
drop operator rtree_filter force;
drop operator rtree_nn force;

@@prvtrtr.plb

Alter table SDO_GEOM_METADATA_TABLE
modify (SDO_COLUMN_NAME varchar2(1024));

Alter table SDO_INDEX_METADATA_TABLE
modify (SDO_COLUMN_NAME varchar2(2048));

Alter table SDO_INDEX_METADATA_TABLE add 
( SDO_INDEX_DIMS number);
Alter table SDO_INDEX_METADATA_TABLE add 
( SDO_LAYER_GTYPE varchar2(32));
Alter table SDO_INDEX_METADATA_TABLE add 
( SDO_RTREE_PCTFREE number);
Alter table SDO_INDEX_METADATA_TABLE add 
( SDO_INDEX_PARTITION varchar2(32));
Alter table SDO_INDEX_METADATA_TABLE add 
( SDO_PARTITIONED number);
Alter table SDO_INDEX_METADATA_TABLE add 
( SDO_RTREE_QUALITY number);
Alter table SDO_INDEX_METADATA_TABLE add 
( SDO_INDEX_VERSION number);
Alter table SDO_INDEX_METADATA_TABLE add
( SDO_INDEX_GEODETIC varchar2(8));
Alter table SDO_INDEX_METADATA_TABLE add
( SDO_INDEX_STATUS varchar2(32));

update sdo_index_metadata_table
set sdo_index_status = 'VALID';

update sdo_index_metadata_table set 
 sdo_rtree_seq_name= RPAD(sdo_index_table, LENGTH(sdo_index_table)+1, 'S') 
  where sdo_index_type='RTREE' ; 


drop package mdexec;
drop package mdexex;
drop package mdtrig;
drop package mdverify;
drop package md_ddl;
drop package md_dml;
drop package md_part;
drop package serv_part;
drop package MDGEN;
drop package MDLEXR;
drop package body mddict;

declare
begin
   begin
      execute immediate
     ' drop package mdbootstrap ';
      exception when others then NULL;
   end;
end;
/
                                                                                

