Rem
Rem $Header: sdoutlh.sql 03-aug-2004.07:58:28 sravada Exp $
Rem
Rem sdoutlh.sql
Rem
Rem Copyright (c) 2001, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdoutlh.sql - SDO_UTIL package Header
Rem
Rem    DESCRIPTION
Rem      Declaration of the SDO_UTIL package.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sravada     08/03/04 - add append function
Rem    jcwang      12/18/01 - add convert_number
Rem    sravada     08/15/01 - add vertex table functions
Rem    sravada     08/15/01 - Cleanup the headers, signatures
Rem    wexu        06/13/01 - Merged wexu_sdo_extract
Rem    wexu        05/24/01 - Created
Rem

-- Create the types needed for GetVertices function
drop type vertex_set_type;
drop type vertex_type;

Create type vertex_type as object
(X number,
 Y number,
 Z number,
 W number );
/

create type vertex_set_type as TABLE of vertex_type;
/

grant execute on vertex_type to public;
grant execute on vertex_set_type to public;


CREATE OR REPLACE PACKAGE sdo_util AUTHID current_user AS

-- CONSTANT DECLARATION
  SDO_GTYPE_POLYGON       CONSTANT  NUMBER := 3;
  SDO_GTYPE_MULTIPOLYGON  CONSTANT  NUMBER := 7;
  SDO_GTYPE_COLLECTION    CONSTANT  NUMBER := 4;

  FUNCTION extract(geometry IN mdsys.sdo_geometry,
                   element  IN NUMBER,
                   ring     IN NUMBER DEFAULT 0) 
    RETURN mdsys.sdo_geometry DETERMINISTIC;
--  PRAGMA restrict_references(extract, wnds, rnps, wnps);

  FUNCTION append(geometry1 IN MDSYS.sdo_geometry,
                  geometry2 IN MDSYS.sdo_geometry)
    RETURN mdsys.sdo_geometry DETERMINISTIC;
--    PRAGMA restrict_references(append, wnds, wnps);
                                                                                

 FUNCTION GetVertices(geometry IN mdsys.sdo_geometry) 
 RETURN vertex_set_type;
-- PRAGMA restrict_references(GetVertices, wnds, rnps, wnps);



 -- truncate the original number up to no_of_digits 
 -- no_of_digits positive:  truncate the number to no_of_digits AFTER the decimal point
 -- ex: truncate_number(1.123456789,5) returns 1.12345
 -- no_of_digits negative:  truncate the number up to no_of_digits BEFORE the decimal point
 -- ex: truncate_number(987654321.123456789,-5) returns 987600000.0
 
 FUNCTION truncate_number(value NUMBER, no_of_digits NUMBER)
    RETURN NUMBER;
 PRAGMA restrict_references(truncate_number, wnds, rnps, wnps);

 FUNCTION remove_duplicate_vertices(geometry IN sdo_geometry,
                                                tolerance in NUMBER)
    return MDSYS.SDO_GEOMETRY deterministic;

 FUNCTION remove_duplicates(geometry IN sdo_geometry, dim in sdo_dim_array)
    return MDSYS.SDO_GEOMETRY deterministic;

END sdo_util;
/

show errors;


