Rem
Rem $Header: sdowkt.sql 29-jan-2004.12:59:50 sravada Exp $
Rem
Rem sdowkt.sql
Rem
Rem Copyright (c) 1999, 2004, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      sdowkt.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sravada     01/29/04 - bug 3241171 
Rem    sravada     07/08/03 - 
Rem    bblackwe    03/31/03 - fix belgian and french coordinate systems
Rem    bblackwe    03/05/03 - fix scale factor for Brit. Natl. Grid
Rem    sravada     03/06/03 - add PENN DOT srid
Rem    bblackwe    02/25/03 - fix GRS 80 in Aussie coordinate systems
Rem    sravada     10/08/02 - 
Rem    bblackwe    09/18/02 - fix nautical mile conversion factor and add UK naut mile
Rem    sravada     08/30/02 - add a new user defined sph
Rem    sravada     06/26/02 - add unit sphere
Rem    sravada     06/27/02 - bug 2412341
Rem    sravada     04/26/02 - update ellipsoids to the right precision
Rem    bblackwe    02/07/02 - add new Australian coord systems
Rem    sravada     01/24/02 - add wkt for MARS 
Rem    sravada     10/08/01 - update 8192 to use 8307 wkt
Rem    sravada     04/26/01 - revert the Non-Earth SRIDs (we should never 
Rem                               change the SRIds or the name once it is
Rem                              shipped out with a release. So here we will
Rem                              have duplicates for some of the non-earth
Rem                              as the old names are not consistent. So
Rem                              new SRIDs are added for all the old plus
Rem                               new UNITs we added in 9i.
Rem    qxie        11/22/00 - Add Non-Earth w/ unit CS (262144 - 262166)
Rem    sravada     07/03/00 - add USER Defined CS tables
Rem    sravada     06/21/00 - add grants on views for geodetic srids
Rem    sravada     01/20/00 - add a view for Geodetic SRIDs
Rem    sravada     10/21/99 - change Mapinfo to Oracle in AUTH_NAME
Rem    sravada     08/18/99 - change Sinusiodal to Sinusoidal
Rem    sravada     07/31/99 - Created
Rem


Rem Create the table holding the WKT/SRID/Datum Info

drop table cs_srs;
 create table cs_srs (
    cs_name varchar2(68),
    srid integer not null primary key,
    auth_srid integer,
    auth_name varchar2(256),
    wktext varchar2(2046),
    cs_bounds mdsys.sdo_geometry
 ) ;

grant select on cs_srs to public;

begin

insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Unit Sphere', 2, 2, 'Oracle', 'GEOGCS [ "Unit Sphere Longitude/Latitude", DATUM [ "UnitSphere", SPHEROID ["UnitSphere", 1.0, 1000000000000]], PRIMEM ["NONE", 0.0000000], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Martian Longitude/Latitude', 2000001, 2000001, 'University of Arizona', 'GEOGCS [ "Martian Longitude/Latitude", DATUM [ "Mars", SPHEROID ["Mars", 3390592.987983, 1000000000000]], PRIMEM ["Airy-0", 0.0000000], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude', 8192, 8192, 'Oracle', 'GEOGCS [ "Longitude / Latitude (WGS 84)", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (AGD 66)', 8193, 8193, 'Oracle', 'GEOGCS [ "Longitude / Latitude (AGD 66)", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (AGD 84)', 8194, 8194, 'Oracle', 'GEOGCS [ "Longitude / Latitude (AGD 84)", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Adindan)', 8195, 8195, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Adindan)", DATUM ["Adindan", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Afgooye)', 8196, 8196, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Afgooye)", DATUM ["Afgooye", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Ain el Abd 1970)', 8197, 8197, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Ain el Abd 1970)", DATUM ["Ain el Abd 1970", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Anna 1 Astro 1965)', 8198, 8198, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Anna 1 Astro 1965)", DATUM ["Anna 1 Astro 1965", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Arc 1950)', 8199, 8199, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Arc 1950)", DATUM ["Arc 1950", SPHEROID ["Clarke 1880 (Arc 1950)", 6378249.145326, 293.4663076]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Arc 1960)', 8200, 8200, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Arc 1960)", DATUM ["Arc 1960", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Ascension Island 1958)', 8201, 8201, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Ascension Island 1958)", DATUM ["Ascension Island 1958", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Astro B4 Sorol Atoll)', 8202, 8202, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Astro B4 Sorol Atoll)", DATUM ["Astro B4 Sorol Atoll", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Astro Beacon E)', 8203, 8203, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Astro Beacon E)", DATUM ["Astro Beacon E", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Astro DOS 71/4)', 8204, 8204, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Astro DOS 71/4)", DATUM ["Astro DOS 71/4", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Astronomic Station 1952)', 8205, 8205, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Astronomic Station 1952)", DATUM ["Astronomic Station 1952", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Belgium)', 8206, 8206, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Belgium)", DATUM ["Belgium Hayford", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Bellevue)', 8207, 8207, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Bellevue)", DATUM ["Bellevue (IGN)", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Bermuda 1957)', 8208, 8208, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Bermuda 1957)", DATUM ["Bermuda 1957", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Bogota Observatory)', 8209, 8209, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Bogota Observatory)", DATUM ["Bogota Observatory", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (CH 1903)', 8210, 8210, 'Oracle', 'GEOGCS [ "Longitude / Latitude (CH 1903)", DATUM ["CH 1903 (Switzerland)", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Campo Inchauspe)', 8211, 8211, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Campo Inchauspe)", DATUM ["Campo Inchauspe", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Canton Astro 1966)', 8212, 8212, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Canton Astro 1966)", DATUM ["Canton Astro 1966", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Cape Canaveral)', 8213, 8213, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Cape Canaveral)", DATUM ["Cape Canaveral", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Cape)', 8214, 8214, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Cape)", DATUM ["Cape", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Carthage)', 8215, 8215, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Carthage)", DATUM ["Carthage", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Chatham 1971)', 8216, 8216, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Chatham 1971)", DATUM ["Chatham 1971", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Chua Astro)', 8217, 8217, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Chua Astro)", DATUM ["Chua Astro", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Corrego Alegre)', 8218, 8218, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Corrego Alegre)", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (D73)', 8219, 8219, 'Oracle', 'GEOGCS [ "Longitude / Latitude (D73)", DATUM ["Melrica 1973 (D73)", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (DHDN)', 8220, 8220, 'Oracle', 'GEOGCS [ "Longitude / Latitude (DHDN)", DATUM ["", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128], 582.000000, 105.000000, 414.000000, -1.040000, -0.350000, 3.080000, 8.300000 ], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (DLx)', 8221, 8221, 'Oracle', 'GEOGCS [ "Longitude / Latitude (DLx)", DATUM ["Lisboa (DLx)", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (DOS 1968)', 8222, 8222, 'Oracle', 'GEOGCS [ "Longitude / Latitude (DOS 1968)", DATUM ["DOS 1968", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (ED 50)', 8223, 8223, 'Oracle', 'GEOGCS [ "Longitude / Latitude (ED 50)", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (ED 79)', 8224, 8224, 'Oracle', 'GEOGCS [ "Longitude / Latitude (ED 79)", DATUM ["European 1979", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (ED 87)', 8225, 8225, 'Oracle', 'GEOGCS [ "Longitude / Latitude (ED 87)", DATUM ["European 1987", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Easter Island 1967)', 8226, 8226, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Easter Island 1967)", DATUM ["Easter Island 1967", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (GUX 1 Astro)', 8227, 8227, 'Oracle', 'GEOGCS [ "Longitude / Latitude (GUX 1 Astro)", DATUM ["GUX 1 Astro", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Gandajika Base)', 8228, 8228, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Gandajika Base)", DATUM ["Gandajika Base", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Geodetic Datum 1949)', 8229, 8229, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Geodetic Datum 1949)", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Guam 1963)', 8230, 8230, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Guam 1963)", DATUM ["Guam 1963", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Hito XVIII 1963)', 8231, 8231, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Hito XVIII 1963)", DATUM ["Hito XVIII 1963", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Hong Kong 1963)', 8232, 8232, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Hong Kong 1963)", DATUM ["Hong Kong 1963", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Hu-Tzu-Shan)', 8233, 8233, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Hu-Tzu-Shan)", DATUM ["Hu-Tzu-Shan", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (ISTS 073 Astro 1969)', 8234, 8234, 'Oracle', 'GEOGCS [ "Longitude / Latitude (ISTS 073 Astro 1969)", DATUM ["ISTS 073 Astro 1969", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Indian for Bangladesh, India, Nepal)', 8235, 8235, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Indian for Bangladesh, India, Nepal)", DATUM ["Indian (Bangladesh, etc.)", SPHEROID ["Everest", 6377276.345, 300.8017]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Indian for Thailand, Vietnam)', 8236, 8236, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Indian for Thailand, Vietnam)", DATUM ["Indian (Thailand/Vietnam)", SPHEROID ["Everest", 6377276.345, 300.8017]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Ireland 1965)', 8237, 8237, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Ireland 1965)", DATUM ["Ireland 1965", SPHEROID ["Airy 1930(Ireland 1965)", 6377340.189, 299.3249646]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Johnston Island 1961)', 8238, 8238, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Johnston Island 1961)", DATUM ["Johnston Island 1961", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Kandawala)', 8239, 8239, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Kandawala)", DATUM ["Kandawala", SPHEROID ["Everest", 6377276.345, 300.8017]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Kerguelen Island)', 8240, 8240, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Kerguelen Island)", DATUM ["Kerguelen Island", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Kertau 1948)', 8241, 8241, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Kertau 1948)", DATUM ["Kertau 1948", SPHEROID ["Everest (Kertau)", 6377304.063, 300.8017]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (LC 5 Astro)', 8242, 8242, 'Oracle', 'GEOGCS [ "Longitude / Latitude (LC 5 Astro)", DATUM ["L.C. 5 Astro", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Liberia 1964)', 8243, 8243, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Liberia 1964)", DATUM ["Liberia 1964", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Lisboa)', 8244, 8244, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Lisboa)", DATUM ["Lisboa (DLx)", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Luzon for Mindanao Island)', 8245, 8245, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Luzon for Mindanao Island)", DATUM ["Luzon (Mindanao Island)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Luzon for Philippines)', 8246, 8246, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Luzon for Philippines)", DATUM ["Luzon (Philippines)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Mahe 1971)', 8247, 8247, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Mahe 1971)", DATUM ["Mahe 1971", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Marco Astro)', 8248, 8248, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Marco Astro)", DATUM ["Marco Astro", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Massawa)', 8249, 8249, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Massawa)", DATUM ["Massawa", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Melrica 1973)', 8250, 8250, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Melrica 1973)", DATUM ["Melrica 1973 (D73)", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Merchich)', 8251, 8251, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Merchich)", DATUM ["Merchich", SPHEROID ["Clarke 1880 (Merchich)", 6378249.2, 293.46598]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Midway Astro 1961)', 8252, 8252, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Midway Astro 1961)", DATUM ["Midway Astro 1961", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Minna)', 8253, 8253, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Minna)", DATUM ["Minna", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Alaska)', 8254, 8254, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Bahamas)', 8255, 8255, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Bahamas)", DATUM ["NAD 27 (Bahamas)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Canada)', 8256, 8256, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Canal Zone)', 8257, 8257, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Canal Zone)", DATUM ["NAD 27 (Canal Zone)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Carribbean)', 8258, 8258, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Carribbean)", DATUM ["NAD 27 (Caribbean)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Central America)', 8259, 8259, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Central America)", DATUM ["NAD 27 (Central America)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Continental US)', 8260, 8260, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Cuba)', 8261, 8261, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Cuba)", DATUM ["NAD 27 (Cuba)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Greenland)', 8262, 8262, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Greenland)", DATUM ["NAD 27 (Greenland)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for Mexico)', 8263, 8263, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for Mexico)", DATUM ["NAD 27 (Central America)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 27 for San Salvador Island)', 8264, 8264, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 27 for San Salvador Island)", DATUM ["NAD 27 (San Salvador)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NAD 83)', 8265, 8265, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NAD 83)", DATUM ["NAD 83", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NTF with Greenwich prime meridian)', 8266, 8266, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NTF with Greenwich prime meridian)", DATUM ["NTF", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NTF with Paris prime meridian)', 8267, 8267, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NTF with Paris prime meridian)", DATUM ["NTF", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 2.337229167 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (NWGL 10)', 8268, 8268, 'Oracle', 'GEOGCS [ "Longitude / Latitude (NWGL 10)", DATUM ["NWGL 10", SPHEROID ["WGS 72", 6378135, 298.26]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Nahrwan for Masirah Island)', 8269, 8269, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Nahrwan for Masirah Island)", DATUM ["Nahrwan (Masirah Island)", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Nahrwan for Saudi Arabia)', 8270, 8270, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Nahrwan for Saudi Arabia)", DATUM ["Nahrwan (Saudi Arabia)", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Nahrwan for United Arab Emirates)', 8271, 8271, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Nahrwan for United Arab Emirates)", DATUM ["Nahrwan (Un. Arab Emirates)", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Naparima, BWI)', 8272, 8272, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Naparima, BWI)", DATUM ["Naparima, BWI", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Netherlands)', 8273, 8273, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Netherlands)", DATUM ["Netherlands Bessel", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (OSGB 36)', 8274, 8274, 'Oracle', 'GEOGCS [ "Longitude / Latitude (OSGB 36)", DATUM ["Ordnance Survey Great Brit", SPHEROID ["Airy 1930", 6377563.396, 299.3249646]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Observatorio 1966)', 8275, 8275, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Observatorio 1966)", DATUM ["Observatorio 1966", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Old Egyptian)', 8276, 8276, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Old Egyptian)", DATUM ["Old Egyptian", SPHEROID ["Helmert 1906", 6378200, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Old Hawaiian)', 8277, 8277, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Old Hawaiian)", DATUM ["Old Hawaiian", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Oman)', 8278, 8278, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Oman)", DATUM ["Oman", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Pico de las Nieves)', 8279, 8279, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Pico de las Nieves)", DATUM ["Pico de las Nieves", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Pitcairn Astro 1967)', 8280, 8280, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Pitcairn Astro 1967)", DATUM ["Pitcairn Astro 1967", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Potsdam)', 8281, 8281, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Potsdam)", DATUM ["", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128], 582.000000, 105.000000, 414.000000, -1.040000, -0.350000, 3.080000, 8.300000 ], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Provisional South American 1956)', 8282, 8282, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Provisional South American 1956)", DATUM ["Provisional South American", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Provisional South Chilean 1963)', 8283, 8283, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Provisional South Chilean 1963)", DATUM ["Hito XVIII 1963", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Puerto Rico)', 8284, 8284, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Puerto Rico)", DATUM ["Puerto Rico", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Pulkovo 1942)', 8285, 8285, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Pulkovo 1942)", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Qatar National)', 8286, 8286, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Qatar National)", DATUM ["Qatar National", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Qornoq)', 8287, 8287, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Qornoq)", DATUM ["Qornoq", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (RT 90)', 8288, 8288, 'Oracle', 'GEOGCS [ "Longitude / Latitude (RT 90)", DATUM ["RT 90 (Sweden)", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Rauenberg)', 8289, 8289, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Rauenberg)", DATUM ["", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128], 582.000000, 105.000000, 414.000000, -1.040000, -0.350000, 3.080000, 8.300000 ], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Reunion)', 8290, 8290, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Reunion)", DATUM ["Reunion", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Rome 1940)', 8291, 8291, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Rome 1940)", DATUM ["Rome 1940", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (SAD 69)', 8292, 8292, 'Oracle', 'GEOGCS [ "Longitude / Latitude (SAD 69)", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Santo DOS)', 8293, 8293, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Santo DOS)", DATUM ["Santo (DOS)", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Sao Braz)', 8294, 8294, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Sao Braz)", DATUM ["Sao Braz", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Sapper Hill 1943)', 8295, 8295, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Sapper Hill 1943)", DATUM ["Sapper Hill 1943", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Schwarzeck)', 8296, 8296, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Schwarzeck)", DATUM ["Schwarzeck", SPHEROID ["Bessel 1841 (Schwarzeck)", 6377483.865, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (South Asia)', 8297, 8297, 'Oracle', 'GEOGCS [ "Longitude / Latitude (South Asia)", DATUM ["South Asia", SPHEROID ["Fischer 1960 (South Asia)", 6378155, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Southeast Base)', 8298, 8298, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Southeast Base)", DATUM ["Southeast Base", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Southwest Base)', 8299, 8299, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Southwest Base)", DATUM ["Southwest Base", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Timbalai 1948)', 8300, 8300, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Timbalai 1948)", DATUM ["Timbalai 1948", SPHEROID ["Everest", 6377276.345, 300.8017]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Tokyo)', 8301, 8301, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Tokyo)", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Tristan Astro 1968)', 8302, 8302, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Tristan Astro 1968)", DATUM ["Tristan Astro 1968", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Viti Levu 1916)', 8303, 8303, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Viti Levu 1916)", DATUM ["Viti Levu 1916", SPHEROID ["Clarke 1880", 6378249.145, 293.465]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (WGS 60)', 8304, 8304, 'Oracle', 'GEOGCS [ "Longitude / Latitude (WGS 60)", DATUM ["WGS 60", SPHEROID ["WGS 60", 6378165, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (WGS 66)', 8305, 8305, 'Oracle', 'GEOGCS [ "Longitude / Latitude (WGS 66)", DATUM ["WGS 66", SPHEROID ["WGS 66", 6378145, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (WGS 72)', 8306, 8306, 'Oracle', 'GEOGCS [ "Longitude / Latitude (WGS 72)", DATUM ["WGS 72", SPHEROID ["WGS 72", 6378135, 298.26],0.,0.,4.5,0.,0.,.554,.2263], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (WGS 84)', 8307, 8307, 'Oracle', 'GEOGCS [ "Longitude / Latitude (WGS 84)", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Wake-Eniwetok 1960)', 8308, 8308, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Wake-Eniwetok 1960)", DATUM ["Wake-Eniwetok 1960", SPHEROID ["Hough", 6378270, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Yacare)', 8309, 8309, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Yacare)", DATUM ["Yacare", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (Zanderij)', 8310, 8310, 'Oracle', 'GEOGCS [ "Longitude / Latitude (Zanderij)", DATUM ["Zanderij", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (GDA 94)', 8311, 8311, 'Navigate', 'GEOGCS [ "Longitude / Latitude (GDA 94)", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (AGD 66 ACT)', 8312, 8312, 'Navigate', 'GEOGCS [ "Longitude / Latitude (AGD 66 ACT)", DATUM ["AGD 66 ACT", SPHEROID ["Australian", 6378160, 298.25],-129.19,-41.21,130.73,-.25,-.37,-.33,-2.96], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (AGD 66 TAS)', 8313, 8313, 'Navigate', 'GEOGCS [ "Longitude / Latitude (AGD 66 TAS)", DATUM ["AGD 66 TAS", SPHEROID ["Australian", 6378160, 298.25],-120.27,-64.54,161.63,-.22,-.07,.13,2.5], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (AGD 66 VIC NSW)', 8314, 8314, 'Navigate', 'GEOGCS [ "Longitude / Latitude (AGD 66 VIC NSW)", DATUM ["AGD 66 VIC NSW", SPHEROID ["Australian", 6378160, 298.25],-119.35,-48.3,139.48,-.42,-.26,-.44,-.61], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (AGD 66 NT)', 8315, 8315, 'Navigate', 'GEOGCS [ "Longitude / Latitude (AGD 66 NT)", DATUM ["AGD 66 NT", SPHEROID ["Australian", 6378160, 298.25],-124.13,-42.0,137.4,.01,-.56,-.18,-1.85], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Longitude / Latitude (New AGD 84)', 8316, 8316, 'Navigate', 'GEOGCS [ "Longitude / Latitude (New AGD 84)", DATUM ["New AGD 84", SPHEROID ["Australian", 6378160, 298.25],-117.76,-51.51,139.06,-.29,-.44,-.28,-.19], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (Asia)', 32768, 32768, 'Oracle', 'PROJCS["Equal-Area Projection (Asia)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", 20.000000], PARAMETER ["Standard_Parallel_2", 60.000000], PARAMETER ["Central_Meridian", 95.000000], PARAMETER ["Latitude_Of_Origin", 40.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (Australia)', 32769, 32769, 'Oracle', 'PROJCS["Equal-Area Projection (Australia)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", -21.500000], PARAMETER ["Standard_Parallel_2", -33.500000], PARAMETER ["Central_Meridian", 132.500000], PARAMETER ["Latitude_Of_Origin", -10.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (China)', 32770, 32770, 'Oracle', 'PROJCS["Equal-Area Projection (China)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", 25.000000], PARAMETER ["Standard_Parallel_2", 40.000000], PARAMETER ["Central_Meridian", 110.000000], PARAMETER ["Latitude_Of_Origin", 10.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (Europe)', 32771, 32771, 'Oracle', 'PROJCS["Equal-Area Projection (Europe)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", 40.000000], PARAMETER ["Standard_Parallel_2", 65.000000], PARAMETER ["Central_Meridian", 25.000000], PARAMETER ["Latitude_Of_Origin", 35.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (India)', 32772, 32772, 'Oracle', 'PROJCS["Equal-Area Projection (India)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", 22.000000], PARAMETER ["Standard_Parallel_2", 33.000000], PARAMETER ["Central_Meridian", 78.000000], PARAMETER ["Latitude_Of_Origin", 23.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (Middle East)', 32773, 32773, 'Oracle', 'PROJCS["Equal-Area Projection (Middle East)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", 15.000000], PARAMETER ["Standard_Parallel_2", 35.000000], PARAMETER ["Central_Meridian", 47.500000], PARAMETER ["Latitude_Of_Origin", 25.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (North America)', 32774, 32774, 'Oracle', 'PROJCS["Equal-Area Projection (North America)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", 20.000000], PARAMETER ["Standard_Parallel_2", 60.000000], PARAMETER ["Central_Meridian", -96.000000], PARAMETER ["Latitude_Of_Origin", 23.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (United States)', 32775, 32775, 'Oracle', 'PROJCS["Equal-Area Projection (United States)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", 29.500000], PARAMETER ["Standard_Parallel_2", 45.500000], PARAMETER ["Central_Meridian", -96.000000], PARAMETER ["Latitude_Of_Origin", 23.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal Area Projection (Australia GDA94)', 32776, 32776, 'Navigate', 'PROJCS["Equal Area Projection (Australia GDA94)", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Albers Conical Equal Area"], PARAMETER ["Standard_Parallel_1", -18.000000], PARAMETER ["Standard_Parallel_2", -36.000000], PARAMETER ["Central_Meridian", 134.000000], PARAMETER ["Latitude_Of_Origin", -10.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (Australia GDA94)', 32777, 32777, 'Navigate', 'PROJCS["Conformal Projection (Australia GDA94)", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", -18.000000], PARAMETER ["Standard_Parallel_2", -36.000000], PARAMETER ["Central_Meridian", 134.000000], PARAMETER ["Latitude_Of_Origin", -10.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5010, Zone 10 (1927)', 40960, 40960, 'Oracle', 'PROJCS["Alaska 5010, Zone 10 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 51.833333], PARAMETER ["Standard_Parallel_2", 53.833333], PARAMETER ["Central_Meridian", -176.000000], PARAMETER ["Latitude_Of_Origin", 51.000000], PARAMETER ["False_Easting", 914401.828804], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5010, Zone 10 (1983, US Survey feet)', 40961, 40961, 'Oracle', 'PROJCS["Alaska 5010, Zone 10 (1983, US Survey feet)", GEOGCS [ "NAD 83 (Alaska)", DATUM ["NAD 83 (Alaska)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 51.833333], PARAMETER ["Standard_Parallel_2", 53.833333], PARAMETER ["Central_Meridian", -176.000000], PARAMETER ["Latitude_Of_Origin", 51.000000], PARAMETER ["False_Easting", 1000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5010, Zone 10 (1983, meters)', 40962, 40962, 'Oracle', 'PROJCS["Alaska 5010, Zone 10 (1983, meters)", GEOGCS [ "NAD 83 (Alaska)", DATUM ["NAD 83 (Alaska)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 51.833333], PARAMETER ["Standard_Parallel_2", 53.833333], PARAMETER ["Central_Meridian", -176.000000], PARAMETER ["Latitude_Of_Origin", 51.000000], PARAMETER ["False_Easting", 1000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arkansas 0301, Northern Zone (1927)', 40963, 40963, 'Oracle', 'PROJCS["Arkansas 0301, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.933333], PARAMETER ["Standard_Parallel_2", 36.233333], PARAMETER ["Central_Meridian", -92.000000], PARAMETER ["Latitude_Of_Origin", 34.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arkansas 0301, Northern Zone (1983, US Survey feet)', 40964, 40964, 'Oracle', 'PROJCS["Arkansas 0301, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.933333], PARAMETER ["Standard_Parallel_2", 36.233333], PARAMETER ["Central_Meridian", -92.000000], PARAMETER ["Latitude_Of_Origin", 34.333333], PARAMETER ["False_Easting", 400000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arkansas 0301, Northern Zone (1983, meters)', 40965, 40965, 'Oracle', 'PROJCS["Arkansas 0301, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.933333], PARAMETER ["Standard_Parallel_2", 36.233333], PARAMETER ["Central_Meridian", -92.000000], PARAMETER ["Latitude_Of_Origin", 34.333333], PARAMETER ["False_Easting", 400000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arkansas 0302, Southern Zone (1927)', 40966, 40966, 'Oracle', 'PROJCS["Arkansas 0302, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.300000], PARAMETER ["Standard_Parallel_2", 34.766667], PARAMETER ["Central_Meridian", -92.000000], PARAMETER ["Latitude_Of_Origin", 32.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arkansas 0302, Southern Zone (1983, US Survey feet)', 40967, 40967, 'Oracle', 'PROJCS["Arkansas 0302, Southern Zone (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.300000], PARAMETER ["Standard_Parallel_2", 34.766667], PARAMETER ["Central_Meridian", -92.000000], PARAMETER ["Latitude_Of_Origin", 32.666667], PARAMETER ["False_Easting", 400000.000000], PARAMETER ["False_Northing", 400000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arkansas 0302, Southern Zone (1983, meters)', 40968, 40968, 'Oracle', 'PROJCS["Arkansas 0302, Southern Zone (1983, meters)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.300000], PARAMETER ["Standard_Parallel_2", 34.766667], PARAMETER ["Central_Meridian", -92.000000], PARAMETER ["Latitude_Of_Origin", 32.666667], PARAMETER ["False_Easting", 400000.000000], PARAMETER ["False_Northing", 400000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Belgian National System (1950)', 40969, 40969, 'Oracle', 'PROJCS["Belgian National System (1950)", GEOGCS [ "Belgium Hayford", DATUM ["Belgium Hayford", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 49.833333], PARAMETER ["Standard_Parallel_2", 51.166667], PARAMETER ["Central_Meridian", 4.367975], PARAMETER ["Latitude_Of_Origin", 90.000000], PARAMETER ["False_Easting", 150000.000000], PARAMETER ["False_Northing", 5400000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0401, Zone I (1927)', 40970, 40970, 'Oracle', 'PROJCS["California 0401, Zone I (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.000000], PARAMETER ["Standard_Parallel_2", 41.666667], PARAMETER ["Central_Meridian", -122.000000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0401, Zone I (1983, US Survey feet)', 40971, 40971, 'Oracle', 'PROJCS["California 0401, Zone I (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.000000], PARAMETER ["Standard_Parallel_2", 41.666667], PARAMETER ["Central_Meridian", -122.000000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0401, Zone I (1983, meters)', 40972, 40972, 'Oracle', 'PROJCS["California 0401, Zone I (1983, meters)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.000000], PARAMETER ["Standard_Parallel_2", 41.666667], PARAMETER ["Central_Meridian", -122.000000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0402, Zone II (1927)', 40973, 40973, 'Oracle', 'PROJCS["California 0402, Zone II (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.333333], PARAMETER ["Standard_Parallel_2", 39.833333], PARAMETER ["Central_Meridian", -122.000000], PARAMETER ["Latitude_Of_Origin", 37.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0402, Zone II (1983, US Survey feet)', 40974, 40974, 'Oracle', 'PROJCS["California 0402, Zone II (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.333333], PARAMETER ["Standard_Parallel_2", 39.833333], PARAMETER ["Central_Meridian", -122.000000], PARAMETER ["Latitude_Of_Origin", 37.666667], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0402, Zone II (1983, meters)', 40975, 40975, 'Oracle', 'PROJCS["California 0402, Zone II (1983, meters)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.333333], PARAMETER ["Standard_Parallel_2", 39.833333], PARAMETER ["Central_Meridian", -122.000000], PARAMETER ["Latitude_Of_Origin", 37.666667], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0403, Zone III (1927)', 40976, 40976, 'Oracle', 'PROJCS["California 0403, Zone III (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.066667], PARAMETER ["Standard_Parallel_2", 38.433333], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 36.500000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0403, Zone III (1983, US Survey feet)', 40977, 40977, 'Oracle', 'PROJCS["California 0403, Zone III (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.066667], PARAMETER ["Standard_Parallel_2", 38.433333], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 36.500000], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0403, Zone III (1983, meters)', 40978, 40978, 'Oracle', 'PROJCS["California 0403, Zone III (1983, meters)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.066667], PARAMETER ["Standard_Parallel_2", 38.433333], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 36.500000], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0404, Zone IV (1927)', 40979, 40979, 'Oracle', 'PROJCS["California 0404, Zone IV (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.000000], PARAMETER ["Standard_Parallel_2", 37.250000], PARAMETER ["Central_Meridian", -119.000000], PARAMETER ["Latitude_Of_Origin", 35.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0404, Zone IV (1983, US Survey feet)', 40980, 40980, 'Oracle', 'PROJCS["California 0404, Zone IV (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.000000], PARAMETER ["Standard_Parallel_2", 37.250000], PARAMETER ["Central_Meridian", -119.000000], PARAMETER ["Latitude_Of_Origin", 35.333333], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0404, Zone IV (1983, meters)', 40981, 40981, 'Oracle', 'PROJCS["California 0404, Zone IV (1983, meters)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.000000], PARAMETER ["Standard_Parallel_2", 37.250000], PARAMETER ["Central_Meridian", -119.000000], PARAMETER ["Latitude_Of_Origin", 35.333333], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0405, Zone V (1927)', 40982, 40982, 'Oracle', 'PROJCS["California 0405, Zone V (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.033333], PARAMETER ["Standard_Parallel_2", 35.466667], PARAMETER ["Central_Meridian", -118.000000], PARAMETER ["Latitude_Of_Origin", 33.500000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0405, Zone V (1983, US Survey feet)', 40983, 40983, 'Oracle', 'PROJCS["California 0405, Zone V (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.033333], PARAMETER ["Standard_Parallel_2", 35.466667], PARAMETER ["Central_Meridian", -118.000000], PARAMETER ["Latitude_Of_Origin", 33.500000], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0405, Zone V (1983, meters)', 40984, 40984, 'Oracle', 'PROJCS["California 0405, Zone V (1983, meters)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.033333], PARAMETER ["Standard_Parallel_2", 35.466667], PARAMETER ["Central_Meridian", -118.000000], PARAMETER ["Latitude_Of_Origin", 33.500000], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0406, Zone VI (1927)', 40985, 40985, 'Oracle', 'PROJCS["California 0406, Zone VI (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.783333], PARAMETER ["Standard_Parallel_2", 33.883333], PARAMETER ["Central_Meridian", -116.250000], PARAMETER ["Latitude_Of_Origin", 32.166667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0406, Zone VI (1983, US Survey feet)', 40986, 40986, 'Oracle', 'PROJCS["California 0406, Zone VI (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.783333], PARAMETER ["Standard_Parallel_2", 33.883333], PARAMETER ["Central_Meridian", -116.250000], PARAMETER ["Latitude_Of_Origin", 32.166667], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0406, Zone VI (1983, meters)', 40987, 40987, 'Oracle', 'PROJCS["California 0406, Zone VI (1983, meters)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.783333], PARAMETER ["Standard_Parallel_2", 33.883333], PARAMETER ["Central_Meridian", -116.250000], PARAMETER ["Latitude_Of_Origin", 32.166667], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'California 0407, Zone VII (1927)', 40988, 40988, 'Oracle', 'PROJCS["California 0407, Zone VII (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.866667], PARAMETER ["Standard_Parallel_2", 34.416667], PARAMETER ["Central_Meridian", -118.333333], PARAMETER ["Latitude_Of_Origin", 34.133333], PARAMETER ["False_Easting", 1276106.410400], PARAMETER ["False_Northing", 1268252.966908], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0501, Northern Zone (1927)', 40989, 40989, 'Oracle', 'PROJCS["Colorado 0501, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.716667], PARAMETER ["Standard_Parallel_2", 40.783333], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0501, Northern Zone (1983, US Survey feet)', 40990, 40990, 'Oracle', 'PROJCS["Colorado 0501, Northern Zone (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.716667], PARAMETER ["Standard_Parallel_2", 40.783333], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 914401.828804], PARAMETER ["False_Northing", 304800.609601], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0501, Northern Zone (1983, meters)', 40991, 40991, 'Oracle', 'PROJCS["Colorado 0501, Northern Zone (1983, meters)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.716667], PARAMETER ["Standard_Parallel_2", 40.783333], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 914401.828900], PARAMETER ["False_Northing", 304800.609600], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0502, Central Zone (1927)', 40992, 40992, 'Oracle', 'PROJCS["Colorado 0502, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.450000], PARAMETER ["Standard_Parallel_2", 39.750000], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 37.833333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0502, Central Zone (1983, US Survey feet)', 40993, 40993, 'Oracle', 'PROJCS["Colorado 0502, Central Zone (1983, US Survey feet)", GEOGCS [ "NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.450000], PARAMETER ["Standard_Parallel_2", 39.750000], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 37.833333], PARAMETER ["False_Easting", 914401.828804], PARAMETER ["False_Northing", 304800.609601], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0502, Central Zone (1983, meters)', 40994, 40994, 'Oracle', 'PROJCS["Colorado 0502, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.450000], PARAMETER ["Standard_Parallel_2", 39.750000], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 37.833333], PARAMETER ["False_Easting", 914401.828900], PARAMETER ["False_Northing", 304800.609600], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0503, Southern Zone (1927)', 40995, 40995, 'Oracle', 'PROJCS["Colorado 0503, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.233333], PARAMETER ["Standard_Parallel_2", 38.433333], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0503, Southern Zone (1983, US Survey feet)', 40996, 40996, 'Oracle', 'PROJCS["Colorado 0503, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.233333], PARAMETER ["Standard_Parallel_2", 38.433333], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 914401.828804], PARAMETER ["False_Northing", 304800.609601], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Colorado 0503, Southern Zone (1983, meters)', 40997, 40997, 'Oracle', 'PROJCS["Colorado 0503, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.233333], PARAMETER ["Standard_Parallel_2", 38.433333], PARAMETER ["Central_Meridian", -105.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 914401.828900], PARAMETER ["False_Northing", 304800.609600], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (Asia)', 40998, 40998, 'Oracle', 'PROJCS["Conformal Projection (Asia)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 20.000000], PARAMETER ["Standard_Parallel_2", 60.000000], PARAMETER ["Central_Meridian", 95.000000], PARAMETER ["Latitude_Of_Origin", 40.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (Australia)', 40999, 40999, 'Oracle', 'PROJCS["Conformal Projection (Australia)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", -21.500000], PARAMETER ["Standard_Parallel_2", -33.500000], PARAMETER ["Central_Meridian", 132.500000], PARAMETER ["Latitude_Of_Origin", -10.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (China)', 41000, 41000, 'Oracle', 'PROJCS["Conformal Projection (China)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 25.000000], PARAMETER ["Standard_Parallel_2", 40.000000], PARAMETER ["Central_Meridian", 110.000000], PARAMETER ["Latitude_Of_Origin", 10.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (Europe)', 41001, 41001, 'Oracle', 'PROJCS["Conformal Projection (Europe)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.000000], PARAMETER ["Standard_Parallel_2", 65.000000], PARAMETER ["Central_Meridian", 25.000000], PARAMETER ["Latitude_Of_Origin", 35.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (Middle East)', 41002, 41002, 'Oracle', 'PROJCS["Conformal Projection (Middle East)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 15.000000], PARAMETER ["Standard_Parallel_2", 35.000000], PARAMETER ["Central_Meridian", 47.500000], PARAMETER ["Latitude_Of_Origin", 25.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (North America)', 41003, 41003, 'Oracle', 'PROJCS["Conformal Projection (North America)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 20.000000], PARAMETER ["Standard_Parallel_2", 60.000000], PARAMETER ["Central_Meridian", -96.000000], PARAMETER ["Latitude_Of_Origin", 23.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (United States)', 41004, 41004, 'Oracle', 'PROJCS["Conformal Projection (United States)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.000000], PARAMETER ["Standard_Parallel_2", 45.000000], PARAMETER ["Central_Meridian", -96.000000], PARAMETER ["Latitude_Of_Origin", 23.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Connecticut 0600 (1927)', 41005, 41005, 'Oracle', 'PROJCS["Connecticut 0600 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.200000], PARAMETER ["Standard_Parallel_2", 41.866667], PARAMETER ["Central_Meridian", -72.750000], PARAMETER ["Latitude_Of_Origin", 40.833333], PARAMETER ["False_Easting", 182880.365761], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Connecticut 0600 (1983, US Survey feet)', 41006, 41006, 'Oracle', 'PROJCS["Connecticut 0600 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.200000], PARAMETER ["Standard_Parallel_2", 41.866667], PARAMETER ["Central_Meridian", -72.750000], PARAMETER ["Latitude_Of_Origin", 40.833333], PARAMETER ["False_Easting", 304800.609601], PARAMETER ["False_Northing", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Connecticut 0600 (1983, meters)', 41007, 41007, 'Oracle', 'PROJCS["Connecticut 0600 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.200000], PARAMETER ["Standard_Parallel_2", 41.866667], PARAMETER ["Central_Meridian", -72.750000], PARAMETER ["Latitude_Of_Origin", 40.833333], PARAMETER ["False_Easting", 304800.609600], PARAMETER ["False_Northing", 152400.304800], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Demo Projection', 41008, 41008, 'Oracle', 'PROJCS["Demo Projection", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 30.116667], PARAMETER ["Standard_Parallel_2", 31.883333], PARAMETER ["Central_Meridian", -100.333333], PARAMETER ["Latitude_Of_Origin", 29.666667], PARAMETER ["False_Easting", 700000.000000], PARAMETER ["False_Northing", 3000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0903, Northern Zone (1927)', 41009, 41009, 'Oracle', 'PROJCS["Florida 0903, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 29.583333], PARAMETER ["Standard_Parallel_2", 30.750000], PARAMETER ["Central_Meridian", -84.500000], PARAMETER ["Latitude_Of_Origin", 29.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0903, Northern Zone (1983, US Survey feet)', 41010, 41010, 'Oracle', 'PROJCS["Florida 0903, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 29.583333], PARAMETER ["Standard_Parallel_2", 30.750000], PARAMETER ["Central_Meridian", -84.500000], PARAMETER ["Latitude_Of_Origin", 29.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0903, Northern Zone (1983, meters)', 41011, 41011, 'Oracle', 'PROJCS["Florida 0903, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 29.583333], PARAMETER ["Standard_Parallel_2", 30.750000], PARAMETER ["Central_Meridian", -84.500000], PARAMETER ["Latitude_Of_Origin", 29.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'French Lambert I Carto', 41012, 41012, 'Oracle', 'PROJCS["French Lambert I Carto", GEOGCS [ "NTF (Paris meridian)", DATUM ["NTF (Paris meridian)", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 0.0 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 48.598523], PARAMETER ["Standard_Parallel_2", 50.395912], PARAMETER ["Latitude_Of_Origin", 49.500000], PARAMETER["Central_Meridian",2.337229167], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 1200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'French Lambert I Nord', 41013, 41013, 'Oracle', 'PROJCS["French Lambert I Nord", GEOGCS [ "NTF (Paris meridian)", DATUM ["NTF (Paris meridian)", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 0.0 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 48.598523], PARAMETER ["Standard_Parallel_2", 50.395912], PARAMETER ["Latitude_Of_Origin", 49.500000], PARAMETER["Central_Meridian",2.337229167], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'French Lambert II Carto', 41014, 41014, 'Oracle', 'PROJCS["French Lambert II Carto", GEOGCS [ "NTF (Paris meridian)", DATUM ["NTF (Paris meridian)", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 0.0 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.898919], PARAMETER ["Standard_Parallel_2", 47.696015], PARAMETER ["Latitude_Of_Origin", 46.800000], PARAMETER["Central_Meridian",2.337229167], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 2200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'French Lambert II Centre', 41015, 41015, 'Oracle', 'PROJCS["French Lambert II Centre", GEOGCS [ "NTF (Paris meridian)", DATUM ["NTF (Paris meridian)", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 0.0 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.898919], PARAMETER ["Standard_Parallel_2", 47.696015], PARAMETER ["Latitude_Of_Origin", 46.800000], PARAMETER["Central_Meridian",2.337229167], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'French Lambert III Carto', 41016, 41016, 'Oracle', 'PROJCS["French Lambert III Carto", GEOGCS [ "NTF (Paris meridian)", DATUM ["NTF (Paris meridian)", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 0.0 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 43.199291], PARAMETER ["Standard_Parallel_2", 44.996094], PARAMETER ["Latitude_Of_Origin", 44.100000], PARAMETER["Central_Meridian",2.337229167], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 3200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'French Lambert III Sud', 41017, 41017, 'Oracle', 'PROJCS["French Lambert III Sud", GEOGCS [ "NTF (Paris meridian)", DATUM ["NTF (Paris meridian)", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 0.0 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 43.199291], PARAMETER ["Standard_Parallel_2", 44.996094], PARAMETER ["Latitude_Of_Origin", 44.100000], PARAMETER["Central_Meridian",2.337229167], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'French Lambert IV Carto', 41018, 41018, 'Oracle', 'PROJCS["French Lambert IV Carto", GEOGCS [ "NTF (Paris meridian)", DATUM ["NTF (Paris meridian)", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 0.0 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.560388], PARAMETER ["Standard_Parallel_2", 42.767663], PARAMETER ["Latitude_Of_Origin", 42.165000], PARAMETER["Central_Meridian",2.337229167], PARAMETER ["False_Easting", 234.358000], PARAMETER ["False_Northing", 4185861.369000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'French Lambert IV Corse', 41019, 41019, 'Oracle', 'PROJCS["French Lambert IV Corse", GEOGCS [ "NTF (Paris meridian)", DATUM ["NTF (Paris meridian)", SPHEROID ["Clarke 1880 (IGN)", 6378249.2, 293.4660213]], PRIMEM [ "Paris", 0.0 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.560388], PARAMETER ["Standard_Parallel_2", 42.767663], PARAMETER ["Latitude_Of_Origin", 42.165000], PARAMETER["Central_Meridian",2.337229167], PARAMETER ["False_Easting", 234.358000], PARAMETER ["False_Northing", 185861.369000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Iowa 1401, Northern Zone (1927)', 41020, 41020, 'Oracle', 'PROJCS["Iowa 1401, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.066667], PARAMETER ["Standard_Parallel_2", 43.266667], PARAMETER ["Central_Meridian", -93.500000], PARAMETER ["Latitude_Of_Origin", 41.500000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Iowa 1401, Northern Zone (1983, US Survey feet)', 41021, 41021, 'Oracle', 'PROJCS["Iowa 1401, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.066667], PARAMETER ["Standard_Parallel_2", 43.266667], PARAMETER ["Central_Meridian", -93.500000], PARAMETER ["Latitude_Of_Origin", 41.500000], PARAMETER ["False_Easting", 1500000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Iowa 1401, Northern Zone (1983, meters)', 41022, 41022, 'Oracle', 'PROJCS["Iowa 1401, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.066667], PARAMETER ["Standard_Parallel_2", 43.266667], PARAMETER ["Central_Meridian", -93.500000], PARAMETER ["Latitude_Of_Origin", 41.500000], PARAMETER ["False_Easting", 1500000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Iowa 1402, Southern Zone (1927)', 41023, 41023, 'Oracle', 'PROJCS["Iowa 1402, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.616667], PARAMETER ["Standard_Parallel_2", 41.783333], PARAMETER ["Central_Meridian", -93.500000], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Iowa 1402, Southern Zone (1983, US Survey feet)', 41024, 41024, 'Oracle', 'PROJCS["Iowa 1402, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.616667], PARAMETER ["Standard_Parallel_2", 41.783333], PARAMETER ["Central_Meridian", -93.500000], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Iowa 1402, Southern Zone (1983, meters)', 41025, 41025, 'Oracle', 'PROJCS["Iowa 1402, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.616667], PARAMETER ["Standard_Parallel_2", 41.783333], PARAMETER ["Central_Meridian", -93.500000], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kansas 1501, Northern Zone (1927)', 41026, 41026, 'Oracle', 'PROJCS["Kansas 1501, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.716667], PARAMETER ["Standard_Parallel_2", 39.783333], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 38.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kansas 1501, Northern Zone (1983, US Survey feet)', 41027, 41027, 'Oracle', 'PROJCS["Kansas 1501, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.716667], PARAMETER ["Standard_Parallel_2", 39.783333], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 38.333333], PARAMETER ["False_Easting", 400000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kansas 1501, Northern Zone (1983, meters)', 41028, 41028, 'Oracle', 'PROJCS["Kansas 1501, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.716667], PARAMETER ["Standard_Parallel_2", 39.783333], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 38.333333], PARAMETER ["False_Easting", 400000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kansas 1502, Southern Zone (1927)', 41029, 41029, 'Oracle', 'PROJCS["Kansas 1502, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.566667], PARAMETER ["Standard_Parallel_2", 37.266667], PARAMETER ["Central_Meridian", -98.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kansas 1502, Southern Zone (1983, US Survey feet)', 41030, 41030, 'Oracle', 'PROJCS["Kansas 1502, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.566667], PARAMETER ["Standard_Parallel_2", 37.266667], PARAMETER ["Central_Meridian", -98.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 400000.000000], PARAMETER ["False_Northing", 400000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kansas 1502, Southern Zone (1983, meters)', 41031, 41031, 'Oracle', 'PROJCS["Kansas 1502, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.566667], PARAMETER ["Standard_Parallel_2", 37.266667], PARAMETER ["Central_Meridian", -98.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 400000.000000], PARAMETER ["False_Northing", 400000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kentucky 1601, Northern Zone (1927)', 41032, 41032, 'Oracle', 'PROJCS["Kentucky 1601, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.966667], PARAMETER ["Standard_Parallel_2", 38.966667], PARAMETER ["Central_Meridian", -84.250000], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kentucky 1601, Northern Zone (1983, US Survey feet)', 41033, 41033, 'Oracle', 'PROJCS["Kentucky 1601, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.966667], PARAMETER ["Standard_Parallel_2", 38.966667], PARAMETER ["Central_Meridian", -84.250000], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kentucky 1601, Northern Zone (1983, meters)', 41034, 41034, 'Oracle', 'PROJCS["Kentucky 1601, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.966667], PARAMETER ["Standard_Parallel_2", 38.966667], PARAMETER ["Central_Meridian", -84.250000], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kentucky 1602, Southern Zone (1927)', 41035, 41035, 'Oracle', 'PROJCS["Kentucky 1602, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.733333], PARAMETER ["Standard_Parallel_2", 37.933333], PARAMETER ["Central_Meridian", -85.750000], PARAMETER ["Latitude_Of_Origin", 36.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kentucky 1602, Southern Zone (1983, US Survey feet)', 41036, 41036, 'Oracle', 'PROJCS["Kentucky 1602, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.733333], PARAMETER ["Standard_Parallel_2", 37.933333], PARAMETER ["Central_Meridian", -85.750000], PARAMETER ["Latitude_Of_Origin", 36.333333], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Kentucky 1602, Southern Zone (1983, meters)', 41037, 41037, 'Oracle', 'PROJCS["Kentucky 1602, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.733333], PARAMETER ["Standard_Parallel_2", 37.933333], PARAMETER ["Central_Meridian", -85.750000], PARAMETER ["Latitude_Of_Origin", 36.333333], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1701, Northern Zone (1927)', 41038, 41038, 'Oracle', 'PROJCS["Louisiana 1701, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 31.166667], PARAMETER ["Standard_Parallel_2", 32.666667], PARAMETER ["Central_Meridian", -92.500000], PARAMETER ["Latitude_Of_Origin", 30.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1701, Northern Zone (1983, US Survey feet)', 41039, 41039, 'Oracle', 'PROJCS["Louisiana 1701, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 31.166667], PARAMETER ["Standard_Parallel_2", 32.666667], PARAMETER ["Central_Meridian", -92.500000], PARAMETER ["Latitude_Of_Origin", 30.500000], PARAMETER ["False_Easting", 1000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1701, Northern Zone (1983, meters)', 41040, 41040, 'Oracle', 'PROJCS["Louisiana 1701, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 31.166667], PARAMETER ["Standard_Parallel_2", 32.666667], PARAMETER ["Central_Meridian", -92.500000], PARAMETER ["Latitude_Of_Origin", 30.500000], PARAMETER ["False_Easting", 1000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1702, Southern Zone (1927)', 41041, 41041, 'Oracle', 'PROJCS["Louisiana 1702, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 29.300000], PARAMETER ["Standard_Parallel_2", 30.670000], PARAMETER ["Central_Meridian", -91.333333], PARAMETER ["Latitude_Of_Origin", 28.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1702, Southern Zone (1983, US Survey feet)', 41042, 41042, 'Oracle', 'PROJCS["Louisiana 1702, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 29.300000], PARAMETER ["Standard_Parallel_2", 30.700000], PARAMETER ["Central_Meridian", -91.333333], PARAMETER ["Latitude_Of_Origin", 28.500000], PARAMETER ["False_Easting", 1000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1702, Southern Zone (1983, meters)', 41043, 41043, 'Oracle', 'PROJCS["Louisiana 1702, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 29.300000], PARAMETER ["Standard_Parallel_2", 30.700000], PARAMETER ["Central_Meridian", -91.333333], PARAMETER ["Latitude_Of_Origin", 28.500000], PARAMETER ["False_Easting", 1000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1703, Offshore Zone (1927)', 41044, 41044, 'Oracle', 'PROJCS["Louisiana 1703, Offshore Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 26.166667], PARAMETER ["Standard_Parallel_2", 27.833333], PARAMETER ["Central_Meridian", -91.333333], PARAMETER ["Latitude_Of_Origin", 25.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1703, Offshore Zone (1983, US Survey feet)', 41045, 41045, 'Oracle', 'PROJCS["Louisiana 1703, Offshore Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 26.166667], PARAMETER ["Standard_Parallel_2", 27.833333], PARAMETER ["Central_Meridian", -91.333333], PARAMETER ["Latitude_Of_Origin", 25.500000], PARAMETER ["False_Easting", 1000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Louisiana 1703, Offshore Zone (1983, meters)', 41046, 41046, 'Oracle', 'PROJCS["Louisiana 1703, Offshore Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 26.166667], PARAMETER ["Standard_Parallel_2", 27.833333], PARAMETER ["Central_Meridian", -91.333333], PARAMETER ["Latitude_Of_Origin", 25.500000], PARAMETER ["False_Easting", 1000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maryland 1900 (1927)', 41047, 41047, 'Oracle', 'PROJCS["Maryland 1900 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.300000], PARAMETER ["Standard_Parallel_2", 39.450000], PARAMETER ["Central_Meridian", -77.000000], PARAMETER ["Latitude_Of_Origin", 37.833333], PARAMETER ["False_Easting", 243840.487681], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maryland 1900 (1983, US Survey feet)', 41048, 41048, 'Oracle', 'PROJCS["Maryland 1900 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.300000], PARAMETER ["Standard_Parallel_2", 39.450000], PARAMETER ["Central_Meridian", -77.000000], PARAMETER ["Latitude_Of_Origin", 37.666667], PARAMETER ["False_Easting", 400000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maryland 1900 (1983, meters)', 41049, 41049, 'Oracle', 'PROJCS["Maryland 1900 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.300000], PARAMETER ["Standard_Parallel_2", 39.450000], PARAMETER ["Central_Meridian", -77.000000], PARAMETER ["Latitude_Of_Origin", 37.666667], PARAMETER ["False_Easting", 400000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Massachusetts 2001, Mainland Zone (1927)', 41050, 41050, 'Oracle', 'PROJCS["Massachusetts 2001, Mainland Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.716667], PARAMETER ["Standard_Parallel_2", 42.683333], PARAMETER ["Central_Meridian", -71.500000], PARAMETER ["Latitude_Of_Origin", 41.000000], PARAMETER ["False_Easting", 182880.365761], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Massachusetts 2001, Mainland Zone (1983, US Survey feet)', 41051, 41051, 'Oracle', 'PROJCS["Massachusetts 2001, Mainland Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.716667], PARAMETER ["Standard_Parallel_2", 42.683333], PARAMETER ["Central_Meridian", -71.500000], PARAMETER ["Latitude_Of_Origin", 41.000000], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 750000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Massachusetts 2001, Mainland Zone (1983, meters)', 41052, 41052, 'Oracle', 'PROJCS["Massachusetts 2001, Mainland Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.716667], PARAMETER ["Standard_Parallel_2", 42.683333], PARAMETER ["Central_Meridian", -71.500000], PARAMETER ["Latitude_Of_Origin", 41.000000], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 750000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Massachusetts 2002, Island Zone (1927)', 41053, 41053, 'Oracle', 'PROJCS["Massachusetts 2002, Island Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.283333], PARAMETER ["Standard_Parallel_2", 41.483333], PARAMETER ["Central_Meridian", -70.500000], PARAMETER ["Latitude_Of_Origin", 41.000000], PARAMETER ["False_Easting", 243840.487681], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Massachusetts 2002, Island Zone (1983, US Survey feet)', 41054, 41054, 'Oracle', 'PROJCS["Massachusetts 2002, Island Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.283333], PARAMETER ["Standard_Parallel_2", 41.483333], PARAMETER ["Central_Meridian", -70.500000], PARAMETER ["Latitude_Of_Origin", 41.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Massachusetts 2002, Island Zone (1983, meters)', 41055, 41055, 'Oracle', 'PROJCS["Massachusetts 2002, Island Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.283333], PARAMETER ["Standard_Parallel_2", 41.483333], PARAMETER ["Central_Meridian", -70.500000], PARAMETER ["Latitude_Of_Origin", 41.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2111, Northern Zone (1927)', 41056, 41056, 'Oracle', 'PROJCS["Michigan 2111, Northern Zone (1927)", GEOGCS [ "NAD 27 (Michigan)", DATUM ["NAD 27 (Michigan)", SPHEROID ["Clarke 1866 (Michigan)", 6378450.047484481, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.483333], PARAMETER ["Standard_Parallel_2", 47.083333], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["Latitude_Of_Origin", 44.783333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2111, Northern Zone (1983, US Survey feet)', 41057, 41057, 'Oracle', 'PROJCS["Michigan 2111, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.483333], PARAMETER ["Standard_Parallel_2", 47.083333], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["Latitude_Of_Origin", 44.783333], PARAMETER ["False_Easting", 8000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2111, Northern Zone (1983, feet)', 41058, 41058, 'Oracle', 'PROJCS["Michigan 2111, Northern Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.483333], PARAMETER ["Standard_Parallel_2", 47.083333], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["Latitude_Of_Origin", 44.783333], PARAMETER ["False_Easting", 8000000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2111, Northern Zone (1983, meters)', 41059, 41059, 'Oracle', 'PROJCS["Michigan 2111, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.483333], PARAMETER ["Standard_Parallel_2", 47.083333], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["Latitude_Of_Origin", 44.783333], PARAMETER ["False_Easting", 8000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2112, Central Zone (1927)', 41060, 41060, 'Oracle', 'PROJCS["Michigan 2112, Central Zone (1927)", GEOGCS [ "NAD 27 (Michigan)", DATUM ["NAD 27 (Michigan)", SPHEROID ["Clarke 1866 (Michigan)", 6378450.047484481, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.183333], PARAMETER ["Standard_Parallel_2", 45.700000], PARAMETER ["Central_Meridian", -84.333333], PARAMETER ["Latitude_Of_Origin", 43.316667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2112, Central Zone (1983, US Survey feet)', 41061, 41061, 'Oracle', 'PROJCS["Michigan 2112, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.183333], PARAMETER ["Standard_Parallel_2", 45.700000], PARAMETER ["Central_Meridian", -84.366667], PARAMETER ["Latitude_Of_Origin", 43.316667], PARAMETER ["False_Easting", 6000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2112, Central Zone (1983, feet)', 41062, 41062, 'Oracle', 'PROJCS["Michigan 2112, Central Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.183333], PARAMETER ["Standard_Parallel_2", 45.700000], PARAMETER ["Central_Meridian", -84.366667], PARAMETER ["Latitude_Of_Origin", 43.316667], PARAMETER ["False_Easting", 6000000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2112, Central Zone (1983, meters)', 41063, 41063, 'Oracle', 'PROJCS["Michigan 2112, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.183333], PARAMETER ["Standard_Parallel_2", 45.700000], PARAMETER ["Central_Meridian", -84.366667], PARAMETER ["Latitude_Of_Origin", 43.316667], PARAMETER ["False_Easting", 6000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2113, Southern Zone (1927)', 41064, 41064, 'Oracle', 'PROJCS["Michigan 2113, Southern Zone (1927)", GEOGCS [ "NAD 27 (Michigan)", DATUM ["NAD 27 (Michigan)", SPHEROID ["Clarke 1866 (Michigan)", 6378450.047484481, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.100000], PARAMETER ["Standard_Parallel_2", 43.666667], PARAMETER ["Central_Meridian", -84.333333], PARAMETER ["Latitude_Of_Origin", 41.500000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2113, Southern Zone (1983, US Survey feet)', 41065, 41065, 'Oracle', 'PROJCS["Michigan 2113, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.100000], PARAMETER ["Standard_Parallel_2", 43.666667], PARAMETER ["Central_Meridian", -84.366667], PARAMETER ["Latitude_Of_Origin", 41.500000], PARAMETER ["False_Easting", 4000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2113, Southern Zone (1983, feet)', 41066, 41066, 'Oracle', 'PROJCS["Michigan 2113, Southern Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.100000], PARAMETER ["Standard_Parallel_2", 43.666667], PARAMETER ["Central_Meridian", -84.366667], PARAMETER ["Latitude_Of_Origin", 41.500000], PARAMETER ["False_Easting", 4000000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Michigan 2113, Southern Zone (1983, meters)', 41067, 41067, 'Oracle', 'PROJCS["Michigan 2113, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.100000], PARAMETER ["Standard_Parallel_2", 43.666667], PARAMETER ["Central_Meridian", -84.366667], PARAMETER ["Latitude_Of_Origin", 41.500000], PARAMETER ["False_Easting", 4000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2201, Northern Zone (1927)', 41068, 41068, 'Oracle', 'PROJCS["Minnesota 2201, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.033333], PARAMETER ["Standard_Parallel_2", 48.633333], PARAMETER ["Central_Meridian", -93.100000], PARAMETER ["Latitude_Of_Origin", 46.500000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2201, Northern Zone (1983, US Survey feet)', 41069, 41069, 'Oracle', 'PROJCS["Minnesota 2201, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.033333], PARAMETER ["Standard_Parallel_2", 48.633333], PARAMETER ["Central_Meridian", -93.100000], PARAMETER ["Latitude_Of_Origin", 46.500000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2201, Northern Zone (1983, meters)', 41070, 41070, 'Oracle', 'PROJCS["Minnesota 2201, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.033333], PARAMETER ["Standard_Parallel_2", 48.633333], PARAMETER ["Central_Meridian", -93.100000], PARAMETER ["Latitude_Of_Origin", 46.500000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2202, Central Zone (1927)', 41071, 41071, 'Oracle', 'PROJCS["Minnesota 2202, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.616667], PARAMETER ["Standard_Parallel_2", 47.050000], PARAMETER ["Central_Meridian", -94.250000], PARAMETER ["Latitude_Of_Origin", 45.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2202, Central Zone (1983, US Survey feet)', 41072, 41072, 'Oracle', 'PROJCS["Minnesota 2202, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.616667], PARAMETER ["Standard_Parallel_2", 47.050000], PARAMETER ["Central_Meridian", -94.250000], PARAMETER ["Latitude_Of_Origin", 45.000000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2202, Central Zone (1983, meters)', 41073, 41073, 'Oracle', 'PROJCS["Minnesota 2202, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.616667], PARAMETER ["Standard_Parallel_2", 47.050000], PARAMETER ["Central_Meridian", -94.250000], PARAMETER ["Latitude_Of_Origin", 45.000000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2203, South Zone (1927)', 41074, 41074, 'Oracle', 'PROJCS["Minnesota 2203, South Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 43.783333], PARAMETER ["Standard_Parallel_2", 45.216667], PARAMETER ["Central_Meridian", -94.000000], PARAMETER ["Latitude_Of_Origin", 43.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2203, South Zone (1983, US Survey feet)', 41075, 41075, 'Oracle', 'PROJCS["Minnesota 2203, South Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 43.783333], PARAMETER ["Standard_Parallel_2", 45.216667], PARAMETER ["Central_Meridian", -94.000000], PARAMETER ["Latitude_Of_Origin", 43.000000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Minnesota 2203, South Zone (1983, meters)', 41076, 41076, 'Oracle', 'PROJCS["Minnesota 2203, South Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 43.783333], PARAMETER ["Standard_Parallel_2", 45.216667], PARAMETER ["Central_Meridian", -94.000000], PARAMETER ["Latitude_Of_Origin", 43.000000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Montana 2500 (1983, US Survey feet)', 41077, 41077, 'Oracle', 'PROJCS["Montana 2500 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.000000], PARAMETER ["Standard_Parallel_2", 49.000000], PARAMETER ["Central_Meridian", -109.500000], PARAMETER ["Latitude_Of_Origin", 44.250000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Montana 2500 (1983, feet)', 41078, 41078, 'Oracle', 'PROJCS["Montana 2500 (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.000000], PARAMETER ["Standard_Parallel_2", 49.000000], PARAMETER ["Central_Meridian", -109.500000], PARAMETER ["Latitude_Of_Origin", 44.250000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Montana 2500 (1983, meters)', 41079, 41079, 'Oracle', 'PROJCS["Montana 2500 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.000000], PARAMETER ["Standard_Parallel_2", 49.000000], PARAMETER ["Central_Meridian", -109.500000], PARAMETER ["Latitude_Of_Origin", 44.250000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Montana 2501, Northern Zone (1927)', 41080, 41080, 'Oracle', 'PROJCS["Montana 2501, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.850000], PARAMETER ["Standard_Parallel_2", 48.716667], PARAMETER ["Central_Meridian", -109.500000], PARAMETER ["Latitude_Of_Origin", 47.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Montana 2502, Central Zone (1927)', 41081, 41081, 'Oracle', 'PROJCS["Montana 2502, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 46.450000], PARAMETER ["Standard_Parallel_2", 47.883333], PARAMETER ["Central_Meridian", -109.500000], PARAMETER ["Latitude_Of_Origin", 45.833333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Montana 2503, Southern Zone (1927)', 41082, 41082, 'Oracle', 'PROJCS["Montana 2503, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.866667], PARAMETER ["Standard_Parallel_2", 46.400000], PARAMETER ["Central_Meridian", -109.500000], PARAMETER ["Latitude_Of_Origin", 44.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nebraska 2600 (1983, US Survey feet)', 41083, 41083, 'Oracle', 'PROJCS["Nebraska 2600 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.000000], PARAMETER ["Standard_Parallel_2", 43.000000], PARAMETER ["Central_Meridian", -100.000000], PARAMETER ["Latitude_Of_Origin", 39.833333], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nebraska 2600 (1983, meters)', 41084, 41084, 'Oracle', 'PROJCS["Nebraska 2600 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.000000], PARAMETER ["Standard_Parallel_2", 43.000000], PARAMETER ["Central_Meridian", -100.000000], PARAMETER ["Latitude_Of_Origin", 39.833333], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nebraska 2601, Northern Zone (1927)', 41085, 41085, 'Oracle', 'PROJCS["Nebraska 2601, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 41.850000], PARAMETER ["Standard_Parallel_2", 42.816667], PARAMETER ["Central_Meridian", -100.000000], PARAMETER ["Latitude_Of_Origin", 41.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nebraska 2602, Southern Zone (1927)', 41086, 41086, 'Oracle', 'PROJCS["Nebraska 2602, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.283333], PARAMETER ["Standard_Parallel_2", 41.716667], PARAMETER ["Central_Meridian", -99.500000], PARAMETER ["Latitude_Of_Origin", 39.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3104, Long Island (1927)', 41087, 41087, 'Oracle', 'PROJCS["New York 3104, Long Island (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.666667], PARAMETER ["Standard_Parallel_2", 41.033333], PARAMETER ["Central_Meridian", -74.000000], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 609601.219202], PARAMETER ["False_Northing", 30480.060960], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3104, Long Island Zone (1983, US Survey feet)', 41088, 41088, 'Oracle', 'PROJCS["New York 3104, Long Island Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.666667], PARAMETER ["Standard_Parallel_2", 41.033333], PARAMETER ["Central_Meridian", -74.000000], PARAMETER ["Latitude_Of_Origin", 40.166667], PARAMETER ["False_Easting", 300000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3104, Long Island Zone (1983, meters)', 41089, 41089, 'Oracle', 'PROJCS["New York 3104, Long Island Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.666667], PARAMETER ["Standard_Parallel_2", 41.033333], PARAMETER ["Central_Meridian", -74.000000], PARAMETER ["Latitude_Of_Origin", 40.166667], PARAMETER ["False_Easting", 300000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Carolina 3200 (1927)', 41090, 41090, 'Oracle', 'PROJCS["North Carolina 3200 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.333333], PARAMETER ["Standard_Parallel_2", 36.166667], PARAMETER ["Central_Meridian", -79.000000], PARAMETER ["Latitude_Of_Origin", 33.750000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Carolina 3200 (1983, US Survey feet)', 41091, 41091, 'Oracle', 'PROJCS["North Carolina 3200 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.333333], PARAMETER ["Standard_Parallel_2", 36.166667], PARAMETER ["Central_Meridian", -79.000000], PARAMETER ["Latitude_Of_Origin", 33.750000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Carolina 3200 (1983, meters)', 41092, 41092, 'Oracle', 'PROJCS["North Carolina 3200 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.333333], PARAMETER ["Standard_Parallel_2", 36.166667], PARAMETER ["Central_Meridian", -79.000000], PARAMETER ["Latitude_Of_Origin", 33.750000], PARAMETER ["False_Easting", 609601.219202], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Dakota 3301, Northern Zone (1927)', 41093, 41093, 'Oracle', 'PROJCS["North Dakota 3301, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.433333], PARAMETER ["Standard_Parallel_2", 48.733333], PARAMETER ["Central_Meridian", -100.500000], PARAMETER ["Latitude_Of_Origin", 47.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Dakota 3301, Northern Zone (1983, US Survey feet)', 41094, 41094, 'Oracle', 'PROJCS["North Dakota 3301, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.433333], PARAMETER ["Standard_Parallel_2", 48.733333], PARAMETER ["Central_Meridian", -100.500000], PARAMETER ["Latitude_Of_Origin", 47.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Dakota 3301, Northern Zone (1983, meters)', 41095, 41095, 'Oracle', 'PROJCS["North Dakota 3301, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.433333], PARAMETER ["Standard_Parallel_2", 48.733333], PARAMETER ["Central_Meridian", -100.500000], PARAMETER ["Latitude_Of_Origin", 47.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Dakota 3302, Southern Zone (1927)', 41096, 41096, 'Oracle', 'PROJCS["North Dakota 3302, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 46.183333], PARAMETER ["Standard_Parallel_2", 47.483333], PARAMETER ["Central_Meridian", -100.500000], PARAMETER ["Latitude_Of_Origin", 45.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Dakota 3302, Southern Zone (1983, US Survey feet)', 41097, 41097, 'Oracle', 'PROJCS["North Dakota 3302, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 46.183333], PARAMETER ["Standard_Parallel_2", 47.483333], PARAMETER ["Central_Meridian", -100.500000], PARAMETER ["Latitude_Of_Origin", 45.666667], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Dakota 3302, Southern Zone (1983, meters)', 41098, 41098, 'Oracle', 'PROJCS["North Dakota 3302, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 46.183333], PARAMETER ["Standard_Parallel_2", 47.483333], PARAMETER ["Central_Meridian", -100.500000], PARAMETER ["Latitude_Of_Origin", 45.666667], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Ohio 3401, Northern Zone (1927)', 41099, 41099, 'Oracle', 'PROJCS["Ohio 3401, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.433333], PARAMETER ["Standard_Parallel_2", 41.700000], PARAMETER ["Central_Meridian", -82.500000], PARAMETER ["Latitude_Of_Origin", 39.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Ohio 3401, Northern Zone (1983, US Survey feet)', 41100, 41100, 'Oracle', 'PROJCS["Ohio 3401, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.433333], PARAMETER ["Standard_Parallel_2", 41.700000], PARAMETER ["Central_Meridian", -82.500000], PARAMETER ["Latitude_Of_Origin", 39.666667], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Ohio 3401, Northern Zone (1983, meters)', 41101, 41101, 'Oracle', 'PROJCS["Ohio 3401, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.433333], PARAMETER ["Standard_Parallel_2", 41.700000], PARAMETER ["Central_Meridian", -82.500000], PARAMETER ["Latitude_Of_Origin", 39.666667], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Ohio 3402, Southern Zone (1927)', 41102, 41102, 'Oracle', 'PROJCS["Ohio 3402, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.733333], PARAMETER ["Standard_Parallel_2", 40.033333], PARAMETER ["Central_Meridian", -82.500000], PARAMETER ["Latitude_Of_Origin", 38.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Ohio 3402, Southern Zone (1983, US Survey feet)', 41103, 41103, 'Oracle', 'PROJCS["Ohio 3402, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.733333], PARAMETER ["Standard_Parallel_2", 40.033333], PARAMETER ["Central_Meridian", -82.500000], PARAMETER ["Latitude_Of_Origin", 38.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Ohio 3402, Southern Zone (1983, meters)', 41104, 41104, 'Oracle', 'PROJCS["Ohio 3402, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.733333], PARAMETER ["Standard_Parallel_2", 40.033333], PARAMETER ["Central_Meridian", -82.500000], PARAMETER ["Latitude_Of_Origin", 38.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oklahoma 3501, Northern Zone (1927)', 41105, 41105, 'Oracle', 'PROJCS["Oklahoma 3501, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 35.566667], PARAMETER ["Standard_Parallel_2", 36.766667], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 35.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oklahoma 3501, Northern Zone (1983, US Survey feet)', 41106, 41106, 'Oracle', 'PROJCS["Oklahoma 3501, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 35.566667], PARAMETER ["Standard_Parallel_2", 36.766667], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 35.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oklahoma 3501, Northern Zone (1983, meters)', 41107, 41107, 'Oracle', 'PROJCS["Oklahoma 3501, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 35.566667], PARAMETER ["Standard_Parallel_2", 36.766667], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 35.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oklahoma 3502, Southern Zone (1927)', 41108, 41108, 'Oracle', 'PROJCS["Oklahoma 3502, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.933333], PARAMETER ["Standard_Parallel_2", 35.233333], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 33.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oklahoma 3502, Southern Zone (1983, US Survey feet)', 41109, 41109, 'Oracle', 'PROJCS["Oklahoma 3502, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.933333], PARAMETER ["Standard_Parallel_2", 35.233333], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 33.333333], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oklahoma 3502, Southern Zone (1983, meters)', 41110, 41110, 'Oracle', 'PROJCS["Oklahoma 3502, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.933333], PARAMETER ["Standard_Parallel_2", 35.233333], PARAMETER ["Central_Meridian", -98.000000], PARAMETER ["Latitude_Of_Origin", 33.333333], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oregon 3601, Northern Zone (1927)', 41111, 41111, 'Oracle', 'PROJCS["Oregon 3601, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.333333], PARAMETER ["Standard_Parallel_2", 46.000000], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 43.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oregon 3601, Northern Zone (1983, US Survey feet)', 41112, 41112, 'Oracle', 'PROJCS["Oregon 3601, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.333333], PARAMETER ["Standard_Parallel_2", 46.000000], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 43.666667], PARAMETER ["False_Easting", 2500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oregon 3601, Northern Zone (1983, feet)', 41113, 41113, 'Oracle', 'PROJCS["Oregon 3601, Northern Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.333333], PARAMETER ["Standard_Parallel_2", 46.000000], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 43.666667], PARAMETER ["False_Easting", 2500000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oregon 3601, Northern Zone (1983, meters)', 41114, 41114, 'Oracle', 'PROJCS["Oregon 3601, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.333333], PARAMETER ["Standard_Parallel_2", 46.000000], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 43.666667], PARAMETER ["False_Easting", 2500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oregon 3602, Southern Zone (1927)', 41115, 41115, 'Oracle', 'PROJCS["Oregon 3602, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.333333], PARAMETER ["Standard_Parallel_2", 44.000000], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oregon 3602, Southern Zone (1983, US Survey feet)', 41116, 41116, 'Oracle', 'PROJCS["Oregon 3602, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.333333], PARAMETER ["Standard_Parallel_2", 44.000000], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 1500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oregon 3602, Southern Zone (1983, feet)', 41117, 41117, 'Oracle', 'PROJCS["Oregon 3602, Southern Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.333333], PARAMETER ["Standard_Parallel_2", 44.000000], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 1500000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Oregon 3602, Southern Zone (1983, meters)', 41118, 41118, 'Oracle', 'PROJCS["Oregon 3602, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.333333], PARAMETER ["Standard_Parallel_2", 44.000000], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 1500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Pennsylvania 3701, Northern Zone (1927)', 41119, 41119, 'Oracle', 'PROJCS["Pennsylvania 3701, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.883333], PARAMETER ["Standard_Parallel_2", 41.950000], PARAMETER ["Central_Meridian", -77.750000], PARAMETER ["Latitude_Of_Origin", 40.166667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Pennsylvania 3701, Northern Zone (1983, US Survey feet)', 41120, 41120, 'Oracle', 'PROJCS["Pennsylvania 3701, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.883333], PARAMETER ["Standard_Parallel_2", 41.950000], PARAMETER ["Central_Meridian", -77.750000], PARAMETER ["Latitude_Of_Origin", 40.166667], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Pennsylvania 3701, Northern Zone (1983, meters)', 41121, 41121, 'Oracle', 'PROJCS["Pennsylvania 3701, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.883333], PARAMETER ["Standard_Parallel_2", 41.950000], PARAMETER ["Central_Meridian", -77.750000], PARAMETER ["Latitude_Of_Origin", 40.166667], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values 
          ( 'Pennsylvania Polyconic', 141122, 141122, 'Oracle', 
          'PROJCS["Pennsylvania Polyconic", 
             GEOGCS [ "NAD 83", 
               DATUM ["NAD 83", 
               SPHEROID ["GRS 80", 6378137, 298.257222101]], 
               PRIMEM [ "Greenwich", 0.000000 ], 
               UNIT ["Decimal Degree", 0.01745329251994330]], 
             PROJECTION ["Polyconic"], 
               PARAMETER ["Central_Meridian", -77.750000], 
               PARAMETER ["Latitude_Of_Origin", 40.925], 
               UNIT ["Meter", 1.000000000000]]' ); 

insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Pennsylvania 3702, Southern Zone (1927)', 41122, 41122, 'Oracle', 'PROJCS["Pennsylvania 3702, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.933333], PARAMETER ["Standard_Parallel_2", 40.966667], PARAMETER ["Central_Meridian", -77.750000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Pennsylvania 3702, Southern Zone (1983, US Survey feet)', 41123, 41123, 'Oracle', 'PROJCS["Pennsylvania 3702, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.933333], PARAMETER ["Standard_Parallel_2", 40.966667], PARAMETER ["Central_Meridian", -77.750000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Pennsylvania 3702, Southern Zone (1983, meters)', 41124, 41124, 'Oracle', 'PROJCS["Pennsylvania 3702, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.933333], PARAMETER ["Standard_Parallel_2", 40.966667], PARAMETER ["Central_Meridian", -77.750000], PARAMETER ["Latitude_Of_Origin", 39.333333], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Puerto Rico and Virgin Islands 5200 (1983, US Survey feet)', 41125, 41125, 'Oracle', 'PROJCS["Puerto Rico and Virgin Islands 5200 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 18.033333], PARAMETER ["Standard_Parallel_2", 18.433333], PARAMETER ["Central_Meridian", -66.433333], PARAMETER ["Latitude_Of_Origin", 17.833333], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 200000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Puerto Rico and Virgin Islands 5200 (1983, meters)', 41126, 41126, 'Oracle', 'PROJCS["Puerto Rico and Virgin Islands 5200 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 18.033333], PARAMETER ["Standard_Parallel_2", 18.433333], PARAMETER ["Central_Meridian", -66.433333], PARAMETER ["Latitude_Of_Origin", 17.833333], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Puerto Rico and Virgin Islands 5201, Zone 1 (1927)', 41127, 41127, 'Oracle', 'PROJCS["Puerto Rico and Virgin Islands 5201, Zone 1 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 18.033333], PARAMETER ["Standard_Parallel_2", 18.433333], PARAMETER ["Central_Meridian", -66.433333], PARAMETER ["Latitude_Of_Origin", 18.433333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Puerto Rico, St. Croix, Virgin Islands 5202, Zone 2 (1927)', 41128, 41128, 'Oracle', 'PROJCS["Puerto Rico, St. Croix, Virgin Islands 5202, Zone 2 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 18.033333], PARAMETER ["Standard_Parallel_2", 18.433333], PARAMETER ["Central_Meridian", -66.433333], PARAMETER ["Latitude_Of_Origin", 18.433333], PARAMETER ["False_Easting", 152400.304801], PARAMETER ["False_Northing", 30480.060960], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Carolina 3900 (1983, US Survey feet)', 41129, 41129, 'Oracle', 'PROJCS["South Carolina 3900 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.500000], PARAMETER ["Standard_Parallel_2", 34.833333], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 31.833333], PARAMETER ["False_Easting", 609600.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Carolina 3900 (1983, feet)', 41130, 41130, 'Oracle', 'PROJCS["South Carolina 3900 (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.500000], PARAMETER ["Standard_Parallel_2", 34.833333], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 31.833333], PARAMETER ["False_Easting", 609600.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Carolina 3900 (1983, meters)', 41131, 41131, 'Oracle', 'PROJCS["South Carolina 3900 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.500000], PARAMETER ["Standard_Parallel_2", 34.833333], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 31.833333], PARAMETER ["False_Easting", 609600.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Carolina 3901, Northern Zone (1927)', 41132, 41132, 'Oracle', 'PROJCS["South Carolina 3901, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 33.766667], PARAMETER ["Standard_Parallel_2", 34.966667], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 33.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Carolina 3902, Southern Zone (1927)', 41133, 41133, 'Oracle', 'PROJCS["South Carolina 3902, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.333333], PARAMETER ["Standard_Parallel_2", 33.666667], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 31.833333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Dakota 4001, Northern Zone (1927)', 41134, 41134, 'Oracle', 'PROJCS["South Dakota 4001, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.416667], PARAMETER ["Standard_Parallel_2", 45.683333], PARAMETER ["Central_Meridian", -100.000000], PARAMETER ["Latitude_Of_Origin", 43.833333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Dakota 4001, Northern Zone (1983, US Survey feet)', 41135, 41135, 'Oracle', 'PROJCS["South Dakota 4001, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.416667], PARAMETER ["Standard_Parallel_2", 45.683333], PARAMETER ["Central_Meridian", -100.000000], PARAMETER ["Latitude_Of_Origin", 43.833333], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Dakota 4001, Northern Zone (1983, meters)', 41136, 41136, 'Oracle', 'PROJCS["South Dakota 4001, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.416667], PARAMETER ["Standard_Parallel_2", 45.683333], PARAMETER ["Central_Meridian", -100.000000], PARAMETER ["Latitude_Of_Origin", 43.833333], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Dakota 4002, Southern Zone (1927)', 41137, 41137, 'Oracle', 'PROJCS["South Dakota 4002, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.833333], PARAMETER ["Standard_Parallel_2", 44.400000], PARAMETER ["Central_Meridian", -100.333333], PARAMETER ["Latitude_Of_Origin", 42.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Dakota 4002, Southern Zone (1983, US Survey feet)', 41138, 41138, 'Oracle', 'PROJCS["South Dakota 4002, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.833333], PARAMETER ["Standard_Parallel_2", 44.400000], PARAMETER ["Central_Meridian", -100.333333], PARAMETER ["Latitude_Of_Origin", 42.333333], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'South Dakota 4002, Southern Zone (1983, meters)', 41139, 41139, 'Oracle', 'PROJCS["South Dakota 4002, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.833333], PARAMETER ["Standard_Parallel_2", 44.400000], PARAMETER ["Central_Meridian", -100.333333], PARAMETER ["Latitude_Of_Origin", 42.333333], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Tennessee 4100 (1927)', 41140, 41140, 'Oracle', 'PROJCS["Tennessee 4100 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 35.250000], PARAMETER ["Standard_Parallel_2", 36.416667], PARAMETER ["Central_Meridian", -86.000000], PARAMETER ["Latitude_Of_Origin", 34.666667], PARAMETER ["False_Easting", 609601.219202], PARAMETER ["False_Northing", 30480.060960], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Tennessee 4100 (1983, US Survey feet)', 41141, 41141, 'Oracle', 'PROJCS["Tennessee 4100 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 35.250000], PARAMETER ["Standard_Parallel_2", 36.416667], PARAMETER ["Central_Meridian", -86.000000], PARAMETER ["Latitude_Of_Origin", 34.333333], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Tennessee 4100 (1983, meters)', 41142, 41142, 'Oracle', 'PROJCS["Tennessee 4100 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 35.250000], PARAMETER ["Standard_Parallel_2", 36.416667], PARAMETER ["Central_Meridian", -86.000000], PARAMETER ["Latitude_Of_Origin", 34.333333], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4201, Northern Zone (1927)', 41143, 41143, 'Oracle', 'PROJCS["Texas 4201, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.650000], PARAMETER ["Standard_Parallel_2", 36.183333], PARAMETER ["Central_Meridian", -101.500000], PARAMETER ["Latitude_Of_Origin", 34.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4201, Northern Zone (1983, US Survey feet)', 41144, 41144, 'Oracle', 'PROJCS["Texas 4201, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.650000], PARAMETER ["Standard_Parallel_2", 36.183333], PARAMETER ["Central_Meridian", -101.500000], PARAMETER ["Latitude_Of_Origin", 34.000000], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4201, Northern Zone (1983, meters)', 41145, 41145, 'Oracle', 'PROJCS["Texas 4201, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 34.650000], PARAMETER ["Standard_Parallel_2", 36.183333], PARAMETER ["Central_Meridian", -101.500000], PARAMETER ["Latitude_Of_Origin", 34.000000], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4202, North Central Zone (1927)', 41146, 41146, 'Oracle', 'PROJCS["Texas 4202, North Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.133333], PARAMETER ["Standard_Parallel_2", 33.966667], PARAMETER ["Central_Meridian", -97.500000], PARAMETER ["Latitude_Of_Origin", 31.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4202, North Central Zone (1983, US Survey feet)', 41147, 41147, 'Oracle', 'PROJCS["Texas 4202, North Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.133333], PARAMETER ["Standard_Parallel_2", 33.966667], PARAMETER ["Central_Meridian", -98.500000], PARAMETER ["Latitude_Of_Origin", 31.666667], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4202, North Central Zone (1983, meters)', 41148, 41148, 'Oracle', 'PROJCS["Texas 4202, North Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 32.133333], PARAMETER ["Standard_Parallel_2", 33.966667], PARAMETER ["Central_Meridian", -98.500000], PARAMETER ["Latitude_Of_Origin", 31.666667], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4203, Central Zone (1927)', 41149, 41149, 'Oracle', 'PROJCS["Texas 4203, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 30.116667], PARAMETER ["Standard_Parallel_2", 31.883333], PARAMETER ["Central_Meridian", -100.333333], PARAMETER ["Latitude_Of_Origin", 29.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4203, Central Zone (1983, US Survey feet)', 41150, 41150, 'Oracle', 'PROJCS["Texas 4203, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 30.116667], PARAMETER ["Standard_Parallel_2", 31.883333], PARAMETER ["Central_Meridian", -100.333333], PARAMETER ["Latitude_Of_Origin", 29.666667], PARAMETER ["False_Easting", 700000.000000], PARAMETER ["False_Northing", 3000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4203, Central Zone (1983, meters)', 41151, 41151, 'Oracle', 'PROJCS["Texas 4203, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 30.116667], PARAMETER ["Standard_Parallel_2", 31.883333], PARAMETER ["Central_Meridian", -100.333333], PARAMETER ["Latitude_Of_Origin", 29.666667], PARAMETER ["False_Easting", 700000.000000], PARAMETER ["False_Northing", 3000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4204, South Central Zone (1927)', 41152, 41152, 'Oracle', 'PROJCS["Texas 4204, South Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 28.383333], PARAMETER ["Standard_Parallel_2", 30.283333], PARAMETER ["Central_Meridian", -99.000000], PARAMETER ["Latitude_Of_Origin", 27.833333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4204, South Central Zone (1983, US Survey feet)', 41153, 41153, 'Oracle', 'PROJCS["Texas 4204, South Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 28.383333], PARAMETER ["Standard_Parallel_2", 30.283333], PARAMETER ["Central_Meridian", -99.000000], PARAMETER ["Latitude_Of_Origin", 27.833333], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 4000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4204, South Central Zone (1983, meters)', 41154, 41154, 'Oracle', 'PROJCS["Texas 4204, South Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 28.383333], PARAMETER ["Standard_Parallel_2", 30.283333], PARAMETER ["Central_Meridian", -99.000000], PARAMETER ["Latitude_Of_Origin", 27.833333], PARAMETER ["False_Easting", 600000.000000], PARAMETER ["False_Northing", 4000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4205, Southern Zone (1927)', 41155, 41155, 'Oracle', 'PROJCS["Texas 4205, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 26.166667], PARAMETER ["Standard_Parallel_2", 27.833333], PARAMETER ["Central_Meridian", -98.500000], PARAMETER ["Latitude_Of_Origin", 25.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4205, Southern Zone (1983, US Survey feet)', 41156, 41156, 'Oracle', 'PROJCS["Texas 4205, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 26.166667], PARAMETER ["Standard_Parallel_2", 27.833333], PARAMETER ["Central_Meridian", -98.500000], PARAMETER ["Latitude_Of_Origin", 25.666667], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 5000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Texas 4205, Southern Zone (1983, meters)', 41157, 41157, 'Oracle', 'PROJCS["Texas 4205, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 26.166667], PARAMETER ["Standard_Parallel_2", 27.833333], PARAMETER ["Central_Meridian", -98.500000], PARAMETER ["Latitude_Of_Origin", 25.666667], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 5000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4301, Northern Zone (1927)', 41158, 41158, 'Oracle', 'PROJCS["Utah 4301, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.716667], PARAMETER ["Standard_Parallel_2", 41.783333], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 40.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4301, Northern Zone (1983, US Survey feet)', 41159, 41159, 'Oracle', 'PROJCS["Utah 4301, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.716667], PARAMETER ["Standard_Parallel_2", 41.783333], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 40.333333], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4301, Northern Zone (1983, feet)', 41160, 41160, 'Oracle', 'PROJCS["Utah 4301, Northern Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.716667], PARAMETER ["Standard_Parallel_2", 41.783333], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 40.333333], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4301, Northern Zone (1983, meters)', 41161, 41161, 'Oracle', 'PROJCS["Utah 4301, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 40.716667], PARAMETER ["Standard_Parallel_2", 41.783333], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 40.333333], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4302, Central Zone (1927)', 41162, 41162, 'Oracle', 'PROJCS["Utah 4302, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.016667], PARAMETER ["Standard_Parallel_2", 40.650000], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 38.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4302, Central Zone (1983, US Survey feet)', 41163, 41163, 'Oracle', 'PROJCS["Utah 4302, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.016667], PARAMETER ["Standard_Parallel_2", 40.650000], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 38.333333], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4302, Central Zone (1983, feet)', 41164, 41164, 'Oracle', 'PROJCS["Utah 4302, Central Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.016667], PARAMETER ["Standard_Parallel_2", 40.650000], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 38.333333], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4302, Central Zone (1983, meters)', 41165, 41165, 'Oracle', 'PROJCS["Utah 4302, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.016667], PARAMETER ["Standard_Parallel_2", 40.650000], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 38.333333], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4303, Southern Zone (1927)', 41166, 41166, 'Oracle', 'PROJCS["Utah 4303, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.216667], PARAMETER ["Standard_Parallel_2", 38.350000], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4303, Southern Zone (1983, US Survey feet)', 41167, 41167, 'Oracle', 'PROJCS["Utah 4303, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.216667], PARAMETER ["Standard_Parallel_2", 38.350000], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 3000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4303, Southern Zone (1983, feet)', 41168, 41168, 'Oracle', 'PROJCS["Utah 4303, Southern Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.216667], PARAMETER ["Standard_Parallel_2", 38.350000], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 3000000.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Utah 4303, Southern Zone (1983, meters)', 41169, 41169, 'Oracle', 'PROJCS["Utah 4303, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.216667], PARAMETER ["Standard_Parallel_2", 38.350000], PARAMETER ["Central_Meridian", -111.500000], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 3000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Virginia 4501, Northern Zone (1927)', 41170, 41170, 'Oracle', 'PROJCS["Virginia 4501, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.033333], PARAMETER ["Standard_Parallel_2", 39.200000], PARAMETER ["Central_Meridian", -78.500000], PARAMETER ["Latitude_Of_Origin", 37.666667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Virginia 4501, Northern Zone (1983, US Survey feet)', 41171, 41171, 'Oracle', 'PROJCS["Virginia 4501, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.033333], PARAMETER ["Standard_Parallel_2", 39.200000], PARAMETER ["Central_Meridian", -78.500000], PARAMETER ["Latitude_Of_Origin", 37.666667], PARAMETER ["False_Easting", 3500000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Virginia 4501, Northern Zone (1983, meters)', 41172, 41172, 'Oracle', 'PROJCS["Virginia 4501, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 38.033333], PARAMETER ["Standard_Parallel_2", 39.200000], PARAMETER ["Central_Meridian", -78.500000], PARAMETER ["Latitude_Of_Origin", 37.666667], PARAMETER ["False_Easting", 3500000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Virginia 4502, Southern Zone (1927)', 41173, 41173, 'Oracle', 'PROJCS["Virginia 4502, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.766667], PARAMETER ["Standard_Parallel_2", 37.966667], PARAMETER ["Central_Meridian", -78.500000], PARAMETER ["Latitude_Of_Origin", 36.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Virginia 4502, Southern Zone (1983, US Survey feet)', 41174, 41174, 'Oracle', 'PROJCS["Virginia 4502, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.766667], PARAMETER ["Standard_Parallel_2", 37.966667], PARAMETER ["Central_Meridian", -78.500000], PARAMETER ["Latitude_Of_Origin", 36.333333], PARAMETER ["False_Easting", 3500000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Virginia 4502, Southern Zone (1983, meters)', 41175, 41175, 'Oracle', 'PROJCS["Virginia 4502, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 36.766667], PARAMETER ["Standard_Parallel_2", 37.966667], PARAMETER ["Central_Meridian", -78.500000], PARAMETER ["Latitude_Of_Origin", 36.333333], PARAMETER ["False_Easting", 3500000.000000], PARAMETER ["False_Northing", 1000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Washington 4601, Northern Zone (1927)', 41176, 41176, 'Oracle', 'PROJCS["Washington 4601, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.500000], PARAMETER ["Standard_Parallel_2", 48.733333], PARAMETER ["Central_Meridian", -120.833333], PARAMETER ["Latitude_Of_Origin", 47.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Washington 4601, Northern Zone (1983, US Survey feet)', 41177, 41177, 'Oracle', 'PROJCS["Washington 4601, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.500000], PARAMETER ["Standard_Parallel_2", 48.733333], PARAMETER ["Central_Meridian", -120.833333], PARAMETER ["Latitude_Of_Origin", 47.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Washington 4601, Northern Zone (1983, meters)', 41178, 41178, 'Oracle', 'PROJCS["Washington 4601, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 47.500000], PARAMETER ["Standard_Parallel_2", 48.733333], PARAMETER ["Central_Meridian", -120.833333], PARAMETER ["Latitude_Of_Origin", 47.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Washington 4602, Southern Zone (1927)', 41179, 41179, 'Oracle', 'PROJCS["Washington 4602, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.833333], PARAMETER ["Standard_Parallel_2", 47.333333], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 45.333333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Washington 4602, Southern Zone (1983, US Survey feet)', 41180, 41180, 'Oracle', 'PROJCS["Washington 4602, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.833333], PARAMETER ["Standard_Parallel_2", 47.333333], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 45.333333], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Washington 4602, Southern Zone (1983, meters)', 41181, 41181, 'Oracle', 'PROJCS["Washington 4602, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.833333], PARAMETER ["Standard_Parallel_2", 47.333333], PARAMETER ["Central_Meridian", -120.500000], PARAMETER ["Latitude_Of_Origin", 45.333333], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'West Virginia 4701, Northern Zone (1927)', 41182, 41182, 'Oracle', 'PROJCS["West Virginia 4701, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.000000], PARAMETER ["Standard_Parallel_2", 40.250000], PARAMETER ["Central_Meridian", -79.500000], PARAMETER ["Latitude_Of_Origin", 38.500000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'West Virginia 4701, Northern Zone (1983, US Survey feet)', 41183, 41183, 'Oracle', 'PROJCS["West Virginia 4701, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.000000], PARAMETER ["Standard_Parallel_2", 40.250000], PARAMETER ["Central_Meridian", -79.500000], PARAMETER ["Latitude_Of_Origin", 38.500000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'West Virginia 4701, Northern Zone (1983, meters)', 41184, 41184, 'Oracle', 'PROJCS["West Virginia 4701, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 39.000000], PARAMETER ["Standard_Parallel_2", 40.250000], PARAMETER ["Central_Meridian", -79.500000], PARAMETER ["Latitude_Of_Origin", 38.500000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'West Virginia 4702, Southern Zone (1927)', 41185, 41185, 'Oracle', 'PROJCS["West Virginia 4702, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.483333], PARAMETER ["Standard_Parallel_2", 38.883333], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 37.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'West Virginia 4702, Southern Zone (1983, US Survey feet)', 41186, 41186, 'Oracle', 'PROJCS["West Virginia 4702, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.483333], PARAMETER ["Standard_Parallel_2", 38.883333], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 37.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'West Virginia 4702, Southern Zone (1983, meters)', 41187, 41187, 'Oracle', 'PROJCS["West Virginia 4702, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 37.483333], PARAMETER ["Standard_Parallel_2", 38.883333], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 37.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4801, Northern Zone (1927)', 41188, 41188, 'Oracle', 'PROJCS["Wisconsin 4801, Northern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.566667], PARAMETER ["Standard_Parallel_2", 46.766667], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 45.166667], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4801, Northern Zone (1983, US Survey feet)', 41189, 41189, 'Oracle', 'PROJCS["Wisconsin 4801, Northern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.566667], PARAMETER ["Standard_Parallel_2", 46.766667], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 45.166667], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4801, Northern Zone (1983, meters)', 41190, 41190, 'Oracle', 'PROJCS["Wisconsin 4801, Northern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 45.566667], PARAMETER ["Standard_Parallel_2", 46.766667], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 45.166667], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4802, Central Zone (1927)', 41191, 41191, 'Oracle', 'PROJCS["Wisconsin 4802, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.250000], PARAMETER ["Standard_Parallel_2", 45.500000], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 43.833333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4802, Central Zone (1983, US Survey feet)', 41192, 41192, 'Oracle', 'PROJCS["Wisconsin 4802, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.250000], PARAMETER ["Standard_Parallel_2", 45.500000], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 43.833333], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4802, Central Zone (1983, meters)', 41193, 41193, 'Oracle', 'PROJCS["Wisconsin 4802, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 44.250000], PARAMETER ["Standard_Parallel_2", 45.500000], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 43.833333], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4803, Southern Zone (1927)', 41194, 41194, 'Oracle', 'PROJCS["Wisconsin 4803, Southern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.733333], PARAMETER ["Standard_Parallel_2", 44.066667], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 42.000000], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4803, Southern Zone (1983, US Survey feet)', 41195, 41195, 'Oracle', 'PROJCS["Wisconsin 4803, Southern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.733333], PARAMETER ["Standard_Parallel_2", 44.066667], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 42.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wisconsin 4803, Southern Zone (1983, meters)', 41196, 41196, 'Oracle', 'PROJCS["Wisconsin 4803, Southern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", 42.733333], PARAMETER ["Standard_Parallel_2", 44.066667], PARAMETER ["Central_Meridian", -90.000000], PARAMETER ["Latitude_Of_Origin", 42.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (Africa)', 49152, 49152, 'Oracle', 'PROJCS["Conformal Projection (Africa)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Mercator"], PARAMETER ["Central_Meridian", 20.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (Central America)', 49153, 49153, 'Oracle', 'PROJCS["Conformal Projection (Central America)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Mercator"], PARAMETER ["Central_Meridian", -85.500000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (South America)', 49154, 49154, 'Oracle', 'PROJCS["Conformal Projection (South America)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Mercator"], PARAMETER ["Central_Meridian", -60.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mercator', 49155, 49155, 'Oracle', 'PROJCS["Mercator", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Mercator"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 47 (AGD 66)', 81920, 81920, 'Oracle', 'PROJCS["AMG Zone 47 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 99.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 47 (AGD 84)', 81921, 81921, 'Oracle', 'PROJCS["AMG Zone 47 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 99.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 48 (AGD 66)', 81922, 81922, 'Oracle', 'PROJCS["AMG Zone 48 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 105.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 48 (AGD 84)', 81923, 81923, 'Oracle', 'PROJCS["AMG Zone 48 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 105.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 49 (AGD 66)', 81924, 81924, 'Oracle', 'PROJCS["AMG Zone 49 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 111.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 49 (AGD 84)', 81925, 81925, 'Oracle', 'PROJCS["AMG Zone 49 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 111.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 50 (AGD 66)', 81926, 81926, 'Oracle', 'PROJCS["AMG Zone 50 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 117.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 50 (AGD 84)', 81927, 81927, 'Oracle', 'PROJCS["AMG Zone 50 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 117.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 51 (AGD 66)', 81928, 81928, 'Oracle', 'PROJCS["AMG Zone 51 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 123.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 51 (AGD 84)', 81929, 81929, 'Oracle', 'PROJCS["AMG Zone 51 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 123.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 52 (AGD 66)', 81930, 81930, 'Oracle', 'PROJCS["AMG Zone 52 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 129.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 52 (AGD 84)', 81931, 81931, 'Oracle', 'PROJCS["AMG Zone 52 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 129.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 53 (AGD 66)', 81932, 81932, 'Oracle', 'PROJCS["AMG Zone 53 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 135.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 53 (AGD 84)', 81933, 81933, 'Oracle', 'PROJCS["AMG Zone 53 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 135.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 54 (AGD 66)', 81934, 81934, 'Oracle', 'PROJCS["AMG Zone 54 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 141.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 54 (AGD 84)', 81935, 81935, 'Oracle', 'PROJCS["AMG Zone 54 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 141.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 55 (AGD 66)', 81936, 81936, 'Oracle', 'PROJCS["AMG Zone 55 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 147.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 55 (AGD 84)', 81937, 81937, 'Oracle', 'PROJCS["AMG Zone 55 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 147.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 56 (AGD 66)', 81938, 81938, 'Oracle', 'PROJCS["AMG Zone 56 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 153.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 56 (AGD 84)', 81939, 81939, 'Oracle', 'PROJCS["AMG Zone 56 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 153.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 57 (AGD 66)', 81940, 81940, 'Oracle', 'PROJCS["AMG Zone 57 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 159.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 57 (AGD 84)', 81941, 81941, 'Oracle', 'PROJCS["AMG Zone 57 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 159.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 58 (AGD 66)', 81942, 81942, 'Oracle', 'PROJCS["AMG Zone 58 (AGD 66)", GEOGCS [ "Australian Geodetic 1966", DATUM ["Australian Geodetic 1966", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 165.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'AMG Zone 58 (AGD 84)', 81943, 81943, 'Oracle', 'PROJCS["AMG Zone 58 (AGD 84)", GEOGCS [ "Australian Geodetic 1984", DATUM ["Australian Geodetic 1984", SPHEROID ["Australian", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 165.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alabama 0101, Eastern Zone (1927)', 81944, 81944, 'Oracle', 'PROJCS["Alabama 0101, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999960], PARAMETER ["Central_Meridian", -85.833333], PARAMETER ["Latitude_Of_Origin", 30.500000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alabama 0101, Eastern Zone (1983, US Survey feet)', 81945, 81945, 'Oracle', 'PROJCS["Alabama 0101, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999960], PARAMETER ["Central_Meridian", -85.833333], PARAMETER ["Latitude_Of_Origin", 30.500000], PARAMETER ["False_Easting", 200000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alabama 0101, Eastern Zone (1983, meters)', 81946, 81946, 'Oracle', 'PROJCS["Alabama 0101, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999960], PARAMETER ["Central_Meridian", -85.833333], PARAMETER ["Latitude_Of_Origin", 30.500000], PARAMETER ["False_Easting", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alabama 0102, Western Zone (1927)', 81947, 81947, 'Oracle', 'PROJCS["Alabama 0102, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -87.500000], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alabama 0102, Western Zone (1983, US Survey feet)', 81948, 81948, 'Oracle', 'PROJCS["Alabama 0102, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -87.500000], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alabama 0102, Western Zone (1983, meters)', 81949, 81949, 'Oracle', 'PROJCS["Alabama 0102, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -87.500000], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5002, Zone 2 (1927)', 81950, 81950, 'Oracle', 'PROJCS["Alaska 5002, Zone 2 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -142.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5002, Zone 2 (1983, US Survey feet)', 81951, 81951, 'Oracle', 'PROJCS["Alaska 5002, Zone 2 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -142.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5002, Zone 2 (1983, meters)', 81952, 81952, 'Oracle', 'PROJCS["Alaska 5002, Zone 2 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -142.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5003, Zone 3 (1927)', 81953, 81953, 'Oracle', 'PROJCS["Alaska 5003, Zone 3 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -146.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5003, Zone 3 (1983, US Survey feet)', 81954, 81954, 'Oracle', 'PROJCS["Alaska 5003, Zone 3 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -146.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5003, Zone 3 (1983, meters)', 81955, 81955, 'Oracle', 'PROJCS["Alaska 5003, Zone 3 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -146.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5004, Zone 4 (1927)', 81956, 81956, 'Oracle', 'PROJCS["Alaska 5004, Zone 4 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -150.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5004, Zone 4 (1983, US Survey feet)', 81957, 81957, 'Oracle', 'PROJCS["Alaska 5004, Zone 4 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -150.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5004, Zone 4 (1983, meters)', 81958, 81958, 'Oracle', 'PROJCS["Alaska 5004, Zone 4 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -150.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5005, Zone 5 (1927)', 81959, 81959, 'Oracle', 'PROJCS["Alaska 5005, Zone 5 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -154.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5005, Zone 5 (1983, US Survey feet)', 81960, 81960, 'Oracle', 'PROJCS["Alaska 5005, Zone 5 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -154.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5005, Zone 5 (1983, meters)', 81961, 81961, 'Oracle', 'PROJCS["Alaska 5005, Zone 5 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -154.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5006, Zone 6 (1927)', 81962, 81962, 'Oracle', 'PROJCS["Alaska 5006, Zone 6 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -158.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5006, Zone 6 (1983, US Survey feet)', 81963, 81963, 'Oracle', 'PROJCS["Alaska 5006, Zone 6 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -158.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5006, Zone 6 (1983, meters)', 81964, 81964, 'Oracle', 'PROJCS["Alaska 5006, Zone 6 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -158.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5007, Zone 7 (1927)', 81965, 81965, 'Oracle', 'PROJCS["Alaska 5007, Zone 7 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -162.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 213360.426721], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5007, Zone 7 (1983, US Survey feet)', 81966, 81966, 'Oracle', 'PROJCS["Alaska 5007, Zone 7 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -162.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5007, Zone 7 (1983, meters)', 81967, 81967, 'Oracle', 'PROJCS["Alaska 5007, Zone 7 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -162.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5008, Zone 8 (1927)', 81968, 81968, 'Oracle', 'PROJCS["Alaska 5008, Zone 8 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -166.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5008, Zone 8 (1983, US Survey feet)', 81969, 81969, 'Oracle', 'PROJCS["Alaska 5008, Zone 8 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -166.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5008, Zone 8 (1983, meters)', 81970, 81970, 'Oracle', 'PROJCS["Alaska 5008, Zone 8 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -166.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5009, Zone 9 (1927)', 81971, 81971, 'Oracle', 'PROJCS["Alaska 5009, Zone 9 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -170.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 182880.365761], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5009, Zone 9 (1983, US Survey feet)', 81972, 81972, 'Oracle', 'PROJCS["Alaska 5009, Zone 9 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -170.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5009, Zone 9 (1983, meters)', 81973, 81973, 'Oracle', 'PROJCS["Alaska 5009, Zone 9 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -170.000000], PARAMETER ["Latitude_Of_Origin", 54.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Amuri Circuit', 81974, 81974, 'Oracle', 'PROJCS["Amuri Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 173.010133], PARAMETER ["Latitude_Of_Origin", -42.689117], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0201, Eastern Zone (1927)', 81975, 81975, 'Oracle', 'PROJCS["Arizona 0201, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -110.166667], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0201, Eastern Zone (1983, US Survey feet)', 81976, 81976, 'Oracle', 'PROJCS["Arizona 0201, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -110.166667], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.426721], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0201, Eastern Zone (1983, feet)', 81977, 81977, 'Oracle', 'PROJCS["Arizona 0201, Eastern Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -110.166667], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0201, Eastern Zone (1983, meters)', 81978, 81978, 'Oracle', 'PROJCS["Arizona 0201, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -110.166667], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0202, Central Zone (1927)', 81979, 81979, 'Oracle', 'PROJCS["Arizona 0202, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -111.916667], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0202, Central Zone (1983, US Survey feet)', 81980, 81980, 'Oracle', 'PROJCS["Arizona 0202, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -111.916667], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.426721], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0202, Central Zone (1983, feet)', 81981, 81981, 'Oracle', 'PROJCS["Arizona 0202, Central Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -111.916667], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0202, Central Zone (1983, meters)', 81982, 81982, 'Oracle', 'PROJCS["Arizona 0202, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -111.916667], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0203, Western Zone (1927)', 81983, 81983, 'Oracle', 'PROJCS["Arizona 0203, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -113.750000], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0203, Western Zone (1983, US Survey feet)', 81984, 81984, 'Oracle', 'PROJCS["Arizona 0203, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -113.750000], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.426721], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0203, Western Zone (1983, feet)', 81985, 81985, 'Oracle', 'PROJCS["Arizona 0203, Western Zone (1983, feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -113.750000], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.000000], UNIT ["Foot (International)", 0.304800000000]]' );                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Arizona 0203, Western Zone (1983, meters)', 81986, 81986, 'Oracle', 'PROJCS["Arizona 0203, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -113.750000], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 213360.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Bay of Plenty Circuit', 81987, 81987, 'Oracle', 'PROJCS["Bay of Plenty Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 176.466197], PARAMETER ["Latitude_Of_Origin", -37.761250], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Bluff Circuit', 81988, 81988, 'Oracle', 'PROJCS["Bluff Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 168.342872], PARAMETER ["Latitude_Of_Origin", -46.600010], PARAMETER ["False_Easting", 300002.660000], PARAMETER ["False_Northing", 699999.580000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'British National Grid', 81989, 81989, 'Oracle', 'PROJCS["British National Grid", GEOGCS [ "Ordnance Survey Great Brit", DATUM ["Ordnance Survey Great Brit", SPHEROID ["Airy 1930", 6377563.396, 299.3249646]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.9996012717], PARAMETER ["Central_Meridian", -2.000000], PARAMETER ["Latitude_Of_Origin", 49.000000], PARAMETER ["False_Easting", 400000.000000], PARAMETER ["False_Northing", -100000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'British OSGRS80 Grid', 81990, 81990, 'Oracle', 'PROJCS["British OSGRS80 Grid", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999601], PARAMETER ["Central_Meridian", -2.000000], PARAMETER ["Latitude_Of_Origin", 49.000000], PARAMETER ["False_Easting", 400000.000000], PARAMETER ["False_Northing", -100000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Buller Circuit', 81991, 81991, 'Oracle', 'PROJCS["Buller Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 171.581260], PARAMETER ["Latitude_Of_Origin", -41.810803], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Collingwood Circuit', 81992, 81992, 'Oracle', 'PROJCS["Collingwood Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 172.672046], PARAMETER ["Latitude_Of_Origin", -40.714759], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Conformal Projection (India)', 81993, 81993, 'Oracle', 'PROJCS["Conformal Projection (India)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 78.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Delaware 0700 (1927)', 81994, 81994, 'Oracle', 'PROJCS["Delaware 0700 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999995], PARAMETER ["Central_Meridian", -75.416667], PARAMETER ["Latitude_Of_Origin", 38.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Delaware 0700 (1983, US Survey feet)', 81995, 81995, 'Oracle', 'PROJCS["Delaware 0700 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999995], PARAMETER ["Central_Meridian", -75.416667], PARAMETER ["Latitude_Of_Origin", 38.000000], PARAMETER ["False_Easting", 200000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Delaware 0700 (1983, meters)', 81996, 81996, 'Oracle', 'PROJCS["Delaware 0700 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999995], PARAMETER ["Central_Meridian", -75.416667], PARAMETER ["Latitude_Of_Origin", 38.000000], PARAMETER ["False_Easting", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0901, Eastern Zone (1927)', 81997, 81997, 'Oracle', 'PROJCS["Florida 0901, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 24.333333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0901, Eastern Zone (1983, US Survey feet)', 81998, 81998, 'Oracle', 'PROJCS["Florida 0901, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 24.333333], PARAMETER ["False_Easting", 200000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0901, Eastern Zone (1983, meters)', 81999, 81999, 'Oracle', 'PROJCS["Florida 0901, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["Latitude_Of_Origin", 24.333333], PARAMETER ["False_Easting", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0902, Western Zone (1927)', 82000, 82000, 'Oracle', 'PROJCS["Florida 0902, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -82.000000], PARAMETER ["Latitude_Of_Origin", 24.333333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0902, Western Zone (1983, US Survey feet)', 82001, 82001, 'Oracle', 'PROJCS["Florida 0902, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -82.000000], PARAMETER ["Latitude_Of_Origin", 24.333333], PARAMETER ["False_Easting", 200000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Florida 0902, Western Zone (1983, meters)', 82002, 82002, 'Oracle', 'PROJCS["Florida 0902, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -82.000000], PARAMETER ["Latitude_Of_Origin", 24.333333], PARAMETER ["False_Easting", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 1 (DHDN)', 82003, 82003, 'Oracle', 'PROJCS["GK Zone 1 (DHDN)", GEOGCS [ "", DATUM ["", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128], 582.000000, 105.000000, 414.000000, -1.040000, -0.350000, 3.080000, 8.300000 ], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 3.000000], PARAMETER ["False_Easting", 1500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 1 (Pulkovo 1942)', 82004, 82004, 'Oracle', 'PROJCS["GK Zone 1 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 3.000000], PARAMETER ["False_Easting", 1500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 10 (Pulkovo 1942)', 82005, 82005, 'Oracle', 'PROJCS["GK Zone 10 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 57.000000], PARAMETER ["False_Easting", 10500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 11 (Pulkovo 1942)', 82006, 82006, 'Oracle', 'PROJCS["GK Zone 11 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 63.000000], PARAMETER ["False_Easting", 11500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 12 (Pulkovo 1942)', 82007, 82007, 'Oracle', 'PROJCS["GK Zone 12 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 69.000000], PARAMETER ["False_Easting", 12500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 13 (Pulkovo 1942)', 82008, 82008, 'Oracle', 'PROJCS["GK Zone 13 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 75.000000], PARAMETER ["False_Easting", 13500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 14 (Pulkovo 1942)', 82009, 82009, 'Oracle', 'PROJCS["GK Zone 14 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 81.000000], PARAMETER ["False_Easting", 14500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 15 (Pulkovo 1942)', 82010, 82010, 'Oracle', 'PROJCS["GK Zone 15 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 87.000000], PARAMETER ["False_Easting", 15500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 16 (Pulkovo 1942)', 82011, 82011, 'Oracle', 'PROJCS["GK Zone 16 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 93.000000], PARAMETER ["False_Easting", 16500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 17 (Pulkovo 1942)', 82012, 82012, 'Oracle', 'PROJCS["GK Zone 17 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 99.000000], PARAMETER ["False_Easting", 17500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 18 (Pulkovo 1942)', 82013, 82013, 'Oracle', 'PROJCS["GK Zone 18 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 105.000000], PARAMETER ["False_Easting", 18500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 19 (Pulkovo 1942)', 82014, 82014, 'Oracle', 'PROJCS["GK Zone 19 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 111.000000], PARAMETER ["False_Easting", 19500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 2 (DHDN)', 82015, 82015, 'Oracle', 'PROJCS["GK Zone 2 (DHDN)", GEOGCS [ "", DATUM ["", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128], 582.000000, 105.000000, 414.000000, -1.040000, -0.350000, 3.080000, 8.300000 ], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 6.000000], PARAMETER ["False_Easting", 2500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 2 (Pulkovo 1942)', 82016, 82016, 'Oracle', 'PROJCS["GK Zone 2 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 9.000000], PARAMETER ["False_Easting", 2500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 20 (Pulkovo 1942)', 82017, 82017, 'Oracle', 'PROJCS["GK Zone 20 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 117.000000], PARAMETER ["False_Easting", 20500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 21 (Pulkovo 1942)', 82018, 82018, 'Oracle', 'PROJCS["GK Zone 21 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 123.000000], PARAMETER ["False_Easting", 21500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 22 (Pulkovo 1942)', 82019, 82019, 'Oracle', 'PROJCS["GK Zone 22 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 129.000000], PARAMETER ["False_Easting", 22500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 23 (Pulkovo 1942)', 82020, 82020, 'Oracle', 'PROJCS["GK Zone 23 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 135.000000], PARAMETER ["False_Easting", 23500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 24 (Pulkovo 1942)', 82021, 82021, 'Oracle', 'PROJCS["GK Zone 24 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 141.000000], PARAMETER ["False_Easting", 24500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 25 (Pulkovo 1942)', 82022, 82022, 'Oracle', 'PROJCS["GK Zone 25 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 147.000000], PARAMETER ["False_Easting", 25500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 26 (Pulkovo 1942)', 82023, 82023, 'Oracle', 'PROJCS["GK Zone 26 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 153.000000], PARAMETER ["False_Easting", 26500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 27 (Pulkovo 1942)', 82024, 82024, 'Oracle', 'PROJCS["GK Zone 27 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 159.000000], PARAMETER ["False_Easting", 27500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 28 (Pulkovo 1942)', 82025, 82025, 'Oracle', 'PROJCS["GK Zone 28 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 165.000000], PARAMETER ["False_Easting", 28500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 29 (Pulkovo 1942)', 82026, 82026, 'Oracle', 'PROJCS["GK Zone 29 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 171.000000], PARAMETER ["False_Easting", 29500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 3 (DHDN)', 82027, 82027, 'Oracle', 'PROJCS["GK Zone 3 (DHDN)", GEOGCS [ "", DATUM ["", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128], 582.000000, 105.000000, 414.000000, -1.040000, -0.350000, 3.080000, 8.300000 ], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 9.000000], PARAMETER ["False_Easting", 3500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 3 (Pulkovo 1942)', 82028, 82028, 'Oracle', 'PROJCS["GK Zone 3 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 15.000000], PARAMETER ["False_Easting", 3500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 30 (Pulkovo 1942)', 82029, 82029, 'Oracle', 'PROJCS["GK Zone 30 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 177.000000], PARAMETER ["False_Easting", 30500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 31 (Pulkovo 1942)', 82030, 82030, 'Oracle', 'PROJCS["GK Zone 31 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", -177.000000], PARAMETER ["False_Easting", 31500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 32 (Pulkovo 1942)', 82031, 82031, 'Oracle', 'PROJCS["GK Zone 32 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", -171.000000], PARAMETER ["False_Easting", 32500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 4 (DHDN)', 82032, 82032, 'Oracle', 'PROJCS["GK Zone 4 (DHDN)", GEOGCS [ "", DATUM ["", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128], 582.000000, 105.000000, 414.000000, -1.040000, -0.350000, 3.080000, 8.300000 ], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 12.000000], PARAMETER ["False_Easting", 4500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 4 (Pulkovo 1942)', 82033, 82033, 'Oracle', 'PROJCS["GK Zone 4 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 21.000000], PARAMETER ["False_Easting", 4500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 5 (DHDN)', 82034, 82034, 'Oracle', 'PROJCS["GK Zone 5 (DHDN)", GEOGCS [ "", DATUM ["", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128], 582.000000, 105.000000, 414.000000, -1.040000, -0.350000, 3.080000, 8.300000 ], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 15.000000], PARAMETER ["False_Easting", 5500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 5 (Pulkovo 1942)', 82035, 82035, 'Oracle', 'PROJCS["GK Zone 5 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 27.000000], PARAMETER ["False_Easting", 5500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 6 (Pulkovo 1942)', 82036, 82036, 'Oracle', 'PROJCS["GK Zone 6 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 33.000000], PARAMETER ["False_Easting", 6500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 7 (Pulkovo 1942)', 82037, 82037, 'Oracle', 'PROJCS["GK Zone 7 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 39.000000], PARAMETER ["False_Easting", 7500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 8 (Pulkovo 1942)', 82038, 82038, 'Oracle', 'PROJCS["GK Zone 8 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 45.000000], PARAMETER ["False_Easting", 8500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'GK Zone 9 (Pulkovo 1942)', 82039, 82039, 'Oracle', 'PROJCS["GK Zone 9 (Pulkovo 1942)", GEOGCS [ "Pulkovo 1942", DATUM ["Pulkovo 1942", SPHEROID ["Krassovsky", 6378245, 298.3]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 51.000000], PARAMETER ["False_Easting", 9500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Gawler Circuit', 82040, 82040, 'Oracle', 'PROJCS["Gawler Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 171.360748], PARAMETER ["Latitude_Of_Origin", -43.748712], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Georgia 1001, Eastern Zone (1927)', 82041, 82041, 'Oracle', 'PROJCS["Georgia 1001, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -82.166667], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Georgia 1001, Eastern Zone (1983, US Survey feet)', 82042, 82042, 'Oracle', 'PROJCS["Georgia 1001, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -82.166667], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 200000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Georgia 1001, Eastern Zone (1983, meters)', 82043, 82043, 'Oracle', 'PROJCS["Georgia 1001, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -82.166667], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Georgia 1002, Western Zone (1927)', 82044, 82044, 'Oracle', 'PROJCS["Georgia 1002, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -84.166667], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Georgia 1002, Western Zone (1983, US Survey feet)', 82045, 82045, 'Oracle', 'PROJCS["Georgia 1002, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -84.166667], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 700000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Georgia 1002, Western Zone (1983, meters)', 82046, 82046, 'Oracle', 'PROJCS["Georgia 1002, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -84.166667], PARAMETER ["Latitude_Of_Origin", 30.000000], PARAMETER ["False_Easting", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Grey Circuit', 82047, 82047, 'Oracle', 'PROJCS["Grey Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 171.549771], PARAMETER ["Latitude_Of_Origin", -42.333694], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5101, Zone 1 (1927)', 82048, 82048, 'Oracle', 'PROJCS["Hawaii 5101, Zone 1 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -155.500000], PARAMETER ["Latitude_Of_Origin", 18.833333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5101, Zone 1 (1983, US Survey feet)', 82049, 82049, 'Oracle', 'PROJCS["Hawaii 5101, Zone 1 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -155.500000], PARAMETER ["Latitude_Of_Origin", 18.833333], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5101, Zone 1 (1983, meters)', 82050, 82050, 'Oracle', 'PROJCS["Hawaii 5101, Zone 1 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -155.500000], PARAMETER ["Latitude_Of_Origin", 18.833333], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5102, Zone 2 (1927)', 82051, 82051, 'Oracle', 'PROJCS["Hawaii 5102, Zone 2 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -156.666667], PARAMETER ["Latitude_Of_Origin", 20.333333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5102, Zone 2 (1983, US Survey feet)', 82052, 82052, 'Oracle', 'PROJCS["Hawaii 5102, Zone 2 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -156.666667], PARAMETER ["Latitude_Of_Origin", 20.333333], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5102, Zone 2 (1983, meters)', 82053, 82053, 'Oracle', 'PROJCS["Hawaii 5102, Zone 2 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -156.666667], PARAMETER ["Latitude_Of_Origin", 20.333333], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5103, Zone 3 (1927)', 82054, 82054, 'Oracle', 'PROJCS["Hawaii 5103, Zone 3 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", -158.000000], PARAMETER ["Latitude_Of_Origin", 21.166667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5103, Zone 3 (1983, US Survey feet)', 82055, 82055, 'Oracle', 'PROJCS["Hawaii 5103, Zone 3 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", -158.000000], PARAMETER ["Latitude_Of_Origin", 21.166667], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5103, Zone 3 (1983, meters)', 82056, 82056, 'Oracle', 'PROJCS["Hawaii 5103, Zone 3 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", -158.000000], PARAMETER ["Latitude_Of_Origin", 21.166667], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5104, Zone 4 (1927)', 82057, 82057, 'Oracle', 'PROJCS["Hawaii 5104, Zone 4 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", -159.500000], PARAMETER ["Latitude_Of_Origin", 21.833333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5104, Zone 4 (1983, US Survey feet)', 82058, 82058, 'Oracle', 'PROJCS["Hawaii 5104, Zone 4 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", -159.500000], PARAMETER ["Latitude_Of_Origin", 21.833333], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5104, Zone 4 (1983, meters)', 82059, 82059, 'Oracle', 'PROJCS["Hawaii 5104, Zone 4 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", -159.500000], PARAMETER ["Latitude_Of_Origin", 21.833333], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5105, Zone 5 (1927)', 82060, 82060, 'Oracle', 'PROJCS["Hawaii 5105, Zone 5 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", -160.166667], PARAMETER ["Latitude_Of_Origin", 21.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5105, Zone 5 (1983, US Survey feet)', 82061, 82061, 'Oracle', 'PROJCS["Hawaii 5105, Zone 5 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", -160.166667], PARAMETER ["Latitude_Of_Origin", 21.666667], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawaii 5105, Zone 5 (1983, meters)', 82062, 82062, 'Oracle', 'PROJCS["Hawaii 5105, Zone 5 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", -160.166667], PARAMETER ["Latitude_Of_Origin", 21.666667], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hawkes Bay Circuit', 82063, 82063, 'Oracle', 'PROJCS["Hawkes Bay Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 176.673681], PARAMETER ["Latitude_Of_Origin", -39.650929], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Hokitika Circuit', 82064, 82064, 'Oracle', 'PROJCS["Hokitika Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 170.979993], PARAMETER ["Latitude_Of_Origin", -42.886322], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1101, Eastern Zone (1927)', 82065, 82065, 'Oracle', 'PROJCS["Idaho 1101, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999947], PARAMETER ["Central_Meridian", -112.166667], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1101, Eastern Zone (1983, US Survey feet)', 82066, 82066, 'Oracle', 'PROJCS["Idaho 1101, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999947], PARAMETER ["Central_Meridian", -112.166667], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 200000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1101, Eastern Zone (1983, meters)', 82067, 82067, 'Oracle', 'PROJCS["Idaho 1101, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999947], PARAMETER ["Central_Meridian", -112.166667], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1102, Central Zone (1927)', 82068, 82068, 'Oracle', 'PROJCS["Idaho 1102, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999947], PARAMETER ["Central_Meridian", -114.000000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1102, Central Zone (1983, US Survey feet)', 82069, 82069, 'Oracle', 'PROJCS["Idaho 1102, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999947], PARAMETER ["Central_Meridian", -114.000000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1102, Central Zone (1983, meters)', 82070, 82070, 'Oracle', 'PROJCS["Idaho 1102, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999947], PARAMETER ["Central_Meridian", -114.000000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1103, Western Zone (1927)', 82071, 82071, 'Oracle', 'PROJCS["Idaho 1103, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -115.750000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1103, Western Zone (1983, US Survey feet)', 82072, 82072, 'Oracle', 'PROJCS["Idaho 1103, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -115.750000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 800000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Idaho 1103, Western Zone (1983, meters)', 82073, 82073, 'Oracle', 'PROJCS["Idaho 1103, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -115.750000], PARAMETER ["Latitude_Of_Origin", 41.666667], PARAMETER ["False_Easting", 800000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Illinois 1201, Eastern Zone (1927)', 82074, 82074, 'Oracle', 'PROJCS["Illinois 1201, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999975], PARAMETER ["Central_Meridian", -88.333333], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Illinois 1201, Eastern Zone (1983, US Survey feet)', 82075, 82075, 'Oracle', 'PROJCS["Illinois 1201, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999975], PARAMETER ["Central_Meridian", -88.333333], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 300000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Illinois 1201, Eastern Zone (1983, meters)', 82076, 82076, 'Oracle', 'PROJCS["Illinois 1201, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999975], PARAMETER ["Central_Meridian", -88.333333], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 300000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Illinois 1202, Western Zone (1927)', 82077, 82077, 'Oracle', 'PROJCS["Illinois 1202, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -90.166667], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Illinois 1202, Western Zone (1983, US Survey feet)', 82078, 82078, 'Oracle', 'PROJCS["Illinois 1202, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -90.166667], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 700000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Illinois 1202, Western Zone (1983, meters)', 82079, 82079, 'Oracle', 'PROJCS["Illinois 1202, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -90.166667], PARAMETER ["Latitude_Of_Origin", 36.666667], PARAMETER ["False_Easting", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Indiana 1301, Eastern Zone (1927)', 82080, 82080, 'Oracle', 'PROJCS["Indiana 1301, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -85.666667], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Indiana 1301, Eastern Zone (1983, US Survey feet)', 82081, 82081, 'Oracle', 'PROJCS["Indiana 1301, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -85.666667], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 100000.000000], PARAMETER ["False_Northing", 250000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Indiana 1301, Eastern Zone (1983, meters)', 82082, 82082, 'Oracle', 'PROJCS["Indiana 1301, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -85.666667], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 100000.000000], PARAMETER ["False_Northing", 250000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Indiana 1302, Western Zone (1927)', 82083, 82083, 'Oracle', 'PROJCS["Indiana 1302, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -87.083333], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Indiana 1302, Western Zone (1983, US Survey feet)', 82084, 82084, 'Oracle', 'PROJCS["Indiana 1302, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -87.083333], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 900000.000000], PARAMETER ["False_Northing", 249999.992115], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Indiana 1302, Western Zone (1983, meters)', 82085, 82085, 'Oracle', 'PROJCS["Indiana 1302, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -87.083333], PARAMETER ["Latitude_Of_Origin", 37.500000], PARAMETER ["False_Easting", 900000.000000], PARAMETER ["False_Northing", 250000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Irish Transverse Mercator Grid', 82086, 82086, 'Oracle', 'PROJCS["Irish Transverse Mercator Grid", GEOGCS [ "Ireland 1965", DATUM ["Ireland 1965", SPHEROID ["Airy 1930(Ireland 1965)", 6377340.189, 299.3249646]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000035], PARAMETER ["Central_Meridian", -8.000000], PARAMETER ["Latitude_Of_Origin", 53.500000], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 250000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Italian National System (Gauss-Boaga), Zone 1 (West)', 82087, 82087, 'Oracle', 'PROJCS["Italian National System (Gauss-Boaga), Zone 1 (West)", GEOGCS [ "Rome 1940", DATUM ["Rome 1940", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 9.000000], PARAMETER ["False_Easting", 1500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Italian National System (Gauss-Boaga), Zone 2 (East)', 82088, 82088, 'Oracle', 'PROJCS["Italian National System (Gauss-Boaga), Zone 2 (East)", GEOGCS [ "Rome 1940", DATUM ["Rome 1940", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 15.000000], PARAMETER ["False_Easting", 2520000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Jacksons Bay Circuit', 82089, 82089, 'Oracle', 'PROJCS["Jacksons Bay Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 168.606267], PARAMETER ["Latitude_Of_Origin", -43.977803], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone I', 82090, 82090, 'Oracle', 'PROJCS["Japanese Zone I", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 129.500000], PARAMETER ["Latitude_Of_Origin", 33.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone II', 82091, 82091, 'Oracle', 'PROJCS["Japanese Zone II", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 131.000000], PARAMETER ["Latitude_Of_Origin", 33.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone III', 82092, 82092, 'Oracle', 'PROJCS["Japanese Zone III", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 132.166666], PARAMETER ["Latitude_Of_Origin", 36.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone IV', 82093, 82093, 'Oracle', 'PROJCS["Japanese Zone IV", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 133.500000], PARAMETER ["Latitude_Of_Origin", 33.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone IX', 82094, 82094, 'Oracle', 'PROJCS["Japanese Zone IX", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 139.833333], PARAMETER ["Latitude_Of_Origin", 36.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone V', 82095, 82095, 'Oracle', 'PROJCS["Japanese Zone V", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 134.333333], PARAMETER ["Latitude_Of_Origin", 36.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone VI', 82096, 82096, 'Oracle', 'PROJCS["Japanese Zone VI", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 136.000000], PARAMETER ["Latitude_Of_Origin", 36.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone VII', 82097, 82097, 'Oracle', 'PROJCS["Japanese Zone VII", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 137.166666], PARAMETER ["Latitude_Of_Origin", 36.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone VIII', 82098, 82098, 'Oracle', 'PROJCS["Japanese Zone VIII", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 138.500000], PARAMETER ["Latitude_Of_Origin", 36.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone X', 82099, 82099, 'Oracle', 'PROJCS["Japanese Zone X", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 140.833333], PARAMETER ["Latitude_Of_Origin", 40.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XI', 82100, 82100, 'Oracle', 'PROJCS["Japanese Zone XI", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 140.250000], PARAMETER ["Latitude_Of_Origin", 44.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XII', 82101, 82101, 'Oracle', 'PROJCS["Japanese Zone XII", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 142.250000], PARAMETER ["Latitude_Of_Origin", 44.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XIII', 82102, 82102, 'Oracle', 'PROJCS["Japanese Zone XIII", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 144.250000], PARAMETER ["Latitude_Of_Origin", 44.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XIV', 82103, 82103, 'Oracle', 'PROJCS["Japanese Zone XIV", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 142.000000], PARAMETER ["Latitude_Of_Origin", 26.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XIX', 82104, 82104, 'Oracle', 'PROJCS["Japanese Zone XIX", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 154.000000], PARAMETER ["Latitude_Of_Origin", 26.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XV', 82105, 82105, 'Oracle', 'PROJCS["Japanese Zone XV", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 127.500000], PARAMETER ["Latitude_Of_Origin", 26.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XVI', 82106, 82106, 'Oracle', 'PROJCS["Japanese Zone XVI", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 124.000000], PARAMETER ["Latitude_Of_Origin", 26.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XVII', 82107, 82107, 'Oracle', 'PROJCS["Japanese Zone XVII", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 131.000000], PARAMETER ["Latitude_Of_Origin", 26.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Japanese Zone XVIII', 82108, 82108, 'Oracle', 'PROJCS["Japanese Zone XVIII", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999990], PARAMETER ["Central_Meridian", 136.000000], PARAMETER ["Latitude_Of_Origin", 20.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Karamea Circuit', 82109, 82109, 'Oracle', 'PROJCS["Karamea Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 172.109028], PARAMETER ["Latitude_Of_Origin", -41.289912], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Lindis Peak Circuit', 82110, 82110, 'Oracle', 'PROJCS["Lindis Peak Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 169.467755], PARAMETER ["Latitude_Of_Origin", -44.735268], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maine 102, Western Zone (1983, US Survey feet)', 82111, 82111, 'Oracle', 'PROJCS["Maine 102, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -70.166667], PARAMETER ["Latitude_Of_Origin", 42.833333], PARAMETER ["False_Easting", 900000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maine 1801, Eastern Zone (1927)', 82112, 82112, 'Oracle', 'PROJCS["Maine 1801, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -68.500000], PARAMETER ["Latitude_Of_Origin", 43.833333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maine 1801, Eastern Zone (1983, US Survey feet)', 82113, 82113, 'Oracle', 'PROJCS["Maine 1801, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -68.500000], PARAMETER ["Latitude_Of_Origin", 43.666667], PARAMETER ["False_Easting", 300000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maine 1801, Eastern Zone (1983, meters)', 82114, 82114, 'Oracle', 'PROJCS["Maine 1801, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -68.500000], PARAMETER ["Latitude_Of_Origin", 43.666667], PARAMETER ["False_Easting", 300000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maine 1802, Western Zone (1927)', 82115, 82115, 'Oracle', 'PROJCS["Maine 1802, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -70.166667], PARAMETER ["Latitude_Of_Origin", 42.833333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Maine 1802, Western Zone (1983, meters)', 82116, 82116, 'Oracle', 'PROJCS["Maine 1802, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -70.166667], PARAMETER ["Latitude_Of_Origin", 42.833333], PARAMETER ["False_Easting", 900000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Marlborough Circuit', 82117, 82117, 'Oracle', 'PROJCS["Marlborough Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 173.802074], PARAMETER ["Latitude_Of_Origin", -41.544487], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mississippi 2301, Eastern Zone (1927)', 82118, 82118, 'Oracle', 'PROJCS["Mississippi 2301, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999996], PARAMETER ["Central_Meridian", -88.833333], PARAMETER ["Latitude_Of_Origin", 29.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mississippi 2301, Eastern Zone (1983, US Survey feet)', 82119, 82119, 'Oracle', 'PROJCS["Mississippi 2301, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999950], PARAMETER ["Central_Meridian", -88.833333], PARAMETER ["Latitude_Of_Origin", 29.500000], PARAMETER ["False_Easting", 300000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mississippi 2301, Eastern Zone (1983, meters)', 82120, 82120, 'Oracle', 'PROJCS["Mississippi 2301, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999950], PARAMETER ["Central_Meridian", -88.833333], PARAMETER ["Latitude_Of_Origin", 29.500000], PARAMETER ["False_Easting", 300000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mississippi 2302, Western Zone (1927)', 82121, 82121, 'Oracle', 'PROJCS["Mississippi 2302, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -90.333333], PARAMETER ["Latitude_Of_Origin", 30.500000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mississippi 2302, Western Zone (1983, US Survey feet)', 82122, 82122, 'Oracle', 'PROJCS["Mississippi 2302, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999950], PARAMETER ["Central_Meridian", -90.333333], PARAMETER ["Latitude_Of_Origin", 29.500000], PARAMETER ["False_Easting", 700000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mississippi 2302, Western Zone (1983, meters)', 82123, 82123, 'Oracle', 'PROJCS["Mississippi 2302, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999950], PARAMETER ["Central_Meridian", -90.333333], PARAMETER ["Latitude_Of_Origin", 29.500000], PARAMETER ["False_Easting", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2401, Eastern Zone (1927)', 82124, 82124, 'Oracle', 'PROJCS["Missouri 2401, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -90.500000], PARAMETER ["Latitude_Of_Origin", 35.833333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2401, Eastern Zone (1983, US Survey feet)', 82125, 82125, 'Oracle', 'PROJCS["Missouri 2401, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -90.500000], PARAMETER ["Latitude_Of_Origin", 35.833333], PARAMETER ["False_Easting", 250000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2401, Eastern Zone (1983, meters)', 82126, 82126, 'Oracle', 'PROJCS["Missouri 2401, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -90.500000], PARAMETER ["Latitude_Of_Origin", 35.833333], PARAMETER ["False_Easting", 250000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2402, Central Zone (1927)', 82127, 82127, 'Oracle', 'PROJCS["Missouri 2402, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -92.500000], PARAMETER ["Latitude_Of_Origin", 35.833333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2402, Central Zone (1983, US Survey feet)', 82128, 82128, 'Oracle', 'PROJCS["Missouri 2402, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -92.500000], PARAMETER ["Latitude_Of_Origin", 35.833333], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2402, Central Zone (1983, meters)', 82129, 82129, 'Oracle', 'PROJCS["Missouri 2402, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999933], PARAMETER ["Central_Meridian", -92.500000], PARAMETER ["Latitude_Of_Origin", 35.833333], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2403, Western Zone (1927)', 82130, 82130, 'Oracle', 'PROJCS["Missouri 2403, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -94.500000], PARAMETER ["Latitude_Of_Origin", 36.166667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2403, Western Zone (1983, US Survey feet)', 82131, 82131, 'Oracle', 'PROJCS["Missouri 2403, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -94.500000], PARAMETER ["Latitude_Of_Origin", 36.166667], PARAMETER ["False_Easting", 850000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Missouri 2403, Western Zone (1983, meters)', 82132, 82132, 'Oracle', 'PROJCS["Missouri 2403, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -94.500000], PARAMETER ["Latitude_Of_Origin", 36.166667], PARAMETER ["False_Easting", 850000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mt. Eden Circuit', 82133, 82133, 'Oracle', 'PROJCS["Mt. Eden Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", 174.764339], PARAMETER ["Latitude_Of_Origin", -36.879865], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mt. Nicholas Circuit', 82134, 82134, 'Oracle', 'PROJCS["Mt. Nicholas Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 168.398641], PARAMETER ["Latitude_Of_Origin", -45.132903], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mt. Pleasant Circuit', 82135, 82135, 'Oracle', 'PROJCS["Mt. Pleasant Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 172.727194], PARAMETER ["Latitude_Of_Origin", -43.590638], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mt. York Circuit', 82136, 82136, 'Oracle', 'PROJCS["Mt. York Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 167.738862], PARAMETER ["Latitude_Of_Origin", -45.563726], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'National Yard Grid (North Island)', 82137, 82137, 'Oracle', 'PROJCS["National Yard Grid (North Island)", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 175.500000], PARAMETER ["Latitude_Of_Origin", -39.000000], PARAMETER ["False_Easting", 274320.000000], PARAMETER ["False_Northing", 365760.000000], UNIT ["Yard", 0.914400000000]]' );                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'National Yard Grid (South Island)', 82138, 82138, 'Oracle', 'PROJCS["National Yard Grid (South Island)", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 171.500000], PARAMETER ["Latitude_Of_Origin", -44.000000], PARAMETER ["False_Easting", 457200.000000], PARAMETER ["False_Northing", 457200.000000], UNIT ["Yard", 0.914400000000]]' );                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nelson Circuit', 82139, 82139, 'Oracle', 'PROJCS["Nelson Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 173.299317], PARAMETER ["Latitude_Of_Origin", -41.274545], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2701 , Eastern Zone (1983, meters)', 82140, 82140, 'Oracle', 'PROJCS["Nevada 2701 , Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -115.583333], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 8000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2701, Eastern Zone (1927)', 82141, 82141, 'Oracle', 'PROJCS["Nevada 2701, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -115.583333], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2701, Eastern Zone (1983, US Survey feet)', 82142, 82142, 'Oracle', 'PROJCS["Nevada 2701, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -115.583333], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 8000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2702, Central Zone (1927)', 82143, 82143, 'Oracle', 'PROJCS["Nevada 2702, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -116.666667], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2702, Central Zone (1983, US Survey feet)', 82144, 82144, 'Oracle', 'PROJCS["Nevada 2702, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -116.666667], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 6000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2702, Central Zone (1983, meters)', 82145, 82145, 'Oracle', 'PROJCS["Nevada 2702, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -116.666667], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 6000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2703, Western Zone (1927)', 82146, 82146, 'Oracle', 'PROJCS["Nevada 2703, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -118.583333], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2703, Western Zone (1983, US Survey feet)', 82147, 82147, 'Oracle', 'PROJCS["Nevada 2703, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -118.583333], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 4000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Nevada 2703, Western Zone (1983, meters)', 82148, 82148, 'Oracle', 'PROJCS["Nevada 2703, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -118.583333], PARAMETER ["Latitude_Of_Origin", 34.750000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 4000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Hampshire 2800 (1927)', 82149, 82149, 'Oracle', 'PROJCS["New Hampshire 2800 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -71.666667], PARAMETER ["Latitude_Of_Origin", 42.500000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Hampshire 2800 (1983, US Survey feet)', 82150, 82150, 'Oracle', 'PROJCS["New Hampshire 2800 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -71.666667], PARAMETER ["Latitude_Of_Origin", 42.500000], PARAMETER ["False_Easting", 300000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Hampshire 2800 (1983, meters)', 82151, 82151, 'Oracle', 'PROJCS["New Hampshire 2800 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -71.666667], PARAMETER ["Latitude_Of_Origin", 42.500000], PARAMETER ["False_Easting", 300000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Jersey 2900 (1927)', 82152, 82152, 'Oracle', 'PROJCS["New Jersey 2900 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999975], PARAMETER ["Central_Meridian", -74.666667], PARAMETER ["Latitude_Of_Origin", 38.833333], PARAMETER ["False_Easting", 609601.219202], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Jersey 2900 (1983, US Survey feet)', 82153, 82153, 'Oracle', 'PROJCS["New Jersey 2900 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -74.500000], PARAMETER ["Latitude_Of_Origin", 38.833333], PARAMETER ["False_Easting", 150000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Jersey 2900 (1983, meters)', 82154, 82154, 'Oracle', 'PROJCS["New Jersey 2900 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -74.500000], PARAMETER ["Latitude_Of_Origin", 38.833333], PARAMETER ["False_Easting", 150000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3001 , Eastern Zone (1983, US Survey feet)', 82155, 82155, 'Oracle', 'PROJCS["New Mexico 3001 , Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999909], PARAMETER ["Central_Meridian", -104.333333], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 165000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3001, Eastern Zone (1927)', 82156, 82156, 'Oracle', 'PROJCS["New Mexico 3001, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999909], PARAMETER ["Central_Meridian", -104.333333], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3001, Eastern Zone (1983, meters)', 82157, 82157, 'Oracle', 'PROJCS["New Mexico 3001, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999909], PARAMETER ["Central_Meridian", -104.333333], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 165000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3002, Central Zone (1927)', 82158, 82158, 'Oracle', 'PROJCS["New Mexico 3002, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -106.250000], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3002, Central Zone (1983, US Survey feet)', 82159, 82159, 'Oracle', 'PROJCS["New Mexico 3002, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -106.250000], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3002, Central Zone (1983, meters)', 82160, 82160, 'Oracle', 'PROJCS["New Mexico 3002, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -106.250000], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3003, Western Zone (1927)', 82161, 82161, 'Oracle', 'PROJCS["New Mexico 3003, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999917], PARAMETER ["Central_Meridian", -107.833333], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3003, Western Zone (1983, US Survey feet)', 82162, 82162, 'Oracle', 'PROJCS["New Mexico 3003, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999917], PARAMETER ["Central_Meridian", -107.833333], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 830000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Mexico 3003, Western Zone (1983, meters)', 82163, 82163, 'Oracle', 'PROJCS["New Mexico 3003, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999917], PARAMETER ["Central_Meridian", -107.833333], PARAMETER ["Latitude_Of_Origin", 31.000000], PARAMETER ["False_Easting", 830000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3101, Eastern Zone (1927)', 82164, 82164, 'Oracle', 'PROJCS["New York 3101, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999967], PARAMETER ["Central_Meridian", -74.333333], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3101, Eastern Zone (1983, US Survey feet)', 82165, 82165, 'Oracle', 'PROJCS["New York 3101, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -74.500000], PARAMETER ["Latitude_Of_Origin", 38.833333], PARAMETER ["False_Easting", 150000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3101, Eastern Zone (1983, meters)', 82166, 82166, 'Oracle', 'PROJCS["New York 3101, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -74.500000], PARAMETER ["Latitude_Of_Origin", 38.833333], PARAMETER ["False_Easting", 150000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3102, Central Zone (1927)', 82167, 82167, 'Oracle', 'PROJCS["New York 3102, Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -76.583333], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3102, Central Zone (1983, US Survey feet)', 82168, 82168, 'Oracle', 'PROJCS["New York 3102, Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -76.583333], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 250000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3102, Central Zone (1983, meters)', 82169, 82169, 'Oracle', 'PROJCS["New York 3102, Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -76.583333], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 250000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3103, Western Zone (1927)', 82170, 82170, 'Oracle', 'PROJCS["New York 3103, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -78.583333], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3103, Western Zone (1983, US Survey feet)', 82171, 82171, 'Oracle', 'PROJCS["New York 3103, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -78.583333], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 350000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New York 3103, Western Zone (1983, meters)', 82172, 82172, 'Oracle', 'PROJCS["New York 3103, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -78.583333], PARAMETER ["Latitude_Of_Origin", 40.000000], PARAMETER ["False_Easting", 350000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'North Taieri Circuit', 82173, 82173, 'Oracle', 'PROJCS["North Taieri Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999960], PARAMETER ["Central_Meridian", 170.282589], PARAMETER ["Latitude_Of_Origin", -45.861513], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Observation Pt. Circuit', 82174, 82174, 'Oracle', 'PROJCS["Observation Pt. Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 170.628595], PARAMETER ["Latitude_Of_Origin", -45.816197], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Okarito Circuit', 82175, 82175, 'Oracle', 'PROJCS["Okarito Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 170.260926], PARAMETER ["Latitude_Of_Origin", -43.110128], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Portuguese National System (D73)', 82176, 82176, 'Oracle', 'PROJCS["Portuguese National System (D73)", GEOGCS [ "Melrica 1973 (D73)", DATUM ["Melrica 1973 (D73)", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", -8.131906], PARAMETER ["Latitude_Of_Origin", 39.666667], PARAMETER ["False_Easting", 180.598000], PARAMETER ["False_Northing", -86.990000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Portuguese National System (DLx)', 82177, 82177, 'Oracle', 'PROJCS["Portuguese National System (DLx)", GEOGCS [ "Lisboa (DLx)", DATUM ["Lisboa (DLx)", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", -8.131906], PARAMETER ["Latitude_Of_Origin", 39.666667], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Portuguese National System (WGS 84)', 82178, 82178, 'Oracle', 'PROJCS["Portuguese National System (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", -8.131906], PARAMETER ["Latitude_Of_Origin", 39.666667], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Poverty Bay Circuit', 82179, 82179, 'Oracle', 'PROJCS["Poverty Bay Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 177.885636], PARAMETER ["Latitude_Of_Origin", -38.624703], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Projection 3', 82180, 82180, 'Oracle', 'PROJCS["Projection 3", GEOGCS [ "Ascension Island 1958", DATUM ["Ascension Island 1958", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -79.500000], PARAMETER ["False_Easting", 304800.609601], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 10 (NAD 27)', 82181, 82181, 'Oracle', 'PROJCS["Quebec MTM Zone 10 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -79.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 10 (NAD 83)', 82182, 82182, 'Oracle', 'PROJCS["Quebec MTM Zone 10 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -79.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 2 (NAD 27)', 82183, 82183, 'Oracle', 'PROJCS["Quebec MTM Zone 2 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -55.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 2 (NAD 83)', 82184, 82184, 'Oracle', 'PROJCS["Quebec MTM Zone 2 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -55.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 3 (NAD 27)', 82185, 82185, 'Oracle', 'PROJCS["Quebec MTM Zone 3 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -58.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 3 (NAD 83)', 82186, 82186, 'Oracle', 'PROJCS["Quebec MTM Zone 3 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -58.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 4 (NAD 27)', 82187, 82187, 'Oracle', 'PROJCS["Quebec MTM Zone 4 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -61.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 4 (NAD 83)', 82188, 82188, 'Oracle', 'PROJCS["Quebec MTM Zone 4 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -61.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 5 (NAD 27)', 82189, 82189, 'Oracle', 'PROJCS["Quebec MTM Zone 5 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -64.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 5 (NAD 83)', 82190, 82190, 'Oracle', 'PROJCS["Quebec MTM Zone 5 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -64.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 6 (NAD 27)', 82191, 82191, 'Oracle', 'PROJCS["Quebec MTM Zone 6 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -67.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 6 (NAD 83)', 82192, 82192, 'Oracle', 'PROJCS["Quebec MTM Zone 6 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -67.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 7 (NAD 27)', 82193, 82193, 'Oracle', 'PROJCS["Quebec MTM Zone 7 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -70.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 7 (NAD 83)', 82194, 82194, 'Oracle', 'PROJCS["Quebec MTM Zone 7 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -70.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 8 (NAD 27)', 82195, 82195, 'Oracle', 'PROJCS["Quebec MTM Zone 8 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -73.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 8 (NAD 83)', 82196, 82196, 'Oracle', 'PROJCS["Quebec MTM Zone 8 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -73.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 9 (NAD 27)', 82197, 82197, 'Oracle', 'PROJCS["Quebec MTM Zone 9 (NAD 27)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -76.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Quebec MTM Zone 9 (NAD 83)', 82198, 82198, 'Oracle', 'PROJCS["Quebec MTM Zone 9 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Central_Meridian", -76.500000], PARAMETER ["False_Easting", 304800.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Rhode Island 3800 (1927)', 82199, 82199, 'Oracle', 'PROJCS["Rhode Island 3800 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999994], PARAMETER ["Central_Meridian", -71.500000], PARAMETER ["Latitude_Of_Origin", 41.083333], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Rhode Island 3800 (1983, US Survey feet)', 82200, 82200, 'Oracle', 'PROJCS["Rhode Island 3800 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999994], PARAMETER ["Central_Meridian", -71.500000], PARAMETER ["Latitude_Of_Origin", 41.083333], PARAMETER ["False_Easting", 100000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Rhode Island 3800 (1983, meters)', 82201, 82201, 'Oracle', 'PROJCS["Rhode Island 3800 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999994], PARAMETER ["Central_Meridian", -71.500000], PARAMETER ["Latitude_Of_Origin", 41.083333], PARAMETER ["False_Easting", 100000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Swedish National System (RT 90)', 82202, 82202, 'Oracle', 'PROJCS["Swedish National System (RT 90)", GEOGCS [ "RT 90 (Sweden)", DATUM ["RT 90 (Sweden)", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 15.808278], PARAMETER ["False_Easting", 1500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Taranaki Circuit', 82203, 82203, 'Oracle', 'PROJCS["Taranaki Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 174.228012], PARAMETER ["Latitude_Of_Origin", -39.135758], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Timaru Circuit', 82204, 82204, 'Oracle', 'PROJCS["Timaru Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 171.057251], PARAMETER ["Latitude_Of_Origin", -44.402220], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Tuhirangi Circuit', 82205, 82205, 'Oracle', 'PROJCS["Tuhirangi Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 175.640037], PARAMETER ["Latitude_Of_Origin", -39.512470], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 1 (NAD 27 for Alaska)', 82206, 82206, 'Oracle', 'PROJCS["UTM Zone 1 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -177.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 1 (NAD 83)', 82207, 82207, 'Oracle', 'PROJCS["UTM Zone 1 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -177.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 1, Northern Hemisphere (WGS 84)', 82208, 82208, 'Oracle', 'PROJCS["UTM Zone 1, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -177.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 1, Southern Hemisphere (WGS 84)', 82209, 82209, 'Oracle', 'PROJCS["UTM Zone 1, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -177.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 10 (NAD 27 for Canada)', 82210, 82210, 'Oracle', 'PROJCS["UTM Zone 10 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -123.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 10 (NAD 27 for US)', 82211, 82211, 'Oracle', 'PROJCS["UTM Zone 10 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -123.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 10 (NAD 83)', 82212, 82212, 'Oracle', 'PROJCS["UTM Zone 10 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -123.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 10, Northern Hemisphere (WGS 84)', 82213, 82213, 'Oracle', 'PROJCS["UTM Zone 10, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -123.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 10, Southern Hemisphere (WGS 84)', 82214, 82214, 'Oracle', 'PROJCS["UTM Zone 10, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -123.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 11 (NAD 27 for Canada)', 82215, 82215, 'Oracle', 'PROJCS["UTM Zone 11 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -117.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 11 (NAD 27 for US)', 82216, 82216, 'Oracle', 'PROJCS["UTM Zone 11 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -117.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 11 (NAD 83)', 82217, 82217, 'Oracle', 'PROJCS["UTM Zone 11 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -117.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 11, Northern Hemisphere (WGS 84)', 82218, 82218, 'Oracle', 'PROJCS["UTM Zone 11, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -117.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 11, Southern Hemisphere (WGS 84)', 82219, 82219, 'Oracle', 'PROJCS["UTM Zone 11, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -117.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 12 (NAD 27 for Canada)', 82220, 82220, 'Oracle', 'PROJCS["UTM Zone 12 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -111.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 12 (NAD 27 for US)', 82221, 82221, 'Oracle', 'PROJCS["UTM Zone 12 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -111.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 12 (NAD 83)', 82222, 82222, 'Oracle', 'PROJCS["UTM Zone 12 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -111.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 12, Northern Hemisphere (WGS 84)', 82223, 82223, 'Oracle', 'PROJCS["UTM Zone 12, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -111.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 12, Southern Hemisphere (WGS 84)', 82224, 82224, 'Oracle', 'PROJCS["UTM Zone 12, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -111.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 13 (NAD 27 for Canada)', 82225, 82225, 'Oracle', 'PROJCS["UTM Zone 13 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -105.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 13 (NAD 27 for US)', 82226, 82226, 'Oracle', 'PROJCS["UTM Zone 13 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -105.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 13 (NAD 83)', 82227, 82227, 'Oracle', 'PROJCS["UTM Zone 13 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -105.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 13, Northern Hemisphere (WGS 84)', 82228, 82228, 'Oracle', 'PROJCS["UTM Zone 13, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -105.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 13, Southern Hemisphere (WGS 84)', 82229, 82229, 'Oracle', 'PROJCS["UTM Zone 13, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -105.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 14 (NAD 27 for Canada)', 82230, 82230, 'Oracle', 'PROJCS["UTM Zone 14 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -99.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 14 (NAD 27 for US)', 82231, 82231, 'Oracle', 'PROJCS["UTM Zone 14 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -99.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 14 (NAD 83)', 82232, 82232, 'Oracle', 'PROJCS["UTM Zone 14 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -99.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 14, Northern Hemisphere (WGS 84)', 82233, 82233, 'Oracle', 'PROJCS["UTM Zone 14, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -99.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 14, Southern Hemisphere (WGS 84)', 82234, 82234, 'Oracle', 'PROJCS["UTM Zone 14, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -99.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 15 (NAD 27 for Canada)', 82235, 82235, 'Oracle', 'PROJCS["UTM Zone 15 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -93.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 15 (NAD 27 for US)', 82236, 82236, 'Oracle', 'PROJCS["UTM Zone 15 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -93.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 15 (NAD 83)', 82237, 82237, 'Oracle', 'PROJCS["UTM Zone 15 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -93.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 15, Northern Hemisphere (WGS 84)', 82238, 82238, 'Oracle', 'PROJCS["UTM Zone 15, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -93.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 15, Southern Hemisphere (WGS 84)', 82239, 82239, 'Oracle', 'PROJCS["UTM Zone 15, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -93.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 16 (NAD 27 for Canada)', 82240, 82240, 'Oracle', 'PROJCS["UTM Zone 16 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 16 (NAD 27 for US)', 82241, 82241, 'Oracle', 'PROJCS["UTM Zone 16 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 16 (NAD 83)', 82242, 82242, 'Oracle', 'PROJCS["UTM Zone 16 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 16, Northern Hemisphere (WGS 84)', 82243, 82243, 'Oracle', 'PROJCS["UTM Zone 16, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 16, Southern Hemisphere (WGS 84)', 82244, 82244, 'Oracle', 'PROJCS["UTM Zone 16, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -87.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 17 (NAD 27 for Canada)', 82245, 82245, 'Oracle', 'PROJCS["UTM Zone 17 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 17 (NAD 27 for US)', 82246, 82246, 'Oracle', 'PROJCS["UTM Zone 17 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 17 (NAD 83)', 82247, 82247, 'Oracle', 'PROJCS["UTM Zone 17 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 17, Northern Hemisphere (SAD 69)', 82248, 82248, 'Oracle', 'PROJCS["UTM Zone 17, Northern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 17, Northern Hemisphere (WGS 84)', 82249, 82249, 'Oracle', 'PROJCS["UTM Zone 17, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 17, Southern Hemisphere (SAD 69)', 82250, 82250, 'Oracle', 'PROJCS["UTM Zone 17, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 17, Southern Hemisphere (WGS 84)', 82251, 82251, 'Oracle', 'PROJCS["UTM Zone 17, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -81.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 18 (NAD 27 for Canada)', 82252, 82252, 'Oracle', 'PROJCS["UTM Zone 18 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -75.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 18 (NAD 27 for US)', 82253, 82253, 'Oracle', 'PROJCS["UTM Zone 18 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -75.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 18 (NAD 83)', 82254, 82254, 'Oracle', 'PROJCS["UTM Zone 18 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -75.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 18, Northern Hemisphere (SAD 69)', 82255, 82255, 'Oracle', 'PROJCS["UTM Zone 18, Northern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -75.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 18, Northern Hemisphere (WGS 84)', 82256, 82256, 'Oracle', 'PROJCS["UTM Zone 18, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -75.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 18, Southern Hemisphere (Corrego Alegre)', 82257, 82257, 'Oracle', 'PROJCS["UTM Zone 18, Southern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -75.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 18, Southern Hemisphere (SAD 69)', 82258, 82258, 'Oracle', 'PROJCS["UTM Zone 18, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -75.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 18, Southern Hemisphere (WGS 84)', 82259, 82259, 'Oracle', 'PROJCS["UTM Zone 18, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -75.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19 (NAD 27 for Canada)', 82260, 82260, 'Oracle', 'PROJCS["UTM Zone 19 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19 (NAD 27 for US)', 82261, 82261, 'Oracle', 'PROJCS["UTM Zone 19 (NAD 27 for US)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19 (NAD 83)', 82262, 82262, 'Oracle', 'PROJCS["UTM Zone 19 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19, Northern Hemisphere (Corrego Alegre)', 82263, 82263, 'Oracle', 'PROJCS["UTM Zone 19, Northern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19, Northern Hemisphere (SAD 69)', 82264, 82264, 'Oracle', 'PROJCS["UTM Zone 19, Northern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19, Northern Hemisphere (WGS 84)', 82265, 82265, 'Oracle', 'PROJCS["UTM Zone 19, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19, Southern Hemisphere (Corrego Alegre)', 82266, 82266, 'Oracle', 'PROJCS["UTM Zone 19, Southern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19, Southern Hemisphere (SAD 69)', 82267, 82267, 'Oracle', 'PROJCS["UTM Zone 19, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 19, Southern Hemisphere (WGS 84)', 82268, 82268, 'Oracle', 'PROJCS["UTM Zone 19, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -69.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 2 (NAD 27 for Alaska)', 82269, 82269, 'Oracle', 'PROJCS["UTM Zone 2 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -171.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 2 (NAD 83)', 82270, 82270, 'Oracle', 'PROJCS["UTM Zone 2 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -171.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 2, Northern Hemisphere (WGS 84)', 82271, 82271, 'Oracle', 'PROJCS["UTM Zone 2, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -171.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 2, Southern Hemisphere (WGS 84)', 82272, 82272, 'Oracle', 'PROJCS["UTM Zone 2, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -171.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 20 (NAD 27 for Canada)', 82273, 82273, 'Oracle', 'PROJCS["UTM Zone 20 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -63.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 20 (NAD 83)', 82274, 82274, 'Oracle', 'PROJCS["UTM Zone 20 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -63.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 20, Northern Hemisphere (Corrego Alegre)', 82275, 82275, 'Oracle', 'PROJCS["UTM Zone 20, Northern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -63.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 20, Northern Hemisphere (SAD 69)', 82276, 82276, 'Oracle', 'PROJCS["UTM Zone 20, Northern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -63.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 20, Northern Hemisphere (WGS 84)', 82277, 82277, 'Oracle', 'PROJCS["UTM Zone 20, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -63.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 20, Southern Hemisphere (Corrego Alegre)', 82278, 82278, 'Oracle', 'PROJCS["UTM Zone 20, Southern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -63.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 20, Southern Hemisphere (SAD 69)', 82279, 82279, 'Oracle', 'PROJCS["UTM Zone 20, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -63.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 20, Southern Hemisphere (WGS 84)', 82280, 82280, 'Oracle', 'PROJCS["UTM Zone 20, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -63.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 21 (NAD 27 for Canada)', 82281, 82281, 'Oracle', 'PROJCS["UTM Zone 21 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -57.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 21 (NAD 83)', 82282, 82282, 'Oracle', 'PROJCS["UTM Zone 21 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -57.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 21, Northern Hemisphere (Corrego Alegre)', 82283, 82283, 'Oracle', 'PROJCS["UTM Zone 21, Northern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -57.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 21, Northern Hemisphere (SAD 69)', 82284, 82284, 'Oracle', 'PROJCS["UTM Zone 21, Northern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -57.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 21, Northern Hemisphere (WGS 84)', 82285, 82285, 'Oracle', 'PROJCS["UTM Zone 21, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -57.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 21, Southern Hemisphere (Corrego Alegre)', 82286, 82286, 'Oracle', 'PROJCS["UTM Zone 21, Southern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -57.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 21, Southern Hemisphere (SAD 69)', 82287, 82287, 'Oracle', 'PROJCS["UTM Zone 21, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -57.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 21, Southern Hemisphere (WGS 84)', 82288, 82288, 'Oracle', 'PROJCS["UTM Zone 21, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -57.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 22 (NAD 27 for Canada)', 82289, 82289, 'Oracle', 'PROJCS["UTM Zone 22 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -51.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 22 (NAD 83)', 82290, 82290, 'Oracle', 'PROJCS["UTM Zone 22 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -51.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 22, Northern Hemisphere (Corrego Alegre)', 82291, 82291, 'Oracle', 'PROJCS["UTM Zone 22, Northern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -51.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 22, Northern Hemisphere (SAD 69)', 82292, 82292, 'Oracle', 'PROJCS["UTM Zone 22, Northern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -51.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 22, Northern Hemisphere (WGS 84)', 82293, 82293, 'Oracle', 'PROJCS["UTM Zone 22, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -51.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 22, Southern Hemisphere (Corrego Alegre)', 82294, 82294, 'Oracle', 'PROJCS["UTM Zone 22, Southern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -51.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 22, Southern Hemisphere (SAD 69)', 82295, 82295, 'Oracle', 'PROJCS["UTM Zone 22, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -51.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 22, Southern Hemisphere (WGS 84)', 82296, 82296, 'Oracle', 'PROJCS["UTM Zone 22, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -51.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 23 (NAD 27 for Canada)', 82297, 82297, 'Oracle', 'PROJCS["UTM Zone 23 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -45.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 23 (NAD 83)', 82298, 82298, 'Oracle', 'PROJCS["UTM Zone 23 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -45.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 23, Northern Hemisphere (WGS 84)', 82299, 82299, 'Oracle', 'PROJCS["UTM Zone 23, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -45.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 23, Southern Hemisphere (Corrego Alegre)', 82300, 82300, 'Oracle', 'PROJCS["UTM Zone 23, Southern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -45.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 23, Southern Hemisphere (SAD 69)', 82301, 82301, 'Oracle', 'PROJCS["UTM Zone 23, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -45.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 23, Southern Hemisphere (WGS 84)', 82302, 82302, 'Oracle', 'PROJCS["UTM Zone 23, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -45.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 24 (NAD 27 for Canada)', 82303, 82303, 'Oracle', 'PROJCS["UTM Zone 24 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -39.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 24 (NAD 83)', 82304, 82304, 'Oracle', 'PROJCS["UTM Zone 24 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -39.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 24, Northern Hemisphere (WGS 84)', 82305, 82305, 'Oracle', 'PROJCS["UTM Zone 24, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -39.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 24, Southern Hemisphere (Corrego Alegre)', 82306, 82306, 'Oracle', 'PROJCS["UTM Zone 24, Southern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -39.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 24, Southern Hemisphere (SAD 69)', 82307, 82307, 'Oracle', 'PROJCS["UTM Zone 24, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -39.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 24, Southern Hemisphere (WGS 84)', 82308, 82308, 'Oracle', 'PROJCS["UTM Zone 24, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -39.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 25 (NAD 27 for Canada)', 82309, 82309, 'Oracle', 'PROJCS["UTM Zone 25 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -33.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 25 (NAD 83)', 82310, 82310, 'Oracle', 'PROJCS["UTM Zone 25 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -33.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 25, Northern Hemisphere (WGS 84)', 82311, 82311, 'Oracle', 'PROJCS["UTM Zone 25, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -33.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 25, Southern Hemisphere (Corrego Alegre)', 82312, 82312, 'Oracle', 'PROJCS["UTM Zone 25, Southern Hemisphere (Corrego Alegre)", GEOGCS [ "Corrego Alegre", DATUM ["Corrego Alegre", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -33.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 25, Southern Hemisphere (SAD 69)', 82313, 82313, 'Oracle', 'PROJCS["UTM Zone 25, Southern Hemisphere (SAD 69)", GEOGCS [ "South American 1969", DATUM ["South American 1969", SPHEROID ["South American 1969", 6378160, 298.25]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -33.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 25, Southern Hemisphere (WGS 84)', 82314, 82314, 'Oracle', 'PROJCS["UTM Zone 25, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -33.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 26 (NAD 27 for Canada)', 82315, 82315, 'Oracle', 'PROJCS["UTM Zone 26 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -27.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 26 (NAD 83)', 82316, 82316, 'Oracle', 'PROJCS["UTM Zone 26 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -27.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 26, Northern Hemisphere (WGS 84)', 82317, 82317, 'Oracle', 'PROJCS["UTM Zone 26, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -27.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 26, Southern Hemisphere (WGS 84)', 82318, 82318, 'Oracle', 'PROJCS["UTM Zone 26, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -27.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 27 (NAD 27 for Canada)', 82319, 82319, 'Oracle', 'PROJCS["UTM Zone 27 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -21.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 27 (NAD 83)', 82320, 82320, 'Oracle', 'PROJCS["UTM Zone 27 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -21.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 27, Northern Hemisphere (WGS 84)', 82321, 82321, 'Oracle', 'PROJCS["UTM Zone 27, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -21.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 27, Southern Hemisphere (WGS 84)', 82322, 82322, 'Oracle', 'PROJCS["UTM Zone 27, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -21.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 28 (ED 50)', 82323, 82323, 'Oracle', 'PROJCS["UTM Zone 28 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -15.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 28 (NAD 27 for Canada)', 82324, 82324, 'Oracle', 'PROJCS["UTM Zone 28 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -15.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 28 (NAD 83)', 82325, 82325, 'Oracle', 'PROJCS["UTM Zone 28 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -15.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 28, Northern Hemisphere (WGS 84)', 82326, 82326, 'Oracle', 'PROJCS["UTM Zone 28, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -15.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 28, Southern Hemisphere (WGS 84)', 82327, 82327, 'Oracle', 'PROJCS["UTM Zone 28, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -15.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 29 (ED 50)', 82328, 82328, 'Oracle', 'PROJCS["UTM Zone 29 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -9.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 29 (NAD 27 for Canada)', 82329, 82329, 'Oracle', 'PROJCS["UTM Zone 29 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -9.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 29 (NAD 83)', 82330, 82330, 'Oracle', 'PROJCS["UTM Zone 29 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -9.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 29, Northern Hemisphere (WGS 84)', 82331, 82331, 'Oracle', 'PROJCS["UTM Zone 29, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -9.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 29, Southern Hemisphere (WGS 84)', 82332, 82332, 'Oracle', 'PROJCS["UTM Zone 29, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -9.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 3 (NAD 27 for Alaska)', 82333, 82333, 'Oracle', 'PROJCS["UTM Zone 3 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -165.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 3 (NAD 83)', 82334, 82334, 'Oracle', 'PROJCS["UTM Zone 3 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -165.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 3, Northern Hemisphere (WGS 84)', 82335, 82335, 'Oracle', 'PROJCS["UTM Zone 3, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -165.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 3, Southern Hemisphere (WGS 84)', 82336, 82336, 'Oracle', 'PROJCS["UTM Zone 3, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -165.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 30 (ED 50)', 82337, 82337, 'Oracle', 'PROJCS["UTM Zone 30 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -3.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 30, Northern Hemisphere (WGS 84)', 82338, 82338, 'Oracle', 'PROJCS["UTM Zone 30, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -3.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 30, Southern Hemisphere (WGS 84)', 82339, 82339, 'Oracle', 'PROJCS["UTM Zone 30, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -3.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 31 (ED 50)', 82340, 82340, 'Oracle', 'PROJCS["UTM Zone 31 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 3.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 31, Northern Hemisphere (WGS 84)', 82341, 82341, 'Oracle', 'PROJCS["UTM Zone 31, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 3.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 31, Southern Hemisphere (WGS 84)', 82342, 82342, 'Oracle', 'PROJCS["UTM Zone 31, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 3.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 32 (ED 50)', 82343, 82343, 'Oracle', 'PROJCS["UTM Zone 32 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 9.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 32, Northern Hemisphere (WGS 84)', 82344, 82344, 'Oracle', 'PROJCS["UTM Zone 32, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 9.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 32, Southern Hemisphere (WGS 84)', 82345, 82345, 'Oracle', 'PROJCS["UTM Zone 32, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 9.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 33 (ED 50)', 82346, 82346, 'Oracle', 'PROJCS["UTM Zone 33 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 15.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 33, Northern Hemisphere (WGS 84)', 82347, 82347, 'Oracle', 'PROJCS["UTM Zone 33, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 15.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 33, Southern Hemisphere (WGS 84)', 82348, 82348, 'Oracle', 'PROJCS["UTM Zone 33, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 15.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 34 (ED 50)', 82349, 82349, 'Oracle', 'PROJCS["UTM Zone 34 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 21.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 34, Northern Hemisphere (WGS 84)', 82350, 82350, 'Oracle', 'PROJCS["UTM Zone 34, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 21.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 34, Southern Hemisphere (WGS 84)', 82351, 82351, 'Oracle', 'PROJCS["UTM Zone 34, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 21.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 35 (ED 50)', 82352, 82352, 'Oracle', 'PROJCS["UTM Zone 35 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 27.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 35, Northern Hemisphere (WGS 84)', 82353, 82353, 'Oracle', 'PROJCS["UTM Zone 35, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 27.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 35, Southern Hemisphere (WGS 84)', 82354, 82354, 'Oracle', 'PROJCS["UTM Zone 35, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 27.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 36 (ED 50)', 82355, 82355, 'Oracle', 'PROJCS["UTM Zone 36 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 33.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 36, Northern Hemisphere (WGS 84)', 82356, 82356, 'Oracle', 'PROJCS["UTM Zone 36, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 33.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 36, Southern Hemisphere (WGS 84)', 82357, 82357, 'Oracle', 'PROJCS["UTM Zone 36, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 33.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 37 (ED 50)', 82358, 82358, 'Oracle', 'PROJCS["UTM Zone 37 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 39.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 37, Northern Hemisphere (WGS 84)', 82359, 82359, 'Oracle', 'PROJCS["UTM Zone 37, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 39.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 37, Southern Hemisphere (WGS 84)', 82360, 82360, 'Oracle', 'PROJCS["UTM Zone 37, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 39.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 38 (ED 50)', 82361, 82361, 'Oracle', 'PROJCS["UTM Zone 38 (ED 50)", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 45.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 38, Northern Hemisphere (WGS 84)', 82362, 82362, 'Oracle', 'PROJCS["UTM Zone 38, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 45.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 38, Southern Hemisphere (WGS 84)', 82363, 82363, 'Oracle', 'PROJCS["UTM Zone 38, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 45.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 39, Northern Hemisphere (WGS 84)', 82364, 82364, 'Oracle', 'PROJCS["UTM Zone 39, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 51.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 39, Southern Hemisphere (WGS 84)', 82365, 82365, 'Oracle', 'PROJCS["UTM Zone 39, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 51.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 4 (NAD 27 for Alaska)', 82366, 82366, 'Oracle', 'PROJCS["UTM Zone 4 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -159.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 4 (NAD 83)', 82367, 82367, 'Oracle', 'PROJCS["UTM Zone 4 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -159.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 4, Northern Hemisphere (WGS 84)', 82368, 82368, 'Oracle', 'PROJCS["UTM Zone 4, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -159.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 4, Southern Hemisphere (WGS 84)', 82369, 82369, 'Oracle', 'PROJCS["UTM Zone 4, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -159.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 40, Northern Hemisphere (WGS 84)', 82370, 82370, 'Oracle', 'PROJCS["UTM Zone 40, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 57.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 40, Southern Hemisphere (WGS 84)', 82371, 82371, 'Oracle', 'PROJCS["UTM Zone 40, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 57.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 41, Northern Hemisphere (WGS 84)', 82372, 82372, 'Oracle', 'PROJCS["UTM Zone 41, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 63.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 41, Southern Hemisphere (WGS 84)', 82373, 82373, 'Oracle', 'PROJCS["UTM Zone 41, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 63.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 42, Northern Hemisphere (WGS 84)', 82374, 82374, 'Oracle', 'PROJCS["UTM Zone 42, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 69.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 42, Southern Hemisphere (WGS 84)', 82375, 82375, 'Oracle', 'PROJCS["UTM Zone 42, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 69.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 43, Northern Hemisphere (WGS 84)', 82376, 82376, 'Oracle', 'PROJCS["UTM Zone 43, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 75.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 43, Southern Hemisphere (WGS 84)', 82377, 82377, 'Oracle', 'PROJCS["UTM Zone 43, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 75.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 44, Northern Hemisphere (WGS 84)', 82378, 82378, 'Oracle', 'PROJCS["UTM Zone 44, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 81.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 44, Southern Hemisphere (WGS 84)', 82379, 82379, 'Oracle', 'PROJCS["UTM Zone 44, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 81.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 45, Northern Hemisphere (WGS 84)', 82380, 82380, 'Oracle', 'PROJCS["UTM Zone 45, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 87.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 45, Southern Hemisphere (WGS 84)', 82381, 82381, 'Oracle', 'PROJCS["UTM Zone 45, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 87.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 46, Northern Hemisphere (WGS 84)', 82382, 82382, 'Oracle', 'PROJCS["UTM Zone 46, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 93.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 46, Southern Hemisphere (WGS 84)', 82383, 82383, 'Oracle', 'PROJCS["UTM Zone 46, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 93.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 47, Northern Hemisphere (WGS 84)', 82384, 82384, 'Oracle', 'PROJCS["UTM Zone 47, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 99.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 47, Southern Hemisphere (WGS 84)', 82385, 82385, 'Oracle', 'PROJCS["UTM Zone 47, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 99.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 48, Northern Hemisphere (WGS 84)', 82386, 82386, 'Oracle', 'PROJCS["UTM Zone 48, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 105.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 48, Southern Hemisphere (WGS 84)', 82387, 82387, 'Oracle', 'PROJCS["UTM Zone 48, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 105.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 49, Northern Hemisphere (WGS 84)', 82388, 82388, 'Oracle', 'PROJCS["UTM Zone 49, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 111.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 49, Southern Hemisphere (WGS 84)', 82389, 82389, 'Oracle', 'PROJCS["UTM Zone 49, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 111.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 5 (NAD 27 for Alaska)', 82390, 82390, 'Oracle', 'PROJCS["UTM Zone 5 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -153.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 5 (NAD 83)', 82391, 82391, 'Oracle', 'PROJCS["UTM Zone 5 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -153.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 5, Northern Hemisphere (WGS 84)', 82392, 82392, 'Oracle', 'PROJCS["UTM Zone 5, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -153.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 5, Southern Hemisphere (WGS 84)', 82393, 82393, 'Oracle', 'PROJCS["UTM Zone 5, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -153.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 50, Northern Hemisphere (WGS 84)', 82394, 82394, 'Oracle', 'PROJCS["UTM Zone 50, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 117.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 50, Southern Hemisphere (WGS 84)', 82395, 82395, 'Oracle', 'PROJCS["UTM Zone 50, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 117.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 51 (Tokyo)', 82396, 82396, 'Oracle', 'PROJCS["UTM Zone 51 (Tokyo)", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 123.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 51, Northern Hemisphere (WGS 84)', 82397, 82397, 'Oracle', 'PROJCS["UTM Zone 51, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 123.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 51, Southern Hemisphere (WGS 84)', 82398, 82398, 'Oracle', 'PROJCS["UTM Zone 51, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 123.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 52 (Tokyo)', 82399, 82399, 'Oracle', 'PROJCS["UTM Zone 52 (Tokyo)", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 129.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 52, Northern Hemisphere (WGS 84)', 82400, 82400, 'Oracle', 'PROJCS["UTM Zone 52, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 129.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 52, Southern Hemisphere (WGS 84)', 82401, 82401, 'Oracle', 'PROJCS["UTM Zone 52, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 129.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 53 (Tokyo)', 82402, 82402, 'Oracle', 'PROJCS["UTM Zone 53 (Tokyo)", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 135.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 53, Northern Hemisphere (WGS 84)', 82403, 82403, 'Oracle', 'PROJCS["UTM Zone 53, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 135.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 53, Southern Hemisphere (WGS 84)', 82404, 82404, 'Oracle', 'PROJCS["UTM Zone 53, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 135.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 54 (Tokyo)', 82405, 82405, 'Oracle', 'PROJCS["UTM Zone 54 (Tokyo)", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 141.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 54, Northern Hemisphere (WGS 84)', 82406, 82406, 'Oracle', 'PROJCS["UTM Zone 54, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 141.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 54, Southern Hemisphere (WGS 84)', 82407, 82407, 'Oracle', 'PROJCS["UTM Zone 54, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 141.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 55 (Tokyo)', 82408, 82408, 'Oracle', 'PROJCS["UTM Zone 55 (Tokyo)", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 147.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 55, Northern Hemisphere (WGS 84)', 82409, 82409, 'Oracle', 'PROJCS["UTM Zone 55, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 147.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 55, Southern Hemisphere (WGS 84)', 82410, 82410, 'Oracle', 'PROJCS["UTM Zone 55, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 147.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 56 (Tokyo)', 82411, 82411, 'Oracle', 'PROJCS["UTM Zone 56 (Tokyo)", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 153.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 56, Northern Hemisphere (WGS 84)', 82412, 82412, 'Oracle', 'PROJCS["UTM Zone 56, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 153.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 56, Southern Hemisphere (WGS 84)', 82413, 82413, 'Oracle', 'PROJCS["UTM Zone 56, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 153.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 57 (Tokyo)', 82414, 82414, 'Oracle', 'PROJCS["UTM Zone 57 (Tokyo)", GEOGCS [ "Tokyo", DATUM ["Tokyo", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 159.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 57, Northern Hemisphere (WGS 84)', 82415, 82415, 'Oracle', 'PROJCS["UTM Zone 57, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 159.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 57, Southern Hemisphere (WGS 84)', 82416, 82416, 'Oracle', 'PROJCS["UTM Zone 57, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 159.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 58, Northern Hemisphere (WGS 84)', 82417, 82417, 'Oracle', 'PROJCS["UTM Zone 58, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 165.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 58, Southern Hemisphere (WGS 84)', 82418, 82418, 'Oracle', 'PROJCS["UTM Zone 58, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 165.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 59, Northern Hemisphere (WGS 84)', 82419, 82419, 'Oracle', 'PROJCS["UTM Zone 59, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 171.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 59, Southern Hemisphere (WGS 84)', 82420, 82420, 'Oracle', 'PROJCS["UTM Zone 59, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 171.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 6 (NAD 27 for Alaska)', 82421, 82421, 'Oracle', 'PROJCS["UTM Zone 6 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -147.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 6 (NAD 83)', 82422, 82422, 'Oracle', 'PROJCS["UTM Zone 6 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -147.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 6, Northern Hemisphere (WGS 84)', 82423, 82423, 'Oracle', 'PROJCS["UTM Zone 6, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -147.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 6, Southern Hemisphere (WGS 84)', 82424, 82424, 'Oracle', 'PROJCS["UTM Zone 6, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -147.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 60, Northern Hemisphere (WGS 84)', 82425, 82425, 'Oracle', 'PROJCS["UTM Zone 60, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 177.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 60, Southern Hemisphere (WGS 84)', 82426, 82426, 'Oracle', 'PROJCS["UTM Zone 60, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 177.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 7 (NAD 27 for Alaska)', 82427, 82427, 'Oracle', 'PROJCS["UTM Zone 7 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -141.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 7 (NAD 27 for Canada)', 82428, 82428, 'Oracle', 'PROJCS["UTM Zone 7 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -141.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 7 (NAD 83)', 82429, 82429, 'Oracle', 'PROJCS["UTM Zone 7 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -141.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 7, Northern Hemisphere (WGS 84)', 82430, 82430, 'Oracle', 'PROJCS["UTM Zone 7, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -141.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 7, Southern Hemisphere (WGS 84)', 82431, 82431, 'Oracle', 'PROJCS["UTM Zone 7, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -141.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 8 (NAD 27 for Alaska)', 82432, 82432, 'Oracle', 'PROJCS["UTM Zone 8 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -135.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 8 (NAD 27 for Canada)', 82433, 82433, 'Oracle', 'PROJCS["UTM Zone 8 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -135.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 8 (NAD 83)', 82434, 82434, 'Oracle', 'PROJCS["UTM Zone 8 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -135.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 8, Northern Hemisphere (WGS 84)', 82435, 82435, 'Oracle', 'PROJCS["UTM Zone 8, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -135.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 8, Southern Hemisphere (WGS 84)', 82436, 82436, 'Oracle', 'PROJCS["UTM Zone 8, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -135.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 9 (NAD 27 for Alaska)', 82437, 82437, 'Oracle', 'PROJCS["UTM Zone 9 (NAD 27 for Alaska)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -129.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 9 (NAD 27 for Canada)', 82438, 82438, 'Oracle', 'PROJCS["UTM Zone 9 (NAD 27 for Canada)", GEOGCS [ "NAD 27 (Canada)", DATUM ["NAD 27 (Canada)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -129.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 9 (NAD 83)', 82439, 82439, 'Oracle', 'PROJCS["UTM Zone 9 (NAD 83)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -129.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 9, Northern Hemisphere (WGS 84)', 82440, 82440, 'Oracle', 'PROJCS["UTM Zone 9, Northern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -129.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UTM Zone 9, Southern Hemisphere (WGS 84)', 82441, 82441, 'Oracle', 'PROJCS["UTM Zone 9, Southern Hemisphere (WGS 84)", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", -129.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Vermont 4400 (1927)', 82442, 82442, 'Oracle', 'PROJCS["Vermont 4400 (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999964], PARAMETER ["Central_Meridian", -72.500000], PARAMETER ["Latitude_Of_Origin", 42.500000], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Vermont 4400 (1983, US Survey feet)', 82443, 82443, 'Oracle', 'PROJCS["Vermont 4400 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999964], PARAMETER ["Central_Meridian", -72.500000], PARAMETER ["Latitude_Of_Origin", 42.500000], PARAMETER ["False_Easting", 500000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Vermont 4400 (1983, meters)', 82444, 82444, 'Oracle', 'PROJCS["Vermont 4400 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999964], PARAMETER ["Central_Meridian", -72.500000], PARAMETER ["Latitude_Of_Origin", 42.500000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wairarapa Circuit', 82445, 82445, 'Oracle', 'PROJCS["Wairarapa Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 175.647350], PARAMETER ["Latitude_Of_Origin", -40.925533], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                    
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wanganui Circuit', 82446, 82446, 'Oracle', 'PROJCS["Wanganui Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 175.488100], PARAMETER ["Latitude_Of_Origin", -40.241947], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wellington Circuit', 82447, 82447, 'Oracle', 'PROJCS["Wellington Circuit", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 174.776623], PARAMETER ["Latitude_Of_Origin", -41.301320], PARAMETER ["False_Easting", 300000.000000], PARAMETER ["False_Northing", 700000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4901, Eastern Zone (1927)', 82448, 82448, 'Oracle', 'PROJCS["Wyoming 4901, Eastern Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -105.166667], PARAMETER ["Latitude_Of_Origin", 40.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4901, Eastern Zone (1983, US Survey feet)', 82449, 82449, 'Oracle', 'PROJCS["Wyoming 4901, Eastern Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -105.166667], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 200000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4901, Eastern Zone (1983, meters)', 82450, 82450, 'Oracle', 'PROJCS["Wyoming 4901, Eastern Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -105.166667], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 200000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4902, East Central Zone (1927)', 82451, 82451, 'Oracle', 'PROJCS["Wyoming 4902, East Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -107.333333], PARAMETER ["Latitude_Of_Origin", 40.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4902, East Central Zone (1983, US Survey feet)', 82452, 82452, 'Oracle', 'PROJCS["Wyoming 4902, East Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -107.333333], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 400000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4902, East Central Zone (1983, meters)', 82453, 82453, 'Oracle', 'PROJCS["Wyoming 4902, East Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -107.333333], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 400000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4903, West Central Zone (1927)', 82454, 82454, 'Oracle', 'PROJCS["Wyoming 4903, West Central Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -108.750000], PARAMETER ["Latitude_Of_Origin", 40.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4903, West Central Zone (1983, US Survey feet)', 82455, 82455, 'Oracle', 'PROJCS["Wyoming 4903, West Central Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -108.750000], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 600000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4903, West Central Zone (1983, meters)', 82456, 82456, 'Oracle', 'PROJCS["Wyoming 4903, West Central Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -108.750000], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 600000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4904, Western Zone (1927)', 82457, 82457, 'Oracle', 'PROJCS["Wyoming 4904, Western Zone (1927)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999941], PARAMETER ["Central_Meridian", -110.083333], PARAMETER ["Latitude_Of_Origin", 40.666667], PARAMETER ["False_Easting", 152400.304801], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4904, Western Zone (1983, US Survey feet)', 82458, 82458, 'Oracle', 'PROJCS["Wyoming 4904, Western Zone (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -110.083333], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Wyoming 4904, Western Zone (1983, meters)', 82459, 82459, 'Oracle', 'PROJCS["Wyoming 4904, Western Zone (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999938], PARAMETER ["Central_Meridian", -110.083333], PARAMETER ["Latitude_Of_Origin", 40.500000], PARAMETER ["False_Easting", 800000.000000], PARAMETER ["False_Northing", 100000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 47', 82460, 82460, 'Navigate', 'PROJCS["MGA94 Zone 47", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 99.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 48', 82461, 82461, 'Navigate', 'PROJCS["MGA94 Zone 48", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 105.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 49', 82462, 82462, 'Navigate', 'PROJCS["MGA94 Zone 49", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 111.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 50', 82463, 82463, 'Navigate', 'PROJCS["MGA94 Zone 50", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 117.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 51', 82464, 82464, 'Navigate', 'PROJCS["MGA94 Zone 51", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 123.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 52', 82465, 82465, 'Navigate', 'PROJCS["MGA94 Zone 52", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 129.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 53', 82466, 82466, 'Navigate', 'PROJCS["MGA94 Zone 53", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 135.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 54', 82467, 82467, 'Navigate', 'PROJCS["MGA94 Zone 54", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 141.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 55', 82468, 82468, 'Navigate', 'PROJCS["MGA94 Zone 55", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 147.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 56', 82469, 82469, 'Navigate', 'PROJCS["MGA94 Zone 56", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 153.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 57', 82470, 82470, 'Navigate', 'PROJCS["MGA94 Zone 57", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 159.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'MGA94 Zone 58', 82471, 82471, 'Navigate', 'PROJCS["MGA94 Zone 58", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 165.000000], PARAMETER ["False_Easting", 500000.000000], PARAMETER ["False_Northing", 10000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'VICGRID66', 82472, 82472, 'Navigate', 'PROJCS["VICGRID66 Conformal Projection (Australia AGD66)", GEOGCS [ "AGD 66 VIC NSW", DATUM ["AGD 66 VIC NSW", SPHEROID ["Australian", 6378160, 298.25],-119.35,-48.3,139.48,-.42,-.26,-.44,-.61], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", -36.000000], PARAMETER ["Standard_Parallel_2", -38.000000], PARAMETER ["Central_Meridian", 145.000000], PARAMETER ["Latitude_Of_Origin", -37.000000], PARAMETER ["False_Easting", 2500000.00000], PARAMETER ["False_Northing", 4500000.00000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'VICGRID94', 82473, 82473, 'Navigate', 'PROJCS["VICGRID94 Conformal Projection (Australia GDA94)", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", -36.000000], PARAMETER ["Standard_Parallel_2", -38.000000], PARAMETER ["Central_Meridian", 145.000000], PARAMETER ["Latitude_Of_Origin", -37.000000], PARAMETER ["False_Easting", 2500000.00000], PARAMETER ["False_Northing", 2500000.00000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'ACT Standard Grid (AGD 66)', 82474, 82474, 'Navigate', 'PROJCS["ACT Standard Grid (AGD66)", GEOGCS [ "Australian Geodetic 1966 ACT", DATUM ["AGD 66 ACT", SPHEROID ["Australian", 6378160, 298.25],-129.19,-41.21,130.73,-.25,-.37,-.33,-2.96], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator"], PARAMETER ["Scale_Factor", 1.000086], PARAMETER ["Central_Meridian", 149.0092948333], PARAMETER ["False_Easting", 200000.000000], PARAMETER ["False_Northing", 4510193.4939], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'SA Lambert (GDA94)', 82475, 82475, 'Navigate', 'PROJCS["SA Lambert Conformal Projection (Australia GDA94)", GEOGCS [ "Geodetic Datum of Australia 1994", DATUM ["GDA 94", SPHEROID ["GRS 80", 6378137.000000, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic"], PARAMETER ["Standard_Parallel_1", -28.000000], PARAMETER ["Standard_Parallel_2", -36.000000], PARAMETER ["Central_Meridian", 135.000000], PARAMETER ["Latitude_Of_Origin", -32.000000], PARAMETER ["False_Easting", 1000000.00000], PARAMETER ["False_Northing", 2000000.00000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Netherlands National System', 90112, 90112, 'Oracle', 'PROJCS["Netherlands National System", GEOGCS [ "Netherlands Bessel", DATUM ["Netherlands Bessel", SPHEROID ["Bessel 1841", 6377397.155, 299.1528128]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Stereographic"], PARAMETER ["Scale_Factor", 0.999908], PARAMETER ["Central_Meridian", 5.387639], PARAMETER ["Latitude_Of_Origin", 52.156161], PARAMETER ["False_Easting", 155000.000000], PARAMETER ["False_Northing", 463000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UPS North Zone', 90113, 90113, 'Oracle', 'PROJCS["UPS North Zone", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Stereographic"], PARAMETER ["Scale_Factor", 0.994000], PARAMETER ["Latitude_Of_Origin", 90.000000], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'UPS South Zone', 90114, 90114, 'Oracle', 'PROJCS["UPS South Zone", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Stereographic"], PARAMETER ["Scale_Factor", 0.994000], PARAMETER ["Latitude_Of_Origin", -90.000000], PARAMETER ["False_Easting", 2000000.000000], PARAMETER ["False_Northing", 2000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Lambert Azimuthal Equal-Area (North Pole)', 98304, 98304, 'Oracle', 'PROJCS["Lambert Azimuthal Equal-Area (North Pole)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Azimuthal Equal Area"], PARAMETER ["Latitude_Of_Origin", 90.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Lambert Azimuthal Equal-Area (South Pole)', 98305, 98305, 'Oracle', 'PROJCS["Lambert Azimuthal Equal-Area (South Pole)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Azimuthal Equal Area"], PARAMETER ["Latitude_Of_Origin", -90.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Azimuthal Equidistant (North Pole)', 106496, 106496, 'Oracle', 'PROJCS["Azimuthal Equidistant (North Pole)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Azimuthal Equidistant"], PARAMETER ["Latitude_Of_Origin", 90.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Azimuthal Equidistant (South Pole)', 106497, 106497, 'Oracle', 'PROJCS["Azimuthal Equidistant (South Pole)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Azimuthal Equidistant"], PARAMETER ["Latitude_Of_Origin", -90.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Sinusoidal (Equal-Area)', 139264, 139264, 'Oracle', 'PROJCS["Sinusoidal (Equal-Area)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Sinusoidal"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Miller Cylindrical', 155648, 155648, 'Oracle', 'PROJCS["Miller Cylindrical", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Miller Cylindrical"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5001, Zone 1 (1927)', 172032, 172032, 'Oracle', 'PROJCS["Alaska 5001, Zone 1 (1927)", GEOGCS [ "NAD 27 (Alaska)", DATUM ["NAD 27 (Alaska)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Hotine Oblique Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Azimuth", -36.869898], PARAMETER ["Central_Meridian", -133.666667], PARAMETER ["Latitude_Of_Origin", 57.000000], PARAMETER ["False_Easting", 5000000.000000], PARAMETER ["False_Northing", -5000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5001, Zone 1 (1983, US Survey feet)', 172033, 172033, 'Oracle', 'PROJCS["Alaska 5001, Zone 1 (1983, US Survey feet)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Hotine Oblique Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Azimuth", -36.869898], PARAMETER ["Central_Meridian", -133.666667], PARAMETER ["Latitude_Of_Origin", 57.000000], PARAMETER ["False_Easting", 5000000.000000], PARAMETER ["False_Northing", -5000000.000000], UNIT ["U.S. Foot", 0.3048006096012]]' );                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Alaska 5001, Zone 1 (1983, meters)', 172034, 172034, 'Oracle', 'PROJCS["Alaska 5001, Zone 1 (1983, meters)", GEOGCS ["NAD 83 (Continental US)", DATUM ["NAD 83 (Continental US)", SPHEROID ["GRS 80", 6378137, 298.257222101]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Hotine Oblique Mercator"], PARAMETER ["Scale_Factor", 0.999900], PARAMETER ["Azimuth", -36.869898], PARAMETER ["Central_Meridian", -133.666667], PARAMETER ["Latitude_Of_Origin", 57.000000], PARAMETER ["False_Easting", 5000000.000000], PARAMETER ["False_Northing", -5000000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Projection 2', 180224, 180224, 'Oracle', 'PROJCS["Projection 2", GEOGCS [ "WGS 84", DATUM ["WGS 84", SPHEROID ["WGS 84", 6378137, 298.257223563]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Robinson"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Robinson', 180225, 180225, 'Oracle', 'PROJCS["Robinson", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Robinson"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Mollweide (Equal-Area)', 212992, 212992, 'Oracle', 'PROJCS["Mollweide (Equal-Area)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Mollweide"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (centimeters)', 262144, 262144, 'Oracle', 'LOCAL_CS [ "Non-Earth (Centimeter)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Centimeter", 0.01], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (feet)', 262145, 262145, 'Oracle', 'LOCAL_CS [ "Non-Earth (U.S. Foot)", LOCAL_DATUM ["Local Datum", 0], UNIT ["U.S. Foot", 3.048006096012e-01], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (inches)', 262146, 262146, 'Oracle', 'LOCAL_CS [ "Non-Earth (Inch)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Inch", 2.540000e-02], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (kilometers)', 262147, 262147, 'Oracle', 'LOCAL_CS [ "Non-Earth (Kilometer)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Kilometer", 1000.0], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (meters)', 262148, 262148, 'Oracle', 'LOCAL_CS [ "Non-Earth (Meter)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Meter", 1.0], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (miles)', 262149, 262149, 'Oracle', 'LOCAL_CS [ "Non-Earth (Mile)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Mile", 1.609344e+03], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (millimeters)', 262150, 262150, 'Oracle', 'LOCAL_CS [ "Non-Earth (Millimeter)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Millimeter", 0.001], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (yards)', 262151, 262151, 'Oracle', 'LOCAL_CS [ "Non-Earth (Yard)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Yard", 9.144000e-01], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Meter)', 262152, 262152, 'Oracle', 'LOCAL_CS [ "Non-Earth (Meter)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Meter", 1.0], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Kilometer)', 262153, 262153, 'Oracle', 'LOCAL_CS [ "Non-Earth (Kilometer)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Kilometer", 1000.0], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Centimeter)', 262154, 262154, 'Oracle', 'LOCAL_CS [ "Non-Earth (Centimeter)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Centimeter", 0.01], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Millimeter)', 262155, 262155, 'Oracle', 'LOCAL_CS [ "Non-Earth (Millimeter)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Millimeter", 0.001], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Mile)', 262156, 262156, 'Oracle', 'LOCAL_CS [ "Non-Earth (Mile)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Mile", 1.609344e+03], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Nautical Mile)', 262157, 262157, 'Oracle', 'LOCAL_CS [ "Non-Earth (Nautical Mile)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Nautical Mile", 1852.0], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (U.S. Foot)', 262158, 262158, 'Oracle', 'LOCAL_CS [ "Non-Earth (U.S. Foot)", LOCAL_DATUM ["Local Datum", 0], UNIT ["U.S. Foot", 3.048006096012e-01], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Foot (International))', 262159, 262159, 'Oracle', 'LOCAL_CS [ "Non-Earth (Foot (International))", LOCAL_DATUM ["Local Datum", 0], UNIT ["Foot (International)", 3.048000e-01], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Inch)', 262160, 262160, 'Oracle', 'LOCAL_CS [ "Non-Earth (Inch)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Inch", 2.540000e-02], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Yard)', 262161, 262161, 'Oracle', 'LOCAL_CS [ "Non-Earth (Yard)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Yard", 9.144000e-01], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Chain)', 262162, 262162, 'Oracle', 'LOCAL_CS [ "Non-Earth (Chain)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Chain", 2.011680e+01], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Rod)', 262163, 262163, 'Oracle', 'LOCAL_CS [ "Non-Earth (Rod)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Rod", 5.029200e+00], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Link)', 262164, 262164, 'Oracle', 'LOCAL_CS [ "Non-Earth (Link)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Link", 2.0116619e-1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Modified American Foot)', 262165, 262165, 'Oracle', 'LOCAL_CS [ "Non-Earth (Modified American Foot)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Modified American Foot", 3.0481226e-1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Clarke''s Foot)', 262166, 262166, 'Oracle', 'LOCAL_CS [ "Non-Earth (Clarkes Foot)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Clarke''s Foot", 3.0479727e-1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Indian Foot)', 262167, 262167, 'Oracle', 'LOCAL_CS [ "Non-Earth (Indian Foot)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Indian Foot", 3.0479952e-1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Link (Benoit))', 262168, 262168, 'Oracle', 'LOCAL_CS [ "Non-Earth (Link (Benoit))", LOCAL_DATUM ["Local Datum", 0], UNIT ["Link (Benoit)", 2.0116782e-1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Link (Sears))', 262169, 262169, 'Oracle', 'LOCAL_CS [ "Non-Earth (Link (Sears))", LOCAL_DATUM ["Local Datum", 0], UNIT ["Link (Sears)", 2.0116765e-1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Chain (Benoit))', 262170, 262170, 'Oracle', 'LOCAL_CS [ "Non-Earth (Chain (Benoit))", LOCAL_DATUM ["Local Datum", 0], UNIT ["Chain (Benoit)", 2.0116782e+1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Chain (Sears))', 262171, 262171, 'Oracle', 'LOCAL_CS [ "Non-Earth (Chain (Sears))", LOCAL_DATUM ["Local Datum", 0], UNIT ["Chain (Sears)", 2.0116765e+1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Yard (Indian))', 262172, 262172, 'Oracle', 'LOCAL_CS [ "Non-Earth (Yard (Indian))", LOCAL_DATUM ["Local Datum", 0], UNIT ["Yard (Indian)", 9.1439855e-1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Yard (Sears))', 262173, 262173, 'Oracle', 'LOCAL_CS [ "Non-Earth (Yard (Sears))", LOCAL_DATUM ["Local Datum", 0], UNIT ["Yard (Sears)", 9.1439841e-1], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Fathom)', 262174, 262174, 'Oracle', 'LOCAL_CS [ "Non-Earth (Fathom)", LOCAL_DATUM ["Local Datum", 0], UNIT ["Fathom", 1.8288], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                       
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Non-Earth (Nautical Mile (UK))', 262175, 262175, 'Oracle', 'LOCAL_CS [ "Non-Earth (Nautical Mile (UK))", LOCAL_DATUM ["Local Datum", 0], UNIT ["Nautical Mile (UK)", 1853.184], AXIS ["X", EAST], AXIS["Y", NORTH]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Danish System 45 Bornholm', 270336, 270336, 'Oracle', 'PROJCS["Danish System 45 Bornholm", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator Danish System 45 Bornholm"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 15.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Danish System 34 Jylland-Fyn', 278528, 278528, 'Oracle', 'PROJCS["Danish System 34 Jylland-Fyn", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator Danish System 34 Jylland-Fyn"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 9.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                        
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Danish System 34 Sjaelland', 286720, 286720, 'Oracle', 'PROJCS["Danish System 34 Sjaelland", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator Sjaelland"], PARAMETER ["Scale_Factor", 0.999600], PARAMETER ["Central_Meridian", 9.000000], PARAMETER ["False_Easting", 500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Finnish KKJ Zone 1', 294912, 294912, 'Oracle', 'PROJCS["Finnish KKJ Zone 1", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator Finnish KKJ"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 21.000000], PARAMETER ["False_Easting", 1500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Finnish KKJ Zone 2', 294913, 294913, 'Oracle', 'PROJCS["Finnish KKJ Zone 2", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator Finnish KKJ"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 24.000000], PARAMETER ["False_Easting", 2500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Finnish KKJ Zone 3', 294914, 294914, 'Oracle', 'PROJCS["Finnish KKJ Zone 3", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator Finnish KKJ"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 27.000000], PARAMETER ["False_Easting", 3500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Finnish KKJ Zone 4', 294915, 294915, 'Oracle', 'PROJCS["Finnish KKJ Zone 4", GEOGCS [ "European 1950", DATUM ["European 1950", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Transverse Mercator Finnish KKJ"], PARAMETER ["Scale_Factor", 1.000000], PARAMETER ["Central_Meridian", 30.000000], PARAMETER ["False_Easting", 4500000.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Eckert IV (Equal-Area)', 303104, 303104, 'Oracle', 'PROJCS["Eckert IV (Equal-Area)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Eckert IV"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (South America)', 303105, 303105, 'Oracle', 'PROJCS["Equal-Area Projection (South America)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Eckert IV"], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Eckert VI (Equal-Area)', 311296, 311296, 'Oracle', 'PROJCS["Eckert VI (Equal-Area)", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Eckert VI"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Gall', 319488, 319488, 'Oracle', 'PROJCS["Gall", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Gall"], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Belgian National System (1972)', 327680, 327680, 'Oracle', 'PROJCS["Belgian National System (1972)", GEOGCS [ "Belgium Hayford", DATUM ["Belgium Hayford", SPHEROID ["International 1924", 6378388, 297],-99.059, 53.322, -112.486, -0.419, 0.83, -1.885, 0.999999], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Lambert Conformal Conic (Belgium 1972)"], PARAMETER ["Standard_Parallel_1", 49.833333], PARAMETER ["Standard_Parallel_2", 51.166667], PARAMETER ["Central_Meridian", 4.356940], PARAMETER ["Latitude_Of_Origin", 90.000000], PARAMETER ["False_Easting", 150000.012560], PARAMETER ["False_Northing", 5400088.437800], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                         
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'New Zealand Map Grid', 335872, 335872, 'Oracle', 'PROJCS["New Zealand Map Grid", GEOGCS [ "Geodetic Datum 1949", DATUM ["Geodetic Datum 1949", SPHEROID ["International 1924", 6378388, 297]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["New Zealand Map Grid"], PARAMETER ["Central_Meridian", 173.000000], PARAMETER ["Latitude_Of_Origin", -41.000000], PARAMETER ["False_Easting", 2510000.000000], PARAMETER ["False_Northing", 6023150.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Behrmann Cylindrical Equal-Area', 344064, 344064, 'Oracle', 'PROJCS["Behrmann Cylindrical Equal-Area", GEOGCS [ "NAD 27 (Continental US)", DATUM ["NAD 27 (Continental US)", SPHEROID ["Clarke 1866", 6378206.4, 294.9786982]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Cylindrical Equal Area"], PARAMETER ["Standard_Parallel_1", 30.000000], UNIT ["Meter", 1.000000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (Africa)', 344065, 344065, 'Oracle', 'PROJCS["Equal-Area Projection (Africa)", GEOGCS [ "", DATUM ["", SPHEROID ["None", 0.000000, 0.000000]], PRIMEM [ "Greenwich", 0.000000 ], UNIT ["Decimal Degree", 0.01745329251994330]], PROJECTION ["Cylindrical Equal Area"], PARAMETER ["Central_Meridian", 20.000000], UNIT ["Mile", 1609.344000000000]]' );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
insert into cs_srs (cs_name, srid, auth_srid, auth_name, wktext ) values ( 'Equal-Area Projection (Central America)', 344066, 344066, 'Oracle', 'PROJCS["Equal-Area Projection (Central America)", GEOGCS [ 