# $Header: shutdown.tcl 11-aug-2003.20:32:21 vnukal Exp $
#
# Copyright (c) 1995, 2003, Oracle Corporation.  All rights reserved.  
#
# NAME:
#
#  shutdown.tcl : Script to shutdown listener
#
# ARGUMENTS:
#           argv(0) == listener name, If '*' is specified,
#                      then stop the default listener LISTENER.
#           argv(1) == password, If '*' is specified,
#                      then do not set the password.
#       
#  None 
#
# $Log:  $
# Revision 1.5  1996/08/22  22:02:50  yliu
# use tempfile
#
# Revision 1.4  1996/01/19  01:10:58  yliu
# added listener name
#
# Revision 1.3  1996/01/11 00:42:18  yliu
# use message file
#
# Revision 1.2  1995/10/30 22:55:40  yliu
# took out oraobject
#
# Revision 1.1  1995/09/25  23:10:54  yliu
# Initial revision
#

oradefine job /oracle/sqlnet/general/shutdown description=VOC-02011
oraarguments listener_name password
oravardesc listener_name string default=*
oravardesc password string default=*
oradefine end

set listener_name [lindex $argv 0] 
if {[string compare $listener_name *] == 0} {
    # NT LISTENER CONTROL UTILITY DOES NOT SUPPORT * TO BE THE DEFAULT LISTENER
    orafail [msgtxt [NETWORK] nms 1002] 
}

set lsnrinfo [getlsnrinfo $listener_name]
if { [llength $lsnrinfo] >= 4 } {
    set lsnrorclhome [lindex $lsnrinfo 3]
    set ifile [lindex $lsnrinfo 1]
    set sname [lindex $lsnrinfo 2]
} else {
    error "Could not get all information for listener"
}

set lsnrctlexec [LSNRCTL $listener_name]

set err 0
set outx ""
set buffer ""

# construct the command sequence
set dcmd {|cmd.exe /c "set ORACLE_HOME=}
append dcmd ${lsnrorclhome}
append dcmd {&& }
append dcmd ${lsnrctlexec}
append dcmd { ifile=}
append dcmd ${ifile}
append dcmd {"}

# need to replace the masking character with forward slash otherwise
# the "open" will do it - with some unexpected results
regsub -all {\\} ${dcmd} {/} dcmd

# open bi-directional command pipe
set fd [open ${dcmd} RDWR]

# now issue lsnrctl subcommands
# listener password protected ?
if {[string compare [lindex $argv 1] *] != 0} {
    puts $fd "set password [lindex $argv 1]"
}
puts $fd "stop [lindex $sname 2]"
puts $fd "exit"
flush $fd

# and read the lsnrctl output into message buffer
while { [gets $fd line] >= 0 } {
  append buffer "${line}\n"
}
# close the pipe - error will be reported here
set err [catch {close $fd} outx]

append buffer "$outx"
if {$err > 0 || [regexp {(TNS|NL|SNL)(-)([0-9]+)} $buffer] == 1} {
    puts "$buffer"
    orafail [format [msgtxt [NETWORK] nms 915] ""]
} else {
    puts [msgtxt1 [NETWORK] nms 1101]
}

