# $Header: startup.tcl 11-aug-2003.20:32:20 vnukal Exp $
#
# Copyright (c) 1995, 2003, Oracle Corporation.  All rights reserved.  
#
# NAME:
#
#  startup.tcl : Script to startup listener
#
# ARGUMENTS:
#           argv(0) == listener name, If default '*' is specified,
#                      then start the default listener LISTENER.
#       
#  None 
#
# $Log:  $
# Revision 1.3  1996/08/22  22:07:07  yliu
# use tempfile and rmfile
#
# Revision 1.2  1996/01/19  01:11:25  yliu
# added listener name
#
# Revision 1.1  1996/01/11 00:44:43  yliu
# Initial revision
#

oradefine job /oracle/sqlnet/general/startup description=VOC-02001
oraarguments listener_name
oravardesc listener_name string default=*
oradefine end

set listener_name [lindex $argv 0] 
if {[string compare $listener_name *] == 0} {
	# NT LISTENER CONTROL UTILITY DOES NOT SUPPORT * TO BE THE DEFAULT LISTENER
    orafail [msgtxt [NETWORK] nms 1002]  
}

set lsnrinfo [getlsnrinfo $listener_name]
if { [llength $lsnrinfo] >= 4 } {
    set lsnrorclhome [lindex $lsnrinfo 3]
    set ifile [lindex $lsnrinfo 1]
    set lsname [lindex $lsnrinfo 2]
} else {
    error "Could not get all information for listener"
}
set lsnrctlexec [LSNRCTL $listener_name]

set err [catch {exec cmd.exe /c "set ORACLE_HOME=$lsnrorclhome&& $lsnrctlexec ifile=$ifile start $lsname"} outx]

if { [regexp "TNS-01169" $outx] } {
    puts [msgtxt1 [NETWORK] nms 1101]
    return
}

if { $err > 0 || [regexp {(TNS|NL|SNL)(-)([0-9]+)} $outx] == 1 } {
    puts $outx
    orafail [format [msgtxt [NETWORK] nms 915] ""]
} else {
    puts [msgtxt1 [NETWORK] nms 1101]
}
