<?xml version="1.0" ?>
<!--
NAME
    kualter.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_constraint_t ADTs
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    kamble      02/07/05 - backport bug 3397761: implement sqlterminator
    htseng      01/07/03 - fix bug 2736436 
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      07/17/01 - creation for alter table/view add constraint
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->
<xsl:import href="kucommon.xsl"/>
<xsl:import href="kucolumn.xsl"/>
<xsl:import href="kustorag.xsl"/>
<xsl:import href="kuprtobj.xsl"/>

<!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>

<!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>

<xsl:template match ="CONSTRAINT_T |
                      REF_CONSTRAINT_T">

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType" select ="BASE_OBJ/TYPE_NAME"/>
   <xsl:with-param name="NameNode"   select ="BASE_OBJ/NAME"/>
  </xsl:call-template>

  <xsl:text>ALTER </xsl:text>
  <xsl:value-of select = "BASE_OBJ/TYPE_NAME"/>
  <xsl:text> </xsl:text>
  <xsl:apply-templates select="BASE_OBJ"/>
  <xsl:text>ADD</xsl:text>

  <xsl:for-each select="CON0 | CON1 | CON2">
   <xsl:call-template name="DoConstraint">
    <xsl:with-param name="TAB_CONSTRAINT" select = "1"/>
   </xsl:call-template>
  </xsl:for-each>

  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>               <!-- Terminate the SQL statement -->
  </xsl:if>

</xsl:template>

</xsl:stylesheet>
