<?xml version="1.0" ?>
<!--
NAME
    kubody.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of type/package body ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     03/30/05 - backport bug 2844111: DoSourceLines 
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     07/24/00 - use uriref in import
    lbarton	07/17/00 - bugfix: use DoTerminator
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kusource.xsl"/>

<xsl:template match="TYPE_BODY_T | PACKAGE_BODY_T">

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">
    <xsl:choose>
     <xsl:when test="local-name(.)='PACKAGE_BODY_T'">PACKAGE BODY</xsl:when>
     <xsl:when test="local-name(.)='TYPE_BODY_T'">TYPE BODY</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>

  <xsl:text>CREATE OR REPLACE </xsl:text>
  <xsl:call-template name="BodyObjType">
   <xsl:with-param name="NodeName" select="local-name(.)"/>
  </xsl:call-template>
  <xsl:text> BODY </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:choose>
   <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0">
    <xsl:apply-templates select="SOURCE_LINES">
     <xsl:with-param name="OBJTYPE">2</xsl:with-param>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoSourceLines">
     <xsl:with-param name="SourceLines" select="SOURCE_LINES"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"
 select="SOURCE_LINES/SOURCE_LINES_ITEM[position()=last()]/SOURCE"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="BodyObjType">
  <xsl:param name="NodeName" select="''"/>
   <xsl:choose>
    <xsl:when test="$NodeName='PACKAGE_BODY_T'">PACKAGE</xsl:when>
    <xsl:when test="$NodeName='TYPE_BODY_T'">TYPE</xsl:when>
    <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
   </xsl:choose>
</xsl:template>

</xsl:stylesheet>