<?xml version="1.0" ?>
<!--
NAME
    kucolumn.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_column_list_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     03/29/05 - Backport bug 4154125: trim the last col with default
    htseng      07/02/04 - backport bug 3330599 
    htseng      10/12/01 - add trim_string.
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     10/24/00 - sort in views, not xsl
    lbarton     10/13/00 - bugfix: NOT NULL constraints on adt and ref cols
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     10/10/00 - bugfix: distinguish NCLOB from CLOB
    lbarton     09/25/00 - codepoint semantics
    lbarton     09/21/00 - bugfix: use SPARE3 for NCHAR length
    lbarton	08/18/00 - logical standby support
    lbarton	07/24/00 - use uriref in import
    lbarton	06/23/00 - TIMESTAMP, INTERVAL
    lbarton	05/15/00 - Params for new API
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kuconstr.xsl"/>

<xsl:template match="COL_LIST">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="DoLF">1</xsl:param>
 <xsl:param name="DoHidden">0</xsl:param>
 <xsl:param name="Prefix">0</xsl:param>
  <xsl:choose>
   <xsl:when test="$DoHidden=0">
    <xsl:for-each select="COL_LIST_ITEM[(PROPERTY mod 64)&lt;32]">
     <!--xsl:sort select="COL_NUM" data-type="number"/-->
      <xsl:call-template name="DoCOL_LIST_ITEM">
       <xsl:with-param name="ADT_type" select="$ADT_type"/>
       <xsl:with-param name="DoLF" select="$DoLF"/>
       <xsl:with-param name="Prefix" select="$Prefix"/>
      </xsl:call-template>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:for-each select="COL_LIST_ITEM">
     <!--xsl:sort select="COL_NUM" data-type="number"/-->
      <xsl:call-template name="DoCOL_LIST_ITEM">
       <xsl:with-param name="ADT_type" select="$ADT_type"/>
       <xsl:with-param name="DoLF" select="$DoLF"/>
       <xsl:with-param name="Prefix" select="$Prefix"/>
      </xsl:call-template>
    </xsl:for-each>
   </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="DoCOL_LIST_ITEM">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="DoLF">1</xsl:param>
 <xsl:param name="Prefix">0</xsl:param>
     <xsl:if test="$PRETTY and $DoLF=1">
       <xsl:text>	</xsl:text>
     </xsl:if>

     <xsl:if test="$Prefix!=0">
      <xsl:value-of select="$Prefix"/>
     </xsl:if>

     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select="current()"/>
     </xsl:call-template>

     <xsl:if test="$ADT_type='TABLE'">
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="TYPE_NUM"/>
      <xsl:apply-templates select="DEFAULT_VAL"/>
      <xsl:if test="$CONSTRAINTS=1">
       <xsl:apply-templates select="CON"/>
      </xsl:if>
     </xsl:if>
     <!-- Put out a comma / LF if not the last col -->
     <xsl:if test="not(position()=last())">
      <xsl:text>, </xsl:text>
      <xsl:if test="$PRETTY=1 and $DoLF=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
     </xsl:if>
</xsl:template>


<!-- column datatype for TABLE -->
<xsl:template match="TYPE_NUM">
    <xsl:choose>
      <xsl:when test=".='1'">
        <xsl:choose>
         <xsl:when test="../CHARSETFORM='2'">
          <xsl:text>NVARCHAR2(</xsl:text>
          <xsl:value-of select="../SPARE3"/>
          <xsl:text>)</xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:text>VARCHAR2</xsl:text>
          <xsl:call-template name="DoCharLength"/>
         </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test=".='2'">
	<xsl:choose>
	 <xsl:when test="(../PRECISION_NUM) and not(../SCALE)">FLOAT</xsl:when>
	  <xsl:otherwise>NUMBER</xsl:otherwise>
	</xsl:choose>
        <xsl:call-template name="DoPrecScale">
         <xsl:with-param name="Node" select=".."/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test=".='8'">LONG</xsl:when>
      <xsl:when test=".='12'">DATE</xsl:when>

      <xsl:when test=".='178'">
       <xsl:text>TIME (</xsl:text>
       <xsl:value-of select="../SCALE"/>
       <xsl:text>)</xsl:text>
      </xsl:when>
      <xsl:when test=".='179'">
       <xsl:text>TIME (</xsl:text>
       <xsl:value-of select="../SCALE"/>
       <xsl:text>) WITH TIME ZONE</xsl:text>
      </xsl:when>
      <xsl:when test=".='180'">
       <xsl:text>TIMESTAMP (</xsl:text>
       <xsl:value-of select="../SCALE"/>
       <xsl:text>)</xsl:text>
      </xsl:when>
      <xsl:when test=".='181'">
       <xsl:text>TIMESTAMP (</xsl:text>
       <xsl:value-of select="../SCALE"/>
       <xsl:text>) WITH TIME ZONE</xsl:text>
      </xsl:when>
      <xsl:when test=".='231'">
       <xsl:text>TIMESTAMP (</xsl:text>
       <xsl:value-of select="../SCALE"/>
       <xsl:text>) WITH LOCAL TIME ZONE</xsl:text>
      </xsl:when>
      <xsl:when test=".='182'">
       <xsl:text>INTERVAL YEAR (</xsl:text>
       <xsl:value-of select="../PRECISION_NUM"/>
       <xsl:text>) TO MONTH</xsl:text>
      </xsl:when>
      <xsl:when test=".='183'">
       <xsl:text>INTERVAL DAY (</xsl:text>
       <xsl:value-of select="../PRECISION_NUM"/>
       <xsl:text>) TO SECOND (</xsl:text>
       <xsl:value-of select="../SCALE"/>
       <xsl:text>)</xsl:text>
      </xsl:when>

      <xsl:when test=".='23'">
        <xsl:text>RAW</xsl:text>
        <xsl:apply-templates select="../LENGTH"/>
      </xsl:when>
      <xsl:when test=".='24'">LONG RAW</xsl:when>
      <xsl:when test=".='69'">ROWID</xsl:when>
      <xsl:when test=".='208'">
       <xsl:text>UROWID (</xsl:text>
       <xsl:value-of select="../LENGTH"/>
       <xsl:text>)</xsl:text>
      </xsl:when>
      <xsl:when test=".='96'">
        <xsl:choose>
         <xsl:when test="../CHARSETFORM='2'">
          <xsl:text>NCHAR(</xsl:text>
          <xsl:value-of select="../SPARE3"/>
          <xsl:text>)</xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:text>CHAR</xsl:text>
          <xsl:call-template name="DoCharLength"/>
         </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test=".='105'">MLSLABEL</xsl:when>
      <xsl:when test=".='111'">
        <xsl:for-each select="../TYPEMD">
         <xsl:text>REF </xsl:text>
         <xsl:apply-templates select="SCHEMA_OBJ"/>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test=".='112'">
       <xsl:choose>
        <xsl:when test="../CHARSETFORM='2'">NCLOB</xsl:when>
        <xsl:otherwise>CLOB</xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <xsl:when test=".='113'">BLOB</xsl:when>
      <xsl:when test=".='114'">BFILE</xsl:when>
      <xsl:when test=".='121' or .='122' or .='123' or .='58'">
        <xsl:for-each select="../TYPEMD">
         <xsl:apply-templates select="SCHEMA_OBJ"/>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>***UNSUPPORTED DATA TYPE (</xsl:text>
       <xsl:value-of select="current()"/>
       <xsl:text>)***</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="DoCharLength">
 <xsl:text>(</xsl:text>
 <xsl:choose>
  <!-- character-length semantics -->
  <xsl:when test="(../PROPERTY mod 16777216)>=8388608">
   <xsl:value-of select="../SPARE3"/>
   <xsl:text> CHAR</xsl:text>
  </xsl:when>
  <!-- byte-length semantics -->
  <xsl:otherwise>
   <xsl:value-of select="../LENGTH"/>
   <xsl:if test="$SIZE_BYTE_KEYWORD=1">
    <xsl:text> BYTE</xsl:text>
   </xsl:if>
  </xsl:otherwise>
 </xsl:choose>
 <xsl:text>)</xsl:text>
</xsl:template>

<xsl:template match="LENGTH">
  <xsl:text>(</xsl:text>
  <xsl:value-of select="."/>
      <xsl:if test = "(../SCALE) and not(../SCALE='0')">
        <xsl:text>,</xsl:text>
        <xsl:value-of select="../SCALE"/>
      </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template used for  NUMBER(x,y) and FLOAT(z)
     There are 4 cases (see below)
-->
<xsl:template name="DoPrecScale">
 <xsl:param name="Node" select="''"/>
  <xsl:choose>
   <xsl:when test="($Node/PRECISION_NUM)">
 <!--
     precision	scale	result
	Y	  Y	NUMBER(prec,scale)
	Y	  N	FLOAT(prec)
 -->
    <xsl:text>(</xsl:text>
    <xsl:value-of select="($Node/PRECISION_NUM)"/>
    <xsl:if test = "($Node/SCALE)">
     <xsl:text>,</xsl:text>
     <xsl:value-of select="$Node/SCALE"/>
    </xsl:if>
    <xsl:text>)</xsl:text>
   </xsl:when>
   <xsl:otherwise>
 <!--
     precision	scale	result
	N	  Y	NUMBER(*,scale)
	N	  N	NUMBER
 -->
    <xsl:if test = "($Node/SCALE)">
     <xsl:text>(*,</xsl:text>
     <xsl:value-of select="$Node/SCALE"/>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template match="DEFAULT_VAL">
  <xsl:text> DEFAULT </xsl:text>
  <xsl:call-template name="Trim_string">
    <xsl:with-param name="String" select="."/>
    <xsl:with-param name="TrimAllWS">1</xsl:with-param>
  </xsl:call-template> 
</xsl:template>

<!-- Trim_string: trim trailing white space, then output string
     Parameters:   String = the string to trim
                   TrimAllWS = 0: only trim trailing space (default)
                               1: trim all trailing whitespace
     TrimAllWS is designed to handle default values that are stored
     in the dictionary with a trailing new-line, e.g.,

       create table foo( a number default 1
                    );

     The default value is stored as "1<NL>".
     Since pretty-printing introduces a new-line before the trailing right
     paren, failure to trim the new-line in the default value can cause
     a blank line in the generated DDL:

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1

         );

     Trimming the new-line fixes the problem in this case, but it doesn't
     if the column default value includes a comment and the column is not the
     last item before the right paren: in that case the comma separator
     appears right after the comment, i.e., it becomes part of the comment.  
     (Since XSL does not allow the string "dash-dash" inside xsl comments,
     in this and subsequent examples the comment string is represented "- -").

       create table foo(a number default 1 - - this is a comment
                    , constraint bar foreign key ...
                    );

     We would generate

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1 - - this is a comment,
         CONSTRAINT "BAR" FOREIGN KEY ...
         );

     The code below causes the least harm but is still not perfect, e.g.,

       create table foo(a number default 1 - - this is a comment
                    );

     still results in a blank line

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1 - - this is a comment

         );

     (All this would be much easier if xsl allowed us to keep state.)
 -->

<xsl:template name="Trim_string">
 <xsl:param name="String"/>
 <xsl:param name="TrimAllWS">0</xsl:param>
  <xsl:choose>
   <xsl:when test="$TrimAllWS=1 and contains($String,'--')=0 and
 string-length(normalize-space(substring($String,string-length($String),1)))=0">
    <xsl:call-template name="Trim_string">
     <xsl:with-param name="String"
                   select="substring($String,1,string-length($String)-1)"/>
     <xsl:with-param name="TrimAllWS">1</xsl:with-param>
    </xsl:call-template> 
   </xsl:when>
   <xsl:when test="substring($String,string-length($String),1)=' '">
    <xsl:value-of select="substring($String,1,string-length($String)-1)"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$String"/>
   </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="CON">
 <xsl:if test="CONTYPE='7' or CONTYPE='11'">
  <xsl:call-template name="DoConstraint">
   <xsl:with-param name="TAB_CONSTRAINT">0</xsl:with-param>
  </xsl:call-template>
 </xsl:if>
</xsl:template>

</xsl:stylesheet>

