<?xml version="1.0" ?>
<!-- 
NAME
    kucommon.xsl
DESCRIPTION
    Templates for common and utility functions
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    lbarton     07/24/02 - add EMIT_SCHEMA
    htseng      09/24/01 - fix missing kujob.xsl.
    htseng      09/04/01 - add STATS_OBJ.
    gclaborn    11/03/00 - change name
    lbarton	09/28/00 - add ColNameOrAttr
    gclaborn	06/27/00 - Remove <dummy/> element
    lbarton	06/23/00 - Multinested collections
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top-level parameters -->
<xsl:param name="EMIT_SCHEMA">1</xsl:param>

<!-- All DDL is text, and this is the only way to correctly render '<' -->
<xsl:output method="text"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
  <xsl:for-each select="RESULTSET/ROW | ROWSET/ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<!-- Formats a schema object name -->
<xsl:template match="SCHEMA_OBJ | BASE_OBJ | IMPL_OBJ | OPER_OBJ | STATS_OBJ">
  <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="OWNER_NAME"/>
    <xsl:with-param name="Object" select="NAME"/>
  </xsl:call-template>
  <xsl:text>&#x20;</xsl:text>
</xsl:template>

<!-- Utility routine to form a qualified schema object name; e.g,  "a"."b" -->
<xsl:template name="QuoteObject">
  <xsl:param name="Schema"/>
  <xsl:param name="Object"/>
  <xsl:if test="$EMIT_SCHEMA=1">
   <xsl:if test='string-length($Schema)!=0'>
    <xsl:text>"</xsl:text>
    <xsl:value-of select="$Schema"/>
    <xsl:text>"</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test='string-length($Object)!=0'>
    <xsl:if test="$EMIT_SCHEMA=1">
     <xsl:if test='string-length($Schema)!=0'>
      <xsl:text>.</xsl:text>
     </xsl:if>
    </xsl:if>
    <xsl:text>"</xsl:text>
    <xsl:value-of select="$Object"/>
    <xsl:text>"</xsl:text>
  </xsl:if>
</xsl:template>

<!-- emit a column name or attrname depending on property bit -->
<xsl:template name="ColNameOrAttr">
 <xsl:param name="ColItem">0</xsl:param>
  <!-- use ATTRNAME if it exists, otherwise NAME
       (The old test was "1>($ColItem/PROPERTY mod 2)" -->
  <xsl:choose>
   <xsl:when test="$ColItem/ATTRNAME">
    <xsl:value-of select="$ColItem/ATTRNAME"/>  <!-- already in quotes -->
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>"</xsl:text>			<!-- must supply quotes -->
    <xsl:value-of select="$ColItem/NAME"/>
    <xsl:text>"</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Processes the logging bit in the FLAGS element -->
<xsl:template name="DoLogging">
 <xsl:param name="FlagsNode" select="''"/>
<!-- No Logging is bit 0x20 in FLAGS=1: MOD 64 to capture bit 0x20 in result,
     then test if high bit of result is on.
-->
  <xsl:choose>
   <xsl:when test="($FlagsNode mod 64)>=32">NOLOGGING</xsl:when>
   <xsl:otherwise>LOGGING</xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Emits terminating / with or without preceding lf -->
<xsl:template name="DoTerminator">
 <xsl:param name="Text"/>

 <xsl:if test="$SQLTERMINATOR=1">
   <!-- test whether Text ends in lf; if not, insert lf before / -->
   <xsl:choose>
    <xsl:when
      test="substring($Text,string-length($Text),1)!=
            substring(normalize-space($Text),
                         string-length(normalize-space($Text)),1)">/</xsl:when>
    <xsl:otherwise>
/</xsl:otherwise>
   </xsl:choose>
 </xsl:if>

</xsl:template>

<!-- Processes the parse items -->
<xsl:template name="DoParse">
 <xsl:param name="Verb"/>
 <xsl:param name="ObjectType"/>
 <xsl:param name="SchemaNode" select="''"/>
 <xsl:param name="NameNode" select="''"/>

  <xsl:if test="$PRS_VERB=1">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>AVERB</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>B</xsl:text>
   <xsl:value-of select="$Verb"/>
  </xsl:if>
  <xsl:if test="$PRS_OBJECT_TYPE=1">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>AOBJECT_TYPE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>B</xsl:text>
   <xsl:value-of select="$ObjectType"/>
  </xsl:if>
  <xsl:if test="$PRS_SCHEMA=1 and $SchemaNode != ''">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>ASCHEMA</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>B</xsl:text>
   <xsl:value-of select="$SchemaNode"/>
  </xsl:if>
  <xsl:if test="$PRS_NAME=1 and $NameNode != ''">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>ANAME</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>B</xsl:text>
   <xsl:value-of select="$NameNode"/>
  </xsl:if>
  <xsl:if test="$PRS_DDL=1">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>C</xsl:text>
  </xsl:if>

</xsl:template>

</xsl:stylesheet>
