<?xml version="1.0" ?>
<!-- 
NAME
    kuidxwrk.xsl
DESCRIPTION
    worker XSLT stylesheet for XML => DDL conversion of md$_index_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     03/22/06 - lbarton_rfi_backport_2944274_9.2.0.8: bitmap join 
                           indexes 
    lbarton     05/14/03 - domain index support
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     10/24/00 - sort in views, not xsl
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	10/05/00 - cluster index
    lbarton	09/27/00 - bugfix: sort columns on pos_num
    lbarton	07/24/00 - use uriref in import
    lbarton	06/23/00 - parsing for PL/SQL code
    lbarton	06/14/00 - add PRS_TABLESPACE
    lbarton	06/01/00 - support parsing
    lbarton	05/15/00 - Params for new API
    lbarton	04/03/00 - Creation
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kustorag.xsl"/>
<xsl:import href="kuprtobj.xsl"/>


<xsl:template match="INDEX_T | IND">

  <!-- emit anonymous PLSQL blocks needed for export -->
  <xsl:if test="$EXPORT=1">
   <!-- insert secondary objects for domain indexes -->
   <xsl:apply-templates select="SECOBJS"/>
   <!-- emit the domain index PLSQL code (from ODCIIndexGetMetadata) -->
   <xsl:apply-templates select="PLSQL_CODE/PLSQL"/>
  </xsl:if>

  <xsl:if test="$PRS_TABLESPACE=1">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>ATABLESPACE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>B</xsl:text>
   <xsl:choose>
    <xsl:when test="(PART_OBJ)">
     <xsl:value-of select="PART_OBJ/PARTOBJ/DEFTS_NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="TS_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>

<!-- do the CREATE INDEX statement -->

  <xsl:choose>

   <!-- cluster index -->

   <xsl:when test="BASE_OBJ/TYPE_NUM=3">
    <xsl:text>CREATE INDEX </xsl:text>
    <xsl:apply-templates select="SCHEMA_OBJ"/>
    <xsl:text>ON CLUSTER </xsl:text>
    <xsl:apply-templates select="BASE_OBJ"/>
   </xsl:when>

   <!-- table index -->

   <xsl:otherwise>
    <xsl:text>CREATE </xsl:text>
    <xsl:choose>
     <xsl:when test="TYPE_NUM='2'">BITMAP </xsl:when>
     <xsl:when test="(PROPERTY mod 2)=1">UNIQUE </xsl:when>
    </xsl:choose>
    <xsl:text>INDEX </xsl:text>
    <xsl:apply-templates select="SCHEMA_OBJ"/>
    <xsl:text>ON </xsl:text>
    <xsl:apply-templates select="BASE_OBJ"/>
    <!-- NOTE: we do our own COL_LIST processing,
      not the one in column_list.xsl -->
    <xsl:call-template name="DoColList">
     <xsl:with-param name="ColListNode" select="COL_LIST"/>
     <xsl:with-param name="IndProperty" select="PROPERTY"/>
    </xsl:call-template>
   </xsl:otherwise>

  </xsl:choose>

  <xsl:if test="(PROPERTY mod 8)>=4"> REVERSE </xsl:if>

  <!-- if this is a bitmap join index, add the from-where clause -->
  <xsl:if test="(PROPERTY mod 2048)>=1024">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:apply-templates select="JIJOIN_TABS"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:apply-templates select="JIJOIN"/>
  </xsl:if>

  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>

  <xsl:choose>
<!-- treat domain indexes (type=9) differently -->
   <xsl:when test="TYPE_NUM=9">
    <xsl:text> INDEXTYPE IS "</xsl:text>
    <xsl:value-of select="INDTYPE_OWNER"/>
    <xsl:text>"."</xsl:text>
    <xsl:value-of select="INDTYPE_NAME"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="SPARE4">
     <xsl:text> PARAMETERS ('</xsl:text>
     <xsl:value-of select="SPARE4"/>
     <xsl:text>')</xsl:text>
    </xsl:if>
   </xsl:when>

   <xsl:otherwise>				<!-- not domain index -->
    <xsl:choose>
     <xsl:when test="(PART_OBJ)">
      <xsl:if test="$SEGMENT_ATTRIBUTES=1">
       <xsl:call-template name="DoPartObjSegAttrs">
        <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="DoPartObjLogging"/>
       <xsl:call-template name="DoPartObjStorage">
        <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="DoPartObjTablespace"/>
      </xsl:if>
      <xsl:call-template name="DoPartitionClause">
       <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>				<!-- non-partitioned -->
      <xsl:if test="$SEGMENT_ATTRIBUTES=1">
       <xsl:apply-templates select="PCT_FREE">
        <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
       </xsl:apply-templates>
<!-- No Logging is bit 0x04 in FLAGS=1 -->
       <xsl:if test="(FLAGS mod 8)>=4">NOLOGGING </xsl:if>
       <xsl:if test="(FLAGS mod 4)>=2">COMPUTE STATISTICS </xsl:if>
       <xsl:if test="(FLAGS mod 64)>=32 and NUMKEYCOLS">
        <xsl:text>COMPRESS </xsl:text>
        <xsl:value-of select="NUMKEYCOLS"/>
        <xsl:text> </xsl:text>
       </xsl:if>
       <xsl:apply-templates select="STORAGE">
         <xsl:with-param name="BlkSize" select="../BLOCKSIZE"/>
       </xsl:apply-templates>
      </xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>

  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:call-template name="DoParallel">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    <xsl:with-param name="FlagsParent" select="current()"/>
   </xsl:call-template>
  </xsl:if>

  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>  <!-- Terminate the SQL statement -->
  </xsl:if>
</xsl:template>

<xsl:template name="DoColList">
 <xsl:param name="ColListNode" select="''"/>
  <xsl:text>(</xsl:text>
  <xsl:for-each select="$ColListNode/COL_LIST_ITEM">
   <!--xsl:sort select="POS_NUM" data-type="number"/-->
   <xsl:choose>
<!-- check PROPERTY flags: functional index virt column is marked
     both virtual and hidden
                /* 0x0020 =      32 = hidden column                          */
            /* 0x00010000 =   65536 = virtual column                         */
     In such case we put out col$.default$ which contains the
     defining functional expression.
-->
    <xsl:when test="((COL/PROPERTY mod 64)>=32 
                 and (COL/PROPERTY mod 131072)>=65536)">
     <xsl:value-of select="COL/DEFAULT_VAL"/>
    </xsl:when>
    <xsl:otherwise>

     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select="COL"/>
     </xsl:call-template>

    </xsl:otherwise>
   </xsl:choose>

 <!-- DESCending order index is bit 0x20000 (131072) in col$.property -->
   <xsl:if test="(COL/PROPERTY mod 262144)>=131072"> DESC</xsl:if>

 <!-- Put out a ',' when not the last column -->
 <!-- Otherwise, terminate the col. list -->
   <xsl:choose>
    <xsl:when test="not(position()=last())">
     <xsl:text>, </xsl:text>
    </xsl:when>
    <xsl:otherwise>) </xsl:otherwise>
   </xsl:choose>
 </xsl:for-each>
</xsl:template>

<!-- template for bitmap join index FROM... WHERE... clause -->

<xsl:template match="JIJOIN_TABS">
 <xsl:for-each select="JIJOIN_TABS_ITEM">
  <xsl:if test="position()=1">
   <xsl:text> FROM </xsl:text>
  </xsl:if>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Schema" select="OWNER_NAME"/>
   <xsl:with-param name="Object" select="NAME"/>
  </xsl:call-template>
  <xsl:text> "T</xsl:text>
  <xsl:value-of select="TABOBJ_NUM"/>
  <xsl:text>"</xsl:text>
  <xsl:if test="not(position()=last())">
   <xsl:text>, </xsl:text>
  </xsl:if>
 </xsl:for-each>
</xsl:template>

<xsl:template match="JIJOIN">
 <xsl:for-each select="JIJOIN_ITEM">
  <xsl:choose>
   <xsl:when test="position()=1">
    <xsl:text> WHERE </xsl:text>
   </xsl:when>
   <xsl:otherwise>AND </xsl:otherwise>
  </xsl:choose>
  <xsl:text>"T</xsl:text>
  <xsl:value-of select="TAB1OBJ_NUM"/>
  <xsl:text>"."</xsl:text>
  <xsl:value-of select="TAB1COL/NAME"/>
  <xsl:text>"="T</xsl:text>
  <xsl:value-of select="TAB2OBJ_NUM"/>
  <xsl:text>"."</xsl:text>
  <xsl:value-of select="TAB2COL/NAME"/>
  <xsl:text>" </xsl:text>
 </xsl:for-each>
</xsl:template>

<xsl:template match="PLSQL_CODE/PLSQL">
  <xsl:for-each select="PLSQL_ITEM">
   <xsl:if test="position()=1">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
   <xsl:value-of select="."/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:if test="position()=last() and $SQLTERMINATOR=1">
   <xsl:if test="$PRETTY=0">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
    <xsl:text>/
</xsl:text>  <!-- Terminate the SQL statement -->
   </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="SECOBJS">
  <xsl:for-each select="SECOBJS_ITEM">
   <xsl:if test="position()=1">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_EXPORT_EXTENSION.BEGIN_IMPORT_DOMAIN_INDEX</xsl:with-param>
     <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    </xsl:call-template>
    <xsl:text>BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>SYS.DBMS_EXPORT_EXTENSION.BEGIN_IMPORT_DOMAIN_INDEX('"</xsl:text>
    <xsl:value-of select="../../SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:text>"','"</xsl:text>
    <xsl:value-of select="../../SCHEMA_OBJ/NAME"/>
    <xsl:text>"'); </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>END;</xsl:text>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/
</xsl:text>  <!-- Terminate the SQL statement -->
    </xsl:if>
   </xsl:if>
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_EXPORT_EXTENSION.INSERT_SECOBJ</xsl:with-param>
     <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    </xsl:call-template>
    <xsl:text>BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>SYS.DBMS_EXPORT_EXTENSION.INSERT_SECOBJ('"</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:text>"','"</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    <xsl:text>"'); </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>END;</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>
/
</xsl:text>  <!-- Terminate the SQL statement -->
    </xsl:if>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
