<?xml version="1.0" ?>
<!-- 
NAME
    kulob.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of lob ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    bmccarth    01/25/05 - branchmerge of bug 2549870 - outputting XMLTYPE 
                           when needed. 
    lbarton	04/03/02 - xdb bugfix
    lbarton	01/07/02 - formatting
    dgagne	09/19/01 - create lob store as clause for template subp
    dgagne	09/06/01 - add support for range/list composite partitions
    dgagne	06/14/01 - Move storage PRETTY statements to kustorag
    lbarton	06/01/01 - remove oradb-style imports
    lbarton	12/01/00 - XMLType support
    lbarton	10/27/00 - bugfix
    gclaborn    10/30/00 - Add external imports
    lbarton	09/29/00 - use ColNameOrAttr
    lbarton	07/24/00 - use uriref in import
    lbarton	05/15/00 - Params for new API
    lbarton	04/05/00 - Creation (make separate script)
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kustorag.xsl"/>


<!-- DoLOBStoreAs
  Parameters:
   MetaType
     Lob         - lob column metadata in non-partitioned table
     PartLob     - table level defaults
     LobFrag     - actual partition- or subpartition-level lob attributes
     LobComppart - partition-level defaults
   Parttype - partition type: 1 = range, 2 = hash
   ColList - column list node
   Intcolnum - intcolnum for lob column
   TabBlocksize - Table blocksize value

  Lob name:
     For non-partitioned table, lobname is obj$.name.
     For partitioned table, for table-level default, lobname is obj$.name.
     For non-composite partitioned table, lobname at partition level
       is obj$.subname.
     For composite partitioned table, lobname at partition level
       is obj$.subname
     For composite partitioned table, lobname at subpartition level
       is obj$.subname
-->

<xsl:template name="DoLOBStoreAs">
 <xsl:param name="MetaType">Lob</xsl:param>
 <xsl:param name="Parttype">0</xsl:param>
 <xsl:param name="Subpartition">0</xsl:param>
 <xsl:param name="ColList" select="''"/>
 <xsl:param name="Intcolnum">0</xsl:param>
 <xsl:param name="TabBlocksize">0</xsl:param>

   <!-- do VARRAY or LOB or XMLTYPE clause depending on column type -->

   <xsl:choose>

    <!-- VARRAY (type#=123) -->
   <xsl:when test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPE_NUM=123">

    <!-- We only emit the VARRAY foo STORE AS LOB clause if
         collection storage is specified (coltype$.flags bit #x40).
    -->
     <xsl:if
test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPEMD/FLAGS mod 128 >=64">

    <!-- We *don't* emit the clause if 
         the varray has a system-generated name (obj$.flags bit #x04)
         and either
	   this is a hash partition (parttype=2) or
	   the user specified SEGMENT_ATTRIBUTES=0
    -->
     <xsl:if test="4>(SCHEMA_OBJ/FLAGS mod 8) or 
		  ($Parttype!=2 and $SEGMENT_ATTRIBUTES=1)">

      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
      <xsl:text> VARRAY </xsl:text>
      <xsl:call-template name="ColNameOrAttr">
       <xsl:with-param name="ColItem"
		 select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
      </xsl:call-template>
      <xsl:text> STORE AS LOB </xsl:text>
      <xsl:call-template name="PutLobname">
       <xsl:with-param name="MetaType" select="$MetaType"/>
      </xsl:call-template>

      <!-- Don't emit lob parameters for hash partitions.
           Don't emit lob parameters if SEGMENT_ATTRIBUTES=0. -->

      <xsl:if test="$Parttype!=2 and $SEGMENT_ATTRIBUTES=1">

       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;  </xsl:text>
       </xsl:if>
       <xsl:text>(</xsl:text>
       <xsl:call-template name="PutLOBParams">
        <xsl:with-param name="MetaType" select="$MetaType"/>
        <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>  
       </xsl:call-template>
       <xsl:text>) </xsl:text>
      </xsl:if>
     </xsl:if>
     </xsl:if>
    </xsl:when>

    <!-- CLOB (type#=112) or BLOB (type#113) -->
   <xsl:when test="($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPE_NUM=112)
              or ($ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPE_NUM=113)">

    <!-- If SEGMENT_ATTRIBUTES=0, only emit LOB STORE AS
	 if the user specified a lob segment name.
     -->
    <xsl:if test="$SEGMENT_ATTRIBUTES=1 or 4>(SCHEMA_OBJ/FLAGS mod 8)">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:text> LOB (</xsl:text>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem"
		 select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
     </xsl:call-template>
     <xsl:text>) STORE AS </xsl:text>
     <xsl:call-template name="PutLobname">
      <xsl:with-param name="MetaType" select="$MetaType"/>
     </xsl:call-template>
      <xsl:text>(</xsl:text>
       <xsl:choose>
        <xsl:when test="$MetaType='Lob' or $MetaType='LobFrag'">
         <xsl:apply-templates select="TS_NAME"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:apply-templates select="DEFTS_NAME"/>
        </xsl:otherwise>
       </xsl:choose>
       <!-- don't emit lob parameters for hash partitions or subpartitions -->
       <xsl:if test="$Parttype!=2 and $Subpartition=0">
        <xsl:call-template name="PutLOBParams">
         <xsl:with-param name="MetaType" select="$MetaType"/>
         <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>  
        </xsl:call-template>
       </xsl:if>
       <xsl:text>) </xsl:text>
     </xsl:if>
    </xsl:when>

    <!-- OPAQUE (type#=58) -->
    <xsl:when test="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]/TYPE_NUM=58">
    <!-- If SEGMENT_ATTRIBUTES=0, only emit LOB STORE AS
	 if the user specified a lob segment name.
     -->
    <xsl:if test="$SEGMENT_ATTRIBUTES=1 or 4>(SCHEMA_OBJ/FLAGS mod 8)">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:text> XMLTYPE COLUMN </xsl:text>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem"
		 select="$ColList/COL_LIST_ITEM[INTCOL_NUM=$Intcolnum]"/>
     </xsl:call-template>
     <xsl:text> STORE AS CLOB </xsl:text>
     <xsl:call-template name="PutLobname">
      <xsl:with-param name="MetaType" select="$MetaType"/>
     </xsl:call-template>
      <xsl:text>(</xsl:text>
       <xsl:choose>
        <xsl:when test="$MetaType='Lob' or $MetaType='LobFrag'">
         <xsl:apply-templates select="TS_NAME"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:apply-templates select="DEFTS_NAME"/>
        </xsl:otherwise>
       </xsl:choose>
       <!-- don't emit lob parameters for hash partitions -->
       <xsl:if test="$Parttype!=2">
        <xsl:call-template name="PutLOBParams">
         <xsl:with-param name="MetaType" select="$MetaType"/>
         <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>  
        </xsl:call-template>
       </xsl:if>
       <xsl:text>) </xsl:text>
     </xsl:if>

    </xsl:when>

   </xsl:choose>
</xsl:template>

<xsl:template match="TLOBS_ITEM">
 <xsl:if test="$PRETTY=1">
  <xsl:text>&#xa;   </xsl:text>
 </xsl:if>
 <xsl:text> LOB (</xsl:text>
 <xsl:value-of select="COLNAME"/>
 <xsl:text>) STORE AS "</xsl:text>
 <xsl:value-of select="LOB_SPART_NAME"/>
 <xsl:text>"</xsl:text>
 <xsl:if test="TS_NAME">
  <xsl:text>(</xsl:text>
  <xsl:apply-templates select = "TS_NAME"/>
  <xsl:text>) </xsl:text>
 </xsl:if>
</xsl:template>

<xsl:template name="PutLobname">
 <xsl:param name="MetaType">Lob</xsl:param>
  <xsl:if test="4>(SCHEMA_OBJ/FLAGS mod 8)">	<!-- not sys-generated name -->
   <xsl:text>"</xsl:text>
   <xsl:choose>
    <xsl:when test="$MetaType='Lob' or $MetaType='PartLob'">
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:text>"</xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template name="PutLOBParams">
 <xsl:param name="MetaType">Lob</xsl:param>  <!-- see DoLOBStoreAs -->
 <xsl:param name="TabBlocksize">0</xsl:param>
 <xsl:choose>
  <xsl:when test="$MetaType='Lob' or $MetaType='LobFrag'">
   <xsl:call-template name="DoStorageInRow">
    <xsl:with-param name="Property" select="PROPERTY"/>
   </xsl:call-template>
   <xsl:apply-templates select="CHUNK">
    <xsl:with-param name="Blocksize" select="../BLOCKSIZE"/>
    <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>  
   </xsl:apply-templates>
   <xsl:apply-templates select="PCTVERSION"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <!-- CACHE options -->
   <xsl:call-template name="DoCache">
    <xsl:with-param name="Flags" select="FLAGS"/>
   </xsl:call-template>
   <!-- storage -->
   <xsl:apply-templates select="STORAGE">
    <xsl:with-param name="Nested">1</xsl:with-param>
    <xsl:with-param name="BlkSize" select="../BLOCKSIZE"/>
   </xsl:apply-templates>
  </xsl:when>

  <!-- table level default in partitioned table -->
  <xsl:otherwise>
   <xsl:call-template name="DoStorageInRow">
    <xsl:with-param name="Property" select="DEFPRO"/>
   </xsl:call-template>
   <xsl:apply-templates select="DEFCHUNK">
    <xsl:with-param name="Blocksize" select="../DEFBLOCKSIZE"/>
    <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>  
   </xsl:apply-templates>
   <xsl:apply-templates select="DEFPCTVERSION"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <!-- CACHE options -->
   <xsl:call-template name="DoCache">
    <xsl:with-param name="Flags" select="DEFFLAGS"/>
   </xsl:call-template>
   <!-- storage -->
   <xsl:call-template name="DoDefStorage">
    <xsl:with-param name="Node" select="."/>
    <xsl:with-param name="BlkSize" select="$TabBlocksize"/>
   </xsl:call-template>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<xsl:template name="DoStorageInRow">
 <xsl:param name="Property" select="''"/>
   <xsl:choose>
    <xsl:when test="($Property mod 4)>=2">
     <xsl:text>ENABLE STORAGE IN ROW</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>DISABLE STORAGE IN ROW</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template match="CHUNK | DEFCHUNK">
 <xsl:param name="Blocksize" select="''"/>
 <xsl:param name="TabBlocksize">0</xsl:param>
  <xsl:text> CHUNK </xsl:text>
  <xsl:choose>
   <xsl:when test="$Blocksize">
    <xsl:value-of select="(.)*$Blocksize"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="(.)*$TabBlocksize"/>
   </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="PCTVERSION | DEFPCTVERSION">
 <xsl:text> PCTVERSION </xsl:text>
 <xsl:value-of select="."/>
</xsl:template>


<!-- The processing in DoCache parallels that in 
     exuglb.c routine 'put_lob_params'.  See also
     KKCBLATTR_ bit definitions in rdbms/src/server/dict/if/kkb.h
-->
<xsl:template name="DoCache">
 <xsl:param name="Flags" select="''"/>
   <xsl:choose>
    <xsl:when test="($Flags mod 32)>=16"> CACHE READS NOLOGGING </xsl:when>
    <xsl:when test="($Flags mod 16)>=8">
     <xsl:text> CACHE READS </xsl:text>
     <xsl:if test="($Flags mod 8)>=4">LOGGING </xsl:if>
    </xsl:when>
    <xsl:when test="($Flags mod 4)>=2"> NOCACHE NOLOGGING </xsl:when>
    <xsl:when test="($Flags mod 2)>=1">
     <xsl:text> NOCACHE </xsl:text>
     <xsl:if test="($Flags mod 8)>=4">LOGGING </xsl:if>
    </xsl:when>
    <xsl:otherwise> CACHE </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<!-- Emit STORE AS CLOB for XMLSchema-based object table -->
<!-- current node must be LOBMD -->
<xsl:template name="DoXMLTypeStorage">
 <xsl:param name="Objtbl">0</xsl:param>

 <!-- Does the caller want XMLTYPE output? -->

 <xsl:if test="$Objtbl!=0"> XMLTYPE</xsl:if>

 <xsl:text> STORE AS CLOB </xsl:text>
 <xsl:call-template name="PutLobname">
  <xsl:with-param name="MetaType">Lob</xsl:with-param>
 </xsl:call-template>
 <xsl:text> (</xsl:text>
 <xsl:apply-templates select="TS_NAME"/>
 <xsl:call-template name="PutLOBParams">
  <xsl:with-param name="MetaType">Lob</xsl:with-param>
  <xsl:with-param name="TabBlocksize" select="BLOCKSIZE"/>  
 </xsl:call-template>
 <xsl:text>) </xsl:text>

</xsl:template>

</xsl:stylesheet>
