<?xml version="1.0" ?>
<!-- 
NAME
    kuobjtbl.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of object table ADTs
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    bmccarth    01/25/05 - pass Objtbl to ...TypeStorage (part of backport
                           of bug 254987)
    bmccarth    08/15/02 - Move OID of table to after XMLTABLE
    bmccarth    08/08/02 - add space after oid value
    lbarton	04/03/02 - xdb bugfix
    lbarton     10/25/01 - xdb support
    dgagne      07/12/01 - fix OidIndex clause, missing index name
    gclaborn    11/03/00 - change name
    gclaborn    08/29/00 - use table, not type OID in OID clause
    lbarton	07/07/00 - bugfix: PkOid
    lbarton	05/17/00 - Params for new API
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="ObjTable">
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD">
    <xsl:text>OF </xsl:text>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <xsl:if test="$OID=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text> OID &apos;</xsl:text>
    <xsl:value-of select="../../../SCHEMA_OBJ/OID"/> <!-- Use table's OID -->
    <xsl:text>&apos; </xsl:text>
   </xsl:if>
   <xsl:if test="../OPQMD/SCHEMA_ELMT">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="../OPQMD/SCHEMA_ELMT"/>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template name="OidIndex">
 <xsl:choose>
 <xsl:when
      test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT"/>
 <xsl:otherwise>
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM/OIDINDEX">
    <xsl:text>OIDINDEX </xsl:text>
     <xsl:if test="(FLAGS mod 16) &lt; 8">
      <xsl:value-of select="NAME"/>
     </xsl:if>
     <xsl:text> ( </xsl:text>
     <xsl:apply-templates select="PCT_FREE">
      <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
     </xsl:apply-templates>
     <xsl:apply-templates select="STORAGE">
       <xsl:with-param name="BlkSize" select="../BLOCKSIZE"/>
     </xsl:apply-templates>
    <xsl:text>) </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<xsl:template name="PkOid">
 <xsl:text>(PRIMARY KEY (</xsl:text>
 <xsl:call-template name="DoConstraintColList">
  <xsl:with-param name="ColListNode"
       select="CON1_LIST/CON1_LIST_ITEM[CONTYPE='2']/COL_LIST"/>
 </xsl:call-template>
 <xsl:text>)) OBJECT ID PRIMARY KEY
 </xsl:text>
</xsl:template>

<xsl:template match="OPQMD/SCHEMA_ELMT">
 <xsl:apply-templates select="../../LOBMD"/>
 <xsl:text> XMLSCHEMA "</xsl:text>
 <xsl:value-of select="XMLSCHEMA"/>
 <xsl:text>" ELEMENT "</xsl:text>
 <xsl:value-of select="ELEMENT_NAME"/>
 <xsl:text>" </xsl:text>
</xsl:template>

<xsl:template match="LOBMD">
  <!-- depending on the type of table, tell xmltypestorage to emit -->
  <!-- XMLTYPE before storage clause -->
  <xsl:choose>
   <!-- We are down in lobmd under table_t/col_list/col_list_item -->
   <xsl:when test="(../../../PROPERTY mod 2)>=1">
     <xsl:call-template name="DoXMLTypeStorage">
       <xsl:with-param name="Objtbl">1</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoXMLTypeStorage">
       <xsl:with-param name="Objtbl">0</xsl:with-param>
     </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
 <xsl:if test="$PRETTY=1">
  <xsl:text>&#xa;</xsl:text>
 </xsl:if>
</xsl:template>

</xsl:stylesheet>
