<?xml version="1.0" ?>
<!-- 
NAME
    kuproc.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_proc_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     03/30/05 - backport bug 2844111: DoSourceLines 
    htseng      09/24/01 - fix missing kujob.xsl.
    htseng      09/04/01 - add for password varify function.
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     07/20/00 - use uriref in import
    lbarton	07/17/00 - bugfix: use DoTerminator
    gclaborn	07/07/00 - Set default param values
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kusource.xsl"/>


<!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>

<!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>

<xsl:template match="PROCEDURE_T | FUNCTION_T | PACKAGE_T | PWDVFC_T">

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">
    <xsl:choose>
     <xsl:when test="local-name(.)='PROCEDURE_T'">PROCEDURE</xsl:when>
     <xsl:when test="local-name(.)='FUNCTION_T'">FUNCTION</xsl:when>
     <xsl:when test="local-name(.)='PWDVFC_T'">FUNCTION</xsl:when>
     <xsl:when test="local-name(.)='PACKAGE_T'">PACKAGE</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>

  <xsl:text>CREATE OR REPLACE </xsl:text>
  <xsl:call-template name="ProcObjType">
   <xsl:with-param name="NodeName" select="local-name(.)"/>
  </xsl:call-template>
  <xsl:text>&#x20;</xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:choose>
   <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0">
    <xsl:choose>
     <xsl:when test="local-name(.)='PACKAGE_T'">
      <xsl:apply-templates select="SOURCE_LINES"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="SOURCE_LINES">
       <xsl:with-param name="OBJTYPE">1</xsl:with-param>
      </xsl:apply-templates>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoSourceLines">
     <xsl:with-param name="SourceLines" select="SOURCE_LINES"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"
 select="SOURCE_LINES/SOURCE_LINES_ITEM[position()=last()]/SOURCE"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="ProcObjType">
  <xsl:param name="NodeName" select="''"/>
   <xsl:choose>
    <xsl:when test="$NodeName='PROCEDURE_T'">PROCEDURE</xsl:when>
    <xsl:when test="$NodeName='FUNCTION_T'">FUNCTION</xsl:when>
    <xsl:when test="$NodeName='PWDVFC_T'">FUNCTION</xsl:when>
    <xsl:when test="$NodeName='PACKAGE_T'">PACKAGE</xsl:when>
    <xsl:otherwise>**NOT FOUND**</xsl:otherwise>
   </xsl:choose>
</xsl:template>

</xsl:stylesheet>
