<?xml version="1.0" ?>
<!-- 
NAME
    kuprtobj.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_part_obj_t
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     02/02/06 - lbarton_rfi_backport_2977027_9.2.0.8
    htseng      01/06/03 - fix bug 2711197
    lbarton     01/07/02 - fix formatting
    dgagne      11/05/01 - remove row movement from partitions and tablespace
    dgagne      10/15/01 - add heap segment compression support
    dgagne      09/17/01 - add support for subpartition template
    dgagne      09/05/01 - add range-list composite partitioning
    dgagne      06/14/01 - Move storage PRETTY statements to kustorag
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     12/01/00 - PIOT bugfixes
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     10/25/00 - LRG 50204: sort part cols on pos_num
    lbarton     10/24/00 - sort in views, not xsl
    lbarton	10/16/00 - bugfix: use ColNameOrAttr for partition col names
    lbarton	07/24/00 - use uriref in import
    lbarton	06/23/00 - List partitioning
    lbarton	05/15/00 - Params for new API
    lbarton	03/28/00 - Part. indexes, hash, composite
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kustorag.xsl"/>
<xsl:import href="kulob.xsl"/>


<xsl:template name="DoPartObjSegAttrs">
 <xsl:param name="ADT_type">TABLE</xsl:param>
   <xsl:apply-templates select="PART_OBJ">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="Phase">1</xsl:with-param>
   </xsl:apply-templates>
</xsl:template>

<xsl:template name="DoPartObjLogging">
   <xsl:apply-templates select="PART_OBJ">
    <xsl:with-param name="Phase">2</xsl:with-param>
   </xsl:apply-templates>
</xsl:template>

<xsl:template name="DoPartObjStorage">
 <xsl:param name="ADT_type">TABLE</xsl:param>
   <xsl:apply-templates select="PART_OBJ">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="Phase">3</xsl:with-param>
   </xsl:apply-templates>
</xsl:template>

<xsl:template name="DoPartObjTablespace">
   <xsl:apply-templates select="PART_OBJ">
    <xsl:with-param name="Phase">4</xsl:with-param>
   </xsl:apply-templates>
</xsl:template>

<xsl:template name="DoPartitionClause">
 <xsl:param name="ADT_type">TABLE</xsl:param>
   <xsl:apply-templates select="PART_OBJ">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="Phase">5</xsl:with-param>
   </xsl:apply-templates>
</xsl:template>

<xsl:template match="PART_OBJ">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="Phase">0</xsl:param>
   <xsl:apply-templates select="PARTOBJ">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="Phase" select="$Phase"/>
   </xsl:apply-templates>
</xsl:template>

<xsl:template match="PARTOBJ">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="Phase">0</xsl:param>
 <xsl:choose>
  <xsl:when test="$Phase=1">  <!-- DoPartObjSegAttrs -->
   <xsl:apply-templates select="DEFPCTFREE">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
   </xsl:apply-templates>
  </xsl:when>
  <xsl:when test="$Phase=2">  <!-- DoPartObjLogging -->
   <xsl:apply-templates select="DEFLOGGING"/>
  </xsl:when>
  <xsl:when test="$Phase=3">  <!-- DoPartObjStorage -->
   <xsl:call-template name="DoDefStorage">
    <xsl:with-param name="Node" select="."/>
    <xsl:with-param name="BlkSize" select="../../BLOCKSIZE"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:when test="$Phase=4">  <!-- DoPartObjTablespace -->
   <xsl:apply-templates select="DEFTS_NAME"/>
  </xsl:when>
  <xsl:when test="$Phase=5">  <!-- DoPartitionClause -->
   <xsl:call-template name="DoParttype">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="PartobjNode" select="."/>
   </xsl:call-template>
   <xsl:apply-templates select="../TSUBPARTS/TSUBPARTS_ITEM">
   </xsl:apply-templates>

   <xsl:call-template name="DoPartLists">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="ParentNode" select=".."/>
    <xsl:with-param name="Parttype" select="../PARTOBJ/PARTTYPE"/>
    <xsl:with-param name="Subparttype" select="(../PARTOBJ/SPARE2 mod 256)"/>
    <xsl:with-param name="Local">
     <xsl:choose>
      <xsl:when test="$ADT_type='INDEX' and ../PARTOBJ/FLAGS!=2">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
   </xsl:call-template>
  </xsl:when>
 </xsl:choose>
</xsl:template>

<!-- PIOTs -->

<xsl:template name="DoPIOTSegAttrs">
 <xsl:param name="Node" select="''"/>
  <xsl:apply-templates select="$Node/DEFPCTFREE">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
  </xsl:apply-templates>
</xsl:template>

<xsl:template name="DoPIOTLogging">
 <xsl:param name="Node" select="''"/>
 <xsl:apply-templates select="$Node/DEFLOGGING"/>
 <xsl:apply-templates select="$Node/DEFTS_NAME"/>
 <xsl:call-template name="DoDefStorage">
  <xsl:with-param name="Node" select="$Node"/>
  <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
 </xsl:call-template>
</xsl:template>

<xsl:template name="DoPIOTPartitionClause">
   <xsl:call-template name="DoParttype">
    <xsl:with-param name="PartobjNode" select="PART_OBJ/TABPARTOBJ"/>
   </xsl:call-template>
   <xsl:call-template name="DoPartLists">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    <xsl:with-param name="PIOT">1</xsl:with-param>
    <xsl:with-param name="Parttype" select="PART_OBJ/TABPARTOBJ/PARTTYPE"/>
    <xsl:with-param name="Subparttype" select="(PART_OBJ/TABPARTOBJ/SPARE2 mod 256)"/>
    <xsl:with-param name="Local">0</xsl:with-param>
    <xsl:with-param name="ParentNode" select="PART_OBJ"/>
   </xsl:call-template>
</xsl:template>

<!-- This template does both partition type/cols and subpartition type/cols -->

<xsl:template name="DoParttype">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="PartobjNode" select="''"/>

 <xsl:choose>
  <xsl:when test="$ADT_type='INDEX'
                  and ($PartobjNode/FLAGS mod 2)=1">
   <xsl:text> LOCAL</xsl:text>
  </xsl:when>
  <xsl:when test="$PartobjNode/PARTTYPE=1">		<!-- range -->
   <xsl:if test="$ADT_type='INDEX'"> GLOBAL</xsl:if>
   <xsl:text> PARTITION BY RANGE </xsl:text>
   <xsl:apply-templates select="$PartobjNode/../PARTCOLS"/>
   <xsl:choose>
    <xsl:when test="($PartobjNode/SPARE2 mod 256)=2">	<!-- hash subpart -->
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> SUBPARTITION BY HASH </xsl:text>
     <xsl:apply-templates select="$PartobjNode/../SUBPARTCOLS"/>
    </xsl:when>
    <xsl:when test="($PartobjNode/SPARE2 mod 256)=4">	<!-- list subpart -->
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> SUBPARTITION BY LIST </xsl:text>
     <xsl:apply-templates select="$PartobjNode/../SUBPARTCOLS"/>
    </xsl:when>
   </xsl:choose>
  </xsl:when>
  <xsl:when test="$PartobjNode/PARTTYPE=2">		<!-- hash -->
   <xsl:text> PARTITION BY HASH </xsl:text>
   <xsl:apply-templates select="$PartobjNode/../PARTCOLS"/>
  </xsl:when>
  <xsl:when test="$PartobjNode/PARTTYPE=4">		<!-- list -->
   <xsl:text> PARTITION BY LIST </xsl:text>
   <xsl:apply-templates select="$PartobjNode/../PARTCOLS"/>
  </xsl:when>
 </xsl:choose>
</xsl:template>

<xsl:template match="PARTCOLS | SUBPARTCOLS">
  <xsl:text>(</xsl:text>
  <xsl:for-each select="PARTCOLS_ITEM | SUBPARTCOLS_ITEM">
    <xsl:call-template name="ColNameOrAttr">
     <xsl:with-param name="ColItem" select="COL"/>
    </xsl:call-template>
    <xsl:choose>
	<!-- Put out a comma if not the last col -->
	<xsl:when test="not(position()=last())">
	<xsl:text>,</xsl:text>
	</xsl:when>
	<xsl:otherwise>) </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

<xsl:template match="TSUBPARTS_ITEM">
 <xsl:if test="(position()=1)">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> SUBPARTITION TEMPLATE ( </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
 </xsl:if>
 <xsl:if test="not(position()=1)">
  <xsl:text>, </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
 </xsl:if>
 <xsl:text> SUBPARTITION "</xsl:text>
 <xsl:value-of select="SPART_NAME"/>
 <xsl:text>" values ( </xsl:text>
 <xsl:value-of select="HIBOUNDVAL"/>
 <xsl:text> )</xsl:text>
 <xsl:apply-templates select = "TS_NAME"/>
 <xsl:apply-templates select = "TLOBS/TLOBS_ITEM"/>
 <xsl:if test="position()=last()">
  <xsl:text> ) </xsl:text>
 </xsl:if>
</xsl:template>

<xsl:template name="DoPartLists">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="PIOT">0</xsl:param>
 <xsl:param name="Parttype">0</xsl:param>
 <xsl:param name="Subparttype">0</xsl:param>
 <xsl:param name="Local">0</xsl:param>
 <xsl:param name="ParentNode" select="''"/>
   <xsl:apply-templates select="$ParentNode/PART_LIST">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="PIOT" select="$PIOT"/>
    <xsl:with-param name="Parttype" select="$Parttype"/>
    <xsl:with-param name="Subparttype" select="$Subparttype"/>
    <xsl:with-param name="Local" select="$Local"/>
   </xsl:apply-templates>
   <xsl:apply-templates select="$ParentNode/COMPART_LIST">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="PIOT" select="$PIOT"/>
    <xsl:with-param name="Parttype" select="$Parttype"/>
    <xsl:with-param name="Subparttype" select="$Subparttype"/>
    <xsl:with-param name="Local" select="$Local"/>
    <xsl:with-param name="UseDef">1</xsl:with-param>
   </xsl:apply-templates>
</xsl:template>

<xsl:template match="PART_LIST | COMPART_LIST | SUBPARTS">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="PIOT">0</xsl:param>
 <xsl:param name="Parttype">0</xsl:param>
 <xsl:param name="Subparttype">0</xsl:param>
 <xsl:param name="Local">0</xsl:param>
 <xsl:param name="UseDef">0</xsl:param>
 <xsl:param name="Subpartition">0</xsl:param>
  <xsl:for-each select="PART_LIST_ITEM | COMPART_LIST_ITEM | SUBPARTS_ITEM">
   <xsl:if test="position()=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text> (</xsl:text>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="$Subpartition=0">PARTITION "</xsl:when>
    <xsl:otherwise> SUBPARTITION "</xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
   <xsl:text>" </xsl:text>
   <xsl:if test="$Parttype=1 and $Local=0">
     <xsl:text> VALUES LESS THAN (</xsl:text>
     <xsl:value-of select="HIBOUNDVAL"/>
     <xsl:text>) </xsl:text>
   </xsl:if>
   <xsl:if test="$Parttype=4 and $ADT_type ='TABLE'">
     <xsl:text> VALUES (</xsl:text>
     <xsl:value-of select="HIBOUNDVAL"/>
     <xsl:text>) </xsl:text>
   </xsl:if>
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <xsl:choose>
     <xsl:when test="$Parttype=2">		<!-- hash part'n -->
      <xsl:text> TABLESPACE "</xsl:text>
      <xsl:value-of select="TS_NAME"/>
      <xsl:text>"</xsl:text>
     </xsl:when>
     <xsl:when test="$Subpartition=1">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;  </xsl:text>
      </xsl:if>
      <xsl:text> TABLESPACE "</xsl:text>
      <xsl:value-of select="TS_NAME"/>
      <xsl:text>"</xsl:text>
      <xsl:call-template name="DoPartStorage">
       <xsl:with-param name="ADT_type" select="$ADT_type"/>
       <xsl:with-param name="PIOT" select="$PIOT"/>
       <xsl:with-param name="Local" select="$Local"/>
       <xsl:with-param name="Parttype" select="$Parttype"/>
       <xsl:with-param name="Subpartition" select="$Subpartition"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="$UseDef=1">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
      <xsl:apply-templates select="DEFPCTFREE">
       <xsl:with-param name="ADT_type" select="$ADT_type"/>
       </xsl:apply-templates>
      <xsl:call-template name="DoDefStorage">
       <xsl:with-param name="Node" select="."/>
       <xsl:with-param name="BlkSize" select="../../../BLOCKSIZE"/>
      </xsl:call-template>
      <xsl:apply-templates select="DEFTS_NAME"/>
      <xsl:apply-templates select="DEFLOGGING"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoPartStorage">
       <xsl:with-param name="ADT_type" select="$ADT_type"/>
       <xsl:with-param name="PIOT" select="$PIOT"/>
       <xsl:with-param name="Local" select="$Local"/>
       <xsl:with-param name="Parttype" select="$Parttype"/>
       <xsl:with-param name="Subpartition" select="$Subpartition"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
   <xsl:if test="$Subpartition = 0">
    <xsl:if test="$Parttype!=2">             <!-- not valid for hash part'n -->
     <xsl:if test="$ADT_type = 'TABLE'">
      <xsl:choose>
       <xsl:when test="SPARE2">      <!-- exists if table is subpartitioned -->
        <xsl:call-template name="DoPartOBJCompress">
         <xsl:with-param name="Compress" select="SPARE2"/>
        </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>                          <!-- For partitioned tables -->
        <xsl:call-template name="DoSegCompress">
         <xsl:with-param name="Compress" select="STORAGE/FLAGS"/>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:if>
    </xsl:if>
   </xsl:if>
   <xsl:apply-templates select="SUBPARTS">
     <xsl:with-param name="ADT_type" select="$ADT_type"/>
     <xsl:with-param name="PIOT" select="$PIOT"/>
     <xsl:with-param name="Parttype" select="$Subparttype"/>
     <xsl:with-param name="Local" select="$Local"/>
     <xsl:with-param name="UseDef">0</xsl:with-param>
     <xsl:with-param name="Subpartition">1</xsl:with-param>
   </xsl:apply-templates>
   <xsl:choose>
	<!-- Put out a comma / LF if not the last col -->
	<xsl:when test="not(position()=last())">
	 <xsl:text>, </xsl:text>
         <xsl:if test="$PRETTY=1">
          <xsl:text>&#xa; </xsl:text>
         </xsl:if>
	</xsl:when>
	<xsl:otherwise>) </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
</xsl:template>

<xsl:template name="DoPartStorage">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="PIOT">0</xsl:param>
 <xsl:param name="Local">0</xsl:param>
 <xsl:param name="Parttype">0</xsl:param>
 <xsl:param name="Subpartition">0</xsl:param>

  <xsl:if test = "$Subpartition = 0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:apply-templates select="PCT_FREE">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
   </xsl:apply-templates>
   <!-- No Logging is bit 0x04 in FLAGS=1 (in tabpart$) -->
   <xsl:if test="(FLAGS mod 8)>=4"> NOLOGGING </xsl:if>
   <xsl:apply-templates select="STORAGE">
    <xsl:with-param name="PARTITION">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="../BLOCKSIZE"/>
   </xsl:apply-templates>
  </xsl:if>

  <xsl:apply-templates select="LOBS">
   <xsl:with-param name="PartListItem" select="local-name(..)"/>
   <xsl:with-param name="Parttype" select="$Parttype"/>
   <xsl:with-param name="Subpartition" select="$Subpartition"/>
  </xsl:apply-templates>

  <xsl:if test = "$Subpartition = 0">
   <xsl:if test="$PIOT=1">
    <xsl:call-template name="DoIOVList">
     <xsl:with-param name="List" select="../../IOV_LIST"/>
     <xsl:with-param name="PNUM" select="PART_NUM"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:if>
</xsl:template>


<xsl:template name="DoIOVList">
 <xsl:param name="List" select="''"/>
 <xsl:param name="PNUM">0</xsl:param>
  <xsl:if test="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> OVERFLOW </xsl:text>
   <xsl:apply-templates select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/PCT_FREE"/>
   <xsl:if
test="($List/IOV_LIST_ITEM[PART_NUM=$PNUM]/FLAGS mod 8)>=4"> NOLOGGING </xsl:if>
   <xsl:apply-templates select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/STORAGE">
    <xsl:with-param name="PARTITION">1</xsl:with-param>
    <xsl:with-param name="BlkSize"
             select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/BLOCKSIZE"/>
   </xsl:apply-templates>
  </xsl:if>
</xsl:template>

<xsl:template match="LOBS">
 <xsl:param name="PartListItem" select="''"/>
 <xsl:param name="Parttype">0</xsl:param>
 <xsl:param name="Subpartition">0</xsl:param>
  <xsl:for-each select="LOBS_ITEM">
   <xsl:choose>
    <xsl:when test="$PartListItem='PART_LIST_ITEM'">
     <xsl:call-template name="DoLOBStoreAs">
      <xsl:with-param name="MetaType">LobFrag</xsl:with-param>
      <xsl:with-param name="Parttype" select="$Parttype"/>
      <xsl:with-param name="Subpartition" select="$Subpartition"/>
      <xsl:with-param name="ColList" select="../../../../../COL_LIST"/>
      <xsl:with-param name="Intcolnum" select="INTCOL_NUM"/>
      <xsl:with-param name="TabBlocksize" select="../../../../../BLOCKSIZE"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$PartListItem='COMPART_LIST_ITEM'">
     <xsl:call-template name="DoLOBStoreAs">
      <xsl:with-param name="MetaType">LobComppart</xsl:with-param>
      <xsl:with-param name="Parttype" select="$Parttype"/>
      <xsl:with-param name="Subpartition" select="$Subpartition"/>
      <xsl:with-param name="ColList" select="../../../../../COL_LIST"/>
      <xsl:with-param name="Intcolnum" select="INTCOL_NUM"/>
      <xsl:with-param name="TabBlocksize" select="../../../../../BLOCKSIZE"/>  
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$PartListItem='SUBPARTS_ITEM'">
     <xsl:call-template name="DoLOBStoreAs">
      <xsl:with-param name="MetaType">LobFrag</xsl:with-param>
      <xsl:with-param name="Parttype" select="$Parttype"/>
      <xsl:with-param name="Subpartition" select="$Subpartition"/>
      <xsl:with-param name="ColList" select="../../../../../../../COL_LIST"/>
      <xsl:with-param name="Intcolnum" select="INTCOL_NUM"/>
      <xsl:with-param name="TabBlocksize"
                      select="../../../../../../../BLOCKSIZE"/>  
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
