<?xml version="1.0" ?>
<!-- 
NAME
    kusource.xsl
DESCRIPTION
    XSLT stylesheet for processing source lines for type, package, etc.
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    lbarton     03/30/05 - backport bug 2844111: DoSourceLines 
    gclaborn    11/03/00 - change name
    lbarton	07/18/00 - bugfix
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- This template takes one variable OBJTYPE
     0 = source lines are for type or package (default)
     1 = source lines are for procedure or function
     2 = source lines are for type or package body
  This variable influence how the script processes the first source line.
  If OBJTYPE=2, the script assumes the first line is like TYPE BODY <name>
  rather than like TYPE <name>.
-->

<xsl:template match="SOURCE_LINES">
 <xsl:param name="OBJTYPE">0</xsl:param>
  <xsl:for-each select="SOURCE_LINES_ITEM">
   <xsl:choose>
      <xsl:when test="position()=1">
<!-- process first line of source -->

        <xsl:choose>
<!-- TYPE, PACKAGE -->
         <xsl:when test="$OBJTYPE=0">
<!-- count tokens (THIS IS ERROR-PRONE) -->
            <xsl:value-of 
   select="substring-after(substring-after(normalize-space(SOURCE),' '),' ')"/>
<!-- If 'normalize-space' removed trailing LF, reinsert it -->
            <xsl:if
      test="substring(SOURCE,string-length(SOURCE),1)!=
            substring(normalize-space(SOURCE),
                         string-length(normalize-space(SOURCE)),1)">
             <xsl:text>&#xa;</xsl:text>
            </xsl:if>
         </xsl:when>

<!-- PROCEDURE, FUNCTION -->
         <xsl:when test="$OBJTYPE=1">
          <xsl:choose>
<!-- for procedures or functions with arg lists use open paren as delim -->
           <xsl:when test="contains(SOURCE,'(')">
            <xsl:text>(</xsl:text>
            <xsl:value-of select="substring-after(SOURCE,'(')"/>
           </xsl:when>
<!-- otherwise count tokens (THIS IS ERROR-PRONE) -->
           <xsl:otherwise>
            <xsl:value-of 
   select="substring-after(substring-after(normalize-space(SOURCE),' '),' ')"/>
<!-- If 'normalize-space' removed trailing LF, reinsert it -->
            <xsl:if
      test="substring(SOURCE,string-length(SOURCE),1)!=
            substring(normalize-space(SOURCE),
                         string-length(normalize-space(SOURCE)),1)">
             <xsl:text>&#xa;</xsl:text>
            </xsl:if>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:when>

<!-- TYPE/PACKAGE BODY -->
         <xsl:otherwise>
          <xsl:value-of 
select="substring-after(
         substring-after(
          substring-after(normalize-space(SOURCE),' '),' '),' ')"/>
<!-- 'normalize' removed trailing LF, so reinsert it -->
          <xsl:text>&#xa;</xsl:text>
         </xsl:otherwise>
        </xsl:choose>
      </xsl:when>

<!-- process lines 2-N of source -->
      <xsl:otherwise>
       <xsl:value-of select="SOURCE"/>
      </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
</xsl:template>

<xsl:template name="DoSourceLines">
 <xsl:param name="SourceLines"/>

  <xsl:for-each select="$SourceLines/SOURCE_LINES_ITEM">
   <xsl:choose>

    <!-- Skip lines prior to the name -->
    <xsl:when test="PRE_NAME=1"/>


    <xsl:when test="PRE_NAME=0 and POST_NAME_OFF=0">
     <xsl:value-of select="SOURCE"/>
    </xsl:when>

    <!-- Emit everything after the name.  2 cases:
         1. A procedure or function with arguments, e.g., f(a int).
         2. Something without a parenthesized list of arguments.
    -->
    <xsl:when test="POST_NAME_OFF>0">
     <xsl:value-of select="substring(SOURCE,POST_NAME_OFF)"/>
    </xsl:when>

   </xsl:choose>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
