<?xml version="1.0" ?>
<!-- 
NAME
    kutable.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_{h/fh/pfh/io}table_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    bmccarth    01/26/05 - xbranchmerge to 'st_rdbms_9.2.0.1' add
                           transportable_classic check
    emagrath    05/17/02 - Stabilize constraint genaration order
    lbarton     04/01/02 - xdb fix
    emagrath    01/31/02 - Complete support for REF constraints
    dgagne      11/05/01 - remove row movement from partitions
    lbarton     10/25/01 - xdb support
    lbarton     10/05/01 - Support Ordered Collections in Tables
    dgagne      10/15/01 - add heap segment compression support
    dgagne      06/27/01 - add external table clause
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     04/17/01 - do it again and do it right
    lbarton     04/16/01 - bugfix
    lbarton     01/12/01 - add comments
    lbarton     01/10/01 - nested table referential constraints
    lbarton     12/20/00 - NOT NULL for adt/ref col
    lbarton     12/01/00 - XMLType support
    lbarton     11/01/00 - align table constraints
    lbarton     10/24/00 - sort in views, not xsl
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	10/05/00 - more bugfixes
    lbarton	09/21/00 - bugfixes
    lbarton	08/18/00 - logical standby support
    lbarton	07/24/00 - use uriref in import
    lbarton	06/23/00 - Multinested collections
    lbarton	06/12/00 - constraints in CREATE TABLE
    lbarton	06/01/00 - support parsing
    lbarton	05/15/00 - Params for new API
    lbarton	03/29/00 - More partitioning support
    lbarton	03/17/00 - Multinested collections
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kucolumn.xsl"/>
<xsl:import href="kustorag.xsl"/>
<xsl:import href="kuprtobj.xsl"/>
<xsl:import href="kuconstr.xsl"/>
<xsl:import href="kuobjtbl.xsl"/>
<xsl:import href="kuiot.xsl"/>
<xsl:import href="kulob.xsl"/>
<xsl:import href="kuidxwrk.xsl"/>

<!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <xsl:param name="CONSTRAINTS_AS_ALTER">0</xsl:param>
 <xsl:param name="OID">0</xsl:param>
 <xsl:param name="SIZE_BYTE_KEYWORD">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- Bug 3575797 backport -->
 <xsl:param name="TRANSPORTABLE_CLASSIC">0</xsl:param>

<!-- params for Logical Standby -->
 <xsl:param name="INSERT">0</xsl:param>
 <xsl:param name="DBLINK">0</xsl:param>

<!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_TABLESPACE">0</xsl:param>

<xsl:template match="TABLE_T">

  <xsl:if test="$PRS_TABLESPACE=1">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>ATABLESPACE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>B</xsl:text>
   <xsl:choose>
    <xsl:when test="(PART_OBJ)">
     <xsl:value-of select="PART_OBJ/PARTOBJ/DEFTS_NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="TS_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>


  <xsl:text>CREATE </xsl:text>
  <xsl:if test="(PROPERTY mod 8388608)>=4194304">
   <xsl:text>GLOBAL TEMPORARY </xsl:text>
  </xsl:if>
  <xsl:text>TABLE </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>

  <xsl:choose>
   <xsl:when test="(PROPERTY mod 2)>=1">	<!-- object table -->
    <xsl:call-template name="ObjTable"/>

    <!-- IOT or pkOID must emit primary key constraint in column list -->
    <xsl:if test="$CONSTRAINTS_AS_ALTER=1 and
                  ((PROPERTY mod 128)>=64 or (PROPERTY mod 8192)>=4096)">
     <xsl:text>(</xsl:text>
     <xsl:apply-templates select="CON1_LIST">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="InColList">1</xsl:with-param>
      <xsl:with-param name="CommaNeeded">0</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
     </xsl:apply-templates>
     <xsl:text>)</xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:if test="(PROPERTY mod 8192)>=4096">	<!-- has primary-key OID -->
      <xsl:text> OBJECT IDENTIFIER IS PRIMARY KEY </xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;   </xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:if>

<!-- If CONSTRAINTS_AS_ALTER=0 (i.e., constraints should be specified
    in the CREATE TABLE statement) determine whether to emit any
    object properties (constraints) for the object table.
    If so, open parentheses and call the template to emit the constraints.
    The cases are:
    - REF constraints (scoped, ROWID, pkref, unscoped allowed)
    - referential (FOREIGN KEY) constraints
    - primary key constraint for IOT
    - primary key constraint for pkOID (OID IS PRIMARY KEY)
    - the normal constraints:
      - NOT NULL constraint on object column
      - check, primary and unique key
-->

    <xsl:if test="$CONSTRAINTS_AS_ALTER=0 and (
      PKREF_LIST/PKREF_LIST_ITEM[(REFTYP mod 16)>0] or
      ($REF_CONSTRAINTS=1 and CON2_LIST/CON2_LIST_ITEM) or
      (PROPERTY mod 128)>=64 or
      (PROPERTY mod 8192)>=4096 or
      ($CONSTRAINTS=1 and 
        (COL_LIST/COL_LIST_ITEM/CON or
	 CON0_LIST/CON0_LIST_ITEM or
         CON1_LIST/CON1_LIST_ITEM/COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0)))">
     <xsl:text>(</xsl:text>
     <xsl:call-template name="GenObjTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="current()"/>
      <xsl:with-param name="InColList">1</xsl:with-param>
      <xsl:with-param name="CommaNeeded">0</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <!-- if temp table emit ON COMMIT... -->
     <xsl:call-template name="GenOnCommitAction"/>
     <xsl:if test="(PROPERTY mod 8192)>=4096">	<!-- has primary-key OID -->
      <xsl:text> OBJECT IDENTIFIER IS PRIMARY KEY </xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;   </xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:if>

    <xsl:if test="$SEGMENT_ATTRIBUTES=1">
     <xsl:call-template name="OidIndex"/>
    </xsl:if>
   </xsl:when>

   <xsl:otherwise>  				<!-- relational table -->
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
    <xsl:text>(</xsl:text>
    <xsl:apply-templates select="COL_LIST">
     <xsl:with-param name="ADT_type">TABLE</xsl:with-param>
    </xsl:apply-templates>

    <!-- table constraints -->

    <!-- IOT must emit primary key constraint in column list -->
    <xsl:if test="(PROPERTY mod 128)>=64 and $CONSTRAINTS_AS_ALTER=1">
     <xsl:apply-templates select="CON1_LIST">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="InColList">1</xsl:with-param>
      <xsl:with-param name="CommaNeeded">1</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
     </xsl:apply-templates>
    </xsl:if>

    <xsl:if test="$CONSTRAINTS_AS_ALTER=0">
     <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="current()"/>
      <xsl:with-param name="InColList">1</xsl:with-param>
      <xsl:with-param name="CommaNeeded">1</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
     </xsl:call-template>
    </xsl:if>

    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
    <xsl:text>) </xsl:text>
    <!-- if temp table emit ON COMMIT... -->
    <xsl:call-template name="GenOnCommitAction"/>
   </xsl:otherwise>
  </xsl:choose>

  <xsl:if test="(PROPERTY mod 262144)>=131072">		<!-- AQ -->
   <xsl:text>USAGE QUEUE </xsl:text>
  </xsl:if>

  <xsl:if test="(PROPERTY mod 128)>=64">		<!-- IOT -->
   <xsl:text>ORGANIZATION INDEX </xsl:text>
   <xsl:choose>
    <xsl:when test="NUMKEYCOLS>0">
     <xsl:text>COMPRESS </xsl:text>
     <xsl:value-of select="NUMKEYCOLS"/>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:otherwise>NOCOMPRESS </xsl:otherwise>
   </xsl:choose>
  </xsl:if>

 <!-- XML schema-based columns in relational tables -->
 <xsl:if test="(PROPERTY mod 2)=0">
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[TYPE_NUM=58 and
			TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS' and
			TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE' and
			OPQMD/SCHEMA_ELMT]">
   <xsl:text>XMLTYPE "</xsl:text>
   <xsl:value-of select="NAME"/>
   <xsl:text>" </xsl:text>
   <xsl:apply-templates select="OPQMD/SCHEMA_ELMT"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:if>

 <xsl:choose>
  <xsl:when test="(PROPERTY mod 4294967296)>=2147483648">   <!-- External -->

   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>

   <xsl:text>ORGANIZATION EXTERNAL </xsl:text>

   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;    </xsl:text>
   </xsl:if>

   <xsl:text>( TYPE </xsl:text>
   <xsl:value-of select = "EXTTAB/TYPE"/>

   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>

   <xsl:text> DEFAULT DIRECTORY "</xsl:text>
   <xsl:value-of select = "EXTTAB/DEFAULT_DIR"/>
   <xsl:text>"</xsl:text>

   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>

   <xsl:if test = "EXTTAB/PARAM_CLOB">
    <xsl:text> ACCESS PARAMETERS</xsl:text>

    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>

    <xsl:text> ( </xsl:text>
    <xsl:value-of select = "EXTTAB/PARAM_CLOB"/>
    <xsl:text>    )</xsl:text>
   </xsl:if>

   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>

   <xsl:text> LOCATION</xsl:text>

   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;      </xsl:text>
   </xsl:if>

   <xsl:text> ( </xsl:text>

   <xsl:for-each select = "EXTTAB/LOCATION/LOCATION_ITEM">

    <xsl:if test = "DIR">
     <xsl:text>"</xsl:text>
     <xsl:value-of select = "DIR"/>
     <xsl:text>":</xsl:text>
    </xsl:if>
    <xsl:text>'</xsl:text>
    <xsl:value-of select = "NAME"/>
    <xsl:text>'</xsl:text>
    <xsl:if test="not(position()=last())">
     <xsl:text>, </xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;         </xsl:text>
     </xsl:if>
    </xsl:if>

   </xsl:for-each>

   <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;      </xsl:text>
   </xsl:if>

   <xsl:text> )</xsl:text>

   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>

   <xsl:text> )</xsl:text>

   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>

   <xsl:if test = "EXTTAB/REJECT_LIMIT > 0">
    <xsl:text> REJECT LIMIT </xsl:text>
    <xsl:choose>
     <xsl:when test = "EXTTAB/REJECT_LIMIT = 2147483647">
      <xsl:text>UNLIMITED</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select = "EXTTAB/REJECT_LIMIT"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>

   <xsl:if test = "DEGREE">
    <xsl:text> PARALLEL </xsl:text>
    <xsl:value-of select = "DEGREE"/>
   </xsl:if>
  </xsl:when>

  <xsl:when test="(PROPERTY mod 2048)>=1024">	<!-- clustered table -->
   <xsl:apply-templates select="TABCLUSTER"/>
  </xsl:when>

  <xsl:when test="4194304>(PROPERTY mod 8388608)"> <!-- non-temporary table -->
   <xsl:call-template name="GenTablePhysicalAttrs"/>
  </xsl:when>

 </xsl:choose>

 <xsl:if test="$SQLTERMINATOR=1">
  <xsl:text>;</xsl:text>		<!-- Terminate the SQL statement -->
 </xsl:if>

 <!-- table constraints generated as ALTER TABLE statements -->
 <xsl:if test="$CONSTRAINTS_AS_ALTER=1">
    <xsl:call-template name="GenTableConstraints">
     <xsl:with-param name="SchemaObjParent" select="current()"/>
     <xsl:with-param name="ListParent" select="current()"/>
     <xsl:with-param name="Property" select="PROPERTY"/>
    </xsl:call-template>
 </xsl:if>

 <!-- Note:  the following is commented out in the event that transportable -->
 <!-- is backported to 9.2.0... -->  
 <!-- The backport will need to be edited to include a check for -->
 <!-- transportable_classic -->
 <!-- Not needed for original exp/imp (which has its own way of doing this) -->
 <!--  <xsl:if test="$TRANSPORTABLE=1 and $TRANSPORTABLE_CLASSIC=0"> -->
 <!-- main_43 will have this change inclusive -->

 <!-- Nested table constraints generated as ALTER TABLE statements -->
 <xsl:if test="(PROPERTY mod 8)>=4">        <!-- has nested-TABLE columns -->
  <xsl:call-template name="GenNestedTableConstraints">
   <xsl:with-param name="ListParent" select="NT/NTS"/>
  </xsl:call-template>
 </xsl:if>


 <!-- Generate INSERT SELECT for logical standby -->
 <xsl:if test="$INSERT=1">

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">INSERT</xsl:with-param>
   <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>

  <xsl:choose>
   <xsl:when test="COL_LIST/COL_LIST_ITEM[TYPE_NUM=8]">
    <xsl:call-template name="DoLongInsert"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoSimpleInsert"/>
   </xsl:otherwise>
  </xsl:choose>

 </xsl:if>

</xsl:template>

<xsl:template name="DoLongInsert">
  <xsl:text>
  DECLARE CURSOR C1 IS SELECT </xsl:text>
  <xsl:apply-templates select="COL_LIST">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="DoLF">0</xsl:with-param>
  </xsl:apply-templates>
  <xsl:text> FROM </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:text>@</xsl:text>
  <xsl:value-of select="$DBLINK"/>
  <xsl:text>;
  BEGIN
    FOR C1_REC IN C LOOP
      INSERT INTO </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:text>VALUES (</xsl:text>
  <xsl:apply-templates select="COL_LIST">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="DoLF">0</xsl:with-param>
   <xsl:with-param name="Prefix">C1_REC.</xsl:with-param>
  </xsl:apply-templates>
  <xsl:text>);
    END LOOP;
  END;</xsl:text>
</xsl:template>

<xsl:template name="DoSimpleInsert">
  <xsl:text>
  INSERT INTO </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:text>(</xsl:text>
  <xsl:apply-templates select="COL_LIST">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="DoLF">0</xsl:with-param>
  </xsl:apply-templates>
  <xsl:text>) SELECT </xsl:text>
  <xsl:apply-templates select="COL_LIST">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="DoLF">0</xsl:with-param>
  </xsl:apply-templates>
  <xsl:text> FROM </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:text>@</xsl:text>
  <xsl:value-of select="$DBLINK"/>

  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>		<!-- Terminate the SQL statement -->
  </xsl:if>
</xsl:template>

<xsl:template match="TABCLUSTER">
 <xsl:text>CLUSTER </xsl:text>
 <xsl:apply-templates select="SCHEMA_OBJ"/>
 <xsl:text>(</xsl:text>
 <xsl:apply-templates select="COL_LIST">
  <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
  <xsl:with-param name="DoLF">0</xsl:with-param>
  <xsl:with-param name="DoHidden">1</xsl:with-param>
 </xsl:apply-templates>
 <xsl:text>)</xsl:text>

</xsl:template>

<!-- temporary table ON COMMIT action -->

<xsl:template name="GenOnCommitAction">
  <xsl:if test="(PROPERTY mod 8388608)>=4194304">   <!-- temporary table -->
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 16777216)>=8388608">
     <xsl:text> ON COMMIT PRESERVE ROWS</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text> ON COMMIT DELETE ROWS</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
</xsl:template>

<!-- table physical attributes -->

<xsl:template name="GenTablePhysicalAttrs">
 <xsl:param name= "MVIEW_LOG">0</xsl:param>

 <xsl:if test="$SEGMENT_ATTRIBUTES=1">
  <!-- table physical attributes (PCTFREE, PCTUSED, INITRANS, MAXTRANS) -->
  <xsl:choose>
   <xsl:when test="(PART_OBJ)">
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">     <!-- IOT -->
      <xsl:call-template name="DoPIOTSegAttrs">
       <xsl:with-param name="Node" select="PART_OBJ/INDPARTOBJ"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoPartObjSegAttrs">
       <xsl:with-param name="ADT_type">TABLE</xsl:with-param>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>				<!-- non-partitioned -->
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">     <!-- IOT -->
      <xsl:apply-templates select="PCT_FREE">
       <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
      </xsl:apply-templates>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="PCT_FREE"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>

<!-- LOGGING, STORAGE and TABLESPACE -->
  <xsl:choose>
   <xsl:when test="(PART_OBJ)">
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">     <!-- IOT -->
      <xsl:call-template name="DoPIOTLogging">	  <!-- also does storage -->
       <xsl:with-param name="Node" select="PART_OBJ/INDPARTOBJ"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:if test="$MVIEW_LOG=0">
       <xsl:call-template name="DoPartOBJCompress">
                                            <!-- ONLY WANT BYTE 4 AND ABOVE -->
         <xsl:with-param name="Compress"
              select="(PART_OBJ/PARTOBJ/SPARE2 div 4294967296)"/>
       </xsl:call-template>
      </xsl:if>
      <xsl:call-template name="DoPartObjLogging"/>
      <xsl:call-template name="DoPartObjStorage"/>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="DoPartObjTablespace"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="(PROPERTY mod 128) &lt; 64">                 <!-- not IOT -->
     <xsl:if test="$MVIEW_LOG=0">
      <xsl:call-template name="DoSegCompress">
       <xsl:with-param name="Compress" select="STORAGE/FLAGS"/>
      </xsl:call-template>
     </xsl:if>
    </xsl:if>
    <xsl:call-template name="DoLogging">
     <xsl:with-param name="FlagsNode" select="FLAGS"/>
    </xsl:call-template>
    <xsl:apply-templates select="STORAGE">
     <xsl:with-param name="BlkSize" select="../BLOCKSIZE"/>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:if>

  <xsl:if test="(PROPERTY mod 128)>=64">     <!-- IOT -->
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text> PCTTHRESHOLD </xsl:text>
    <xsl:value-of select="PCT_THRESH"/>
   </xsl:if>
   <xsl:if test = "(FLAGS mod 536870912) >= 268435456">
    <xsl:text> MAPPING TABLE</xsl:text>
   </xsl:if>
  </xsl:if>

  <xsl:if test="(PROPERTY mod 256)>=128">     <!-- IOV -->
   <xsl:call-template name="DoIOV">
    <xsl:with-param name="Node" select="current()"/>
   </xsl:call-template>
  </xsl:if>

  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
<!-- LOB, VARRAY AS LOB -->
<!--  PROPERTY bits:     16 = has array columns (VARRAY)
                       2048 = has internal LOB columns
                     262144 = has user-defined LOB columns
 -->
   <xsl:if test="((PROPERTY mod 32)>=16 or
		 (PROPERTY mod 4096)>=2048 or
		 (PROPERTY mod 524288)>=262144)">
    <xsl:call-template name="DoLOBCols">
     <xsl:with-param name="MetaType">
      <xsl:choose>
       <xsl:when test="(PROPERTY mod 64)>=32">PartLob</xsl:when>
       <xsl:otherwise>Lob</xsl:otherwise>
      </xsl:choose>
     </xsl:with-param>
     <xsl:with-param name="TabBlocksize" select="BLOCKSIZE"/>  
    </xsl:call-template>
   </xsl:if>
  </xsl:if>

  <xsl:if test="(PROPERTY mod 8)>=4">        <!-- has nested-TABLE columns -->
   <xsl:apply-templates select="NT"/>
  </xsl:if>

<!-- PARTITION BY... -->
  <xsl:if test="(PART_OBJ)">
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 128)>=64">     <!-- IOT -->
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:call-template name="DoPIOTPartitionClause"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:if test="(FLAGS mod 262144)>=131072">
      <xsl:text>ENABLE ROW MOVEMENT</xsl:text>
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:call-template name="DoPartitionClause"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>

  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:call-template name="DoParallel">
    <xsl:with-param name="FlagsParent" select="current()"/>
   </xsl:call-template>
  </xsl:if>

</xsl:template>


<!-- Table Constraints -->

<xsl:template name="GenObjTableConstraints">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="ListParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>
 <xsl:param name="Property">0</xsl:param>

  <xsl:if test="$CONSTRAINTS=1">
   <xsl:for-each select="$SchemaObjParent/COL_LIST/COL_LIST_ITEM/CON">

    <xsl:call-template name="DoCON_LIST_ITEM">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Position" select="position()"/>
    </xsl:call-template>

   </xsl:for-each>
  </xsl:if>

  <xsl:choose>
   <xsl:when test="$CONSTRAINTS=1 and 
	$SchemaObjParent/COL_LIST/COL_LIST_ITEM/CON">
    <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
      <xsl:with-param name="ListParent" select="$ListParent"/>
      <xsl:with-param name="InColList" select="$InColList"/>
      <xsl:with-param name="CommaNeeded">1</xsl:with-param>
      <xsl:with-param name="Property" select="$Property"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
      <xsl:with-param name="ListParent" select="$ListParent"/>
      <xsl:with-param name="InColList" select="$InColList"/>
      <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      <xsl:with-param name="Property" select="$Property"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template name="GenTableConstraints">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="ListParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>
 <xsl:param name="Property">0</xsl:param>

  <xsl:apply-templates select="$ListParent/PKREF_LIST">
   <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
   <xsl:with-param name="ListParent" select="$ListParent"/>
   <xsl:with-param name="InColList" select="$InColList"/>
   <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
  </xsl:apply-templates>

  <xsl:choose>
   <xsl:when test="$CommaNeeded=0 and
                   $ListParent/PKREF_LIST/PKREF_LIST_ITEM[(REFTYP mod 16)>0 and
                           not ((REFTYP mod 2)=1 and $REF_CONSTRAINTS=1 and
                                $InColList=1 and FOREIGNKEY=1)]">
    <xsl:call-template name="DoCON0_LIST">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="1"/>
     <xsl:with-param name="Property" select="$Property"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoCON0_LIST">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
   </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template name="DoCON0_LIST">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="ListParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>
 <xsl:param name="Property">0</xsl:param>
 <xsl:param name="Nested">0</xsl:param>

  <xsl:if test="$CONSTRAINTS=1">
   <xsl:apply-templates select="$ListParent/CON0_LIST">
    <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
    <xsl:with-param name="InColList" select="$InColList"/>
    <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
   </xsl:apply-templates>
  </xsl:if>

  <xsl:choose>
   <xsl:when test="$CONSTRAINTS=1 and $ListParent/CON0_LIST/CON0_LIST_ITEM">
    <xsl:call-template name="DoCON1_LIST">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="1"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoCON1_LIST">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="Nested" select="$Nested"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template name="DoCON1_LIST">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="ListParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>
 <xsl:param name="Property">0</xsl:param>
 <xsl:param name="Nested">0</xsl:param>

  <!-- even if CONSTRAINTS=0, must emit IOT primary key constraint -->
  <xsl:if test="$CONSTRAINTS=1 or ($Property mod 128)>=64">
   <xsl:apply-templates select="$ListParent/CON1_LIST">
    <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
    <xsl:with-param name="InColList" select="$InColList"/>
    <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
    <xsl:with-param name="Property" select="$Property"/>
   </xsl:apply-templates>
  </xsl:if>

  <xsl:if test="$Nested=0">
  <xsl:choose>
   <xsl:when test="$CONSTRAINTS=1 and
$ListParent/CON1_LIST/CON1_LIST_ITEM[COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0]">
    <xsl:call-template name="DoCON2_LIST">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="1"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoCON2_LIST">
     <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
     <xsl:with-param name="ListParent" select="$ListParent"/>
     <xsl:with-param name="InColList" select="$InColList"/>
     <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  </xsl:if>

</xsl:template>

<xsl:template name="DoCON2_LIST">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="ListParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>

  <xsl:if test="$REF_CONSTRAINTS=1">
   <xsl:apply-templates select="$ListParent/CON2_LIST">
    <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
    <xsl:with-param name="InColList" select="$InColList"/>
    <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
   </xsl:apply-templates>
  </xsl:if>
</xsl:template>


<xsl:template match="CON0_LIST | CON2_LIST">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>

  <xsl:for-each select="CON0_LIST_ITEM | CON2_LIST_ITEM">
   <xsl:sort select="CON_NUM" data-type="number"/>

   <xsl:call-template name="DoCON_LIST_ITEM">
    <xsl:with-param name="SchemaObjParent" select="$SchemaObjParent"/>
    <xsl:with-param name="InColList" select="$InColList"/>
    <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
    <xsl:with-param name="Position" select="position()"/>
   </xsl:call-template>

  </xsl:for-each>

</xsl:template>

<xsl:template name="DoCON_LIST_ITEM">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>
 <xsl:param name="Position">0</xsl:param>

   <xsl:choose>
    <xsl:when test="$InColList=0 and CONTYPE!='7' and CONTYPE!='11'">

    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">ALTER</xsl:with-param>
     <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
     <xsl:with-param name="SchemaNode"
	 select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode"
	 select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
    </xsl:call-template>

    <xsl:text>
  ALTER TABLE </xsl:text>
    <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
    <xsl:text>ADD</xsl:text>
     <xsl:call-template name="DoConstraint">
      <xsl:with-param name="TAB_CONSTRAINT">1</xsl:with-param>
      <xsl:with-param name="ConstraintNode" select="current()"/>
      <xsl:with-param name="ColListNode" select="$SchemaObjParent/COL_LIST"/>
     </xsl:call-template>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>  <!-- Terminate the SQL statement -->
    </xsl:if>

    </xsl:when>

    <xsl:otherwise>
     <xsl:if test="$CommaNeeded=1 and $Position=1">
      <xsl:text>, </xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;	</xsl:text>
      </xsl:if>
     </xsl:if>
     <xsl:if test="CONTYPE='7' or CONTYPE='11'">
      <xsl:call-template name="ColNameOrAttr">
       <xsl:with-param name="ColItem" select=".."/>
      </xsl:call-template>
     </xsl:if>
     <xsl:call-template name="DoConstraint">
      <xsl:with-param name="TAB_CONSTRAINT">1</xsl:with-param>
      <xsl:with-param name="ConstraintNode" select="current()"/>
      <xsl:with-param name="ColListNode" select="$SchemaObjParent/COL_LIST"/>
     </xsl:call-template>
     <xsl:if test="not($Position=last())">
      <xsl:text>, </xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;	</xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:otherwise>

   </xsl:choose>
  
</xsl:template>

<xsl:template match="CON1_LIST">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>
 <xsl:param name="Property">0</xsl:param>

   <!-- skip unique index on nested table setid column and OID$ column  -->
  <xsl:for-each
         select="CON1_LIST_ITEM[COL_LIST/COL_LIST_ITEM/OID_OR_SETID=0]">

    <!-- IOT (property bit 0x40) primary key (CONTYPE=2)
         is always emitted in the column list, never as ALTER TABLE -->
    <xsl:choose>
     <xsl:when test="$CONSTRAINTS=1 and $InColList=0 and 
                     (64>($Property mod 128) or CONTYPE!='2')">

      <xsl:if test="4>(IND/SCHEMA_OBJ/FLAGS mod 8)">
       <xsl:text>&#xa; </xsl:text>
       <xsl:apply-templates select="IND"/>
      </xsl:if>

      <xsl:call-template name="DoParse">
       <xsl:with-param name="Verb">ALTER</xsl:with-param>
       <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
       <xsl:with-param name="SchemaNode"
                 select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
       <xsl:with-param name="NameNode"
                 select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
      </xsl:call-template>

      <xsl:text>
  ALTER TABLE </xsl:text>
      <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
      <xsl:text>ADD</xsl:text>
      <xsl:call-template name="DoConstraint">
       <xsl:with-param name="TAB_CONSTRAINT">1</xsl:with-param>
       <xsl:with-param name="Property" select="$Property"/>
       <xsl:with-param name="ConstraintNode" select="current()"/>
       <xsl:with-param name="ColListNode" select="$SchemaObjParent/COL_LIST"/>
      </xsl:call-template>
      <xsl:if test="$SQLTERMINATOR=1">
       <xsl:text>;</xsl:text>  <!-- Terminate the SQL statement -->
      </xsl:if>

     </xsl:when>

     <xsl:when test="$InColList=1 and 
                     ($CONSTRAINTS=1 or ($Property mod 128)>=64)">
      <xsl:if test="$CommaNeeded=1 and position()=1">
       <xsl:text>, </xsl:text>
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;	</xsl:text>
       </xsl:if>
      </xsl:if>
      <xsl:call-template name="DoConstraint">
       <xsl:with-param name="TAB_CONSTRAINT">1</xsl:with-param>
       <xsl:with-param name="Property" select="$Property"/>
       <xsl:with-param name="ConstraintNode" select="current()"/>
       <xsl:with-param name="ColListNode" select="$SchemaObjParent/COL_LIST"/>
      </xsl:call-template>
      <xsl:if test="not(position()=last())">
       <xsl:text>, </xsl:text>
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;	</xsl:text>
       </xsl:if>
      </xsl:if>
     </xsl:when>

    </xsl:choose>

  </xsl:for-each>
</xsl:template>



<xsl:template match="PKREF_LIST">
 <xsl:param name="SchemaObjParent" select="''"/>
 <xsl:param name="ListParent" select="''"/>
 <xsl:param name="InColList">0</xsl:param>
 <xsl:param name="CommaNeeded">0</xsl:param>


  <xsl:for-each select="PKREF_LIST_ITEM[(REFTYP mod 16)>0 and
                           not ((REFTYP mod 2)=1 and $REF_CONSTRAINTS=1 and
                                $InColList=1 and FOREIGNKEY=1)]">
   <xsl:sort select="INTCOL_NUM" data-type="number"/>
     <!-- 
         ... All REFs with non 0 type add REF constraints ...
         reftyp    number not null                          /* REF type flag */
                                                     /* 0x01 = REF is scoped */
                                             /* 0x02 = REF stored with rowid */
                                             /* 0x04 = Primary key based ref */
                              /* 0x08 = Allow unscoped Primary key based ref */
    ... Except that SCOPE is skipped if col. list FOREIGN KEY for that REF ...

      -->
    <xsl:if test="$InColList=1">               <!-- Setup if In column list -->
     <xsl:if test="$CommaNeeded=1 and position()=1">
      <xsl:text>, </xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:if>

    <xsl:choose>
     <xsl:when test="(REFTYP mod 2)=1">         <!-- Scoped, possibly pkREF -->

      <xsl:choose>                       <!-- In column list or stand alone -->
       <xsl:when test="$InColList=0">                      <!-- Stand alone -->
        <xsl:call-template name="DoParse">
         <xsl:with-param name="Verb">ALTER</xsl:with-param>
         <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
         <xsl:with-param name="SchemaNode"
              select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
         <xsl:with-param name="NameNode"
              select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
        </xsl:call-template>

        <xsl:text>
  ALTER TABLE </xsl:text>
        <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
        <xsl:text>ADD SCOPE FOR (</xsl:text>
        <xsl:call-template name="ColNameOrAttr">
         <xsl:with-param name="ColItem" select="current()"/>
        </xsl:call-template>
        <xsl:text>) IS </xsl:text>

        <xsl:choose>                     <!-- Refer to Scope by OID or Name -->
         <xsl:when test="$EXPORT=1">                    <!-- OID for Export -->
          <xsl:text>OID '</xsl:text>
          <xsl:value-of select="SCHEMA_OBJ/OID"/>
          <xsl:text>'</xsl:text>

          <xsl:if test="(REFTYP mod 8)=5">    <!-- pkREF requires pkey cols -->
           <xsl:text> USER_DEFINED (</xsl:text>
            <xsl:for-each select="PK_COL_LIST/PK_COL_LIST_ITEM">
             <xsl:call-template name="ColNameOrAttr">
              <xsl:with-param name="ColItem" select="current()"/>
             </xsl:call-template>
             <xsl:if test="not(position()=last())">
              <xsl:text>, </xsl:text>
             </xsl:if>
            </xsl:for-each>
           <xsl:text>)</xsl:text>
          </xsl:if>
         </xsl:when>

         <xsl:otherwise>                <!-- Scope is table name for others -->
          <xsl:apply-templates select="SCHEMA_OBJ"/>
         </xsl:otherwise>
        </xsl:choose>

        <xsl:if test="$SQLTERMINATOR=1">
         <xsl:text>;</xsl:text>            <!-- Terminate the SQL statement -->
        </xsl:if>
       </xsl:when>                                         <!-- Stand alone -->

       <xsl:otherwise>                          <!-- Scoped, In column list -->
        <xsl:if test="$PRETTY=1">
         <xsl:text>	</xsl:text>
        </xsl:if>

        <xsl:text>SCOPE FOR (</xsl:text>
        <xsl:call-template name="ColNameOrAttr">
         <xsl:with-param name="ColItem" select="current()"/>
        </xsl:call-template>
        <xsl:text>) IS </xsl:text>

        <xsl:choose>                   <!--Scope by OID or Name (see above) -->
         <xsl:when test="$EXPORT=1">
          <xsl:text>OID '</xsl:text>
          <xsl:value-of select="SCHEMA_OBJ/OID"/>
          <xsl:text>'</xsl:text>

          <xsl:if test="(REFTYP mod 8)>=5">
           <xsl:if test="$PRETTY=1">
            <xsl:text>&#xa;	 </xsl:text>
           </xsl:if>
           <xsl:text> USER_DEFINED (</xsl:text>
            <xsl:for-each select="PK_COL_LIST/PK_COL_LIST_ITEM">
             <xsl:call-template name="ColNameOrAttr">
              <xsl:with-param name="ColItem" select="current()"/>
             </xsl:call-template>
             <xsl:if test="not(position()=last())">
              <xsl:text>, </xsl:text>
             </xsl:if>
            </xsl:for-each>
           <xsl:text>)</xsl:text>
          </xsl:if>
         </xsl:when>

         <xsl:otherwise>
          <xsl:apply-templates select="SCHEMA_OBJ"/>
         </xsl:otherwise>
        </xsl:choose>

        <xsl:if test="not(position()=last())">
         <xsl:text>, </xsl:text>
         <xsl:if test="$PRETTY=1">
          <xsl:text>&#xa;</xsl:text>
         </xsl:if>
        </xsl:if>

       </xsl:otherwise>                                 <!-- In column list -->
      </xsl:choose>

     </xsl:when>                                                <!-- Scoped -->

     <xsl:otherwise>                                        <!-- Not scoped -->

       <xsl:if test="(REFTYP mod 4)=2">                     <!-- ROWID hint -->

        <xsl:choose>                     <!-- In column list or stand alone -->
         <xsl:when test="$InColList=0">                    <!-- Stand alone -->
          <xsl:call-template name="DoParse">
           <xsl:with-param name="Verb">ALTER</xsl:with-param>
           <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
          <xsl:with-param name="SchemaNode"
               select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
          <xsl:with-param name="NameNode"
               select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
          </xsl:call-template>

          <xsl:text>
  ALTER TABLE </xsl:text>
          <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
          <xsl:text>ADD REF (</xsl:text>
          <xsl:call-template name="ColNameOrAttr">
           <xsl:with-param name="ColItem" select="current()"/>
          </xsl:call-template>
          <xsl:text>) WITH ROWID</xsl:text>

          <xsl:if test="$SQLTERMINATOR=1">
           <xsl:text>;</xsl:text>          <!-- Terminate the SQL statement -->
          </xsl:if>
         </xsl:when>

         <xsl:otherwise>                         <!-- ROWID, In column list -->
          <xsl:if test="$PRETTY=1">
           <xsl:text>	</xsl:text>
          </xsl:if>

          <xsl:text>REF (</xsl:text>
          <xsl:call-template name="ColNameOrAttr">
           <xsl:with-param name="ColItem" select="current()"/>
          </xsl:call-template>
          <xsl:text>) WITH ROWID</xsl:text>

          <xsl:choose>
           <xsl:when test="(REFTYP mod 16)=10">            <!-- ALLOW also? -->
            <xsl:text>, </xsl:text>         <!-- Yes, always comma seperate -->
            <xsl:if test="$PRETTY=1">
             <xsl:text>&#xa;</xsl:text>
            </xsl:if>
           </xsl:when>
           <xsl:otherwise>          <!-- No - prepare for any next REF item -->
            <xsl:if test="not(position()=last())">
             <xsl:text>, </xsl:text>
             <xsl:if test="$PRETTY=1">
              <xsl:text>&#xa;</xsl:text>
             </xsl:if>
            </xsl:if>
           </xsl:otherwise>
          </xsl:choose>

         </xsl:otherwise>                              <!-- In column list -->
        </xsl:choose>

       </xsl:if>                                          <!-- ROWID syntax -->

       <xsl:if test="(REFTYP mod 16)>=8">            <!-- ALLOW PRIMARY KEY -->

        <xsl:choose>                     <!-- In column list or stand alone -->
         <xsl:when test="$InColList=0">                    <!-- Stand alone -->
          <xsl:call-template name="DoParse">
           <xsl:with-param name="Verb">ALTER</xsl:with-param>
           <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
          <xsl:with-param name="SchemaNode"
               select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
          <xsl:with-param name="NameNode"
               select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
          </xsl:call-template>

          <xsl:text>
  ALTER TABLE </xsl:text>
          <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
          <xsl:text>ADD REF (</xsl:text>
          <xsl:call-template name="ColNameOrAttr">
           <xsl:with-param name="ColItem" select="current()"/>
          </xsl:call-template>
          <xsl:text>) ALLOW PRIMARY KEY</xsl:text>

          <xsl:if test="$SQLTERMINATOR=1">
           <xsl:text>;</xsl:text>
          </xsl:if>
         </xsl:when>

         <xsl:otherwise>                                <!-- In column list -->
          <xsl:if test="$PRETTY=1">
           <xsl:text>	</xsl:text>
          </xsl:if>

          <xsl:text>REF (</xsl:text>
          <xsl:call-template name="ColNameOrAttr">
           <xsl:with-param name="ColItem" select="current()"/>
          </xsl:call-template>
          <xsl:text>) ALLOW PRIMARY KEY</xsl:text>

          <xsl:if test="not(position()=last())">
           <xsl:text>, </xsl:text>
           <xsl:if test="$PRETTY=1">
            <xsl:text>&#xa;</xsl:text>
           </xsl:if>
          </xsl:if>
         </xsl:otherwise>                               <!-- In column list -->

        </xsl:choose>
       </xsl:if>                                          <!-- ALLOW syntax -->

     </xsl:otherwise>                                       <!-- Not scoped -->
    </xsl:choose>

  </xsl:for-each>
</xsl:template>


<xsl:template name="DoLOBCols">
 <xsl:param name="MetaType">Lob</xsl:param>
 <xsl:param name="TabBlocksize">0</xsl:param>
  <!-- exclude system-generated columns -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[256>(PROPERTY mod 512)]/LOBMD">
   <!-- exclude XMLSchema-based columns -->
   <xsl:choose>
    <xsl:when test="(../OPQMD/FLAGS mod 4)>=2"/>
    <xsl:otherwise>
     <xsl:call-template name="DoLOBStoreAs">
      <xsl:with-param name="MetaType" select="$MetaType"/>
      <xsl:with-param name="ColList" select="../.."/>
      <xsl:with-param name="Intcolnum" select="../INTCOL_NUM"/>
      <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>  
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
</xsl:template>

<!-- Nested tables -->

<xsl:template match="NT">
  <xsl:call-template name="DoNTStoreAs">
   <xsl:with-param name="Node" select="NTS"/>
   <xsl:with-param name="ParentObjNum" select="OBJ_NUM"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="DoNTStoreAs">
 <xsl:param name="Node" select="''"/>
 <xsl:param name="ParentObjNum">0</xsl:param>

  <xsl:for-each select="$Node/NTS_ITEM[OBJ_NUM=$ParentObjNum]">
   <xsl:sort select="INTCOL_NUM" data-type="number"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:choose>
    <!-- column is varray stored as table -->
    <xsl:when test="COL/TYPE_NUM='123'">
     <xsl:text> VARRAY </xsl:text>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select="COL"/>
     </xsl:call-template>
     <xsl:text> STORE AS TABLE </xsl:text>
    </xsl:when>
    <!-- column is nested table type;
         putting this code in the otherwise-tag
         allows this to work for 9.0 xml docs.
         Those docs don't have a COL/TYPE_NUM element.
         (Varrays stored as tables were not supported before 9.2
         so there was no need for a COL/TYPE_NUM element.) -->
    <xsl:otherwise>
     <xsl:text> NESTED TABLE </xsl:text>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select="COL"/>
     </xsl:call-template>
     <xsl:text> STORE AS </xsl:text>
    </xsl:otherwise> 
   </xsl:choose>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="''"/>
    <xsl:with-param name="Object" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>

   <xsl:call-template name="EmitStorageTablePropertiesParen">
    <xsl:with-param name="Node" select="$Node"/>
    <xsl:with-param name="OpenParen">1</xsl:with-param>
   </xsl:call-template>

<!-- Emit constraints if
     - constraints requested ($CONSTRAINTS=1)
     - but not as ALTER TABLE ($CONSTRAINTS_AS_ALTER=0)
     - and there is either a CON0 constraint or
     - there is a primary/unique constraint that is NOT the unique index
       on a nested table's setid column
-->
   <xsl:if test="$CONSTRAINTS_AS_ALTER=0 and $CONSTRAINTS=1 and (
	   (HNT | IONT)/CON0_LIST/CON0_LIST_ITEM or
1024>((HNT | IONT)/CON1_LIST/CON1_LIST_ITEM/IND/COL_LIST/COL_LIST_ITEM[1]/COL/PROPERTY mod 2048))">

    <xsl:text>(</xsl:text>
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">
      <xsl:call-template name="DoCON0_LIST">
       <xsl:with-param name="SchemaObjParent" select="current()"/>
       <xsl:with-param name="ListParent" select="IONT"/>
       <xsl:with-param name="InColList">1</xsl:with-param>
       <xsl:with-param name="CommaNeeded">0</xsl:with-param>
       <xsl:with-param name="Property" select="PROPERTY"/>
       <xsl:with-param name="Nested">1</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoCON0_LIST">
       <xsl:with-param name="SchemaObjParent" select="current()"/>
       <xsl:with-param name="ListParent" select="HNT"/>
       <xsl:with-param name="InColList">1</xsl:with-param>
       <xsl:with-param name="CommaNeeded">0</xsl:with-param>
       <xsl:with-param name="Property" select="PROPERTY"/>
       <xsl:with-param name="Nested">1</xsl:with-param>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:text>) </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 128)>=64">     <!-- IOT -->
     <xsl:text> ORGANIZATION INDEX PCTTHRESHOLD </xsl:text>
     <xsl:value-of select="IONT/PCT_THRESH"/>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:text> </xsl:text>
     <xsl:if test="$SEGMENT_ATTRIBUTES=1">
      <xsl:apply-templates select="IONT/PCT_FREE">
       <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
      </xsl:apply-templates>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <xsl:if test="$SEGMENT_ATTRIBUTES=1">
      <xsl:apply-templates select="HNT/PCT_FREE"/>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <xsl:call-template name="DoLogging">
     <xsl:with-param name="FlagsNode" select="(HNT | IONT)/FLAGS"/>
    </xsl:call-template>
    <xsl:apply-templates select="(HNT | IONT)/STORAGE">
     <xsl:with-param name="Nested">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="../BLOCKSIZE"/>
    </xsl:apply-templates>
   </xsl:if>
   <xsl:if test="(PROPERTY mod 256)>=128">     <!-- IOV -->
    <xsl:call-template name="DoIOV">
     <xsl:with-param name="Node" select="IONT"/>
     <xsl:with-param name="Nested">1</xsl:with-param>
    </xsl:call-template>
   </xsl:if>

<!-- LOB, VARRAY AS LOB -->
<!--  PROPERTY bits:     16 = has array columns (VARRAY)
                       2048 = has internal LOB columns
                     262144 = has user-defined LOB columns
 -->
    <xsl:if test="((PROPERTY mod 32)>=16 or
		 (PROPERTY mod 4096)>=2048 or
		 (PROPERTY mod 524288)>=262144)">
     <xsl:call-template name="DoLOBCols">
      <xsl:with-param name="MetaType">
       <xsl:choose>
        <xsl:when test="(PROPERTY mod 64)>=32">PartLob</xsl:when>
        <xsl:otherwise>Lob</xsl:otherwise>
       </xsl:choose>
      </xsl:with-param>
      <xsl:with-param name="TabBlocksize" select="(HNT | IONT)/BLOCKSIZE"/>  
     </xsl:call-template>
    </xsl:if>

   <!-- call self recursively if this NT contains NTs -->
   <xsl:if test="$Node/NTS_ITEM[OBJ_NUM=current()/NTAB_NUM]">
    <xsl:call-template name="DoNTStoreAs">
     <xsl:with-param name="Node" select="$Node"/>
     <xsl:with-param name="ParentObjNum" select="NTAB_NUM"/>
    </xsl:call-template>
   </xsl:if>

   <xsl:call-template name="EmitStorageTablePropertiesParen">
    <xsl:with-param name="Node" select="$Node"/>
    <xsl:with-param name="OpenParen">0</xsl:with-param>
   </xsl:call-template>

   <xsl:choose>
    <xsl:when test="(FLAGS mod 64)>=32">RETURN AS LOCATOR</xsl:when>
    <xsl:otherwise>RETURN AS VALUE</xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
</xsl:template>


<!-- Generate open (or close) parens around storage table properties
     for nested table.  The logic is sufficiently baroque that
     it deserves its own template. 
     The cases are:
     (1) User has asked for segment attributes
     (2) Nested table is an IOT (must emit ORGANIZATION INDEX etc.)
     (3) Need to emit non-referential constraints (referential constraints
	  on a nested table must be added in a separate ALTER TABLE stmt)
     (4) Nested table contains a CLOB or BLOB column 
	 (or a VARRAY column stored as a LOB)
	 with a user-specified segment name 
	 (Must emit LOB STORE AS... or VARRAY ... STORE AS LOB...)
     (5) Nested table itself contains a nested table column
-->
<xsl:template name="EmitStorageTablePropertiesParen">
 <xsl:param name="Node" select="''"/>
 <xsl:param name="OpenParen">1</xsl:param>

 <xsl:choose>
  <xsl:when test="$SEGMENT_ATTRIBUTES=1">
   <xsl:call-template name="EmitParen">
    <xsl:with-param name="OpenParen" select="$OpenParen"/>
   </xsl:call-template>
  </xsl:when>

  <xsl:when test="(PROPERTY mod 128)>=64">
   <xsl:call-template name="EmitParen">
    <xsl:with-param name="OpenParen" select="$OpenParen"/>
   </xsl:call-template>
  </xsl:when>

<!-- see comment in template DoNTStoreAS, above -->

  <xsl:when test="$CONSTRAINTS_AS_ALTER=0 and $CONSTRAINTS=1 and (
      (HNT | IONT)/CON0_LIST/CON0_LIST_ITEM or
1024>((HNT | IONT)/CON1_LIST/CON1_LIST_ITEM/IND/COL_LIST/COL_LIST_ITEM[1]/COL/PROPERTY mod 2048))">
   <xsl:call-template name="EmitParen">
    <xsl:with-param name="OpenParen" select="$OpenParen"/>
   </xsl:call-template>
  </xsl:when>

  <xsl:when test="4>(COL_LIST/COL_LIST_ITEM[TYPE_NUM=112 or TYPE_NUM=113 or TYPE_NUM=123]/LOBMD/SCHEMA_OBJ/FLAGS mod 8)">

   <xsl:call-template name="EmitParen">
    <xsl:with-param name="OpenParen" select="$OpenParen"/>
   </xsl:call-template>
  </xsl:when>

  <xsl:when test="$Node/NTS_ITEM[OBJ_NUM=current()/NTAB_NUM]">
   <xsl:call-template name="EmitParen">
    <xsl:with-param name="OpenParen" select="$OpenParen"/>
   </xsl:call-template>
  </xsl:when>


 </xsl:choose>

</xsl:template>

<xsl:template name="EmitParen">
 <xsl:param name="OpenParen">1</xsl:param>

 <xsl:choose>
  <xsl:when test="$OpenParen=1">(</xsl:when>
  <xsl:otherwise>) </xsl:otherwise>
 </xsl:choose>

</xsl:template>


<!-- Nested Table Constraints (when generated as ALTER TABLE) -->

<xsl:template name="GenNestedTableConstraints">
 <xsl:param name="ListParent" select="''"/>

  <xsl:for-each select="$ListParent/NTS_ITEM">
   <xsl:sort select="INTCOL_NUM" data-type="number"/>
   <xsl:if test="(HNT | IONT)/PKREF_LIST/PKREF_LIST_ITEM">
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">
      <xsl:apply-templates select="IONT/PKREF_LIST">
       <xsl:with-param name="SchemaObjParent" select="../.."/>
       <xsl:with-param name="ListParent" select="IONT"/>
      </xsl:apply-templates>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="HNT/PKREF_LIST">
       <xsl:with-param name="SchemaObjParent" select="../.."/>
       <xsl:with-param name="ListParent" select="HNT"/>
      </xsl:apply-templates>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>

   <xsl:if test="$CONSTRAINTS_AS_ALTER=1">
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">
      <xsl:call-template name="DoCON0_LIST">
       <xsl:with-param name="SchemaObjParent" select="current()"/>
       <xsl:with-param name="ListParent" select="IONT"/>
       <xsl:with-param name="InColList">0</xsl:with-param>
       <xsl:with-param name="CommaNeeded">0</xsl:with-param>
       <xsl:with-param name="Property" select="PROPERTY"/>
       <xsl:with-param name="Nested">1</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoCON0_LIST">
       <xsl:with-param name="SchemaObjParent" select="current()"/>
       <xsl:with-param name="ListParent" select="HNT"/>
       <xsl:with-param name="InColList">0</xsl:with-param>
       <xsl:with-param name="CommaNeeded">0</xsl:with-param>
       <xsl:with-param name="Property" select="PROPERTY"/>
       <xsl:with-param name="Nested">1</xsl:with-param>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>

   <xsl:if test="$REF_CONSTRAINTS=1 and
		 (HNT | IONT)/CON2_LIST/CON2_LIST_ITEM">
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">
      <xsl:apply-templates select="IONT/CON2_LIST">
       <xsl:with-param name="SchemaObjParent" select="../.."/>
      </xsl:apply-templates>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="HNT/CON2_LIST">
       <xsl:with-param name="SchemaObjParent" select="../.."/>
      </xsl:apply-templates>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>

  </xsl:for-each>
</xsl:template>


</xsl:stylesheet>
