<?xml version="1.0" ?>
<!--
NAME
    kutrig.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_trigger_t ADTs 
    This generates two DDL statements: a CREATE and an ALTER
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    htseng      06/27/03 - bug 2967731: trigger body > 4000
    htseng      11/13/01 - fix bug 2106294 - missing schema name.
    lbarton	06/01/01 - remove oradb-style imports
    lbarton	10/16/00 - fix position of / sqlterminator
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	07/24/00 - use uriref in import
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->
<xsl:import href="kucommon.xsl"/>


<!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>

<!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_ENABLE">0</xsl:param>


<xsl:template match="TRIGGER_T">

  <xsl:if test="$PRS_ENABLE=1">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>AENABLE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>B</xsl:text>
   <xsl:choose>
    <xsl:when test="ENABLED=0">
      <xsl:text>DISABLE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>ENABLE</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">TRIGGER</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>


  <xsl:text>CREATE OR REPLACE TRIGGER </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:if test="$PRETTY=1">  
    <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:value-of select="substring-after(DEFINITION,substring-before(normalize-space(DEFINITION),' '))"/>
  <xsl:apply-templates select="WHENCLAUSE"/>

  <xsl:choose>
  <xsl:when test="BODY_LEN > 4000">
    <xsl:choose> <!-- Have to strip trailing ';' off CALL triggers(go figure) -->
     <xsl:when test="(PROPERTY mod 4)>=2">
       <xsl:text> CALL </xsl:text>
       <xsl:for-each select="BODY_VCNT/BODY_VCNT_ITEM">
         <xsl:choose>
         <xsl:when test="position()=last() and 
		contains(substring(.,string-length(.)),';')">
           <xsl:value-of select="substring(.,1,string-length(.)-1)"/>
         </xsl:when>
         <xsl:otherwise>
           <xsl:value-of select="."/>
         </xsl:otherwise>
         </xsl:choose>
         <xsl:text>&#xa; </xsl:text>
       </xsl:for-each>
     </xsl:when>
     <xsl:otherwise>
      <xsl:for-each select="BODY_VCNT/BODY_VCNT_ITEM">
        <xsl:value-of select="."/>
        <xsl:text>&#xa; </xsl:text>
      </xsl:for-each>
     </xsl:otherwise>
    </xsl:choose>
  </xsl:when> <!-- end length greater than 4000 -->

  <xsl:otherwise> <!-- body length less than 4000 -->
    <xsl:choose> <!-- Have to strip trailing ';' off CALL triggers(go figure) -->
      <xsl:when test="(PROPERTY mod 4)>=2">
       <xsl:text> CALL </xsl:text>
       <xsl:choose>
        <xsl:when test="contains(substring(BODY,string-length(BODY)),';')">
          <xsl:value-of select="substring(BODY,1,string-length(BODY)-1)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="BODY"/>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="BODY"/>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:otherwise>
 </xsl:choose>

  <xsl:if test="$SQLTERMINATOR=1">
   <!-- Terminate trigger text with a '/' rather than ';' -->
   <xsl:text>
/</xsl:text>
  </xsl:if>
  <xsl:text>&#xa;</xsl:text>
  <xsl:apply-templates select="ENABLED"/>
</xsl:template>

<xsl:template match="WHENCLAUSE">
  <xsl:text> WHEN (</xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>) </xsl:text>
</xsl:template>

<xsl:template match="ENABLED">

  <xsl:if test="$PRS_ENABLE=1">
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>AENABLE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/><xsl:text>B</xsl:text>
   <xsl:choose>
    <xsl:when test=".=0">
      <xsl:text>DISABLE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>ENABLE</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">TRIGGER</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="../SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="../SCHEMA_OBJ/NAME"/>
  </xsl:call-template>

  <xsl:text>ALTER TRIGGER </xsl:text>
  <xsl:apply-templates select="../SCHEMA_OBJ"/>
  <xsl:choose>
    <xsl:when test=".=0">
      <xsl:text>DISABLE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>ENABLE</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>  <!-- Terminate the SQL statement -->
  </xsl:if>
</xsl:template>

</xsl:stylesheet>

