<?xml version="1.0" ?>
<!-- 
NAME
    kutsquo.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_tsquota_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    htseng 04/03/03 - fix bug 2884168 
    htseng 09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	05/29/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->
<xsl:import href="kucommon.xsl"/>

<!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>

<!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>

<xsl:template match="TSQUOTA_T">


  <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">TABLESPACE_QUOTA</xsl:with-param>
  </xsl:call-template>

  <xsl:text> ALTER USER </xsl:text>
  <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Object" select="USER_NAME"/>
  </xsl:call-template>

  <xsl:choose>
    <xsl:when test="MAXBLOCKS= -1">
      <xsl:text> QUOTA UNLIMITED ON </xsl:text>
    <xsl:call-template name="QuoteObject">
      <xsl:with-param name="Object" select="TS_NAME"/>
    </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
      <xsl:text> QUOTA </xsl:text>
      <xsl:value-of select="MAXBLOCKS * BLOCKSIZE"/> 
      <xsl:text> ON </xsl:text>
      <xsl:call-template name="QuoteObject">
        <xsl:with-param name="Object" select="TS_NAME"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
  </xsl:if>

</xsl:template>

</xsl:stylesheet>















