<?xml version="1.0" ?>
<!-- 
NAME
    kutypspc.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_type_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     03/30/05 - backport bug 2844111: DoSourceLines 
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	07/24/00 - use uriref in import
    lbarton	07/17/00 - bugfix: use DoTerminator
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kusource.xsl"/>


<xsl:template match="TYPE_T">

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">TYPE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>

  <xsl:text>CREATE OR REPLACE TYPE </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>

   <!-- timestamp and OID clauses -->
   <xsl:if test="$TIMESTAMP=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>  TIMESTAMP '</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/MTIME"/>
    <xsl:text>' </xsl:text>
   </xsl:if>
   <xsl:if test="$OID=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>  OID '</xsl:text>
    <xsl:value-of select="OID"/>
    <xsl:text>' </xsl:text>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0">
     <xsl:apply-templates select="SOURCE_LINES"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoSourceLines">
      <xsl:with-param name="SourceLines" select="SOURCE_LINES"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:call-template name="DoTerminator">
    <xsl:with-param name="Text"
 select="SOURCE_LINES/SOURCE_LINES_ITEM[position()=last()]/SOURCE"/>
   </xsl:call-template>
</xsl:template>

</xsl:stylesheet>