<?xml version="1.0" ?>
<!-- 
NAME
    kuview.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_view_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    htseng 	10/01/03 - backport 3056720 support long view text 
    lbarton	10/25/01 - xdb support
    dgagne	07/16/01 - update for constraints on views
    lbarton	06/01/01 - remove oradb-style imports
    lbarton	11/10/00 - support long views
    lbarton	10/26/00 - fix sqlterminator bug
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	07/24/00 - use uriref in import
    lbarton	07/03/00 - fix sqlterminator bug
    lbarton	06/02/00 - support parsing
    lbarton	05/15/00 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>
<xsl:import href="kucolumn.xsl"/>
<xsl:import href="kutable.xsl"/>


<!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="FORCE">1</xsl:param>

<!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>

<xsl:template match="VIEW_T">


  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">VIEW</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>

  <xsl:text>CREATE OR REPLACE</xsl:text>
  <xsl:if test="$FORCE=1"> FORCE</xsl:if>
  <xsl:text> VIEW </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>

  <xsl:choose>
   <xsl:when test="(PROPERTY mod 2)>=1">  <!-- object view -->
    <xsl:text>OF </xsl:text>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Schema" select="OWNER_NAME"/>
     <xsl:with-param name="Object" select="NAME"/>
    </xsl:call-template>
    <xsl:if test="NAME='XMLTYPE' and OWNER_NAME='SYS' and
	COL_LIST2/COL_LIST2_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;  </xsl:text>
     </xsl:if>
     <xsl:apply-templates
  select="COL_LIST2/COL_LIST2_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT"/>
    </xsl:if>
    <xsl:if test="OIDTEXTLENGTH > 0">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> WITH OBJECT IDENTIFIER (</xsl:text>
    <xsl:value-of select="OIDTEXT"/>
    <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:when>

   <xsl:otherwise>  			<!-- relational view -->
    <xsl:text>(</xsl:text>
    <xsl:apply-templates select="COL_LIST">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
     <xsl:with-param name="DoLF">0</xsl:with-param>
     <xsl:with-param name="DoHidden">1</xsl:with-param>
    </xsl:apply-templates>

     <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="current()"/>
      <xsl:with-param name="InColList">1</xsl:with-param>
      <xsl:with-param name="CommaNeeded">1</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
     </xsl:call-template>

    <xsl:text>)</xsl:text>
   </xsl:otherwise>
  </xsl:choose>

  <xsl:text> AS </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="TEXTVCNT">
    <xsl:for-each select="TEXTVCNT/TEXTVCNT_ITEM">
     <xsl:value-of select="."/>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="TEXT"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>		<!-- Terminate the SQL statement -->
  </xsl:if>

</xsl:template>

</xsl:stylesheet>
