<?xml version="1.0" ?>
<!-- 
NAME
    kuxmlsch.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_xmlschema_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    bmccarth    08/15/02 - remove schema
    bmccarth    08/08/02 - change strip_username to emit_Schema
    bmccarth    07/17/02 - Make FORCE TRUE by default
    lbarton     07/24/02 - get stripped and unstripped val
    lbarton     01/16/02 - Merged lbarton_mdapi_xdb
    lbarton     01/08/02 - api change
    lbarton     12/03/01 - use BEGIN...END
    lbarton     10/25/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Import required scripts -->

<xsl:import href="kucommon.xsl"/>

<!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="GEN_TYPES">0</xsl:param>
 <xsl:param name="GEN_BEAN">0</xsl:param>
 <xsl:param name="GEN_TABLES">0</xsl:param>
 <xsl:param name="FORCE">1</xsl:param>
 <xsl:param name="EMIT_SCHEMA">1</xsl:param>

<!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>

<xsl:template match="XMLSCHEMA_T">

  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">dbms_xmlschema.registerSchema</xsl:with-param>
   <xsl:with-param name="ObjectType">XMLSCHEMA</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="URL"/>
  </xsl:call-template>

  <xsl:text>BEGIN dbms_xmlschema.registerSchema('</xsl:text>
  <xsl:value-of select="URL"/>
  <xsl:text>',</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>'</xsl:text>
  <xsl:choose>
   <xsl:when test="$EMIT_SCHEMA=1">
    <xsl:value-of select="SCHEMA_VAL"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="STRIPPED_VAL"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>',</xsl:text>
  <xsl:choose>
   <xsl:when test="LOCAL = 1">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
   <xsl:when test="$GEN_TYPES = 1">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
   <xsl:when test="$GEN_BEAN = 1">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
   <xsl:when test="$GEN_TABLES = 1">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
   <xsl:when test="$FORCE = 1">
    <xsl:text>TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>

<!-- Include owner name if requested -->
  <xsl:choose>
   <xsl:when test="$EMIT_SCHEMA=1">
    <xsl:text>,'</xsl:text>
    <xsl:value-of select="OWNER_NAME"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
  </xsl:choose>

  <xsl:text>); END</xsl:text>

  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>		<!-- Terminate the call -->
  </xsl:if>

</xsl:template>

</xsl:stylesheet>
