#!/bin/sh
#
# $Header: oidmcrep.sh 29-jul-2002.16:48:27 vasokkum Exp $
#
# oidmcrep.sh
#
# Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      oidmcrep.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vasokkum    07/29/02 - 2388632-2356773
#    xxuli       02/11/02 - xxuli_bug-2216875
#    xxuli       02/11/02 - Creation
#
#
usage() {
cat <<USAGE_MESSAGE
usage: ${0} [ -name <Agent Name> ]
            [ -type   <IMPORT | EXPORT > ]
            [ -agentpwd < Agent Password> ]
            [ -config <which configset to associate to > ]
            [ -host <LDAP server host> ]
            [ -port <LDAP server port> ]
            [ -binddn SuperUserDN (default cn=orcladmin ) ]
            [ -bindpass   Bindpassword (default=welcome) ]
            [ -U <SSL Authentication Mode> ]
            [ -W <Wallet location> ]
            [ -P <Wallet password> ]
            [ -retry   <Max Retry Count on synchronization Errors > ]
            [ -poll < Polling Interval For Synchronization> ]

            [ -conndirurl  < Connected Directory URL > ]

            [ -conndiracct < Connected Directory Account Info > ]
            [ -conndirpwd < Connected Directory Account Pasword> ]
            [ -execmd < Command Line for the Agent > ]

            [ -iftype < Interface Type > ]

            [ -condirfilter < Connected Directory Matching Filter> ]
            [ -oidfilter < OID Matching Filter > ]

            [ -help | -usage ]

 name        : Agent Name.
 type        : IMPORT / EXPORT .
 agentpwd    : Agent Password.
 config      : The configset which is associated with this Agent.
 U           : SSL Authentication mode (default is non-SSL)
 W           : SSL Wallet location (Required only for SSL mode)
 P           : SSL Wallet Password
 host        : LDAP Server Host
 port        : LDAP Server port
 binddn      : LDAP Server BIND DN
 bindpass    : LDAP BIND password
 retry       : Max Retry Counts for Synchronization Errors( Absolute Max is 100)
 poll        : Polling Interval For Synchronization. (in seconds)
 conndirurl  : Connected Directory URL (host:port for LDAP)
 conndiracct : Account to access the connectory directory data source.
 conndirpwd  : Password to access the connectory directory data source.
 execmd      : Agent Executable Command Line.
 iftype      : Interface Type (TAGGED | LDIF | LDAP | DB ). 
 condirfilter: Connected Directory Matching Filter (MultiValued)
 oidfilter   : OID Matching Filter (MultiValued)

Argument Defaults:
  host          : Default Host
  port          : 389
  config        : 1
  type          : IMPORT
  retry         : 10
  poll          : 60 
  agentpwd      : welcome
  conndirurl    : 
  conndiracct   : 
  conndirpwd    : 
  execmd        : 
  iftype        : TAGGED
 
Mandatory Arguments : name

Example . To add an Agent named "HRMS" for Oracle HR  synchronization use..
      ${0} -name HRMS -host abc-host -port 4200 -binddn "cn=orcladmin" \
      -bindpass "welcome" -config 3 -type IMPORT -retry 25 -poll 60 \
      -agentpwd "welcome01" -conndirurl "abcd-host:389" -conndiracct "apps" \
      -conndirpwd "apps" -execmd "" -iftype TAGGED -condirfilter "" \
      -oidfilter "changetype=delete"
      
      You may make modifications through admin tool, for these attrs.
      
USAGE_MESSAGE
}

AGENT_NAME=""
LDAP_HOST=`hostname`
LDAP_PORT=389
BINDDN="cn=orcladmin"
BINDPASS="welcome"
CONFIGSET="1"
AGENT_TYPE="IMPORT"
AGENT_CONTROL="ENABLE"
AGENT_PWD="welcome"
RETRY=10
POLL="60"
templFile=""
CHGDOMAIN=""
IDENTRULE=""
DNCONSTRULE=""
AGENT_HOST=`hostname`
CONNDIRURL=""
CONNDIRACCT=""
CONNDIRPWD=""
EXECMD=""
IFTYPE="TAGGED"
LASTERR=3
EXECSTS=""
ACLDOMAIN=""
SUBSCRIBERDISABLE=1
CONDIRFILTER=""
OIDFILTER=""
SSLAUTH="0"
WLOC="xx"
WPASS="xx"
LASTNUM="0"

AGENTDN_SUFFIX="cn=subscriber profile,cn=changelog Subscriber,cn=oracle internet Directory"
CONFIGSET_DNSUFFIX="cn=metadird,cn=configsets,cn=oracle internet Directory"

TMPDIR=${ORACLE_HOME}/ldap/log
NULLFILE=${TMPDIR}/$$.log

# parse arguments
while [ $# -gt 0 ] ; do
  case $1 in

    -name) AGENT_NAME=$2;
       if [ -z "${AGENT_NAME}" ] ; then
         usage ; exit 1 ;
       else
         shift;
       fi;;

    -host) LDAP_HOST=$2;
       if [ -z "${LDAP_HOST}" ] ; then
         LDAP_HOST=`hostname`;
       else
         shift;
       fi;;

    -port) LDAP_PORT=$2;
       if [ -z "${LDAP_PORT}" ] ; then
         LDAP_PORT=389;
       else
         shift;
       fi;;

    -binddn ) BINDDN=$2 ;
          if [ -z "${BINDDN}" ] ; then
            BINDDN="cn=orcladmin"
          else
            shift ;
          fi;;

    -bindpass ) BINDPASS=$2 ;
          if [ -z "${BINDPASS}" ] ; then
            BINDPASS="welcome"
          else
            shift ;
          fi;;                     

    -config) CONFIGSET=$2;
       if [ -z "${CONFIGSET}" ] ; then
         CONFIGSET="1";
       else
         shift;
       fi;;

    -type) AGENT_TYPE=$2;
       if [ -z "${AGENT_TYPE}" ] ; then
         AGENT_TYPE="IMPORT";
       else
         shift;
       fi;;

    -retry) RETRY=$2;
       if [ -z "${RETRY}" ] ; then
         RETRY="60";
       else
         shift;
       fi;;

    -poll) POLL=$2;
       if [ -z "${POLL}" ] ; then
         POLL="60";
       else
         shift;
       fi;;

    -agentpwd) AGENT_PWD=$2;
       if [ -z "${AGENT_PWD}" ] ; then
         AGENT_TYPE="welcome";
       else
         shift;
       fi;;

    -conndirurl) CONNDIRURL=$2;
       if [ -z "${CONNDIRURL}" ] ; then
         CONNDIRURL="" ;
       else
         shift;
       fi;;

    -conndiracct) CONNDIRACCT=$2;
       if [ -z "${CONNDIRACCT}" ] ; then
         CONNDIRACCT="" ;
       else
         shift;
       fi;;

    -conndirpwd) CONNDIRPWD=$2;
       if [ -z "${CONNDIRPWD}" ] ; then
         CONNDIRPWD="" ;
       else
         shift;
       fi;;

    -execmd) EXECMD=$2;
       if [ -z "${EXECMD}" ] ; then
         EXECMD="" ;
       else
         shift;
       fi;;

    -iftype) IFTYPE=$2;
       if [ -z "${IFTYPE}" ] ; then
         IFTYPE="TAGGED" ;
       else
         shift;
       fi;;

    -condirfilter) CONDIRFILTER=$2;
       if [ -z "${CONDIRFILTER}" ] ; then
         CONDIRFILTER="" ;
       else
         shift;
       fi;;

    -oidfilter) OIDFILTER=$2;
       if [ -z "${OIDFILTER}" ] ; then
         OIDFILTER="" ;
       else
         shift;
       fi;;

    -U) SSLAUTH=$2;
       if [ ${SSLAUTH} -gt 3 ] ; then
          usage ; exit 1 ;
       else
          shift;
       fi;;

    -W) WLOC=$2;
       if [ -z "${WLOC}"  ] ; then
          usage ; exit 1 ;
       else
          shift;
       fi;;

    -P) WPASS=$2;
       if [ -z "${WPASS}"  ] ; then
          usage ; exit 1 ;
       else
          shift;
       fi;;

    -help ) usage ; exit 1 ;;

    *) echo "$1 Not Found " ; usage ; exit 1 ;;

  esac
  shift
done              


  if [ "${AGENT_NAME}" = "" ] 
  then
    echo "Mandatory Argument \"name\" missing.."
    usage ;
    exit 1;
  fi

  if [ "${AGENT_TYPE}" != "IMPORT" -a "${AGENT_TYPE}" != "EXPORT" ]
  then
   echo "TYPE must be either IMPORT or EXPORT .."
   exit 1 ;
  fi

# Numeric Value Checks for Poll , Configset , service , retry

  num_value=`expr ${POLL} + 1 - 1 2>${NULLFILE}`
  if [ "${num_value}" != "${POLL}" ]
  then
   echo "Polling Interval must be numeric.."
   exit 1 ;
  fi

  num_value=`expr ${CONFIGSET} + 1 - 1 2>${NULLFILE}`
  if [ "${num_value}" != "${CONFIGSET}" ]
  then
   echo "Configset must be numeric.."
   exit 1 ;
  fi

  num_value=`expr ${RETRY} + 1 - 1 2>${NULLFILE}`
  if [ "${num_value}" != "${RETRY}" ]
  then
   echo "Retry Count must be numeric.."
   exit 1 ;
  fi

  if [ "${RETRY}" -gt 100 ]
  then
    RETRY=100
  fi

  if [ "${IFTYPE}" != "TAGGED" -a "${IFTYPE}" != "LDIF" -a "${IFTYPE}" != "LDAP"  -a "${IFTYPE}" != "DB" ]
  then
   echo "Interface TYPE must either LDIF / TAGGED / LDAP / DB"
   exit 1 ;
  fi

# Check Availability of LDAP server  
  ldapbind -h ${LDAP_HOST} -p ${LDAP_PORT} -U $SSLAUTH -W $WLOC -P $WPASS >${NULLFILE} 2>&1
  if [ $? -ne 0 ]
  then
    echo "Cannot Connect to LDAP Server.Check host and port.\n"
    exit 1;
  fi        

# Check LDAP credentials
  ldapbind -h ${LDAP_HOST} -p ${LDAP_PORT}  -D "${BINDDN}" -w "${BINDPASS}" -U $SSLAUTH -W $WLOC -P $WPASS > ${NULLFILE} 2>&1

  if [ $? -ne 0 ]
  then
    echo "InValid Credentials..\n"
    exit 1 ;
  fi           

  if [ "${AGENT_TYPE}" = "EXPORT" ]
  then
    SUBSCRIBERDISABLE=0 ;

    # Get Last change Number From OID

    tmpfile=$ORACLE_HOME/ldap/log/$$
    ldapsearch -h ${LDAP_HOST} -p ${LDAP_PORT} -s base  \
                       -U $SSLAUTH -W $WLOC -P $WPASS \
                       -b "" 'objectclass=*' lastchangenumber > $tmpfile 2>&1

    if [ $? -ne 0 ]
    then
      echo "Error Retrieving Last ChangeNumber from OID.. "
      exit 1 ;
    fi

    LASTNUM=`cat $tmpfile | grep -i "lastchangenumber=" | sed 's/lastchangenumber=//g'`
  else
    SUBSCRIBERDISABLE=1 ;
    LASTNUM=0
  fi

# Other Values

  TEMPFILE=${TMPDIR}/$$

  if [ "${EXECMD}" != "" ]
  then
    origcmd=${EXECMD}
    echo ${EXECMD}  | sed 's/\//\\\//g' > ${TEMPFILE}
    EXECMD=`cat ${TEMPFILE}`
    if [ "${EXECMD}" = "${origcmd}" ]
    then
      echo ${EXECMD}  | sed 's/\\/\\\\/g' > ${TEMPFILE}
      EXECMD=`cat ${TEMPFILE}`
    fi
  fi

  rm -f ${TEMPFILE} 2>${NULLFILE}

  if [ -f $ORACLE_HOME/ldap/admin/orclmetaconn_template.ldif ]
  then
    templFile="$ORACLE_HOME/ldap/admin/orclmetaconn_template.ldif"
  fi

  if [ -f $ORACLE_HOME/ldap/odi/admin/orclmetaconn_template.ldif ]
  then
    templFile="$ORACLE_HOME/ldap/odi/admin/orclmetaconn_template.ldif"
  fi

  if [ -f $ORACLE_HOME/ldap/admin/metadir/admin/orclmetaconn_template.ldif ]
  then
    templFile="$ORACLE_HOME/ldap/admin/metadir/admin/orclmetaconn_template.ldif"
  fi

  echo "Adding Agent ...: ${AGENT_NAME} to Configuration Set: ${CONFIGSET}"

cat ${templFile} | \
     sed "s/%AGENT_NAME%/${AGENT_NAME}/g" | \
     sed "s/%AGENT_TYPE%/${AGENT_TYPE}/g" | \
     sed "s/%AGENT_PWD%/${AGENT_PWD}/g" | \
     sed "s/%AGENT_HOST%/${AGENT_HOST}/g" | \
     sed "s/%POLL%/${POLL}/g" | \
     sed "s/%RETRY%/${RETRY}/g" | \
     sed "s/%EXECMD%/${EXECMD}/g" | \
     sed "s/%CONNDIRURL%/${CONNDIRURL}/g" | \
     sed "s/%CONNDIRACCT%/${CONNDIRACCT}/g" | \
     sed "s/%CONNDIRPWD%/${CONNDIRPWD}/g" | \
     sed "s/%IFTYPE%/${IFTYPE}/g" | \
     sed "s/%SUBSCRIBERDISABLE%/${SUBSCRIBERDISABLE}/g" | \
     sed "s/%CONDIRFILTER%/${CONDIRFILTER}/g" | \
     sed "s/%OIDFILTER%/${OIDFILTER}/g" | \
     sed "s/%LASTCHGNUM%/${LASTNUM}/g" > ${TMPDIR}/${AGENT_NAME}.ldif

ldapsearch -h ${LDAP_HOST} -p ${LDAP_PORT} -D "${BINDDN}" -w "${BINDPASS}" -s base  -b "orclODIPAgentName=${AGENT_NAME},${AGENTDN_SUFFIX}" -U $SSLAUTH -W $WLOC -P $WPASS 'objectclass=*' dn > ${NULLFILE} 2>&1

if [ $? -eq 0 ]
then
  echo "Agent Already Exists.."
  exit 1
fi

# Adding The Agent Entry 
echo "Adding Agent Entry"
  ldapadd -h ${LDAP_HOST} -p ${LDAP_PORT} -D "${BINDDN}" -w "${BINDPASS}" -U $SSLAUTH -W $WLOC -P $WPASS -f ${TMPDIR}/${AGENT_NAME}.ldif > ${NULLFILE} 2>&1

  if [ $? -ne 0 ]
  then
    echo "Unable to add Agent.."
    echo "Check LDIF file ${TMPDIR}/${AGENT_NAME}.ldif"
    exit 1;
  fi

  echo "Setting Refresh Flag.."
    
  ldapsearch -h ${LDAP_HOST} -p ${LDAP_PORT} -D "${BINDDN}" -w "${BINDPASS}" -s base  -b "cn=configset${CONFIGSET},${CONFIGSET_DNSUFFIX}" -U $SSLAUTH -W $WLOC -P $WPASS 'objectclass=*' dn > ${NULLFILE} 2>&1

  if [ $? -ne 0 ]
  then
    echo "Creating new configset ${CONFIGSET} .."
     
    ldapadd -h ${LDAP_HOST} -p ${LDAP_PORT} -D "${BINDDN}" -w "${BINDPASS}" -U $SSLAUTH -W $WLOC -P $WPASS << EOF
dn: cn=configset${CONFIGSET},${CONFIGSET_DNSUFFIX}
cn: configset${CONFIGSET}
orclODIPconfigrefreshflag: 1
orclODIPconfigdns: orclODIPAgentName=${AGENT_NAME},${AGENTDN_SUFFIX}
objectclass: top
objectclass: orclODISConfig
EOF
    if [ $? -ne 0 ]
    then
      echo "Error in Adding New Configuration Set.."
      exit 1
    fi

  else
    echo "Modifying Config set "

    ldapmodify -h ${LDAP_HOST} -p ${LDAP_PORT} -D "${BINDDN}" -w "${BINDPASS}" -U $SSLAUTH -W $WLOC -P $WPASS << EOF
dn: cn=configset${CONFIGSET},${CONFIGSET_DNSUFFIX}
changetype: modify
add: orclODIPconfigdns
orclODIPconfigdns: orclODIPAgentName=${AGENT_NAME},${AGENTDN_SUFFIX}
-
changetype: modify
replace: orclODIPconfigrefreshflag
orclODIPconfigrefreshflag: 1
EOF
    if [ $? -ne 0 ]
    then
      echo "Error in Modifying Configuration Set.."
      exit 1
    fi

  fi

echo "Successfully Added Agent : "${AGENT_NAME}"..\n"

rm -f ${TMPDIR}/${AGENT_NAME}.ldif 2>${NULLFILE}
